/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  Motif call backs for xcram_write

  cancel() passes "Cancel" back to getFileName()
  in xcram which kills the routine.

  cramHelp() is unused

  getDriver() passes the choosen driver
  back to xcram

*/

#include <Xm/Xm.h>

void
cancel(w, client, call)
Widget w;
caddr_t client;
XmSelectionBoxCallbackStruct *call;
{
    printf("Cancel\n");
    exit(0);
}

void
cramHelp(w, client, call)
Widget w;
caddr_t client;
XmSelectionBoxCallbackStruct *call;
{
    return;
}
 
void
getDriver(w, client, call)
Widget w;
caddr_t client;
XmSelectionBoxCallbackStruct *call;
{
    char *text;
    XmStringGetLtoR(call->value,XmSTRING_DEFAULT_CHARSET,&text);
    if (text==NULL) return;
    printf("%s \n",text);
    exit(0);
}
