/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <globs.h>
#include <sys/time.h>
#include <sys/types.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>

int chd_status = 0;

int chd_stat(echo,flush)
Boolean echo,flush;
{
        Boolean data_to_be_read();
	int i = 0;
	char chd_char;
	char action[12];
	char status_string[120];
	
	if (data.verbose >= 2 )
	  fprintf(tattle,"*-/- chd_stat -/-*\n");

	if (dpy != NULL) {
	  XMapRaised(dpy,busy_win);
	  XmUpdateDisplay(chd_stat_text);
	  }

	do {

	 i = 0;

	 while ((chd_char = getchar()) == ' ') {
	  XmTextInsert(chd_stat_text,XmTextGetLastPosition(chd_stat_text),".");
	  XmUpdateDisplay(chd_stat_text);
	  }

	 status_string[i] = chd_char;

	 do {
	  if (isdigit(status_string[i]) == 0) {
	    if (chd_char == '\n') {
	      i--;
	      }
	    else {
	      status_string[++i] = '\0';
	      XmTextSetString(chd_stat_text,"unexpected: ");
	      XmTextInsert(chd_stat_text,
		XmTextGetLastPosition(chd_stat_text),status_string);
	      if (data.verbose >= 2)
		fprintf(tattle,"unexpected: %s\n",status_string);
	      chd_response(TRUE);
/*
   We'll go get another line and check it..
   Object is to keep trying until we get a chd code.
*/
	      i = -1;
	      if (dpy != NULL)
	        XUnmapWindow(dpy,busy_win);
	      XmUpdateDisplay(chd_stat_text);
/*
	      return(999);
*/
	      }
	    }
	  } while ((status_string[++i] = getchar()) != ' ');

	 status_string[i] = ' ';
	 status_string[++i] = '\0';
         sscanf(status_string,"%d",&chd_status);

	 if (echo) {
	  XmTextSetString(chd_stat_text,status_string);
	  XmUpdateDisplay(chd_stat_text);
	  }

	 if (data.verbose)
	   fprintf(tattle,"%s ",status_string);

	 XmTextInsert(history_text2,XmTextGetLastPosition(history_text2),
		status_string);
	 XmTextShowPosition(history_text2,
		XmTextGetLastPosition(history_text2)-1);
	 XmUpdateDisplay(history_text2);

	 if (chd_status == 310) chd_response(TRUE);

	 if (chd_status == 410) {
	   chd_response(TRUE);
	   return(chd_status);
	   }
	} while (chd_status == 310);

	if (flush) {
	  chd_response(echo);
	  while (data_to_be_read(fileno(stdin))) {
	    chd_response(TRUE);
	    }
	  }

	if (dpy != NULL) {
	  XUnmapWindow(dpy,busy_win);
	  }

	return(chd_status);
}
void chd_response(echo)
Boolean echo;
{
	char chd_char;
	char status_string[120];

	if (data.verbose >= 2 )
	  fprintf(tattle,"*-/- chd_response -/-*\n");

	while ((chd_char = getchar()) <= 0) {
	  system("sleep 1");
	  }
	
	if (chd_char == '\n') return;
	  
	status_string[0] =  chd_char;
	status_string[1] =  '\0';

	while ((chd_char = getchar()) != '\n') {
	  strncat(&status_string[0], &chd_char, 1);
	  }

	if (data.verbose)
	   fprintf(tattle,"%s\n",status_string);

	if (echo) {
	  XmTextSetString(chd_stat_text,status_string);
	  XmUpdateDisplay(chd_stat_text);
	  }

	XmTextInsert(history_text2,XmTextGetLastPosition(history_text2),
		status_string);
	XmTextInsert(history_text2,XmTextGetLastPosition(history_text2),
		"\n");
	XmTextShowPosition(history_text2,
		XmTextGetLastPosition(history_text2)-1);
	XmUpdateDisplay(history_text2);

}
/*
 *   data_to_be_read() - Check to see if a read of the specified file 
 *	would block.
 *
 *   Returns:
 *        FALSE, if read would block
 *        TRUE, if read would not block
 */
static Boolean
data_to_be_read(fd)
   int fd;                       /* File descriptor */
{
	int nfound;              /* Number of ready descriptors */
	fd_set readfds;               /* Read file descriptors bit mask */
	struct timeval timeout;

	FD_ZERO(&readfds);
	FD_SET(fd, &readfds);

	timeout.tv_sec = 0;      /* Cause select to return immediately */
	timeout.tv_usec = 0;

	while ((nfound = select(FD_SETSIZE, &readfds, 0, 0, &timeout)) == -1) {
		if (errno == EINTR)
			continue; /* Ignore interrupts */

		fprintf(stderr, "select() failed, errno = %d\n", errno);
		exit(1);
	}
	return((Boolean) nfound);
}
char *get_chd_line(echo)
Boolean echo;
{
	char chd_char;
	char *status_string;

	status_string = (char *) XtMalloc(256);
	if (data.verbose >= 2 )
	  fprintf(tattle,"*-/- chd_response -/-*\n");

	while ((chd_char = getchar()) <= 0) {
	  system("sleep 1");
	  }
	
	status_string[0] =  '\0';
	if (chd_char == '\n') return(status_string);;
	  
	strncat(status_string,&chd_char,1);

	while ((chd_char = getchar()) != '\n') {
	  strncat(status_string, &chd_char, 1);
	  }

	if (data.verbose)
	   fprintf(tattle,"%s\n",status_string);

	if (echo) {
	  XmTextSetString(chd_stat_text,status_string);
	  XmUpdateDisplay(chd_stat_text);
	  }

	XmTextInsert(history_text2,XmTextGetLastPosition(history_text2),
		status_string);
	XmTextInsert(history_text2,XmTextGetLastPosition(history_text2),
		"\n");
	XmTextShowPosition(history_text2,
		XmTextGetLastPosition(history_text2)-1);
	XmUpdateDisplay(history_text2);
	status_string = (char *)XtRealloc(status_string,
		strlen(status_string)+1);
	return(status_string);
}
void chd_cmd(cmd)
char *cmd;
{
/* added this to flush out chd responses which may have been delayed */

	while (data_to_be_read(fileno(stdin))) {
	    if (data.verbose >= 2)
	      fprintf(tattle,"unconsumed chd message:\n");
	    chd_response(FALSE);
	    }

	fprintf(stdout,"%s\n",cmd);
	fflush(stdout);

	if (data.verbose)
	   fprintf(tattle,">>%s\n",cmd);

	XmTextInsert(history_text2,XmTextGetLastPosition(history_text2),
		">>");
	XmTextInsert(history_text2,XmTextGetLastPosition(history_text2),
		cmd);
	XmTextInsert(history_text2,XmTextGetLastPosition(history_text2),
		"\n");

	XtVaSetValues (history_text2, XmNcursorPosition, 
		XmTextGetLastPosition(history_text2), NULL);
	XtManageChild(history_text2);
	XmTextShowPosition(history_text2, XmTextGetLastPosition(history_text2)-1);
/*
	XmTextSetInsertionPosition(history_text2, XmTextGetLastPosition(history_text2));
*/
	XmUpdateDisplay(history_text2);
}

