/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <localsys.h>
#include <string.h>
#include <globs.h>

int determine_device()
{
	int i;
	char *unit,*ptr,density_value[4];
	char *current_options,*current_density;
	char *option,options[8];
	struct stat statbuf;

	if (data.verbose >= 2) 
	  fprintf(tattle,"*-/- determine_device -/-*\n");

	unit = (char *)strrchr(deviceName,'/') + 1;

	if (data.verbose >= 2)
	  fprintf(tattle,"original device name = %s\n",deviceName);

#ifdef SUNSYSTEM
	if (strstr(deviceName,"rmt") == NULL) {
/*
	assuming the device is specified as /dev/rstN or /dev/nrstN
*/
	 if ((*unit != 'n') && (strcmp(drive_info.rewind,"off") == 0)) {
	  for (i=strlen(deviceName); deviceName+i>=unit; i--) 
	    *(deviceName+i) = *(deviceName+i-1);
	  *unit = 'n';
	  }
	 else if ((*unit == 'n') && (strcmp(drive_info.rewind,"on") == 0)) {
	  for (ptr=unit; ptr<=deviceName+strlen(deviceName); ptr++)
	    *(ptr) = *(ptr+1);
	  deviceName[strlen(deviceName)] = '\0';
	  }

	 unit = strstr(deviceName,"st") + 2;
	 if (data.verbose >= 2)
	  fprintf(tattle,"unit = %s\n",unit);
	      
/*
	We assume that the device we've got in the table is
	the low density device. However, if DEFAULT_OPTION is specified,
	we just use whatever device is specified in /etc/chd.conf
	for the specified drive.
*/
	 if (strcmp(drive_info.density,DEFAULT_OPTION) == 0) {
	  sprintf(density_value,"%d",atoi(unit) + 8);
	  }
	 else if (strcmp(drive_info.density,"md") == 0) {
	  sprintf(density_value,"%d",atoi(unit) + 8);
	  strcpy(unit,density_value);
	  }
	 else if (strcmp(drive_info.density,"hd") == 0) {
	  sprintf(density_value,"%d",atoi(unit) + 16);
	  strcpy(unit,density_value);
	  }
	 else if (strcmp(drive_info.density,"c") == 0) {
	  sprintf(density_value,"%d",atoi(unit) + 24);
	  strcpy(unit,density_value);
	  }
	 }
	else {
/*
	the device is specified as /dev/rmt/[0-127][l,m,h,u,c][b][n]
*/
	  current_options = strpbrk(unit,"lmhucbn");
	  options[0] = '\0';

	  if (strcmp(drive_info.compression,DEFAULT_OPTION) == 0) {
	    if (strstr(current_options,"c") != NULL) strcat(options,"c");
	    }
	  else if (strcmp(drive_info.compression,"on") == 0)
	    strcat(options,"c");

/*
	if we've got compression on, ignore the density argument
*/
	  if (strstr(options,"c") == NULL) {
	    if (strcmp(drive_info.density,DEFAULT_OPTION) == 0) {
/*
	      current_density=strpbrk(current_options,"lmhu");
	      if (current_density != NULL) strncat(options,current_density,1);
*/
	      strncat(options, (current_density =  strpbrk(current_options,
		"lmhu")) == NULL ? "" : current_density, 1);
	      }
	    else if (strcmp(drive_info.density,"ld") == 0) {
	      strcat(options,"l");
	      }
	    else if (strcmp(drive_info.density,"md") == 0) {
	      strcat(options,"m");
	      }
	    else if (strcmp(drive_info.density,"hd") == 0) {
	      strcat(options,"h");
	      }
	    else if (strcmp(drive_info.density,"ud") == 0) {
	      strcat(options,"u");
	      }
	    }

	  if (strcmp(drive_info.bsd,DEFAULT_OPTION) == 0) {
	    if (strstr(current_options,"b") != NULL) strcat(options,"b");
	    }
	  else {
	    if (strcmp(drive_info.bsd,"on") == 0)
	      strcat(options,"b");
	    }

	  if (strcmp(drive_info.rewind,DEFAULT_OPTION) == 0) {
	    if (strstr(current_options,"n") != NULL) strcat(options,"n");
	    }
	  else {
	    if (strcmp(drive_info.rewind,"off") == 0)
	      strcat(options,"n");
	    }
	  strcpy(current_options,options);
	  }
#endif
#ifdef SGISYSTEM
/*
	I think this will always be the case because the controller
	and the device number should always be single digits.
*/
	/* unit += 6; */
	current_options = strpbrk(unit+6,"nrsvc.");

	options[0] = '\0';

	if (strcmp(drive_info.rewind,DEFAULT_OPTION) == 0) {
	  strncat(options,
	    (option=strstr(current_options,"nr")) == NULL ? "" : option, 2);
	  }
	else {
	  if (strcmp(drive_info.rewind,OFF_OPTION) == 0)
	    strcat(options,"nr");
	  }

	if (strcmp(drive_info.byte_swap,DEFAULT_OPTION) == 0) {
	  if (strstr(current_options,"ns") != NULL)
	    strcat(options,"ns");
	  else if (strstr(current_options,"s") != NULL)
	    strcat(options,"s");
	  }
	else {
	  if (strcmp(drive_info.byte_swap,"on") == 0)
	    strcat(options,"s");
	  else
	    strcat(options,"ns");
	  }

	if (strcmp(drive_info.variable_block,DEFAULT_OPTION) == 0) {
	  strncat(options,
	    (option = strstr(current_options,"v")) == NULL ? "" : option, 1);
	  }
	else {
	  if (strcmp(drive_info.variable_block,ON_OPTION) == 0)
	    strcat(options,"v");
	  }


	if (strcmp(drive_info.density,DEFAULT_OPTION) == 0) {
	  if (strchr(unit,'.') != NULL)
	    current_density = strdup(strchr(unit,'.'));
	  else
	    current_density = NULL;

	  if (current_density != NULL) {
	    if (strchr(current_density,'c') != NULL)
	      strncat(options,current_density,strlen(current_density)-1);
	    else 
	      strcat(options,current_density);
	    }
	  }
	else {
	  sprintf(density_value,".%s",drive_info.density);
	  strcat(options,density_value);
	  }

	if (strcmp(drive_info.compression,DEFAULT_OPTION) == 0) {
	  if (strstr(current_options,"c") != NULL) strcat(options,"c");
	  }
	else {
	  if (strcmp(drive_info.compression,"on") == 0)
	    strcat(options,"c");
	  }

	strcpy(current_options,options);
#endif

	if (data.verbose >= 2)
	  fprintf(tattle,"using device name = %s\n",deviceName);

	if (stat(deviceName, &statbuf) != 0) {
	  sprintf(msg_text,"Device %s does not exist; try altering device options and re-start processing",deviceName);
	  XmTextSetString(chd_stat_text,msg_text);
	  XmUpdateDisplay(chd_stat_text);
	  if (data.verbose) {
	    fprintf(tattle,"\n%s\n",msg_text);
	    }
	  sprintf(msg_text,"xalert Dismiss 'Device %s does not exist; try altering device options'",deviceName);
	  system(msg_text);
	  return(NULL);
	  }
	return 1;
}
