/*
 * generates a family of curves for testing purposes.
 */

#include "copyright.h"
#include <math.h>
#include <stdio.h>

static char *setnames[] = {
    "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta",
    "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Pi",
    "Rho", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega"
};

#define MAXNAMES	(sizeof(setnames)/sizeof(char *))

double func(x, i)
double x;
int i;
/* Yeilds a y value given an X value for curve i */
{
     return (x - ((double) i)) * x - ((double) i);
}

main(argc, argv)
int argc;
char *argv[];
{
    int num, index;
    double start, end, step, xval;

    if (argc != 5) {
	printf("format: %s curves start finish step\n", argv[0]);
	exit(1);
    }
    num = atoi(argv[1]);
    start = atof(argv[2]);
    end = atof(argv[3]);
    step = atof(argv[4]);
    for (index = 1;  index <= num;  index++) {
	if (index-1 < MAXNAMES) {
	    printf("\"%s\n", setnames[index-1]);
	}
	for (xval = start;  xval <= end;  xval += step) {
	    printf("%G %G\n", xval, func(xval, index));
	}
	printf("\n");
    }
}
