/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "Panel.h"
#include "ikp_globalE.h"

Library *libs=NULL;

static char buf1[1024];

void ikp_lib_read(char *filename)
{
  Library *l=NULL;
  Mod_lib *m=NULL;
  int fd,error;
  char *end;
  char library[1024],old_l[1024],module[1024],executable[1024];
  char input_buf[1024],output_buf[1024],diag_buf[1024];
  FILE *fp;

 
  if ((filename == (char *) NULL)||(strlen(filename)==0)) {
    return;
  }
  if ((fp= fopen(filename, "r")) == (FILE *) NULL) {
    fprintf(stderr,"Error open %s.",filename);
    return;
  }
  
  strcpy(old_l,"");

  end=fgets(buf1,1024,fp);
  while (end!=NULL) {  
    if (strlen(buf1)>1)
      buf1[strlen(buf1)-1]=NULL;

    strcpy(library,buf1);
    strcpy(strstr(library,"****"),"");

    if (library[0]=='"') 
      strcpy(library,library+1);
    strcpy(strrchr(library,'"'),"");

    strcpy(buf1,strstr(buf1,"****")+5);
    strcpy(module,buf1);
    strcpy(strstr(module,"****"),"");
    if (module[0]=='"') 
      strcpy(module,module+1);
    strcpy(strrchr(module,'"'),"");

    if (strcmp(old_l,library)!=0) {
      strcpy(old_l,library);
      m=NULL;

      if (l==NULL) {
	l=(Library *)malloc(sizeof(Library));
	libs=l;
      } else {
	l->next=(Library *)malloc(sizeof(Library));
	l=l->next;
      }
      l->name=strdup(library);
      l->next=NULL;
    }

    if (m==NULL) {
      m=(Mod_lib *)malloc(sizeof(Mod_lib));
      l->mod_lib=m;
    } else {
      m->next=(Mod_lib *)malloc(sizeof(Mod_lib));
      m=m->next;
    }
    m->name=strdup(module);
    m->next=NULL;

    end=fgets(buf1,1024,fp);
  }

  fclose(fp);
  return;
}

