/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#define SUN
/* #define CRAY */


#include <localsys.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>
#include <memory.h>
#include <sys/types.h>
#include "std.h"
#include "agm.h"
#ifdef SUN
#include "agm_collection_types.h"
#include "agm_field_sizes.h"
#endif
#ifdef CRAY
#include "agm_co_types.h"
#include "agm_fld_szes.h"
#endif
#include "agm_tree.h"


/* #define PURIFY_DEBUG */

#define MAX_MESSAGE_LEN			256

#define SEGMENT_HASH_TABLE_SIZE		10000
#define ATTRIBUTE_HASH_TABLE_SIZE	10000

#define NO_ID				0
#define NO_TYPE				0
#define NO_SEGMENT			-1

#define DATA_SET			-1

#define seg_hash(x)			(((x)-1) % SEGMENT_HASH_TABLE_SIZE )
#define atb_hash(x)			(((x)-1) % ATTRIBUTE_HASH_TABLE_SIZE )


extern void	agm_io_delete_model( String );

static String concat( String s, ... );
static String fstring_to_cstring( va_list args );
static String *n_fstring_to_cstring( va_list args, int n );
static void cstring_to_fstring( va_list args, String string );
static void n_cstring_to_fstring( va_list args, String *string, int n );
static int create_model( String modelname );
static int delete_model( String modelname );
static int activate_model( String modelname );
static int replace_model_name( String newmodelname );
static int get_number_models( unsigned *nmodels );
static int get_nth_model_name( unsigned nthmodel, String *modelname );
static int put_model_misc( String userid, String ownername, String expirydate, String description );
static int replace_model_misc( String userid, String ownername, String expirydate, String description );
static int get_model_misc( String *userid, String *ownername, String *expirydate, String *description );
static int put_mdmodmisc_item( unsigned itemtype, String string );
static int replace_mdmodmisc_item( unsigned itemtype, String string );
static int get_mdmodmisc_item( unsigned itemtype, String *outstring );
static int put_model_world( Units *units, Factors *factors, Extents *extents );
static int replace_model_world( Units *units, Factors *factors, Extents *extents );
static int get_model_world( Units *units, Factors *factors, Extents *extents );
static int put_mdmodwrld_item( unsigned itemtype, caddr_t item );
static int replace_mdmodwrld_item( unsigned itemtype, caddr_t item );
static int get_mdmodwrld_item( unsigned itemtype, caddr_t item );
static int put_model_loc( Location *location, double zoffset, double azimuth, double latitude, double longitude, String projectionsystem );
static int replace_model_loc( Location *location, double zoffset, double azimuth, double latitude, double longitude, String projectionsystem );
static int get_model_loc( Location *location, float *zoffset, float *azimuth, float *latitude, float *longitude, String *projectionsystem );
static int put_mdmodloc_item( unsigned itemtype, caddr_t item );
static int replace_mdmodloc_item( unsigned itemtype, caddr_t item );
static int get_mdmodloc_item( unsigned itemtype, caddr_t item );
static int create_version( Version version );
static int delete_version( Version version );
static int activate_version( Version version );
static int get_number_versions( unsigned *nversions );
static int get_nth_version_number( unsigned nthversion, Version *version );
static int replace_version_number( Version version );
static int put_version_misc( Version parentversion, String creationdate, String creationtime, String lastupdate, String lastuptime, String description );
static int replace_version_misc( Version parentversion, String creationdate, String creationtime, String lastupdate, String lastuptime, String description );
static int get_version_misc( Version *parentversion, String *creationdate, String *creationtime, String *lastupdate, String *lastuptime, String *description );
static int put_mdvermisc_item( unsigned itemtype, caddr_t item );
static int replace_mdvermisc_item( unsigned itemtype, caddr_t item );
static int get_mdvermisc_item( unsigned itemtype, caddr_t item );
static int put_lineage( String history );
static int replace_lineage( String history );
static int get_lineage( String *history );
static int put_mdlineage_item( unsigned itemtype, caddr_t item );
static int replace_mdlineage_item( unsigned itemtype, caddr_t item );
static int get_mdlineage_item( unsigned itemtype, caddr_t item );
static int restrict_collection_type( Type type );
static int get_number_collections( unsigned *ncollections );
static int get_nth_collection_misc( unsigned nthcollection, Id *collectionid, Id *parentcollectionid, Type *collectiontype, String *description );
static int get_next_collection_misc( Id *collectionid, Id *parentcollectionid, Type *collectiontype, String *description );
static int create_collection( Id collectionid );
static int activate_collection( Id globcollectionid );
static int activate_indexed_collection( unsigned index );
static int put_collection_parent( Id parentcollectionid );
static int put_collection_type( Type collectiontype );
static int put_collection_description( String description );
static int put_id_collection_misc( Id globcollectionid, Id parentcollectionid, Type collectiontype, String description );
static int put_new_collection_misc( Id collectionparentid, Type collectiontype, String description );
static int get_number_collection_types( unsigned *ntypes );
static int get_nth_collection_type( unsigned nthtype, Type *type );
static int get_number_of_collection_type( Type collectiontype, unsigned *ncollections );
static int get_collection_type_nth_collection_id( Type collectiontype, unsigned nthcollection, Id *collectionid );
static int get_indexed_collection_id( unsigned nthcollection, Id *collectionid );
static int get_collection_type_nth_collection_misc( Type collectiontype, unsigned nthcollection, Id *parentcollectionid, String *description );
static int get_collection_parent_id( Id *parentcollectionid );
static int get_collection_description( String *description );
static int get_collection_type( Type *type );
static int get_collection_type_nth_collection_segments( Type collectiontype, unsigned nthcollection, unsigned *nsegments, unsigned **segmentsnpts, Tupleptr **segments );
static int get_collection_segments( unsigned *nsegments, unsigned **segmentsnpts, Tupleptr **segments );
static int delete_collection_type( Type collectiontype );
static int get_number_collection_segment_links( unsigned *nlinks );
static int get_nth_collection_segment_link( unsigned nthlink, Id *collectionid, Id *segmentid );
static int get_next_collection_segment_link( Id *collectionid, Id *segmentid );
static int put_id_collection_segment_link( Id globcollectionid, Id globsegmentid );
static int put_segment_link( Id globsegmentid );
static int create_attribute( Id attributeid );
static int activate_attribute( Id attributeid );
static int activate_collection_indexed_attribute( unsigned index );
static int put_attribute_abbreviation( String abbreviation );
static int put_attribute_component( double component );
static int put_attribute_components( unsigned ncomponents, float *components );
static int put_attribute_location( Location *location );
static int put_attribute_locations( unsigned nlocations, Location *locations );
static int put_attribute_set( String filename, unsigned nelements, float *attribute_set );
static int get_attribute_set( unsigned *nelements, float **attribute_set );
static int get_number_collection_attribute_links( unsigned *nlinks );
static int get_nth_collection_attribute_link( unsigned nthlink, Id *collectionid, Id *attributeid );
static int get_id_collection_attribute_ids( Id collectionid, Id **attributeids, unsigned *nattributeids );
static int put_id_collection_attribute_link( Id globcollectionid, Id attributeid );
static int get_type_nth_collection_attribute_ids( Type collectiontype, unsigned nthcollection, Id **attributeids, unsigned *nattributeids );
static int get_number_attribute_misc( unsigned *nmisc );
static int get_nth_attribute_misc( unsigned nthmisc, String *abbrev, Unit *unit, Factor *factor, String *description );
static int put_attribute_misc( String abbreviation, Unit unit, Factor factor, String description );
static int get_number_attribute_abbreviations( unsigned *nabbreviations );
static int get_nth_attribute_abbreviation( unsigned nthabbreviation, Id *attributeid, String *abbreviation );
static int put_id_attribute_abbreviation( Id attributeid, String abbreviation );
static int get_id_attribute_abbreviation( Id attributeid, String *abbreviation );
static int get_collection_attribute_abbreviations( unsigned *nabbrevs, String **abbreviations );
static int loccompare( Location *i, Location *j );
static int get_collection_number_locations( unsigned *nuniquelocations );
static int get_number_attribute_components( unsigned *ncomponents );
static int get_nth_attribute_component( unsigned nthcomponent, Id *attributeid, Id *componentid, float *component );
static int get_attribute_components( unsigned *ncomponents, float **components );
static int get_id_attribute_nth_component( Id attributeid, unsigned nthcomponent, Id *componentid, float *component );
static int put_id_attribute_component( Id attributeid, Id componentid, double component );
static int get_number_attribute_locations( unsigned *nlocations );
static int get_nth_attribute_location( unsigned nthlocation, Id *attributeid, Id *locationid, Location *location );
static int get_id_attribute_nth_location( Id attributeid, unsigned nthlocation, Id *locationid, Location *location );
static int get_attribute_locations( unsigned *nlocations, Location **locations );
static int put_id_attribute_location( Id attributeid, Id locationid, Location *location );
static int put_attribute( String abbreviation, unsigned ncomponents, float *components, unsigned nlocations, Location *locations );
static int create_segment( Id segmentid );
static int activate_segment( Id segmentid );
static int get_number_segments( unsigned *nsegments );
static int get_nth_segment( unsigned nthsegment, Id *segmentid, Tupleptr *segment, unsigned *npts );
static int get_next_segment( Id *segmentid, Tupleptr *segment, unsigned *npts );
static int put_segment_point( Id globsegmentid, Id pointid, Location *location );
static int put_2d_segment( Tuple2Dptr pointlistptr, unsigned npoints );
static int put_segment( Tupleptr pointlistptr, unsigned npoints );
static int replace_segment( Tupleptr pointlistptr, unsigned npoints );
static int get_collection_num_segs_pts( Idlistptr segmentidlistptr, unsigned *nsegments, unsigned *totalpts );
static int get_collection_num_segs( Idlistptr segmentidlistptr, unsigned *nsegments );
static int get_collection_num_seg_pts( Idlistptr segmentidlistptr, unsigned *nsegpoints );
static int copy_segments( Idlistptr segmentidlistptr, Tupleptr *segments );
static void delete_segment( Id segmentid );
static void delete_attribute( Id attributeid );
static int put_2d_grid_info( Id collectionid, double xorigin, double zorigin, double xintsize, double zintsize, unsigned numintvx, unsigned numintvz );
/* static int make_attribute_set( String attrib_abbrev, unsigned nx, unsigned ny, unsigned nz ); */
/* static int init_location_hash( void ); */
/* static unsigned location_hash( float x, float y, float z ); */
static void handle_empty_model_list( String source );
static void handle_empty_version_list( String source );
static Id new_collection_id( void );
static Id new_segment_id( void );
static Id new_attribute_id( void );
static Id new_attribute_component_id( Componentlistptr crootptr );
static Id new_attribute_location_id( Locationlistptr lrootptr );
static int intcompare( int *i, int *j );
static int rtend( String s );
static int ilistalloc( int i );
static int ilistget( int **ilist );
static int ilistfree( void );
static char *allocstr( String s );

static char			message[MAX_MESSAGE_LEN+1] = { '\0' };
static String			comments = NULL;
static Modellistptr		modelroot = NULL;
static Modellistptr		modellistptr = NULL;
static Versionlistptr		versionlistptr = NULL;
static Collectionlistptr	glob_collection_ptr = NULL;
static Idlistptr		glob_segment_ptr = NULL;
static Segmentlistptr		glob_segment_list_ptr = NULL;
static int			glob_seg_hash_addr = -1;
static Id			globcollectionid = NO_ID;
static Id			globsegmentid = NO_ID;
static Id			globattributeid = NO_ID;
static Id			highest_collection_id = NO_ID;
static Id			highest_segment_id = NO_ID;
static Boolean			connect_segments = FALSE;
static Type			restricted_collection_type = ALL_TYPES;


/*******************/
/*** C Interface ***/
/*******************/

int agm( unsigned command, ... )
{
   va_list		args;
   Units		*units;
   Unit			unit;
   Unit			*outunit;
   Factors		*factors;
   double		factor;
   Factor		*outfactor;
   Extents		*extents;
   Location		*location, *locations;
   Location		**outlocations;
   Tupleptr		tupleptr;
   Tupleptr		*outsegment, **outsegments;
   Tuple2Dptr		tuple2dptr;
   Version		parentversion, version;
   Version		*outversion, *outparentversion;
   String		*outcomments, *outmessage, *outmodelname;
   String		userid, ownername, expirydate, description;
   String		*outuserid, *outownername, *outexpirydate;
   String		*outdescription;
   String		projectionsystem;
   String		*outprojectionsystem;
   String		creationdate, creationtime, lastupdate, lastuptime;
   String		*outcreationdate, *outcreationtime, *outlastupdate;
   String		*outlastuptime;
   String		abbreviation, filename;
   String		*outabbreviation, **outabbreviations;
   double		zoffset, azimuth, latitude, longitude;
   float		*outzoffset, *outazimuth, *outlatitude, *outlongitude;
   double		component, xorigin, zorigin, xintsize, zintsize;
   double		dvalue;
   float		*components, *attributeset;
   float		*outcomponent, **outcomponents, **outattributeset;
   Id			parentcollectionid;
   Id			*outcollectionid, *outparentcollectionid, *outsegmentid;
   Id			locationid, componentid, pointid;
   Id			*outlocationid, *outcomponentid, *outattributeid;
/* Id                   **outcomponentids, **outlocationids; */
   Id			**outattributeids;
   Type			collectiontype;
   Type			*outcollectiontype;
   unsigned		index;
   unsigned		nthmodel, nthversion, nthcollection, nthcollectiontype;
   unsigned		nthlink, nthmisc, nthabbrev, nthcomponent, nthlocation;
   unsigned		nthsegment;
   unsigned		npoints, ncomponents, nlocations, nelements;
   unsigned		numintvx, numintvz;
   unsigned		*outncomponents, *outnlocations, *outnsegments;
   unsigned		*outnpts, *outncollections, *outnattributeids;
   unsigned		*outnabbreviations, **outsegmentsnpts, *outnelements;
   int			rc = 0;


   va_start( args, command );

   switch( command )  {
   case PutComments:					/* General */
      if( comments )  {
         (void)sprintf ( message,
                         "agm(PutComments): comments already buffered." );
         rc = -1;
      } else
         comments = strdup( va_arg( args, String ) );
      break;
   case ReplaceComments:
      if( !comments )  {
         (void)sprintf ( message,
                      "agm(ReplaceComments): no comments currently buffered." );
         rc = -1;
      } else {
         free( comments );
         comments = strdup( va_arg( args, String ) );
      }
      break;
   case GetComments:
      if( !comments )  {
         (void)sprintf ( message,
                         "agm(GetComments): no comments currently buffered." );
         rc = -1;
      } else {
         outcomments = va_arg( args, String* );
         *outcomments = comments;
      }
      break;

   case GetMessage:
      outmessage = va_arg( args, String* );
      *outmessage = message;
      break;

   case CreateModel:					/* Model ROOT */
      rc = create_model( va_arg( args, String ) );
      break;
   case DeleteModel:
      if( (rc = delete_model( va_arg( args, String ) )) == 0 )  {
         agm_io_delete_model( modellistptr->modelname );
         free( (char *)modellistptr->modelname );
         free( (char *)modellistptr );
         modellistptr = NULL;  /* free does NOT guarantee NULLness */
      }
      break;
   case ActivateModel:
      rc = activate_model( va_arg( args, String ) );
      break;

   case GetModelName:
      if( modellistptr == NULL )  {
         handle_empty_model_list( "GetModelName" );
         rc = 1;
      } else {
         outmodelname = va_arg( args, String* );
         *outmodelname = modellistptr->modelname;
      }
      break;
   case ReplaceModelName:
      rc = replace_model_name( va_arg( args, String ) );
      break;
   case GetNumberModels:
      rc = get_number_models( va_arg( args, unsigned* ) );
      break;
   case GetIndexedModelName:
      nthmodel = va_arg( args, unsigned );
      rc = get_nth_model_name( nthmodel, va_arg( args, String* ) );
      break;

   case PutModelMiscellaneous:				/* MDMODMISC */
      userid = va_arg( args, String );
      ownername = va_arg( args, String );
      expirydate = va_arg( args, String );
      description = va_arg( args, String );
      rc = put_model_misc( userid, ownername, expirydate, description );
      break;
   case ReplaceModelMiscellaneous:
      userid = va_arg( args, String );
      ownername = va_arg( args, String );
      expirydate = va_arg( args, String );
      description = va_arg( args, String );
      rc = replace_model_misc( userid, ownername, expirydate, description );
      break;
   case GetModelMiscellaneous:
      outuserid = va_arg( args, String* );
      outownername = va_arg( args, String* );
      outexpirydate = va_arg( args, String* );
      outdescription = va_arg( args, String* );
      rc = get_model_misc( outuserid, outownername, outexpirydate,
                           outdescription );
      break;
   case PutUserId:
      rc = put_mdmodmisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceUserId:
      rc = replace_mdmodmisc_item( command, va_arg( args, String ) );
      break;
   case GetUserId:
      rc = get_mdmodmisc_item( command, va_arg( args, String* ) );
      break;
   case PutOwnerName:
      rc = put_mdmodmisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceOwnerName:
      rc = replace_mdmodmisc_item( command, va_arg( args, String ) );
      break;
   case GetOwnerName:
      rc = get_mdmodmisc_item( command, va_arg( args, String* ) );
      break;
   case PutExpiryDate:
      rc = put_mdmodmisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceExpiryDate:
      rc = replace_mdmodmisc_item( command, va_arg( args, String ) );
      break;
   case GetExpiryDate:
      rc = get_mdmodmisc_item( command, va_arg( args, String* ) );
      break;
   case PutModelDescription:
      rc = put_mdmodmisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceModelDescription:
      rc = replace_mdmodmisc_item( command, va_arg( args, String ) );
      break;
   case GetModelDescription:
      rc = get_mdmodmisc_item( command, va_arg( args, String* ) );
      break;

   case PutModelWorld:					/* MDMODWRLD */
      units = va_arg( args, Units* );
      factors = va_arg( args, Factors* );
      extents = va_arg( args, Extents* );
      rc = put_model_world( units, factors, extents );
      break;
   case ReplaceModelWorld:
      units = va_arg( args, Units* );
      factors = va_arg( args, Factors* );
      extents = va_arg( args, Extents* );
      rc = replace_model_world( units, factors, extents );
      break;
   case GetModelWorld:
      units = va_arg( args, Units* );
      factors = va_arg( args, Factors* );
      extents = va_arg( args, Extents* );
      rc = get_model_world( units, factors, extents );
      break;
   case PutUnits:
      rc = put_mdmodwrld_item( command, (caddr_t)va_arg( args, Units* ) );
      break;
   case ReplaceUnits:
      rc = replace_mdmodwrld_item( command, (caddr_t)va_arg( args, Units* ) );
      break;
   case GetUnits:
      rc = get_mdmodwrld_item( command, (caddr_t)va_arg( args, Units* ) );
      break;
   case PutFactors:
      rc = put_mdmodwrld_item( command, (caddr_t)va_arg( args, Factors* ) );
      break;
   case ReplaceFactors:
      rc = replace_mdmodwrld_item( command, (caddr_t)va_arg( args, Factors* ) );
      break;
   case GetFactors:
      rc = get_mdmodwrld_item( command, (caddr_t)va_arg( args, Factors* ) );
      break;
   case PutExtents:
      rc = put_mdmodwrld_item( command, (caddr_t)va_arg( args, Extents* ) );
      break;
   case ReplaceExtents:
      rc = replace_mdmodwrld_item( command, (caddr_t)va_arg( args, Extents* ) );
      break;
   case GetExtents:
      rc = get_mdmodwrld_item( command, (caddr_t)va_arg( args, Extents* ) );
      break;

   case PutModelLocation:				/* MDMODLOC */
      location = va_arg( args, Location* );
      zoffset = va_arg( args, double );  /* floats stack as doubles */
      azimuth = va_arg( args, double );
      latitude = va_arg( args, double );
      longitude = va_arg( args, double );
      projectionsystem = va_arg( args, String );
      rc = put_model_loc( location, zoffset, azimuth, latitude, longitude,
                          projectionsystem );
      break;
   case ReplaceModelLocation:
      location = va_arg( args, Location* );
      zoffset = va_arg( args, double );  /* floats stack as doubles */
      azimuth = va_arg( args, double );
      latitude = va_arg( args, double );
      longitude = va_arg( args, double );
      projectionsystem = va_arg( args, String );
      rc = replace_model_loc( location, zoffset, azimuth, latitude, longitude,
                              projectionsystem );
      break;
   case GetModelLocation:
      location = va_arg( args, Location* );
      outzoffset = va_arg( args, float* );
      outazimuth = va_arg( args, float* );
      outlatitude = va_arg( args, float* );
      outlongitude = va_arg( args, float* );
      outprojectionsystem = va_arg( args, String* );
      rc = get_model_loc( location, outzoffset, outazimuth, outlatitude,
                          outlongitude, outprojectionsystem );
      break;
   case PutLocation:
      rc = put_mdmodloc_item( command, (caddr_t)va_arg( args, Location* ) );
      break;
   case ReplaceLocation:
      rc = replace_mdmodloc_item( command, (caddr_t)va_arg( args, Location* ) );
      break;
   case GetLocation:
      rc = get_mdmodloc_item( command, (caddr_t)va_arg( args, Location* ) );
      break;
   case PutZoffset:
      dvalue = va_arg( args, double );
      rc = put_mdmodloc_item( command, (caddr_t)&dvalue );
      break;
   case ReplaceZoffset:
      dvalue = va_arg( args, double );
      rc = replace_mdmodloc_item( command, (caddr_t)&dvalue );
      break;
   case GetZoffset:
      rc = get_mdmodloc_item( command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutAzimuth:
      dvalue = va_arg( args, double );
      rc = put_mdmodloc_item( command, (caddr_t)&dvalue );
      break;
   case ReplaceAzimuth:
      dvalue = va_arg( args, double );
      rc = replace_mdmodloc_item( command, (caddr_t)&dvalue );
      break;
   case GetAzimuth:
      rc = get_mdmodloc_item( command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutLatitude:
      dvalue = va_arg( args, double );
      rc = put_mdmodloc_item( command, (caddr_t)&dvalue );
      break;
   case ReplaceLatitude:
      dvalue = va_arg( args, double );
      rc = replace_mdmodloc_item( command, (caddr_t)&dvalue );
      break;
   case GetLatitude:
      rc = get_mdmodloc_item( command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutLongitude:
      dvalue = va_arg( args, double );
      rc = put_mdmodloc_item( command, (caddr_t)&dvalue );
      break;
   case ReplaceLongitude:
      dvalue = va_arg( args, double );
      rc = replace_mdmodloc_item( command, (caddr_t)&dvalue );
      break;
   case GetLongitude:
      rc = get_mdmodloc_item( command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutProjectionSystem:
      rc = put_mdmodloc_item( command, (caddr_t)va_arg( args, String ) );
      break;
   case ReplaceProjectionSystem:
      rc = replace_mdmodloc_item( command, (caddr_t)va_arg( args, String ) );
      break;
   case GetProjectionSystem:
      rc = get_mdmodloc_item( command, (caddr_t)va_arg( args, String* ) );
      break;

   case CreateVersion:					/* Version ROOT */
      rc = create_version( va_arg( args, Version ) );
      break;
   case DeleteVersion:
      rc = delete_version( va_arg( args, Version ) );
      break;
   case ActivateVersion:
      rc = activate_version( va_arg( args, Version ) );
      break;

   case GetNumberVersions:				/* Version misc */
      rc = get_number_versions( va_arg( args, unsigned* ) );
      break;
   case GetIndexedVersionNumber:
      nthversion = va_arg( args, unsigned );
      rc = get_nth_version_number( nthversion, va_arg( args, Version* ) );
      break;
   case GetVersionNumber:
      if( versionlistptr == NULL )  {
         handle_empty_version_list( "GetVersionNumber" );
         rc = 2;
      } else {
         outversion = va_arg( args, Version* );
         *outversion = versionlistptr->version;
      }
      break;
   case ReplaceVersionNumber:
      rc = replace_version_number( va_arg( args, Version ) );
      break;

   case PutVersionMiscellaneous:			/* MDVERMISC */
      parentversion = va_arg( args, Version );
      creationdate = va_arg( args, String );
      creationtime = va_arg( args, String );
      lastupdate = va_arg( args, String );
      lastuptime = va_arg( args, String );
      description = va_arg( args, String );
      rc = put_version_misc( parentversion, creationdate, creationtime,
                             lastupdate, lastuptime, description );
      break;
   case ReplaceVersionMiscellaneous:
      parentversion = va_arg( args, Version );
      creationdate = va_arg( args, String );
      creationtime = va_arg( args, String );
      lastupdate = va_arg( args, String );
      lastuptime = va_arg( args, String );
      description = va_arg( args, String );
      rc = replace_version_misc( parentversion, creationdate, creationtime,
                                 lastupdate, lastuptime, description );
      break;
   case GetVersionMiscellaneous:
      outparentversion = va_arg( args, Version* );
      outcreationdate = va_arg( args, String* );
      outcreationtime = va_arg( args, String* );
      outlastupdate = va_arg( args, String* );
      outlastuptime = va_arg( args, String* );
      outdescription = va_arg( args, String* );
      rc = get_version_misc( outparentversion, outcreationdate, outcreationtime,
                             outlastupdate, outlastuptime, outdescription );
      break;
   case PutVersionParent:
		version = va_arg( args, Version );
      rc = put_mdvermisc_item( command, (caddr_t)&version );
      break;
   case ReplaceVersionParent:
		version = va_arg( args, Version );
      rc = replace_mdvermisc_item( command, (caddr_t)&version );
      break;
   case GetVersionParent:
      rc = get_mdvermisc_item( command, (caddr_t)va_arg( args, Version* ) );
      break;
   case PutVersionCreationDate:
      rc = put_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceVersionCreationDate:
      rc = replace_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case GetVersionCreationDate:
      rc = get_mdvermisc_item( command, (caddr_t)va_arg( args, String* ) );
      break;
   case PutVersionCreationTime:
      rc = put_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceVersionCreationTime:
      rc = replace_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case GetVersionCreationTime:
      rc = get_mdvermisc_item( command, (caddr_t)va_arg( args, String* ) );
      break;
   case PutVersionLastUpDate:
      rc = put_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceVersionLastUpDate:
      rc = replace_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case GetVersionLastUpDate:
      rc = get_mdvermisc_item( command, (caddr_t)va_arg( args, String* ) );
      break;
   case PutVersionLastUpTime:
      rc = put_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceVersionLastUpTime:
      rc = replace_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case GetVersionLastUpTime:
      rc = get_mdvermisc_item( command, (caddr_t)va_arg( args, String* ) );
      break;
   case PutVersionDescription:
      rc = put_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case ReplaceVersionDescription:
      rc = replace_mdvermisc_item( command, va_arg( args, String ) );
      break;
   case GetVersionDescription:
      rc = get_mdvermisc_item( command, (caddr_t)va_arg( args, String* ) );
      break;

   case PutVersionLineage:					/* MDLINEAGE */
      rc = put_lineage( va_arg( args, String ) );
      break;
   case ReplaceVersionLineage:
      rc = replace_lineage( va_arg( args, String ) );
      break;
   case GetVersionLineage:
      rc = get_lineage( va_arg( args, String* ) );
      break;
   case PutVersionHistory:
      rc = put_mdlineage_item( command, va_arg( args, String ) );
      break;
   case ReplaceVersionHistory:
      rc = replace_mdlineage_item( command, va_arg( args, String ) );
      break;
   case GetVersionHistory:
      rc = get_mdlineage_item( command, (caddr_t)va_arg( args, String* ) );
      break;

   case RestrictCollectionType:				/* Collection Info. */
      rc = restrict_collection_type( va_arg( args, Type ) );
      break;
   case GetNumberCollections:
      rc = get_number_collections( va_arg( args, unsigned* ) );
      break;
   case GetNthCollectionMiscellaneous:
      nthcollection = va_arg( args, unsigned );
      outcollectionid = va_arg( args, Id* );
      outparentcollectionid = va_arg( args, Id* );
      outcollectiontype = va_arg( args, Type* );
      outdescription = va_arg( args, String* );
      rc = get_nth_collection_misc( nthcollection, outcollectionid,
              outparentcollectionid, outcollectiontype, outdescription );
      break;
   case GetNextCollectionMiscellaneous:
      outcollectionid = va_arg( args, Id* );
      outparentcollectionid = va_arg( args, Id* );
      outcollectiontype = va_arg( args, Type* );
      outdescription = va_arg( args, String* );
      rc = get_next_collection_misc( outcollectionid, outparentcollectionid,
              outcollectiontype, outdescription );
      break;
   case GetCollectionId:
      outcollectionid = va_arg( args, Id* );
      *outcollectionid = globcollectionid;
      break;

   case CreateCollection:				/* COLLECTION */
      globcollectionid = va_arg( args, Id );
      rc = create_collection( globcollectionid );
      break;
   case ActivateCollection:
      globcollectionid = va_arg( args, Id );
      rc = activate_collection( globcollectionid );
      break;
   case ActivateIndexedCollection:
      index = va_arg( args, unsigned );
      rc = activate_indexed_collection( index );
      break;

   case PutCollectionParent:				/* MDCOLMISC */
      parentcollectionid = va_arg( args, Id );
      rc = put_collection_parent( parentcollectionid );
      break;
   case PutCollectionType:
      collectiontype = va_arg( args, Type );
      rc = put_collection_type( collectiontype );
      break;
   case PutCollectionDescription:
      description = va_arg( args, String );
      rc = put_collection_description( description );
      break;

   case PutIdCollectionMiscellaneous:
      globcollectionid = va_arg( args, Id );
      parentcollectionid = va_arg( args, Id );
      collectiontype = va_arg( args, Type );
      description = va_arg( args, String );
      rc = put_id_collection_misc( globcollectionid, parentcollectionid,
                                   collectiontype, description );
      break;
   case ReplaceIdCollectionMiscellaneous:
      globcollectionid = va_arg( args, Id );
      parentcollectionid = va_arg( args, Id );
      collectiontype = va_arg( args, Type );
      description = va_arg( args, String );
/*    rc = replace_id_collection_misc( globcollectionid, parentcollectionid,
                                       collectiontype, description );
*/
      break;
   case GetIdCollectionMiscellaneous:
      globcollectionid = va_arg( args, Id );
      outparentcollectionid = va_arg( args, Id* );
      outcollectiontype = va_arg( args, Type* );
      outdescription = va_arg( args, String* );
/*    rc = get_id_collection_misc( globcollectionid, outparentcollectionid,
                                   outcollectiontype, outdescription );
*/
      break;

   case PutNewCollectionMiscellaneous:
      parentcollectionid = va_arg( args, Id );
      collectiontype = va_arg( args, Type );
      description = va_arg( args, String );
      rc = put_new_collection_misc( parentcollectionid, collectiontype,
                                    description );
      break;

   case GetNumberCollectionTypes:			/* Collection Types */
      rc = get_number_collection_types( va_arg( args, unsigned* ) );
      break;
   case GetIndexedCollectionType:
      nthcollectiontype = va_arg( args, unsigned );
      outcollectiontype = va_arg( args, Type* );
      rc = get_nth_collection_type( nthcollectiontype, outcollectiontype );
      break;
   case GetNumberOfCollectionType:
      collectiontype = va_arg( args, Type );
      outncollections = va_arg( args, unsigned* );
      rc = get_number_of_collection_type( collectiontype, outncollections );
      break;
   case GetCollectionTypeNthCollectionId:
      collectiontype = va_arg( args, Type );
      nthcollection = va_arg( args, unsigned );
      outcollectionid = va_arg( args, Id* );
      rc = get_collection_type_nth_collection_id( collectiontype, nthcollection,
                                                  outcollectionid );
      break;
   case GetIndexedCollectionId:
      index = va_arg( args, unsigned );
      outcollectionid = va_arg( args, Id* );
      rc = get_indexed_collection_id( index, outcollectionid );
      break;
   case GetCollectionTypeNthCollectionMiscellaneous:
      collectiontype = va_arg( args, Type );
      nthcollection = va_arg( args, unsigned );
      outparentcollectionid = va_arg( args, Id* );
      outdescription = va_arg( args, String* );
      rc = get_collection_type_nth_collection_misc( collectiontype,
              nthcollection, outparentcollectionid, outdescription );
      break;
   case GetCollectionParent:
      outparentcollectionid = va_arg( args, Id* );
      rc = get_collection_parent_id( outparentcollectionid );
      break;
   case GetCollectionDescription:
      outdescription = va_arg( args, String* );
      rc = get_collection_description( outdescription );
      break;
   case GetCollectionType:
      outcollectiontype = va_arg( args, Type* );
      rc = get_collection_type( outcollectiontype );
      break;
   case GetCollectionSegments:
      outnsegments = va_arg( args, unsigned* );
      outsegmentsnpts = va_arg( args, unsigned ** );
      outsegments = va_arg( args, Tupleptr ** );
      rc = get_collection_segments(outnsegments, outsegmentsnpts, outsegments );
      break;
   case GetCollectionTypeNthCollectionSegments:
      collectiontype = va_arg( args, Type );
      nthcollection = va_arg( args, unsigned );
      outnsegments = va_arg( args, unsigned* );
      outsegmentsnpts = va_arg( args, unsigned ** );
      outsegments = va_arg( args, Tupleptr ** );
      rc = get_collection_type_nth_collection_segments( collectiontype,
              nthcollection, outnsegments, outsegmentsnpts, outsegments );
      break;
   case DeleteCollectionType:
      rc = delete_collection_type( va_arg( args, Type ) );
      break;

   case GetNumberCollectionSegmentLinks:		/* Collection Segs */
      rc = get_number_collection_segment_links(
               va_arg( args, unsigned* ) );
      break;
   case GetNthCollectionSegmentLink:
      nthlink = va_arg( args, unsigned );
      outcollectionid = va_arg( args, Id* );
      outsegmentid = va_arg( args, Id* );
      rc = get_nth_collection_segment_link( nthlink, outcollectionid,
                                            outsegmentid );
      break;
   case GetNextCollectionSegmentLink:
      outcollectionid = va_arg( args, Id* );
      outsegmentid = va_arg( args, Id* );
      rc = get_next_collection_segment_link( outcollectionid, outsegmentid );
      break;

   case PutIdCollectionSegmentLink:			/* MDCOLSEGS */
      globcollectionid = va_arg( args, Id );
      globsegmentid = va_arg( args, Id );
      rc = put_id_collection_segment_link( globcollectionid, globsegmentid );
      break;
   case PutIdCollectionSegmentLinks:
      break;
   case AssociateSegment:
      globsegmentid = va_arg( args, Id );
      rc = put_segment_link( globsegmentid );
      break;

   case CreateAttribute:				/* ATTRIBUTE */
      globattributeid = va_arg( args, Id );
      rc = create_attribute( globattributeid );
      break;
   case ActivateAttribute:
      globattributeid = va_arg( args, Id );
      rc = activate_attribute( globattributeid );
      break;
   case ActivateCollectionIndexedAttribute:
      index = va_arg( args, unsigned );
      rc = activate_collection_indexed_attribute( index );
      break;

   case PutAttributeAbbreviation:			/* MDATBABRV */
      abbreviation = va_arg( args, String );
      rc = put_attribute_abbreviation( abbreviation );
      break;
   case PutAttributeComponent:				/* MDATBCOMP */
      component = va_arg( args, double );  /* floats stack as doubles */
      rc = put_attribute_component( component );
      break;
   case PutAttributeComponents:
      ncomponents = va_arg( args, unsigned );
      components = va_arg( args, float* );
      rc = put_attribute_components( ncomponents, components );
      break;
   case PutAttributeLocation:				/* MDATBLOC */
      location = va_arg( args, Location* );
      rc = put_attribute_location( location );
      break;
   case PutAttributeLocations:
      nlocations = va_arg( args, unsigned );
      location = va_arg( args, Location* );
      rc = put_attribute_locations( nlocations, location );
      break;

   case GetNumberCollectionAttributeLinks:		/* Collection Atbs */
      rc = get_number_collection_attribute_links(
                 va_arg( args, unsigned* ) );
      break;
   case GetNthCollectionAttributeLink:
      nthlink = va_arg( args, unsigned );
      outcollectionid = va_arg( args, Id* );
      outattributeid = va_arg( args, Id* );
      rc = get_nth_collection_attribute_link( nthlink, outcollectionid,
                                              outattributeid );
      break;
   case GetIdCollectionAttributeIds:
      globcollectionid = va_arg( args, Id );
      outattributeids = va_arg( args, Id ** );
      outnattributeids = va_arg( args, unsigned* );
      rc = get_id_collection_attribute_ids( globcollectionid, outattributeids,
                                            outnattributeids );
      break;

   case PutIdCollectionAttributeLink:			/* MDCOLATBS */
      globcollectionid = va_arg( args, Id );
      globattributeid = va_arg( args, Id );
      rc = put_id_collection_attribute_link( globcollectionid,
                                             globattributeid );
      break;
   case PutIdCollectionAttributeLinks:
      break;
   case GetTypeNthCollectionAttributeIds:
      collectiontype = va_arg( args, Type );
      nthcollection = va_arg( args, unsigned );
      outattributeids = va_arg( args, Id ** );
      outnattributeids = va_arg( args, unsigned* );
      rc = get_type_nth_collection_attribute_ids( collectiontype, nthcollection,
                                            outattributeids, outnattributeids );
      break;

   case GetNumberAttributeMiscellaneous:		/* Attribute Misc */
      rc = get_number_attribute_misc( va_arg( args, unsigned* ) );
      break;
   case GetNthAttributeMiscellaneous:
      nthmisc = va_arg( args, unsigned );
      outabbreviation = va_arg( args, String* );
      outunit = va_arg( args, Unit* );
      outfactor = va_arg( args, Factor* );
      outdescription = va_arg( args, String* );
      rc = get_nth_attribute_misc( nthmisc, outabbreviation, outunit, outfactor,
                                   outdescription );
      break;

   case PutAttributeMiscellaneous:			/* MDATBMISC */
      abbreviation = va_arg( args, String );
      unit = va_arg( args, Unit );
      factor = va_arg( args, double );  /* floats stack as doubles */
      description = va_arg( args, String );
      rc = put_attribute_misc( abbreviation, unit, factor, description );
      break;
   case ReplaceAttributeMiscellaneous:
      abbreviation = va_arg( args, String );
      unit = va_arg( args, Unit );
      factor = va_arg( args, double );  /* floats stack as doubles */
      description = va_arg( args, String );
      rc = put_attribute_misc( abbreviation, unit, factor, description );
      break;
   case GetAttributeMiscellaneous:
      outabbreviation = va_arg( args, String* );
      outunit = va_arg( args, Unit* );
      outfactor = va_arg( args, Factor* );
      outdescription = va_arg( args, String* );
/*    rc = get_attribute_misc( outabbreviation, outunit, outfactor,
                               outdescription ); */
      break;

   case GetNumberAttributeAbbreviations:		/* Attribute Abbrev. */
      rc = get_number_attribute_abbreviations( va_arg( args, unsigned* ) );
      break;
   case GetNthAttributeAbbreviation:
      nthabbrev = va_arg( args, unsigned );
      outattributeid = va_arg( args, Id* );
      outabbreviation = va_arg( args, String* );
      rc = get_nth_attribute_abbreviation( nthabbrev, outattributeid,
                                           outabbreviation );
      break;

   case PutIdAttributeAbbreviation:			/* MDATBABRV */
      globattributeid = va_arg( args, Id );
      abbreviation = va_arg( args, String );
      rc = put_id_attribute_abbreviation( globattributeid, abbreviation );
      break;
   case ReplaceIdAttributeAbbreviation:
      globattributeid = va_arg( args, Id );
      abbreviation = va_arg( args, String );
/*    rc = replace_id_attribute_abbreviation( globattributeid, abbreviation );*/
      break;
   case GetIdAttributeAbbreviation:
      globattributeid = va_arg( args, Id );
      outabbreviation = va_arg( args, String* );
      rc = get_id_attribute_abbreviation( globattributeid, outabbreviation );
      break;
   case GetCollectionAttributeAbbreviations:
      outnabbreviations = va_arg( args, unsigned* );
      outabbreviations = va_arg( args, String ** );
      rc = get_collection_attribute_abbreviations( outnabbreviations,
                                                   outabbreviations );
      break;
   case GetCollectionNumberLocations:
      outnlocations = va_arg( args, unsigned* );
      rc = get_collection_number_locations( outnlocations );
      break;

   case GetNumberAttributeComponents:			/* Attribute Component*/
      rc = get_number_attribute_components( va_arg( args, unsigned* ) );
      break;
   case GetNthAttributeComponent:
      nthcomponent = va_arg( args, unsigned );
      outattributeid = va_arg( args, Id* );
      outcomponentid = va_arg( args, Id* );
      outcomponent = va_arg( args, float* );
      rc = get_nth_attribute_component( nthcomponent, outattributeid,
                                        outcomponentid, outcomponent );
      break;
   case GetIdAttributeNthComponent:
      globattributeid = va_arg( args, Id );
      nthcomponent = va_arg( args, unsigned );
      outcomponentid = va_arg( args, Id* );
      outcomponent = va_arg( args, float* );
      rc = get_id_attribute_nth_component( globattributeid, nthcomponent,
                                           outcomponentid, outcomponent );
      break;
   case GetAttributeComponents:
      outncomponents = va_arg( args, unsigned* );
      outcomponents = va_arg( args, float ** );
      rc = get_attribute_components( outncomponents, outcomponents );
      break;

   case PutIdAttributeComponent:			/* MDATBCOMP */
      globattributeid = va_arg( args, Id );
      componentid = va_arg( args, Id );
      component = va_arg( args, double );  /* floats stack as doubles */
      rc = put_id_attribute_component( globattributeid, componentid,
                                       component );
      break;
   case ReplaceIdAttributeComponent:
      break;
   case GetIdAttributeComponent:
      globattributeid = va_arg( args, Id );
      componentid = va_arg( args, Id );
      outcomponent = va_arg( args, float* );
/*    rc = get_id_attribute_component( globattributeid, componentid,
                                       outcomponent );
*/
      break;
   case PutIdAttributeComponents:
      break;
   case ReplaceIdAttributeComponents:
      break;
   case GetIdAttributeComponents:
      globattributeid = va_arg( args, Id );
/*    outcomponentids = va_arg( args, Id ** );
      outcomponents = va_arg( args, float ** );
      outncomponents = va_arg( args, unsigned* );
      rc = get_id_attribute_components( globattributeid, outcomponentids,
                                        outcomponents, outncomponents );
*/
      break;

   case GetNumberAttributeLocations:			/* Attribute Location */
      rc = get_number_attribute_locations( va_arg( args, unsigned* ) );
      break;
   case GetNthAttributeLocation:
      nthlocation = va_arg( args, unsigned );
      outattributeid = va_arg( args, Id* );
      outlocationid = va_arg( args, Id* );
      location = va_arg( args, Location* );
      rc = get_nth_attribute_location( nthlocation, outattributeid,
                                       outlocationid, location );
      break;
   case GetIdAttributeNthLocation:
      globattributeid = va_arg( args, Id );
      nthlocation = va_arg( args, unsigned );
      outlocationid = va_arg( args, Id* );
      location = va_arg( args, Location* );
      rc = get_id_attribute_nth_location( globattributeid, nthlocation,
                                          outlocationid, location );
      break;
   case GetAttributeLocations:
      outnlocations = va_arg( args, unsigned* );
      outlocations = va_arg( args, Location ** );
      rc = get_attribute_locations( outnlocations, outlocations );
      break;

   case PutIdAttributeLocation:				/* MDATBLOC */
      globattributeid = va_arg( args, Id );
      locationid = va_arg( args, Id );
      location = va_arg( args, Location* );
      rc = put_id_attribute_location( globattributeid, locationid, location );
      break;
   case ReplaceIdAttributeLocation:
      break;
   case GetIdAttributeLocation:
      globattributeid = va_arg( args, Id );
      locationid = va_arg( args, Id );
      location = va_arg( args, Location* );
/*    rc = get_id_attribute_location( globattributeid, locationid, location );
*/
      break;
   case PutIdAttributeLocations:
      break;
   case ReplaceIdAttributeLocations:
      break;
   case GetIdAttributeLocations:
      globattributeid = va_arg( args, Id );
/*    outlocationids = va_arg( args, Id ** );
      outlocations = va_arg( args, Location ** );
      outnlocations = va_arg( args, unsigned* );
      rc = get_id_attribute_locations( globattributeid, outlocationids,
                                       outlocation, outnlocations );
*/
      break;

   case PutAttributeSet:
      filename = va_arg( args, String );
      nelements = va_arg( args, unsigned );
      attributeset = va_arg( args, float* );
      rc = put_attribute_set( filename, nelements, attributeset );
      break;
   case GetAttributeSet:
      outnelements = va_arg( args, unsigned* );
      outattributeset = va_arg( args, float ** );
      rc = get_attribute_set( outnelements, outattributeset );
      break;
   case Put2DGridInfo:
      globcollectionid = va_arg( args, Id );
      xorigin = va_arg( args, double );  /* floats stack as doubles */
      zorigin = va_arg( args, double );
      xintsize = va_arg( args, double );
      zintsize = va_arg( args, double );
      numintvx = va_arg( args, unsigned );
      numintvz = va_arg( args, unsigned );
      rc = put_2d_grid_info( globcollectionid, xorigin, zorigin, xintsize,
                             zintsize, numintvx, numintvz );
      break;

   case PutAttribute:					/* Attribute info */
      abbreviation = va_arg( args, String );
      ncomponents = va_arg( args, unsigned );
      components = va_arg( args, float* );
      nlocations = va_arg( args, unsigned );
      locations = va_arg( args, Location* );
      rc = put_attribute( abbreviation, ncomponents, components, nlocations,
                          locations );
      break;

   case GetAttributeId:
      outattributeid = va_arg( args, Id* );
      *outattributeid = globattributeid;
      break;

   case CreateSegment:					/* Segment Pool */
      globsegmentid = va_arg( args, Id );
      rc = create_segment( globsegmentid );
      break;
   case ActivateSegment:
      globsegmentid = va_arg( args, Id );
      rc = activate_segment( globsegmentid );
      break;

   case GetNumberSegments:
      rc = get_number_segments( va_arg( args, unsigned* ) );
      break;
   case GetNthSegment:
      nthsegment = va_arg( args, unsigned );
      outsegmentid = va_arg( args, Id* );
      outsegment = va_arg( args, Tupleptr* );
      outnpts = va_arg( args, unsigned* );
      rc = get_nth_segment( nthsegment, outsegmentid, outsegment, outnpts );
      break;
   case GetNextSegment:
      outsegmentid = va_arg( args, Id* );
      outsegment = va_arg( args, Tupleptr* );
      outnpts = va_arg( args, unsigned* );
      rc = get_next_segment( outsegmentid, outsegment, outnpts );
      break;

   case PutSegmentPoint:
      globsegmentid = va_arg( args, Id );
      pointid = va_arg( args, Id );
      location = va_arg( args, Location* );
      rc = put_segment_point( globsegmentid, pointid, location );
      break;
   case Put2DSegment:
      tuple2dptr = va_arg( args, Tuple2Dptr );
      npoints = va_arg( args, unsigned );
      rc = put_2d_segment( tuple2dptr, npoints );
      break;
   case PutSegment:
      tupleptr = va_arg( args, Tupleptr );
      npoints = va_arg( args, unsigned );
      rc = put_segment( tupleptr, npoints );
      break;
   case ReplaceSegment:
      tupleptr = va_arg( args, Tupleptr );
      npoints = va_arg( args, unsigned );
      rc = replace_segment( tupleptr, npoints );
      break;
   case GetSegmentId:
      outsegmentid = va_arg( args, Id* );
      *outsegmentid = globsegmentid;
      break;

   case ConnectSegments:
#if defined(LINUXSYSTEM)
      connect_segments = va_arg( args, int );
#else
      connect_segments = va_arg( args, Boolean );
#endif
      break;

   default:
      fprintf( stderr, "agm: invalid command (%d).\n", command );
      rc = -1;
   }

   va_end( args );

   return( rc );
}


/*************************/
/*** FORTRAN Interface ***/
/*************************/

#ifdef SUN
int agm_( unsigned *command, ... )
#endif
#ifdef CRAY
#include <fortran.h>
int AGM( unsigned *command, ... )
#endif
{
   va_list		args;
   String		temp_string, temp_string2, temp_string3;
   String		fstring, fstring2, fstring3;
   String		*temp_string_array;
   String		cptr, outstring, outstring2, outstring3;
   unsigned		namelen, cnamelen;
   Units		units;
   Tupleptr		*tupleptr;
   Location		*location_ptr;
   double		dvalue;
   float		f, *f_ptr;
   int			rc = 0, i, offset, *i_ptr;
   unsigned		*u_ptr, *u_ptr2;
#ifdef CRAY
   _fcd			fcd;
#endif
 
 
   va_start( args, command );
 
   /* first argument must be a command code */
   switch( *command )  {  /* note: call by ref. */
   case PutComments:					/* General */
      if( comments )  {
         (void)sprintf ( message,
                         "agm(PutComments): comments already buffered." );
         rc = -1;
      } else
         comments = fstring_to_cstring( args );
      break;
   case ReplaceComments:
      if( !comments )  {
         (void)sprintf ( message,
                      "agm(ReplaceComments): no comments currently buffered." );
         rc = -1;
      } else {
         free( comments );
         comments = fstring_to_cstring( args );
      }
      break;
   case GetComments:
      if( !comments )  {
         (void)sprintf ( message,
                         "agm(GetComments): no comments currently buffered." );
         rc = -1;
      } else
         cstring_to_fstring( args, comments );
      break;

   case GetMessage:
      cstring_to_fstring( args, message );
      break;

   case CreateModel:					/* Model ROOT */
      rc = create_model( temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case DeleteModel:
      if( (rc = delete_model( temp_string = fstring_to_cstring( args ) ))
          == 0 )  {
         agm_io_delete_model( modellistptr->modelname );
         free( (char *)modellistptr->modelname );
         free( (char *)modellistptr );
         modellistptr = NULL;  /* free does NOT guarantee NULLness */
      }
      free( temp_string );
      break;
   case ActivateModel:
      rc = activate_model( temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;

   case GetModelName:
      if( modellistptr == NULL )  {
         handle_empty_model_list( "GetModelName" );
         rc = 1;
      } else
         cstring_to_fstring( args, modellistptr->modelname );
      break;
   case ReplaceModelName:
      rc = replace_model_name( temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case GetNumberModels:
      rc = get_number_models( va_arg( args, unsigned* ) );
      break;
   case GetIndexedModelName:
      rc = get_nth_model_name( *va_arg( args, int* ), &temp_string );
      cstring_to_fstring( args, temp_string );
      break;

   case PutUserId:
      rc = put_mdmodmisc_item( *command,
                               temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case ReplaceUserId:
      rc = replace_mdmodmisc_item( *command,
                                   temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case GetUserId:
      rc = get_mdmodmisc_item( *command, &temp_string );
      cstring_to_fstring( args, temp_string );
      break;
   case PutOwnerName:
      rc = put_mdmodmisc_item( *command,
                               temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case ReplaceOwnerName:
      rc = replace_mdmodmisc_item( *command,
                                   temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case GetOwnerName:
      rc = get_mdmodmisc_item( *command, &temp_string );
      cstring_to_fstring( args, temp_string );
      break;
   case PutExpiryDate:
      rc = put_mdmodmisc_item( *command,
                               temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case ReplaceExpiryDate:
      rc = replace_mdmodmisc_item( *command,
                                   temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case GetExpiryDate:
      rc = get_mdmodmisc_item( *command, &temp_string );
      cstring_to_fstring( args, temp_string );
      break;
   case PutModelDescription:
      rc = put_mdmodmisc_item( *command,
                               temp_string = fstring_to_cstring( args ) ); 
      free( temp_string );
      break;
   case ReplaceModelDescription:
      rc = replace_mdmodmisc_item( *command,
                                   temp_string = fstring_to_cstring( args ) ); 
      free( temp_string );
      break;
   case GetModelDescription:
      rc = get_mdmodmisc_item( *command, &temp_string );
      cstring_to_fstring( args, temp_string );
      break;

   case PutUnits:
      temp_string_array = n_fstring_to_cstring( args, 3 );
      rc = put_mdmodwrld_item( *command, (caddr_t)temp_string_array );
      for( i = 0;  i < 3;  i++ )
         free( temp_string_array[i] );
      free( temp_string_array );
      break;
   case ReplaceUnits:
      temp_string_array = n_fstring_to_cstring( args, 3 );
      rc = replace_mdmodwrld_item( *command, (caddr_t)temp_string_array );
      for( i = 0;  i < 3;  i++ )
         free( temp_string_array[i] );
      free( temp_string_array );
      break;
   case GetUnits:
      rc = get_mdmodwrld_item( *command, (caddr_t)&units );
      n_cstring_to_fstring( args, (String*)&units, 3 );
      break;
   case PutFactors:
      rc = put_mdmodwrld_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case ReplaceFactors:
      rc = replace_mdmodwrld_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case GetFactors:
      rc = get_mdmodwrld_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutExtents:
      rc = put_mdmodwrld_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case ReplaceExtents:
      rc = replace_mdmodwrld_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case GetExtents:
      rc = get_mdmodwrld_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutLocation:
      rc = put_mdmodloc_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case ReplaceLocation:
      rc = replace_mdmodloc_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case GetLocation:
      rc = get_mdmodloc_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutZoffset:
      dvalue = *va_arg( args, float* );
      rc = put_mdmodloc_item( *command, (caddr_t)&dvalue );
      break;
   case ReplaceZoffset:
      dvalue = *va_arg( args, float* );
      rc = replace_mdmodloc_item( *command, (caddr_t)&dvalue );
      break;
   case GetZoffset:
      rc = get_mdmodloc_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutAzimuth:
      dvalue = *va_arg( args, float* );
      rc = put_mdmodloc_item( *command, (caddr_t)&dvalue );
      break;
   case ReplaceAzimuth:
      dvalue = *va_arg( args, float* );
      rc = replace_mdmodloc_item( *command, (caddr_t)&dvalue );
      break;
   case GetAzimuth:
      rc = get_mdmodloc_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutLatitude:
      dvalue = *va_arg( args, float* );
      rc = put_mdmodloc_item( *command, (caddr_t)&dvalue );
      break;
   case ReplaceLatitude:
      dvalue = *va_arg( args, float* );
      rc = replace_mdmodloc_item( *command, (caddr_t)&dvalue );
      break;
   case GetLatitude:
      rc = get_mdmodloc_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutLongitude:
      dvalue = *va_arg( args, float* );
      rc = put_mdmodloc_item( *command, (caddr_t)&dvalue );
      break;
   case ReplaceLongitude:
      dvalue = *va_arg( args, float* );
      rc = replace_mdmodloc_item( *command, (caddr_t)&dvalue );
      break;
   case GetLongitude:
      rc = get_mdmodloc_item( *command, (caddr_t)va_arg( args, float* ) );
      break;
   case PutProjectionSystem:
      temp_string = fstring_to_cstring( args );
      if( (size_t)strlen( temp_string ) < PROJECTION_SYS_SIZE )  {
         temp_string2 = (String)malloc( PROJECTION_SYS_SIZE + 1 );
         (void)memset( temp_string2, (int)' ', PROJECTION_SYS_SIZE );
         (void)strncpy( temp_string2, temp_string,
			(size_t)strlen( temp_string ) );
         temp_string2[PROJECTION_SYS_SIZE] = '\0';
         free( temp_string );
         temp_string = temp_string2;
      }
      rc = put_mdmodloc_item( *command, temp_string );
      free( temp_string );
      break;
   case ReplaceProjectionSystem:
      if( (size_t)strlen( temp_string ) < PROJECTION_SYS_SIZE )  {
         temp_string2 = (String)malloc( PROJECTION_SYS_SIZE + 1 );
         (void)memset( temp_string2, (int)' ', PROJECTION_SYS_SIZE );
         (void)strncpy( temp_string2, temp_string, (size_t)strlen( temp_string ) );
         temp_string2[PROJECTION_SYS_SIZE] = '\0';
         free( temp_string );
         temp_string = temp_string2;
      }
      rc = replace_mdmodloc_item( *command, temp_string );
      free( temp_string );
      break;
   case GetProjectionSystem:
      rc = get_mdmodloc_item( *command, (caddr_t)&temp_string );
      cstring_to_fstring( args, temp_string );
      break;

   case CreateVersion:					/* Version ROOT */
      rc = create_version( *va_arg( args, int* ) );
      break;
   case DeleteVersion:
      rc = delete_version( *va_arg( args, int* ) );
      break;
   case ActivateVersion:
      rc = activate_version( *va_arg( args, int* ) );
      break;

   case GetNumberVersions:				/* Version misc */
      rc = get_number_versions( va_arg( args, unsigned* ) );
      break;
   case GetIndexedVersionNumber:
      i = *va_arg( args, int* );
      rc = get_nth_version_number( i, va_arg( args, Version* ) );
      break;
   case GetVersionNumber:
      if( versionlistptr == NULL )  {
         handle_empty_version_list( "GetVersionNumber" );
         rc = 2;
      } else {
         i_ptr = va_arg( args, int* );
         *i_ptr = versionlistptr->version;
      }
      break;
   case ReplaceVersionNumber:
      rc = replace_version_number( *va_arg( args, int* ) );
      break;

   case PutVersionParent:
      rc = put_mdvermisc_item( *command, (caddr_t)va_arg( args, int* ) );
      break;
   case ReplaceVersionParent:
      rc = replace_mdvermisc_item( *command, (caddr_t)va_arg( args, int* ) );
      break;
   case GetVersionParent:
      rc = get_mdvermisc_item( *command, (caddr_t)va_arg( args, int* ) );
      break;
   case PutVersionCreationDate:
      rc = put_mdvermisc_item( *command,
                               temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case ReplaceVersionCreationDate:
      rc = replace_mdvermisc_item( *command, va_arg( args, String ) );
      break;
   case GetVersionCreationDate:
      rc = get_mdvermisc_item( *command, (caddr_t)&temp_string );
      cstring_to_fstring( args, temp_string );
      break;
   case PutVersionCreationTime:
      rc = put_mdvermisc_item( *command,
                               temp_string = fstring_to_cstring( args ) ); 
      free( temp_string );
      break;
   case ReplaceVersionCreationTime:
      rc = replace_mdvermisc_item( *command,
                                   temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case GetVersionCreationTime:
      rc = get_mdvermisc_item( *command, (caddr_t)&temp_string );
      cstring_to_fstring( args, temp_string );
      break;
   case PutVersionLastUpDate:
      rc = put_mdvermisc_item( *command,
                               temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case ReplaceVersionLastUpDate:
      rc = replace_mdvermisc_item( *command,
                                   temp_string = fstring_to_cstring( args ) ); 
      free( temp_string );
      break;
   case GetVersionLastUpDate:
      rc = get_mdvermisc_item( *command, (caddr_t)&temp_string );
      cstring_to_fstring( args, temp_string );
      break;
   case PutVersionLastUpTime:
      rc = put_mdvermisc_item( *command,
                               temp_string = fstring_to_cstring( args ) ); 
      free( temp_string );
      break;
   case ReplaceVersionLastUpTime:
      rc = replace_mdvermisc_item( *command,
                                   temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case GetVersionLastUpTime:
      rc = get_mdvermisc_item( *command, (caddr_t)&temp_string );
      cstring_to_fstring( args, temp_string );
      break;
   case PutVersionDescription:
      rc = put_mdvermisc_item( *command,
                               temp_string = fstring_to_cstring( args ) );  
      free( temp_string );
      break;
   case ReplaceVersionDescription:
      rc = replace_mdvermisc_item( *command,
                                   temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case GetVersionDescription:
      rc = get_mdvermisc_item( *command, (caddr_t)&temp_string );
      cstring_to_fstring( args, temp_string );
      break;

   case PutVersionHistory:
      rc = put_mdlineage_item( *command,
                               temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case ReplaceVersionHistory:
      rc = replace_mdlineage_item( *command,
                                   temp_string = fstring_to_cstring( args ) );
      free( temp_string );
      break;
   case GetVersionHistory:
      rc = get_mdlineage_item( *command, (caddr_t)&temp_string );
      cstring_to_fstring( args, temp_string );
      break;

   case RestrictCollectionType:				/* Collection Info. */
      rc = restrict_collection_type( *va_arg( args, int* ) );
      break;
   case GetNumberCollections:
      rc = get_number_collections( va_arg( args, unsigned* ) );
      break;
   case GetCollectionId:
      i_ptr = va_arg( args, int* );
      *i_ptr = globcollectionid;
      break;

   case CreateCollection:				/* COLLECTION */
      globcollectionid = *va_arg( args, int* );
      rc = create_collection( globcollectionid );
      break;
   case ActivateCollection:
      globcollectionid = *va_arg( args, int* );
      rc = activate_collection( globcollectionid );
      break;
   case ActivateIndexedCollection:
      rc = activate_indexed_collection( *va_arg( args, int* ) );
      break;

   case PutCollectionParent:				/* MDCOLMISC */
      rc = put_collection_parent( *va_arg( args, int* ) );
      break;
   case PutCollectionType:
      rc = put_collection_type( *va_arg( args, int* ) );
      break;
   case PutCollectionDescription:
      rc = put_collection_description( temp_string =
                                          fstring_to_cstring( args ) );
      free( temp_string );
      break;

   case GetNumberCollectionTypes:			/* Collection Types */
      rc = get_number_collection_types( va_arg( args, unsigned* ) );
      break;
   case GetIndexedCollectionType:
      i = *va_arg( args, int* );
      rc = get_nth_collection_type( i, va_arg( args, Type* ) );
      break;

   case GetCollectionParent:
      rc = get_collection_parent_id( va_arg( args, Id* ) );
      break;
   case GetCollectionDescription:
      rc = get_collection_description( &temp_string );
      cstring_to_fstring( args, temp_string );
      break;
   case GetCollectionType:
      rc = get_collection_type( va_arg( args, Type* ) );
      break;

   case PutCollectionSegmentAssociation:		/* MDCOLSEGS */
      globcollectionid = *va_arg( args, int* );
      globsegmentid = *va_arg( args, int* );
      rc = put_id_collection_segment_link( globcollectionid, globsegmentid );
      break;
   case AssociateSegment:
      globsegmentid = *va_arg( args, int* );
      rc = put_segment_link( globsegmentid );
      break;

   case GetCollectionSegments:
      rc = get_collection_segments( u_ptr = va_arg( args, unsigned* ),
                                    &u_ptr2, &tupleptr );
      (void)memcpy( (char *)va_arg( args, int* ), (char *)u_ptr2,
                    *u_ptr * sizeof( int ) );
      f_ptr = va_arg( args, float* );
      for( offset = i = 0;  i < *u_ptr;  i++ )  {
         (void)memcpy( (char *)(f_ptr+offset), (char *)tupleptr[i],
                       u_ptr2[i] * sizeof( Tuple ) );
         offset += u_ptr2[i] * sizeof( Tuple );
      }
      break;

   case PutAttributeAbbreviation:			/* MDATBABRV */
      rc = put_attribute_abbreviation( temp_string = fstring_to_cstring( args));
      free( temp_string );
      break;
   case GetCollectionAttributeAbbreviations:
      rc = get_collection_attribute_abbreviations( u_ptr = va_arg( args, unsigned* ),
                                                   &temp_string_array );
      n_cstring_to_fstring( args, (String*)temp_string_array, *u_ptr );
      break;
   case GetCollectionNumberLocations:
      rc = get_collection_number_locations( va_arg( args, unsigned* ) );
      break;

   case ActivateCollectionIndexedAttribute:
      rc = activate_collection_indexed_attribute( *va_arg( args, int* ) );
      break;

   case PutCollectionAttributeAssociation:		/* MDCOLATBS */
      globcollectionid = *va_arg( args, int* );
      globattributeid = *va_arg( args, int* );
      rc = put_id_collection_attribute_link( globcollectionid,
                                             globattributeid );
      break;

   case CreateAttribute:				/* ATTRIBUTE */
      globattributeid = *va_arg( args, int* );
      rc = create_attribute( globattributeid );
      break;
   case GetAttributeId:
      i_ptr = va_arg( args, int* );
      *i_ptr = globattributeid;
      break;

   case PutAttributeComponent:				/* MDATBCOMP */
      dvalue = *va_arg( args, float* );
      rc = put_attribute_component( dvalue );
      break;
   case PutAttributeComponents:
      i = *va_arg( args, int* );
      rc = put_attribute_components( i, va_arg( args, float* ) );
      break;
   case GetAttributeComponents:
      if( (rc = get_attribute_components( u_ptr = va_arg( args, unsigned* ),
                                          &f_ptr )) == 0 )
         (void)memcpy( (char *)va_arg( args, float* ), (char *)f_ptr,
                       *u_ptr * sizeof( float ) );
      break;

   case PutAttributeLocations:
      i = *va_arg( args, int* );
      rc = put_attribute_locations( i, (Location *)va_arg( args, float* ) );
      break;
   case GetAttributeLocations:
      if( (rc = get_attribute_locations( u_ptr = va_arg( args, unsigned* ),
                                         &location_ptr )) == 0 )
         (void)memcpy( (char *)va_arg( args, float* ), (char *)location_ptr,
                       *u_ptr * sizeof( Location ) );
      break;

   case PutAttributeDefinition:				/* MDATBMISC */
#ifdef SUN
      fstring = va_arg( args, String );
      fstring2 = va_arg( args, String );
      f = *va_arg( args, float* );
      fstring3 = va_arg( args, String );
      namelen = va_arg( args, unsigned );
      temp_string = strncpy( (String)malloc( namelen + 1 ), fstring, namelen );
      temp_string[namelen] = '\0';
      temp_string[rtend( temp_string )] = '\0';
      namelen = va_arg( args, unsigned );
      temp_string2 = strncpy( (String)malloc( namelen + 1 ), fstring2,
                              namelen );
      temp_string2[namelen] = '\0';
      temp_string2[MAX( 1, rtend( temp_string2 ) )] = '\0';
      namelen = va_arg( args, unsigned );
      temp_string3 = strncpy( (String)malloc( namelen + 1 ), fstring3,
                              namelen );
      temp_string3[namelen] = '\0';
      temp_string3[rtend( temp_string3 )] = '\0';
#endif
#ifdef CRAY
      fcd = va_arg( args, _fcd );
      fstring = _fcdtocp( fcd );
      namelen = _fcdlen( fcd );
      temp_string = strncpy( (String)malloc( namelen + 1 ), fstring, namelen );
      temp_string[namelen] = '\0';
      temp_string[rtend( temp_string )] = '\0';
      fcd = va_arg( args, _fcd );
      fstring = _fcdtocp( fcd );
      namelen = _fcdlen( fcd );
      temp_string2 = strncpy( (String)malloc( namelen + 1 ), fstring, namelen );
      temp_string2[namelen] = '\0';
      temp_string2[MAX( 1, rtend( temp_string2 ) )] = '\0';
      fcd = va_arg( args, _fcd );
      fstring = _fcdtocp( fcd );
      namelen = _fcdlen( fcd );
      temp_string3 = strncpy( (String)malloc( namelen + 1 ), fstring, namelen );
      temp_string3[namelen] = '\0';
      temp_string3[rtend( temp_string3 )] = '\0';
#endif
      rc = put_attribute_misc( temp_string, temp_string2, (double)f,
                               temp_string3 );
      free( temp_string );
      free( temp_string2 );
      free( temp_string3 );
      break;

   case GetNumberAttributeDefinitions:			/* Attribute Misc */
      rc = get_number_attribute_misc( va_arg( args, unsigned* ) );
      break;
   case GetIndexedAttributeDefinition:
      if( (rc = get_nth_attribute_misc( *va_arg( args, int* ), &temp_string,
                                        &temp_string2, &f, &temp_string3 ))
                                        == 0 )  {
#ifdef SUN
         outstring = va_arg( args, String );
         outstring2 = va_arg( args, String );
         f_ptr = va_arg( args, float* );   *f_ptr = f;
         outstring3 = va_arg( args, String );
         namelen = va_arg( args, unsigned );
         cnamelen = strlen( temp_string );
         (void)strncpy( outstring, temp_string, MIN( namelen, cnamelen ) );
         for( cptr = outstring+cnamelen;  cptr < outstring+namelen;  cptr++ )
            *cptr = ' ';  /* FORTRAN expects blank padding */
         namelen = va_arg( args, unsigned );
         cnamelen = strlen( temp_string2 );
         (void)strncpy( outstring2, temp_string2, MIN( namelen, cnamelen ) );
         for( cptr = outstring2+cnamelen;  cptr < outstring2+namelen;  cptr++ )
            *cptr = ' ';  /* FORTRAN expects blank padding */
         namelen = va_arg( args, unsigned );
         cnamelen = strlen( temp_string3 );
         (void)strncpy( outstring3, temp_string3, MIN( namelen, cnamelen ) );
         for( cptr = outstring3+cnamelen;  cptr < outstring3+namelen;  cptr++ )
            *cptr = ' ';  /* FORTRAN expects blank padding */
#endif
#ifdef CRAY
         fcd = va_arg( args, _fcd );
         outstring = _fcdtocp( fcd );
         namelen = _fcdlen( fcd );
         cnamelen = strlen( temp_string );
         (void)strncpy( outstring, temp_string, MIN( namelen, cnamelen ) );
         for( cptr = outstring+cnamelen;  cptr < outstring+namelen;  cptr++ )
            *cptr = ' ';  /* FORTRAN expects blank padding */
         fcd = va_arg( args, _fcd );
         outstring = _fcdtocp( fcd );
         namelen = _fcdlen( fcd );
         cnamelen = strlen( temp_string2 );
         (void)strncpy( outstring, temp_string2, MIN( namelen, cnamelen ) );
         for( cptr = outstring+cnamelen;  cptr < outstring+namelen;  cptr++ )
            *cptr = ' ';  /* FORTRAN expects blank padding */
         f_ptr = va_arg( args, float* );   *f_ptr = f;
         fcd = va_arg( args, _fcd );
         outstring = _fcdtocp( fcd );
         namelen = _fcdlen( fcd );
         cnamelen = strlen( temp_string3 );
         (void)strncpy( outstring, temp_string3, MIN( namelen, cnamelen ) );
         for( cptr = outstring+cnamelen;  cptr < outstring+namelen;  cptr++ )
            *cptr = ' ';  /* FORTRAN expects blank padding */
#endif
      }
      break;

   case CreateSegment:					/* Segment Pool */
      globsegmentid = *va_arg( args, int* );
      rc = create_segment( globsegmentid );
      break;
   case PutSegment:
      f_ptr = va_arg( args, float* );
      rc = put_segment( (Tupleptr)f_ptr, *va_arg( args, int* ) );
      break;
   case GetSegmentId:
      i_ptr = va_arg( args, int* );
      *i_ptr = globsegmentid;
      break;

   case ConnectSegments:
      connect_segments = *va_arg( args, int* );
      break;

   default:
      fprintf( stderr, "agm: invalid command (%d).\n", command );
      rc = -1;
   }

   va_end( args );

   return( rc );
}


static String fstring_to_cstring( va_list args )
{
   String		fstring, string;
   unsigned		namelen;


#ifdef SUN
   fstring = va_arg( args, String );
   namelen = va_arg( args, unsigned );
#endif
#ifdef CRAY
   _fcd   fcd;
   fcd = va_arg( args, _fcd );
   fstring = _fcdtocp( fcd );
   namelen = _fcdlen( fcd );
#endif
   string = strncpy( (String)malloc( namelen + 1 ), fstring, namelen );
   string[namelen] = '\0';
   string[rtend( string )] = '\0';

   return( string );
}


static String *n_fstring_to_cstring( va_list args, int n )
{
   String		fstring, *string;
   unsigned		namelen, i;


#ifdef SUN
   fstring = va_arg( args, String );
   namelen = va_arg( args, unsigned );
#endif
#ifdef CRAY
   _fcd   fcd;
   fcd = va_arg( args, _fcd );
#endif

   string = (String *)malloc( n * sizeof( String ) );
   for( i = 0;  i < n;  i++ )  {
#ifdef SUN
      string[i] = strncpy( (String)malloc( namelen + 1 ), fstring+i*namelen,
                           namelen );
#endif
#ifdef CRAY
      fstring = _fcdtocp( fcd+i );
      namelen = _fcdlen( fcd+i );
      string[i] = strncpy( (String)malloc( namelen + 1 ), fstring, namelen );
#endif
      string[i][namelen] = '\0';
      string[i][rtend( string[i] )] = '\0';
   }

   return( string );
}


static void cstring_to_fstring( va_list args, String string )
{
   String		outstring, cptr;
   unsigned		namelen, cnamelen;

   
#ifdef SUN
   outstring = va_arg( args, String );
   namelen = va_arg( args, unsigned );
#endif
#ifdef CRAY
   _fcd   fcd;
   fcd = va_arg( args, _fcd );
   outstring = _fcdtocp( fcd );
   namelen = _fcdlen( fcd );
#endif
   cnamelen = strlen( string );
   (void)strncpy( outstring, string, MIN( namelen, cnamelen ) );
   for( cptr = outstring+cnamelen;  cptr < outstring+namelen;  cptr++ )
      *cptr = ' ';  /* FORTRAN expects blank padding */
}


static void n_cstring_to_fstring( va_list args, String *string, int n )
{
   String		outstring, cptr;
   unsigned		namelen, cnamelen, i;

   
#ifdef SUN
   outstring = va_arg( args, String );
   namelen = va_arg( args, unsigned );
#endif
#ifdef CRAY
   _fcd   fcd;
   fcd = va_arg( args, _fcd );
#endif
   for( i = 0;  i < n;  i++ )  {
      cnamelen = strlen( string[i] );
#ifdef SUN
      (void)strncpy( outstring+i*namelen, string[i], MIN( namelen, cnamelen ) );
      for( cptr = outstring+i*namelen+cnamelen;  cptr < outstring+(i+1)*namelen;
           cptr++ )
         *cptr = ' ';  /* FORTRAN expects blank padding */
#endif
#ifdef CRAY
      outstring = _fcdtocp( fcd+i );
      namelen = _fcdlen( fcd+i );
      (void)strncpy( outstring, string[i], MIN( namelen, cnamelen ) );
      for( cptr = outstring+cnamelen;  cptr < outstring+namelen;  cptr++ )
         *cptr = ' ';  /* FORTRAN expects blank padding */
#endif
   }
}


/******************************************************************************/


static int create_model( String modelname )
{
   if( modelroot == NULL )
      modelroot = modellistptr = new_node( Modellist );
   else  {
      for( modellistptr = modelroot;  modellistptr;
           modellistptr = modellistptr->next )  {
         if( strcmp( modelname, modellistptr->modelname ) == MATCH )  {
            (void) sprintf( message,
                            "agm(create_model): model (%s) already exists.",
                            modelname );
            (void) fprintf( stderr, "%s\n", message );
            return( -1 );
         }
 
         if( !modellistptr->next )  {  /* exhausted list */
            modellistptr->next = new_node( Modellist );
            modellistptr = modellistptr->next;
            break;
         }
      }
   }
 
   modellistptr->modelname = strdup( modelname );
   modellistptr->modelinfoptr = NULL;
   modellistptr->versionlistptr = NULL;
   modellistptr->attributemiscptr = NULL;
   modellistptr->segmentpool = (Segmenthashtable) calloc( 1,
                           SEGMENT_HASH_TABLE_SIZE * sizeof( Segmentlistptr ) );
   modellistptr->attributepool = (Attributehashtable) calloc( 1,
                       ATTRIBUTE_HASH_TABLE_SIZE * sizeof( Attributelistptr ) );
   modellistptr->next = NULL;
 
   versionlistptr = NULL;  /* reset since no longer applicable */

   return( 0 );
}


static int delete_model( String modelname )
{
   Modellistptr		prevmodelptr;
   Versionlistptr     vptr, nextvptr;
   Idlistptr          iptr, nextiptr;
   Attributemiscptr   aptr, nextaptr;
   Segmentlistptr     sptr, nextsptr;
   Attributelistptr   hptr, nexthptr;
   Locationlistptr    lptr, nextlptr;
   Componentlistptr   cptr, nextcptr;
   unsigned       hashaddr;


   if( modelroot == NULL )  {
      handle_empty_model_list( "delete_model" );
      return( 1 );
   }

   for( prevmodelptr = NULL, modellistptr = modelroot;  modellistptr;
        modellistptr = modellistptr->next )  {
      if( strcmp( modelname, modellistptr->modelname ) == MATCH )
         break;
      prevmodelptr = modellistptr;
   }

   if( modellistptr == NULL )  {
      (void)sprintf( message,
                     "agm(delete_model): model '%s' not found in model list.",
                     modelname );
      return( 2 );
   }

/* free( modellistptr->modelname ); DO NOT delete here; see below */

   if( modellistptr->modelinfoptr != NULL )  {		/* modelinfoptr */
      if( modellistptr->modelinfoptr->mdmodmiscptr != NULL )  {
         if( modellistptr->modelinfoptr->mdmodmiscptr->userid != NULL )
            free( modellistptr->modelinfoptr->mdmodmiscptr->userid );
         if( modellistptr->modelinfoptr->mdmodmiscptr->ownername != NULL )
            free( modellistptr->modelinfoptr->mdmodmiscptr->ownername );
         if( modellistptr->modelinfoptr->mdmodmiscptr->expirydate != NULL )
            free( modellistptr->modelinfoptr->mdmodmiscptr->expirydate );
         if( modellistptr->modelinfoptr->mdmodmiscptr->description != NULL )
            free( modellistptr->modelinfoptr->mdmodmiscptr->description );

         free( modellistptr->modelinfoptr->mdmodmiscptr );
      }

      if( modellistptr->modelinfoptr->mdmodwrldptr != NULL )  {
         if( modellistptr->modelinfoptr->mdmodwrldptr->units.x != NULL )
            free( modellistptr->modelinfoptr->mdmodwrldptr->units.x );
         if( modellistptr->modelinfoptr->mdmodwrldptr->units.y != NULL )
            free( modellistptr->modelinfoptr->mdmodwrldptr->units.y );
         if( modellistptr->modelinfoptr->mdmodwrldptr->units.z != NULL )
            free( modellistptr->modelinfoptr->mdmodwrldptr->units.z );

         free( modellistptr->modelinfoptr->mdmodwrldptr );
      }

      if( modellistptr->modelinfoptr->mdmodlocptr != NULL )  {
         if( modellistptr->modelinfoptr->mdmodlocptr->projectionsystem != NULL )
            free( modellistptr->modelinfoptr->mdmodlocptr->projectionsystem );

         free( modellistptr->modelinfoptr->mdmodlocptr );
      }

      free( modellistptr->modelinfoptr );
   }

   if( modellistptr->versionlistptr != NULL )  {	/* versionlistptr */
      for( vptr = modellistptr->versionlistptr;  vptr;  vptr = nextvptr )  {
         nextvptr = vptr->next;

         if( vptr->mdvermiscptr != NULL )  {
            if( vptr->mdvermiscptr->creationdate != NULL )
               free( vptr->mdvermiscptr->creationdate );
            if( vptr->mdvermiscptr->creationtime != NULL )
               free( vptr->mdvermiscptr->creationtime );
            if( vptr->mdvermiscptr->lastupdate != NULL )
               free( vptr->mdvermiscptr->lastupdate );
            if( vptr->mdvermiscptr->lastuptime != NULL )
               free( vptr->mdvermiscptr->lastuptime );
            if( vptr->mdvermiscptr->description != NULL )
               free( vptr->mdvermiscptr->description );

            free( vptr->mdvermiscptr );
         }

         if( vptr->mdlineageptr != NULL )  {
            if( vptr->mdlineageptr->history != NULL )
               free( vptr->mdlineageptr->history );

            free( vptr->mdlineageptr );
         }

         if( vptr->collectionlistptr != NULL )  {
            if( vptr->collectionlistptr->mdcolmiscptr != NULL )  {
               if( vptr->collectionlistptr->mdcolmiscptr->description != NULL )
                  free( vptr->collectionlistptr->mdcolmiscptr->description );

               free( vptr->collectionlistptr->mdcolmiscptr );
            }

            for( iptr = vptr->collectionlistptr->segmentidlistptr;  iptr;
                 iptr = nextiptr )  {
               nextiptr = iptr->next;
               free( iptr );
            }

            for( iptr = vptr->collectionlistptr->attributeidlistptr;  iptr;
                 iptr = nextiptr )  {
               nextiptr = iptr->next;
               free( iptr );
            }

            free( vptr->collectionlistptr );
         }

         free( vptr );
      }
   }

   /* attributemiscptr */
   for( aptr = modellistptr->attributemiscptr;  aptr;  aptr = nextaptr )  {
      nextaptr = aptr->next;

      if( aptr->abbreviation != NULL )
         free( aptr->abbreviation );
      if( aptr->unit != NULL )
         free( aptr->unit );
      if( aptr->description != NULL )
         free( aptr->description );

      free( aptr );
   }

   /* segmentpool */
   for( hashaddr = 0;  hashaddr < SEGMENT_HASH_TABLE_SIZE;  hashaddr++ )
      for( sptr = modellistptr->segmentpool[hashaddr];  sptr;
           sptr = nextsptr )  {
         nextsptr = sptr->next;

#ifdef PURIFY_DEBUG
printf( "freeing sptr->pointlistptr\n" );
#endif
         free( sptr->pointlistptr );
         free( sptr );
      }

   free( modellistptr->segmentpool );

   /* attributepool */
   for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( hptr = modellistptr->attributepool[hashaddr];  hptr;
           hptr = nexthptr )  {
         nexthptr = hptr->next;

         if( hptr->abbreviation != NULL )
            free( hptr->abbreviation );

         for( cptr = hptr->componentlistptr;  cptr;  cptr = nextcptr )  {
            nextcptr = cptr->next;
            free( cptr );
         }

         for( lptr = hptr->locationlistptr;  lptr;  lptr = nextlptr )  {
            nextlptr = lptr->next;
            free( lptr );
         }

         if( hptr->attributesetptr != NULL )  {
            if( hptr->attributesetptr->elements != NULL )
               free( (char *)hptr->attributesetptr->elements );
            free( (char *)hptr->attributesetptr );
         }

         free( hptr );
      }

   free( modellistptr->attributepool );

   if( prevmodelptr == NULL )
      modelroot = modelroot->next;
   else
      prevmodelptr->next = modellistptr->next;

/* free( (char *)modellistptr ); DO NOT free here, see code after return */

   versionlistptr = NULL;  /* reset since no longer applicable */
   glob_collection_ptr = NULL;
   glob_segment_ptr = NULL;

   return( 0 );
}


static int activate_model( String modelname )
{
   if( modelroot == NULL )  {
      handle_empty_model_list( "activate_model" );
      return( 1 );
   }

   for( modellistptr = modelroot;  modellistptr;
        modellistptr = modellistptr->next )
      if( strcmp( modelname, modellistptr->modelname ) == MATCH )
         break;

   if( modellistptr == NULL )  {
      (void)sprintf( message,
                     "agm(activate_model): model '%s' not found in model list.",
                     modelname );
      return( 2 );
   }

   versionlistptr = NULL;  /* reset since no longer applicable */

   return( 0 );
}


static int replace_model_name( String newmodelname )
{
   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_model_name" );
      return( 1 );
   }

   free( modellistptr->modelname );
   modellistptr->modelname = strdup( newmodelname );

   return( 0 );
}


static int get_number_models( unsigned *nmodels )
{
   *nmodels = 0;

   for( modellistptr = modelroot;  modellistptr;
        modellistptr = modellistptr->next )
      ++(*nmodels);

   return( 0 );
}


static int get_nth_model_name( unsigned nthmodel, String *modelname )
{
   unsigned   count = 0;


   for( modellistptr = modelroot;  modellistptr;
        modellistptr = modellistptr->next )
      if( ++count == nthmodel )  {
         *modelname = modellistptr->modelname;
         versionlistptr = NULL;  /* reset since no longer applicable */
         return( 0 );
      }

   (void) sprintf( message,
               "agm(get_nth_model_name): %d models do not exist (%d exist(s)).",
                   nthmodel, count );
   return( -1 );
}


static int put_model_misc( String userid, String ownername, String expirydate, String description )
{
   Modelinfoptr   iptr;
   Mdmodmiscptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_model_misc" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      iptr = modellistptr->modelinfoptr = new_node( Modelinfo );
      mptr = iptr->mdmodmiscptr = new_node( Mdmodmisc );
      iptr->mdmodwrldptr = NULL;
      iptr->mdmodlocptr = NULL;
   } else if( iptr->mdmodmiscptr == NULL )
      mptr = iptr->mdmodmiscptr = new_node( Mdmodmisc );
   else {
      (void) sprintf( message,
"agm(put_model_misc): miscellaneous model information already exists for model '%s'.  Specify 'Replace' instead.", modellistptr->modelname );
      return( -1 );
   }

   mptr->userid = strdup( userid );
   mptr->ownername = strdup( ownername );
   mptr->expirydate = strdup( expirydate );
   mptr->description = strdup( description );

   return( 0 );
}


static int replace_model_misc( String userid, String ownername, String expirydate, String description )
{
   Modelinfoptr   iptr;
   Mdmodmiscptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_model_misc" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
"agm(replace_model_misc): miscellaneous model information does not already exist for model '%s'.  Specify 'Put' instead.", modellistptr->modelname );
      return( -1 );
   } else if( iptr->mdmodmiscptr == NULL )  {
      (void) sprintf( message,
"agm(replace_model_misc): miscellaneous model information does not already exist for model '%s'.  Specify 'Put' instead.", modellistptr->modelname );
      return( -1 );
   }

   mptr = iptr->mdmodmiscptr;
   if( mptr->userid )
      free( mptr->userid );
   if( mptr->ownername )
      free( mptr->ownername );
   if( mptr->expirydate )
      free( mptr->expirydate );
   if( mptr->description )
      free( mptr->description );

   mptr->userid = strdup( userid );
   mptr->ownername = strdup( ownername );
   mptr->expirydate = strdup( expirydate );
   mptr->description = strdup( description );

   return( 0 );
}


static int get_model_misc( String *userid, String *ownername, String *expirydate, String *description )
{
   Modelinfoptr   iptr;
   Mdmodmiscptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_model_misc" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_model_misc): model info. does not exist." );
      return( -1 );
   }

   if( (mptr = iptr->mdmodmiscptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_model_misc): model misc. does not exist." );
      return( -2 );
   }

   *userid = mptr->userid;
   *ownername = mptr->ownername;
   *expirydate = mptr->expirydate;
   *description = mptr->description;

   return( 0 );
}


static int put_mdmodmisc_item( unsigned itemtype, String string )
{
   Modelinfoptr   iptr;
   Mdmodmiscptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_mdmodmisc_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      iptr = modellistptr->modelinfoptr = new_node( Modelinfo );
      iptr->mdmodmiscptr = new_node( Mdmodmisc );
      iptr->mdmodwrldptr = NULL;
      iptr->mdmodlocptr = NULL;
      mptr = iptr->mdmodmiscptr;
      mptr->userid = NULL;
      mptr->ownername = NULL;
      mptr->expirydate = NULL;
      mptr->description = NULL;
   } else if( iptr->mdmodmiscptr == NULL )  {
      iptr->mdmodmiscptr = new_node( Mdmodmisc );
      mptr = iptr->mdmodmiscptr;
      mptr->userid = NULL;
      mptr->ownername = NULL;
      mptr->expirydate = NULL;
      mptr->description = NULL;
   } else {
      mptr = iptr->mdmodmiscptr;
      switch( itemtype )  {
      case PutUserId:
         if( mptr->userid )  {
            (void)sprintf( message,
                          "agm(put_mdmodmisc_item): userid already buffered." );
            return( -1 );
         }
         break;
      case PutOwnerName:
         if( mptr->ownername )  {
            (void)sprintf( message,
                      "agm(put_mdmodmisc_item): owner name already buffered." );
            return( -2 );
         }
         break;
      case PutExpiryDate:
         if( mptr->expirydate )  {
            (void)sprintf( message,
                     "agm(put_mdmodmisc_item): expiry date already buffered." );
            return( -3 );
         }
         break;
      case PutModelDescription:
         if( mptr->description )  {
            (void)sprintf( message,
                     "agm(put_mdmodmisc_item): description already buffered." );
            return( -4 );
         }
         break;
      default:
         (void) fprintf( stderr,
                         "agm(put_mdmodmisc_item): invalid item number.\n" );
         return( -10 );
      }
   }

   switch( itemtype )  {
   case PutUserId:
      mptr->userid = strdup( string );   break;
   case PutOwnerName:
      mptr->ownername = strdup( string );   break;
   case PutExpiryDate:
      mptr->expirydate = strdup( string );   break;
   case PutModelDescription:
      mptr->description = strdup( string );   break;
   default:
      (void) fprintf( stderr,
                      "agm(put_mdmodmisc_item): invalid item value.\n" );
      return( -11 );
   }

   return( 0 );
}


static int replace_mdmodmisc_item( unsigned itemtype, String string )
{
   Modelinfoptr   iptr;
   Mdmodmiscptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_mdmodmisc_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void)sprintf( message,
"agm(replace_mdmodmisc_item): model information does not exist for this model." );
      return( -1 );
   } else if( iptr->mdmodmiscptr == NULL )  {
      (void)sprintf( message,
"agm(replace_mdmodmisc_item): miscellaneous model information does not exist for this model." );
      return( -2 );
   } else {
      mptr = iptr->mdmodmiscptr;
      switch( itemtype )  {
      case ReplaceUserId:
         if( !mptr->userid )  {
            (void)sprintf( message,
                      "agm(replace_mdmodmisc_item): userid not buffered yet." );
            return( -3 );
         } else
            free( mptr->userid );
         break;
      case ReplaceOwnerName:
         if( !mptr->ownername )  {
            (void)sprintf( message,
                  "agm(replace_mdmodmisc_item): owner name not buffered yet." );
            return( -4 );
         } else
            free( mptr->ownername );
         break;
      case ReplaceExpiryDate:
         if( !mptr->expirydate )  {
            (void)sprintf( message,
                 "agm(replace_mdmodmisc_item): expiry date not buffered yet." );
            return( -5 );
         } else
            free( mptr->expirydate );
         break;
      case ReplaceModelDescription:
         if( !mptr->description )  {
            (void)sprintf( message,
                 "agm(replace_mdmodmisc_item): description not buffered yet." );
            return( -6 );
         } else
            free( mptr->description );
         break;
      default:
         (void) fprintf( stderr,
                        "agm(replace_mdmodmisc_item): invalid item number.\n" );
         return( -10 );
      }
   }

   switch( itemtype )  {
   case ReplaceUserId:
      mptr->userid = strdup( string );   break;
   case ReplaceOwnerName:
      mptr->ownername = strdup( string );   break;
   case ReplaceExpiryDate:
      mptr->expirydate = strdup( string );   break;
   case ReplaceModelDescription:
      mptr->description = strdup( string );   break;
   default:
      (void) fprintf( stderr,
                      "agm(replace_mdmodmisc_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int get_mdmodmisc_item( unsigned itemtype, String *outstring )
{
   Modelinfoptr   iptr;
   Mdmodmiscptr   mptr;


   *outstring = NULL;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_mdmodmisc_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_mdmodmisc_item): model info. does not exist." );
      return( -1 );
   }

   if( (mptr = iptr->mdmodmiscptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_mdmodmisc_item): model misc. does not exist." );
      return( -2 );
   }

   switch( itemtype )  {
   case GetUserId:
      *outstring = mptr->userid;   break;
   case GetOwnerName:
      *outstring = mptr->ownername;   break;
   case GetExpiryDate:
      *outstring = mptr->expirydate;   break;
   case GetModelDescription:
      *outstring = mptr->description;   break;
   default:
      (void) fprintf( stderr,
                      "agm(get_mdmodmisc_item): invalid item number.\n" );
      return( -3 );
   }

   return( 0 );
}


static int put_model_world( Units *units, Factors *factors, Extents *extents )
{
   Modelinfoptr   iptr;
   Mdmodwrldptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_model_world" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      iptr = modellistptr->modelinfoptr = new_node( Modelinfo );
      iptr->mdmodmiscptr = NULL;
      mptr = iptr->mdmodwrldptr = new_node( Mdmodwrld );
      iptr->mdmodlocptr = NULL;
   } else if( iptr->mdmodwrldptr == NULL )
      mptr = iptr->mdmodwrldptr = new_node( Mdmodwrld );
   else {
      (void) sprintf( message,
"agm(put_model_world): model world information already exists for model '%s'.  Specify 'Replace' instead.", modellistptr->modelname );
      return( -1 );
   }

   mptr->units.x = strdup( units->x );
   mptr->units.y = strdup( units->y );
   mptr->units.z = strdup( units->z );
   mptr->factors.x = factors->x;
   mptr->factors.y = factors->y;
   mptr->factors.z = factors->z;
   mptr->extents.min.x = extents->min.x;
   mptr->extents.max.x = extents->max.x;
   mptr->extents.min.y = extents->min.y;
   mptr->extents.max.y = extents->max.y;
   mptr->extents.min.z = extents->min.z;
   mptr->extents.max.z = extents->max.z;

   return( 0 );
}


static int replace_model_world( Units *units, Factors *factors, Extents *extents )
{
   Modelinfoptr   iptr;
   Mdmodwrldptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_model_world" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
"agm(replace_model_world): model world information does not already exist for model '%s'.  Specify 'Put' instead.", modellistptr->modelname );
      return( -1 );
   } else if( iptr->mdmodwrldptr == NULL )  {
      (void) sprintf( message,
"agm(replace_model_world): model world information does not already exist for model '%s'.  Specify 'Put' instead.", modellistptr->modelname );
      return( -1 );
   }

   mptr = iptr->mdmodwrldptr;
   if( mptr->units.x )
      free( mptr->units.x );
   if( mptr->units.y )
      free( mptr->units.y );
   if( mptr->units.z )
      free( mptr->units.z );

   mptr->units.x = strdup( units->x );
   mptr->units.y = strdup( units->y );
   mptr->units.z = strdup( units->z );
   mptr->factors.x = factors->x;
   mptr->factors.y = factors->y;
   mptr->factors.z = factors->z;
   mptr->extents.min.x = extents->min.x;
   mptr->extents.max.x = extents->max.x;
   mptr->extents.min.y = extents->min.y;
   mptr->extents.max.y = extents->max.y;
   mptr->extents.min.z = extents->min.z;
   mptr->extents.max.z = extents->max.z;

   return( 0 );
}


static int get_model_world( Units *units, Factors *factors, Extents *extents )
{
   Modelinfoptr   iptr;
   Mdmodwrldptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_model_world" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_model_world): model info. does not exist." );
      return( -1 );
   }

   if( (mptr = iptr->mdmodwrldptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_model_world): model world does not exist." );
      return( -2 );
   }

   units->x = mptr->units.x;
   units->y = mptr->units.y;
   units->z = mptr->units.z;
   factors->x = mptr->factors.x;
   factors->y = mptr->factors.y;
   factors->z = mptr->factors.z;
   extents->min.x = mptr->extents.min.x;
   extents->max.x = mptr->extents.max.x;
   extents->min.y = mptr->extents.min.y;
   extents->max.y = mptr->extents.max.y;
   extents->min.z = mptr->extents.min.z;
   extents->max.z = mptr->extents.max.z;

   return( 0 );
}


static int put_mdmodwrld_item( unsigned itemtype, caddr_t item )
{
   Modelinfoptr   iptr;
   Mdmodwrldptr   mptr;
   Units          *units;
   Factors        *factors;
   Extents        *extents;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_mdmodwrld_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      iptr = modellistptr->modelinfoptr = new_node( Modelinfo );
      iptr->mdmodmiscptr = NULL;
      iptr->mdmodwrldptr = new_node( Mdmodwrld );
      iptr->mdmodlocptr = NULL;
      mptr = iptr->mdmodwrldptr;
      mptr->units.x = mptr->units.y = mptr->units.z = NULL;
      mptr->factors.x = mptr->factors.y = mptr->factors.z = 0.0;
      mptr->extents.min.x = mptr->extents.max.x = 0.0;
      mptr->extents.min.y = mptr->extents.max.y = 0.0;
      mptr->extents.min.z = mptr->extents.max.z = 0.0;
   } else if( iptr->mdmodwrldptr == NULL )  {
      iptr->mdmodwrldptr = new_node( Mdmodwrld );
      mptr = iptr->mdmodwrldptr;
      mptr->units.x = mptr->units.y = mptr->units.z = NULL;
      mptr->factors.x = mptr->factors.y = mptr->factors.z = 0.0;
      mptr->extents.min.x = mptr->extents.max.x = 0.0;
      mptr->extents.min.y = mptr->extents.max.y = 0.0;
      mptr->extents.min.z = mptr->extents.max.z = 0.0;
   } else  {
      mptr = iptr->mdmodwrldptr;
      switch( itemtype )  {
      case PutUnits:
         if( mptr->units.x  &&  mptr->units.y  &&  mptr->units.z )  {
            (void)sprintf( message,
                           "agm(put_mdmodwrld_item): units already buffered." );
            return( -1 );
         }
         if( mptr->units.x )  /* free since these are an aggregate */
            free( (char *)mptr->units.x );
         if( mptr->units.y )
            free( (char *)mptr->units.y );
         if( mptr->units.z )
            free( (char *)mptr->units.z );
         break;
      case PutFactors:
         if( mptr->factors.x != 0.0  ||
             mptr->factors.y != 0.0  ||
             mptr->factors.z != 0.0 )  {
            (void)sprintf( message,
                         "agm(put_mdmodwrld_item): factors already buffered." );
            return( -2 );
         }
         break;
      case PutExtents:
         if( mptr->extents.min.x != 0.0  ||  mptr->extents.max.x != 0.0  ||
             mptr->extents.min.y != 0.0  ||  mptr->extents.max.y != 0.0  ||
             mptr->extents.min.z != 0.0  ||  mptr->extents.max.z != 0.0 )  {
            (void)sprintf( message,
                         "agm(put_mdmodwrld_item): extents already buffered." );
            return( -3 );
         }
         break;
      default:
         (void) fprintf( stderr,
                         "agm(put_mdmodwrld_item): invalid item number.\n" );
         return( -10 );
      }
   }

   switch( itemtype )  {
   case PutUnits:
      units = (Units *) item;
      mptr->units.x = strdup( units->x );
      mptr->units.y = strdup( units->y );
      mptr->units.z = strdup( units->z );
      break;
   case PutFactors:
      factors = (Factors *) item;
      mptr->factors.x = factors->x;
      mptr->factors.y = factors->y;
      mptr->factors.z = factors->z;
      break;
   case PutExtents:
      extents = (Extents *) item;
      mptr->extents.min.x = extents->min.x;
      mptr->extents.max.x = extents->max.x;
      mptr->extents.min.y = extents->min.y;
      mptr->extents.max.y = extents->max.y;
      mptr->extents.min.z = extents->min.z;
      mptr->extents.max.z = extents->max.z;
      break;
   default:
      (void) fprintf( stderr,
                      "agm(put_mdmodwrld_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int replace_mdmodwrld_item( unsigned itemtype, caddr_t item )
{
   Modelinfoptr   iptr;
   Mdmodwrldptr   mptr;
   Units          *units;
   Factors        *factors;
   Extents        *extents;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_mdmodwrld_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void)sprintf( message,
"agm(replace_mdmodwrld_item): model information does not exist for this model." );
      return( -1 );
   } else if( iptr->mdmodwrldptr == NULL )  {
      (void)sprintf( message,
"agm(replace_mdmodwrld_item): model world information does not exist for this model." );
      return( -2 );
   } else  {
      mptr = iptr->mdmodwrldptr;
      switch( itemtype )  {
      case ReplaceUnits:
         if( !mptr->units.x  &&  !mptr->units.y  &&  !mptr->units.z )  {
            (void)sprintf( message,
                       "agm(replace_mdmodwrld_item): units not buffered yet." );
            return( -3 );
         }
         if( mptr->units.x )
            free( (char *)mptr->units.x );
         if( mptr->units.y )
            free( (char *)mptr->units.y );
         if( mptr->units.z )
            free( (char *)mptr->units.z );
         break;
      case ReplaceFactors:
      case ReplaceExtents:
         break;
      default:
         (void) fprintf( stderr,
                        "agm(replace_mdmodwrld_item): invalid item number.\n" );
         return( -10 );
      }
   }

   switch( itemtype )  {
   case ReplaceUnits:
      units = (Units *) item;
      mptr->units.x = strdup( units->x );
      mptr->units.y = strdup( units->y );
      mptr->units.z = strdup( units->z );
      break;
   case ReplaceFactors:
      factors = (Factors *) item;
      mptr->factors.x = factors->x;
      mptr->factors.y = factors->y;
      mptr->factors.z = factors->z;
      break;
   case ReplaceExtents:
      extents = (Extents *) item;
      mptr->extents.min.x = extents->min.x;
      mptr->extents.max.x = extents->max.x;
      mptr->extents.min.y = extents->min.y;
      mptr->extents.max.y = extents->max.y;
      mptr->extents.min.z = extents->min.z;
      mptr->extents.max.z = extents->max.z;
      break;
   default:
      (void) fprintf( stderr,
                      "agm(replace_mdmodwrld_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int get_mdmodwrld_item( unsigned itemtype, caddr_t item )
{
   Modelinfoptr   iptr;
   Mdmodwrldptr   mptr;
   Units          *units;
   Factors        *factors;
   Extents        *extents;


   switch( itemtype )  {
   case GetUnits:
      units = (Units *) item;
      units->x = units->y = units->z = NULL;
      break;
   case GetFactors:
      factors = (Factors *) item;
      factors->x = factors->y = factors->z = 0.0;
      break;
   case GetExtents:
      extents = (Extents *) item;
      extents->min.x = extents->max.x = 0.0;
      extents->min.y = extents->max.y = 0.0;
      extents->min.z = extents->max.z = 0.0;
      break;
   default:
      (void) fprintf( stderr,
                      "agm(get_mdmodwrld_item): invalid item number.\n" );
      return( -1 );
   }

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_mdmodwrld_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_mdmodwrld_item): model info. does not exist." );
      return( -2 );
   }

   if( (mptr = iptr->mdmodwrldptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_mdmodwrld_item): model world does not exist." );
      return( -3 );
   }

   switch( itemtype )  {
   case GetUnits:
      units->x = mptr->units.x;
      units->y = mptr->units.y;
      units->z = mptr->units.z;
      break;
   case GetFactors:
      factors->x = mptr->factors.x;
      factors->y = mptr->factors.y;
      factors->z = mptr->factors.z;
      break;
   case GetExtents:
      extents->min.x = mptr->extents.min.x;
      extents->max.x = mptr->extents.max.x;
      extents->min.y = mptr->extents.min.y;
      extents->max.y = mptr->extents.max.y;
      extents->min.z = mptr->extents.min.z;
      extents->max.z = mptr->extents.max.z;
      break;
   }

   return( 0 );
}


static int put_model_loc( Location *location, double zoffset, double azimuth, double latitude, double longitude, String projectionsystem )
{
   Modelinfoptr   iptr;
   Mdmodlocptr    mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_model_loc" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      iptr = modellistptr->modelinfoptr = new_node( Modelinfo );
      iptr->mdmodmiscptr = NULL;
      iptr->mdmodwrldptr = NULL;
      mptr = iptr->mdmodlocptr = new_node( Mdmodloc );
   } else if( iptr->mdmodlocptr == NULL )
      mptr = iptr->mdmodlocptr = new_node( Mdmodloc );
   else {
      (void) sprintf( message,
"agm(put_model_loc): model location information already exists for model '%s'.  Specify 'Replace' instead.", modellistptr->modelname );
      return( -1 );
   }

   mptr->location.x = location->x;
   mptr->location.y = location->y;
   mptr->location.z = location->z;
   mptr->zoffset = zoffset;
   mptr->azimuth = azimuth;
   mptr->latitude = latitude;
   mptr->longitude = longitude;
   mptr->projectionsystem = strdup( projectionsystem );

   return( 0 );
}


static int replace_model_loc( Location *location, double zoffset, double azimuth, double latitude, double longitude, String projectionsystem )
{
   Modelinfoptr   iptr;
   Mdmodlocptr    mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_model_loc" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
"agm(replace_model_loc): model information does not already exist for model '%s'.  Specify 'Put' instead.", modellistptr->modelname );
      return( -1 );
   } else if( iptr->mdmodlocptr == NULL )  {
      (void) sprintf( message,
"agm(replace_model_loc): model location information does not already exist for model '%s'.  Specify 'Put' instead.", modellistptr->modelname );
      return( -2 );
   }

   mptr = iptr->mdmodlocptr;
   if( mptr->projectionsystem )
      free( mptr->projectionsystem );

   mptr->location.x = location->x;
   mptr->location.y = location->y;
   mptr->location.z = location->z;
   mptr->zoffset = zoffset;
   mptr->azimuth = azimuth;
   mptr->latitude = latitude;
   mptr->longitude = longitude;
   mptr->projectionsystem = strdup( projectionsystem );

   return( 0 );
}


static int get_model_loc( Location *location, float *zoffset, float *azimuth, float *latitude, float *longitude, String *projectionsystem )
{
   Modelinfoptr   iptr;
   Mdmodlocptr    mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_model_loc" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_model_loc): model info. does not exist." );
      return( -1 );
   }

   if( (mptr = iptr->mdmodlocptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_model_loc): model location does not exist." );
      return( -2 );
   }

   location->x = mptr->location.x;
   location->y = mptr->location.y;
   location->z = mptr->location.z;
   *zoffset = mptr->zoffset;
   *azimuth = mptr->azimuth;
   *latitude = mptr->latitude;
   *longitude = mptr->longitude;
   *projectionsystem = mptr->projectionsystem;

   return( 0 );
}


static int put_mdmodloc_item( unsigned itemtype, caddr_t item )
{
   Modelinfoptr   iptr;
   Mdmodlocptr    mptr;
   Location       *location;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_mdmodloc_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      iptr = modellistptr->modelinfoptr = new_node( Modelinfo );
      iptr->mdmodmiscptr = NULL;
      iptr->mdmodwrldptr = NULL;
      mptr = iptr->mdmodlocptr = new_node( Mdmodloc );
      mptr->location.x = mptr->location.y = mptr->location.z = 0.0;
      mptr->zoffset = 0.0;   mptr->azimuth = 0.0;
      mptr->latitude = 0.0;   mptr->longitude = 0.0;
      mptr->projectionsystem = NULL;
   } else if( iptr->mdmodlocptr == NULL )  {
      mptr = iptr->mdmodlocptr = new_node( Mdmodloc );
      mptr->location.x = mptr->location.y = mptr->location.z = 0.0;
      mptr->zoffset = 0.0;   mptr->azimuth = 0.0;
      mptr->latitude = 0.0;   mptr->longitude = 0.0;
      mptr->projectionsystem = NULL;
   } else {
      mptr = iptr->mdmodlocptr;
      switch( itemtype )  {
      case PutLocation:
         if( mptr->location.x != 0.0  ||
             mptr->location.y != 0.0  ||
             mptr->location.z != 0.0 )  {
            (void)sprintf( message,
                         "agm(put_mdmodloc_item): location already buffered." );
            return( -1 );
         }
         break;
      case PutZoffset:
         if( mptr->zoffset != 0.0 )  {
            (void)sprintf( message,
                         "agm(put_mdmodloc_item): z-offset already buffered." );
            return( -2 );
         }
         break;
      case PutAzimuth:
         if( mptr->azimuth!= 0.0 )  {
            (void)sprintf( message,
                          "agm(put_mdmodloc_item): azimuth already buffered." );
            return( -3 );
         }
         break;
      case PutLatitude:
         if( mptr->latitude!= 0.0 )  {
            (void)sprintf( message,
                         "agm(put_mdmodloc_item): latitude already buffered." );
            return( -4 );
         }
         break;
      case PutLongitude:
         if( mptr->longitude != 0.0 )  {
            (void)sprintf( message,
                        "agm(put_mdmodloc_item): longitude already buffered." );
            return( -5 );
         }
         break;
      case PutProjectionSystem:
         if( mptr->projectionsystem )  {
            (void)sprintf( message,
                "agm(put_mdmodloc_item): projection system already buffered." );
            return( -6 );
         }
         break;
      default:
         (void) fprintf( stderr,
                         "agm(put_mdmodloc_item): invalid item number.\n" );
         return( -10 );
      }
   }

   switch( itemtype )  {
   case PutLocation:
      location = (Location *)item;
      mptr->location.x = location->x;
      mptr->location.y = location->y;
      mptr->location.z = location->z;
      break;
   case PutZoffset:
      mptr->zoffset = *((double*)item);
      break;
   case PutAzimuth:
      mptr->azimuth = *((double*)item);
      break;
   case PutLatitude:
      mptr->latitude = *((double*)item);
      break;
   case PutLongitude:
      mptr->longitude = *((double*)item);
      break;
   case PutProjectionSystem:
      mptr->projectionsystem = strdup( (String)item );
      break;
   default:
      (void) fprintf( stderr,
                      "agm(put_mdmodloc_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int replace_mdmodloc_item( unsigned itemtype, caddr_t item )
{
   Modelinfoptr   iptr;
   Mdmodlocptr    mptr;
   Location       *location;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_mdmodloc_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void)sprintf( message,
"agm(replace_mdmodloc_item): model information does not exist for this model." );
      return( -1 );
   } else if( iptr->mdmodlocptr == NULL )  {
      (void)sprintf( message,
"agm(replace_mdmodloc_item): model location information does not exist for this model." );
      return( -2 );
   } else {
      mptr = iptr->mdmodlocptr;
      switch( itemtype )  {
      case ReplaceLocation:
      case ReplaceZoffset:
      case ReplaceAzimuth:
      case ReplaceLatitude:
      case ReplaceLongitude:
         break;
      case ReplaceProjectionSystem:
         if( !mptr->projectionsystem )  {
            (void)sprintf( message,
            "agm(replace_mdmodloc_item): projection system not buffered yet." );
            return( -3 );
         } else
            free( (char *)mptr->projectionsystem );
         break;
      default:
         (void) fprintf( stderr,
                         "agm(replace_mdmodloc_item): invalid item number.\n" );
         return( -10 );
      }
   }

   switch( itemtype )  {
   case ReplaceLocation:
      location = (Location *)item;
      mptr->location.x = location->x;
      mptr->location.y = location->y;
      mptr->location.z = location->z;
      break;
   case ReplaceZoffset:
      mptr->zoffset = *((double*)item);
      break;
   case ReplaceAzimuth:
      mptr->azimuth = *((double*)item);
      break;
   case ReplaceLatitude:
      mptr->latitude = *((double*)item);
      break;
   case ReplaceLongitude:
      mptr->longitude = *((double*)item);
      break;
   case ReplaceProjectionSystem:
      mptr->projectionsystem = strdup( (String)item );
      break;
   default:
      (void) fprintf( stderr,
                      "agm(replace_mdmodloc_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int get_mdmodloc_item( unsigned itemtype, caddr_t item )
{
   Modelinfoptr   iptr;
   Mdmodlocptr    mptr;
   Location       *location;
   float          *floatptr;
   String         *outstring;


   switch( itemtype )  {
   case GetLocation:
      location = (Location *) item;
      location->x = location->y = location->z = 0.0;
      break;
   case GetZoffset:
   case GetAzimuth:
   case GetLatitude:
   case GetLongitude:
      floatptr = (float *)item;   *floatptr = 0.0;   break;
   case GetProjectionSystem:
      outstring = (String *)item;   *outstring = NULL;   break;
   default:
      (void) fprintf( stderr,
                      "agm(get_mdmodloc_item): invalid item number.\n" );
      return( -1 );
   }

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_mdmodloc_item" );
      return( 1 );
   }

   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void) sprintf( message,
                      "agm(get_mdmodloc_item): model info. does not exist." );
      return( -2 );
   }

   if( (mptr = iptr->mdmodlocptr) == NULL )  {
      (void) sprintf( message,
                     "agm(get_mdmodloc_item): model location does not exist." );
      return( -3 );
   }

   switch( itemtype )  {
   case GetLocation:
      location->x = mptr->location.x;
      location->y = mptr->location.y;
      location->z = mptr->location.z;
      break;
   case GetZoffset:
      *floatptr = mptr->zoffset;   break;
   case GetAzimuth:
      *floatptr = mptr->azimuth;   break;
   case GetLatitude:
      *floatptr = mptr->latitude;   break;
   case GetLongitude:
      *floatptr = mptr->longitude;   break;
   case GetProjectionSystem:
      *outstring = mptr->projectionsystem;   break;
   }

   return( 0 );
}


static int create_version( Version version )
{
   Versionlistptr	vptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "create_version" );
      return( 1 );
   }

   if( version <= 0 )  {
      (void) sprintf( message,
                      "agm(create_version): version must be >= 0." );
      fprintf( stderr, "%s\n", message );
      return( 2 );
   }

   for( vptr = modellistptr->versionlistptr;  vptr;  vptr = vptr->next )  {
      if( version == vptr->version )  {  /* matching version */
         (void) sprintf( message,
                         "agm(create_version): version (%d) already exists.",
                         version );
         return( -1 );
      }

      if( vptr->next == NULL )
         break;
   }

   if( vptr == NULL )  /* version list was empty */
      vptr = modellistptr->versionlistptr = new_node( Versionlist );
   else  {  /* no matching version */
      vptr->next = new_node( Versionlist );  /* attach to prev version link */
      vptr = vptr->next;
   }
 
   versionlistptr = vptr;

   vptr->version = version;
   vptr->mdvermiscptr = NULL;
   vptr->mdlineageptr = NULL;
   vptr->collectionlistptr = NULL;
   vptr->end_collectionlistptr = NULL;
   vptr->next = NULL;

   return( 0 );
}


static int delete_version( Version version )

   /* note: all associated segments and attributes could also be deleted here */
   /*       requires checking whether any other versions use them */

{
   Versionlistptr   vptr, prevvptr = NULL;
   Idlistptr        iptr, nextiptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "delete_version" );
      return( 1 );
   }

   if( modellistptr->versionlistptr == NULL )  {
      (void) sprintf( message,
                      "agm(delete_version): model (%s) version list is empty.",
                      modellistptr->modelname );
      return( -1 );
   }

   for( vptr = modellistptr->versionlistptr;  vptr;  vptr = vptr->next )  {
      if( version == vptr->version )  /* matching version */
         break;
      prevvptr = vptr;
   }

   if( vptr == NULL )  {  /* exhausted list */
      (void) sprintf( message,
                      "agm(delete_version): version %d does not exist in '%s'.",
                      version, modellistptr->modelname );
      return( -2 );
   }

   versionlistptr = NULL;  /* reset since no longer applicable */

   if( vptr->mdvermiscptr != NULL )  {
      if( vptr->mdvermiscptr->creationdate != NULL )
         free( vptr->mdvermiscptr->creationdate );
      if( vptr->mdvermiscptr->creationtime != NULL )
         free( vptr->mdvermiscptr->creationtime );
      if( vptr->mdvermiscptr->lastupdate != NULL )
         free( vptr->mdvermiscptr->lastupdate );
      if( vptr->mdvermiscptr->lastuptime != NULL )
         free( vptr->mdvermiscptr->lastuptime );
      if( vptr->mdvermiscptr->description != NULL )
         free( vptr->mdvermiscptr->description );

      free( vptr->mdvermiscptr );
   }

   if( vptr->mdlineageptr != NULL )  {
      if( vptr->mdlineageptr->history != NULL )
         free( vptr->mdlineageptr->history );

      free( vptr->mdlineageptr );
   }

   if( vptr->collectionlistptr != NULL )  {
      if( vptr->collectionlistptr->mdcolmiscptr != NULL )  {
         if( vptr->collectionlistptr->mdcolmiscptr->description != NULL )
            free( vptr->collectionlistptr->mdcolmiscptr->description );

         free( vptr->collectionlistptr->mdcolmiscptr );
      }

      for( iptr = vptr->collectionlistptr->segmentidlistptr;  iptr;
           iptr = nextiptr )  {
         nextiptr = iptr->next;
         free( iptr );
      }

      for( iptr = vptr->collectionlistptr->attributeidlistptr;  iptr;
           iptr = nextiptr )  {
         nextiptr = iptr->next;
         free( iptr );
      }

      free( vptr->collectionlistptr );
   }

   /* tie linked list */
   if( prevvptr != NULL )
      prevvptr->next = vptr->next;
   else
      modellistptr->versionlistptr = vptr->next;

   free( vptr );

/* if( modellistptr->versionlistptr == NULL )  { */  /* delete data pools? */
      /* Note: Since the segment pool, attribute pool, and the miscellaneous
       *       attribute information data do not explicity contain version
       *       information, it may be undesireable to delete such information
       *       here.  For instance, at this point we could delete all remaining
       *       segments, attributes and miscellaneous attribute information for
       *       this model, but the user may want to delete this one last version
       *       and then create a new one which uses the same segment, attribute
       *       and miscellaneous attribute information.
       */
/* } */

   glob_collection_ptr = NULL;
   glob_segment_ptr = NULL;

   return( 0 );
}


static int activate_version( Version version )
{
   Versionlistptr   vptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "activate_version" );
      return( 1 );
   }

   for( vptr = modellistptr->versionlistptr;  vptr;  vptr = vptr->next )
      if( version == vptr->version )  {  /* matching version */
         versionlistptr = vptr;
         return( 0 );
      }

   if( modellistptr->versionlistptr == NULL )  {
      (void) sprintf( message,
                     "agm(activate_version): model (%s) version list is empty.",
                      modellistptr->modelname );
      return( -1 );
   }

   (void) sprintf( message,
                   "agm(activate_version): version %d does not exist in '%s'.",
                   version, modellistptr->modelname );
   return( -2 );
}


static int get_number_versions( unsigned *nversions )
{
   Versionlistptr   vptr;


   *nversions = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_versions" );
      return( 1 );
   }

   for( vptr = modellistptr->versionlistptr;  vptr;  vptr = vptr->next )
      ++(*nversions);

   return( 0 );
}


static int get_nth_version_number( unsigned nthversion, Version *version )
{
   Versionlistptr   vptr;
   unsigned     count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_version_number" );
      return( 1 );
   }

   for( vptr = modellistptr->versionlistptr;  vptr;  vptr = vptr->next )
      if( ++count == nthversion )  {
         *version = vptr->version;
         versionlistptr = vptr;
         return( 0 );
      }

   (void) sprintf( message,
         "agm(get_nth_version_number): %d versions do not exist (%d exist(s)).",
                   nthversion, count );
   return( -1 );
}


static int replace_version_number( Version version )
{
   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_version_number" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "replace_version_number" );
      return( 2 );
   }

   versionlistptr->version = version;

   return 0;
}


static int put_version_misc( Version parentversion, String creationdate, String creationtime, String lastupdate, String lastuptime, String description )
{
   Mdvermiscptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_version_misc" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_version_misc" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdvermiscptr) == NULL )  {
      mptr = versionlistptr->mdvermiscptr = new_node( Mdvermisc );
      mptr->parent = 0;
      mptr->creationdate = NULL;   mptr->creationtime = NULL;
      mptr->lastupdate = NULL;   mptr->lastuptime = NULL;
      mptr->description = NULL;
   } else {
      (void) sprintf( message,
"agm(put_version_misc): miscellaneous version information already exists for model '%s'.  Specify 'Replace' instead.", modellistptr->modelname );
      return( -1 );
   }

   mptr->parent = parentversion;
   mptr->creationdate = strdup( creationdate );
   mptr->creationtime = strdup( creationtime );
   mptr->lastupdate = strdup( lastupdate);
   mptr->lastuptime = strdup( lastuptime );
   mptr->description = strdup( description );

   return( 0 );
}


static int replace_version_misc( Version parentversion, String creationdate, String creationtime, String lastupdate, String lastuptime, String description )
{
   Mdvermiscptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_version_misc" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "replace_version_misc" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdvermiscptr) == NULL )  {
      (void) sprintf( message,
"agm(replace_version_misc): miscellaneous version information does not already exist for model '%s'.  Specify 'Put' instead.", modellistptr->modelname );
      return( -1 );
   }

   if( mptr->creationdate )
      free( (char *)mptr->creationdate );
   if( mptr->creationtime )
      free( (char *)mptr->creationtime );
   if( mptr->lastupdate )
      free( (char *)mptr->lastupdate );
   if( mptr->lastuptime )
      free( (char *)mptr->lastuptime );
   if( mptr->description )
      free( mptr->description );

   mptr->parent = parentversion;
   mptr->creationdate = strdup( creationdate );
   mptr->creationtime = strdup( creationtime );
   mptr->lastupdate = strdup( lastupdate);
   mptr->lastuptime = strdup( lastuptime );
   mptr->description = strdup( description );

   return( 0 );
}


static int get_version_misc( Version *parentversion, String *creationdate, String *creationtime, String *lastupdate, String *lastuptime, String *description )
{
   Mdvermiscptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_version_misc" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_version_misc" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdvermiscptr) == NULL )  {
      (void) sprintf( message,
               "agm(get_version_misc): miscellaneous version info. is empty." );
      return( -1 );
   }

   *parentversion = mptr->parent;
   *creationdate = mptr->creationdate;
   *creationtime = mptr->creationtime;
   *lastupdate = mptr->lastupdate;
   *lastuptime = mptr->lastuptime;
   *description = mptr->description;

   return( 0 );
}


static int put_mdvermisc_item( unsigned itemtype, caddr_t item )
{
   Mdvermiscptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_mdvermisc_item" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_mdvermisc_item" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdvermiscptr) == NULL )  {
      mptr = versionlistptr->mdvermiscptr = new_node( Mdvermisc );
      mptr->parent = 0;
      mptr->creationdate = NULL;   mptr->creationtime = NULL;
      mptr->lastupdate = NULL;   mptr->lastuptime = NULL;
      mptr->description = NULL;
   } else
      switch( itemtype )  {
      case PutVersionParent:
         if( mptr->parent != 0 )  {
            (void)sprintf( message,
                  "agm(put_mdvermisc_item): version parent already buffered." );
            return( -1 );
         }
         mptr->parent = (Version)(*(int*)item & 0xffffffff); /* & 0x00000000ffffffff to handle cast for 64-bit machines */
         break;
      case PutVersionCreationDate:
         if( mptr->creationdate )  {
            (void)sprintf( message,
                   "agm(put_mdvermisc_item): creation date already buffered." );
            return( -2 );
         }
         break;
      case PutVersionCreationTime:
         if( mptr->creationtime )  {
            (void)sprintf( message,
                   "agm(put_mdvermisc_item): creation time already buffered." );
            return( -3 );
         }
         break;
      case PutVersionLastUpDate:
         if( mptr->lastupdate )  {
            (void)sprintf( message,
                     "agm(put_mdvermisc_item): last update already buffered." );
            return( -4 );
         }
         break;
      case PutVersionLastUpTime:
         if( mptr->lastuptime )  {
            (void)sprintf( message,
                "agm(put_mdvermisc_item): last update time already buffered." );
            return( -5 );
         }
         break;
      case PutVersionDescription:
         if( mptr->description )  {
            (void)sprintf( message,
             "agm(put_mdvermisc_item): version description already buffered." );
            return( -6 );
         }
         break;
      default:
         (void) fprintf( stderr,
                         "agm(put_mdvermisc_item): invalid item number.\n" );
         return( -10 );
      }

   switch( itemtype )  {
   case PutVersionParent:
      mptr->parent = (Version)(*(int*)item & 0xffffffff); break; /* & 0x00000000ffffffff to handle cast for 64-bit machines */
   case PutVersionCreationDate:
      mptr->creationdate = strdup( (String)item );   break;
   case PutVersionCreationTime:
      mptr->creationtime = strdup( (String)item );   break;
   case PutVersionLastUpDate:
      mptr->lastupdate = strdup( (String)item );   break;
   case PutVersionLastUpTime:
      mptr->lastuptime = strdup( (String)item );   break;
   case PutVersionDescription:
      mptr->description = strdup( (String)item );   break;
   default:
      (void) fprintf( stderr,
                      "agm(put_mdvermisc_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int replace_mdvermisc_item( unsigned itemtype, caddr_t item )
{
   Mdvermiscptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_mdvermisc_item" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "replace_mdvermisc_item" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdvermiscptr) == NULL )  {
      (void)sprintf( message,
"agm(replace_mdvermisc_item): version information does not exist for this model." );
      return( -1 );
   } else
      switch( itemtype )  {
      case ReplaceVersionParent:
         break;
      case ReplaceVersionCreationDate:
         if( !mptr->creationdate )  {
            (void)sprintf( message,
               "agm(replace_mdvermisc_item): creation date not buffered yet." );
            return( -2 );
         } else
            free( (char *)mptr->creationdate );
         break;
      case ReplaceVersionCreationTime:
         if( !mptr->creationtime )  {
            (void)sprintf( message,
               "agm(replace_mdvermisc_item): creation time not buffered yet." );
            return( -3 );
         } else
            free( (char *)mptr->creationtime );
         break;
      case ReplaceVersionLastUpDate:
         if( !mptr->lastupdate )  {
            (void)sprintf( message,
                 "agm(replace_mdvermisc_item): last update not buffered yet." );
            return( -4 );
         } else
            free( (char *)mptr->lastupdate );
         break;
      case ReplaceVersionLastUpTime:
         if( !mptr->lastuptime )  {
            (void)sprintf( message,
            "agm(replace_mdvermisc_item): last update time not buffered yet." );
            return( -5 );
         } else
            free( (char *)mptr->lastuptime );
         break;
      case ReplaceVersionDescription:
         if( !mptr->description )  {
            (void)sprintf( message,
    "agm(replace_mdvermisc_item): last version description not buffered yet." );
            return( -6 );
         } else
            free( (char *)mptr->description );
         break;
      default:
         (void) fprintf( stderr,
                        "agm(replace_mdvermisc_item): invalid item number.\n" );
         return( -10 );
      }

   switch( itemtype )  {
   case ReplaceVersionParent:
      mptr->parent = (Version)(*(int*)item & 0xffffffff); break; /* & 0x00000000ffffffff to handle cast for 64-bit machines */
   case ReplaceVersionCreationDate:
      mptr->creationdate = strdup( (String)item );   break;
   case ReplaceVersionCreationTime:
      mptr->creationtime = strdup( (String)item );   break;
   case ReplaceVersionLastUpDate:
      mptr->lastupdate = strdup( (String)item );   break;
   case ReplaceVersionLastUpTime:
      mptr->lastuptime = strdup( (String)item );   break;
   case ReplaceVersionDescription:
      mptr->description = strdup( (String)item );   break;
   default:
      (void) fprintf( stderr,
                      "agm(replace_mdvermisc_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int get_mdvermisc_item( unsigned itemtype, caddr_t item )
{
   Mdvermiscptr     mptr;
   Version          *outversion;
   String           *outstring;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_mdvermisc_item" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_mdvermisc_item" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdvermiscptr) == NULL )  {
      (void) sprintf( message,
             "agm(get_mdvermisc_item): miscellaneous version info. is empty." );
      return( -1 );
   }

   switch( itemtype )  {
   case GetVersionParent:
      outversion = (Version *) item;
      *outversion = mptr->parent;
      break;
   case GetVersionCreationDate:
      outstring = (String *) item;
      *outstring = mptr->creationdate;
      break;
   case GetVersionCreationTime:
      outstring = (String *) item;
      *outstring = mptr->creationtime;
      break;
   case GetVersionLastUpDate:
      outstring = (String *) item;
      *outstring = mptr->lastupdate;
      break;
   case GetVersionLastUpTime:
      outstring = (String *) item;
      *outstring = mptr->lastuptime;
      break;
   case GetVersionDescription:
      outstring = (String *) item;
      *outstring = mptr->description;
      break;
   default:
      (void) fprintf( stderr,
                      "agm(get_mdvermisc_item): invalid item number.\n" );
      return( -10 );
   }

   return( 0 );
}


static int put_lineage( String history )
{
   Mdlineageptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_lineage" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_lineage" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdlineageptr) == NULL )  {
      mptr = versionlistptr->mdlineageptr = new_node( Mdlineage );
      mptr->history = NULL;
   } else {
      (void) sprintf( message,
"agm(put_lineage): version lineage information already exists for model '%s'.  Specify 'Replace' instead.", modellistptr->modelname );
      return( -1 );
   }

   mptr->history = strdup( history );

   return( 0 );
}


static int replace_lineage( String history )
{
   Mdlineageptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_lineage" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_lineage" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdlineageptr) == NULL )  {
      mptr = versionlistptr->mdlineageptr = new_node( Mdlineage );
      (void) sprintf( message,
"agm(replace_lineage): lineage information does not already exist for model '%s'.  Specify 'Put' instead.", modellistptr->modelname );
      return( -1 );
   }

   if( mptr->history )
      free( mptr->history );
   mptr->history = strdup( history );

   return( 0 );
}


static int get_lineage( String *history )
{
   Mdlineageptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_lineage" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_lineage" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdlineageptr ) == NULL )  {
      (void) sprintf( message,
               "agm(get_version_misc): version lineage info. is empty." );
      return( -1 );
   }

   *history = mptr->history;

   return( 0 );
}


static int put_mdlineage_item( unsigned itemtype, caddr_t item )
{
   Mdlineageptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_mdlineage_item" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_mdlineage_item" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdlineageptr) == NULL )  {
      mptr = versionlistptr->mdlineageptr = new_node( Mdlineage );
      mptr->history = NULL;
   } else
      switch( itemtype )  {
      case PutVersionHistory:
         if( mptr->history )  {
            (void)sprintf( message,
                 "agm(put_mdlineage_item): version history already buffered." );
            return( -1 );
         }
         mptr->history = strdup( (String) item );
         break;
      default:
         (void) fprintf( stderr,
                         "agm(put_mdlineage_item): invalid item number.\n" );
         return( -10 );
      }

   switch( itemtype )  {
   case PutVersionHistory:
      mptr->history = strdup( (String) item );   break;
   default:
      (void) fprintf( stderr,
                      "agm(put_mdlineage_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int replace_mdlineage_item( unsigned itemtype, caddr_t item )
{
   Mdlineageptr     mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_mdlineage_item" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "replace_mdlineage_item" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdlineageptr) == NULL )  {
      (void)sprintf( message,
"agm(replace_mdlineage_item): version lineage information does not exist for this model." );
      return( -1 );
   } else
      switch( itemtype )  {
      case ReplaceVersionHistory:
         if( !mptr->history )  {
            (void)sprintf( message,
              "agm(replace_mdlineage_item): history string not buffered yet." );
            return( -2 );
         } else
            free( (char *)mptr->history );
         break;
      default:
         (void) fprintf( stderr,
                        "agm(replace_mdlineage_item): invalid item number.\n" );
         return( -10 );
      }

   switch( itemtype )  {
   case ReplaceVersionHistory:
      mptr->history = strdup( (String) item );
      break;
   default:
      (void) fprintf( stderr,
                      "agm(replace_mdlineage_item): invalid item number.\n" );
      return( -11 );
   }

   return( 0 );
}


static int get_mdlineage_item( unsigned itemtype, caddr_t item )
{
   Mdlineageptr     mptr;
   String           *outstring;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_mdlineage_item" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_mdlineage_item" );
      return( 2 );
   }

   if( (mptr = versionlistptr->mdlineageptr) == NULL )  {
      (void) sprintf( message,
             "agm(get_mdlineage_item): version lineage info. is empty." );
      return( -1 );
   }

   switch( itemtype )  {
   case GetVersionHistory:
      outstring = (String *) item;
      *outstring = mptr->history;
      break;
   default:
      (void) fprintf( stderr,
                      "agm(get_mdlineage_item): invalid item number.\n" );
      return( -2 );
   }

   return( 0 );
}


static int restrict_collection_type( Type type )
{
   restricted_collection_type = type;

   return( 0 );
}


static int get_number_collections( unsigned *ncollections )
{
   Collectionlistptr   cptr;


   *ncollections = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_collections" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_number_collections" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
      if( restricted_collection_type != ALL_TYPES )  {
         if( cptr->mdcolmiscptr != NULL )  {
            if( cptr->mdcolmiscptr->type == restricted_collection_type )
               (*ncollections)++;
         }
      } else
         (*ncollections)++;

   return( 0 );
}


static int get_nth_collection_misc( unsigned nthcollection, Id *collectionid, Id *parentcollectionid, Type *collectiontype, String *description )
{
   Collectionlistptr   cptr;
   unsigned        count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_collection_misc" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_nth_collection_misc" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
      if( ++count == nthcollection )  {
         *collectionid = globcollectionid = cptr->id;
         glob_collection_ptr = cptr;

         if( cptr->mdcolmiscptr != NULL )  {
            *parentcollectionid = cptr->mdcolmiscptr->parent;
            *collectiontype = cptr->mdcolmiscptr->type;
            *description = cptr->mdcolmiscptr->description;
            return( 0 );
         } else {
            (void) sprintf( message,
                 "agm(get_nth_collection_misc): collection misc. is empty.\n" );
            return( -1 );
         }
      }

   (void) sprintf( message,
            "agm(get_nth_collection_misc): '%dth' collection does not exist.\n",
                   nthcollection );
   return( -2 );
}


static int get_next_collection_misc( Id *collectionid, Id *parentcollectionid, Type *collectiontype, String *description )
{
   static String	function_name = "get_next_collection_misc";

   if( modellistptr == NULL )  {
      handle_empty_model_list( function_name );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( function_name );
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message, "agm(%s): a collection is not active.",
                     function_name );
      return( -1 );
   }

   if( glob_collection_ptr->next == NULL )  {
      (void)sprintf( message, "agm(%s): 'next' collection does not exist.\n",
                     function_name );
      return( -2 );
   }
   
   if( glob_collection_ptr->next->mdcolmiscptr == NULL )  {
      (void)sprintf( message, "agm(%s): collection misc. is empty.\n",
                     function_name );
      glob_collection_ptr = glob_collection_ptr->next;
      return( -3 );
   }

   glob_collection_ptr = glob_collection_ptr->next;
   *collectionid = globcollectionid = glob_collection_ptr->id;
   *parentcollectionid = glob_collection_ptr->mdcolmiscptr->parent;
   *collectiontype = glob_collection_ptr->mdcolmiscptr->type;
   *description = glob_collection_ptr->mdcolmiscptr->description;

   return( 0 );
}


static int create_collection( Id collectionid )
{
   static String	function_name = "create_collection";

   Collectionlistptr	cptr;

   if( modellistptr == NULL )  {
      handle_empty_model_list( function_name );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( function_name );
      return( 2 );
   }

   if( collectionid == 0 )  {
      (void)new_collection_id();  /* sets globcollectionid */
      cptr = versionlistptr->end_collectionlistptr;
   } else {
      /* scan collection list for possible existing collection id */
      for( cptr = versionlistptr->collectionlistptr;  cptr;
           cptr = cptr->next )  {
         if( cptr->id == collectionid )  {
            (void)sprintf( message,
                 "agm(%s): collection id (%d) already exists for this version.",
                           function_name, collectionid );
            return( -1 );
         }

         if( cptr->next == NULL )
         break;
      }

      globcollectionid = collectionid;
   }

   if( cptr == NULL )  /* collection list is empty */
      cptr = versionlistptr->collectionlistptr = new_node( Collectionlist );
   else  {
      cptr->next = new_node( Collectionlist );  /* attach to prev link */
      cptr = cptr->next;
   }

   if( globcollectionid > highest_collection_id )
      highest_collection_id = globcollectionid;

   versionlistptr->end_collectionlistptr = cptr;

   cptr->id = globcollectionid;
   cptr->mdcolmiscptr = NULL;
   cptr->segmentidlistptr = glob_segment_ptr = NULL;
   cptr->attributeidlistptr = NULL;
   cptr->next = NULL;

   glob_collection_ptr = cptr;
 
   return( 0 );
}
 

static int activate_collection( Id globcollectionid )
{
   Collectionlistptr   cptr;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "activate_collection" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "activate_collection" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
      if( globcollectionid == cptr->id )  {  /* matching collection */
         glob_collection_ptr = cptr;
         return( 0 );
      }
 
   (void) sprintf( message, "agm(activate_collection): collection id (%d) not defined for this version.", globcollectionid );
   return( -1 );
}


static int activate_indexed_collection( unsigned index )
{
   Collectionlistptr	cptr;
   unsigned		count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "activate_indexed_collection" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "activate_indexed_collection" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )
         continue;
      if( cptr->mdcolmiscptr->type == restricted_collection_type )
         if( ++count == index )  {
            globcollectionid = cptr->id;
            glob_collection_ptr = cptr;
            return( 0 );
         }
   }

   (void) sprintf( message,
"agm(activate_indexed_collection_id): indexed collection (%d) does not exist (%d exist(s)).",
                   index, count );
   return( -1 );
}
 

static int put_collection_parent( Id parentcollectionid )
{
   Mdcolmiscptr        mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_collection_parent" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_collection_parent" );
      return( 2 );
   }

   if( globcollectionid == NO_ID )  {
      (void)sprintf( message,
"agm(put_collection_parent): current collection id (%d) not defined for this version or a collection has not been created.",
                     globcollectionid );
      return( -1 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
                    "agm(put_collection_parent): a collection is not active." );
      return( -2 );
   }

   if( (mptr = glob_collection_ptr->mdcolmiscptr) != NULL ) /* have mdcolmisc */
      if( mptr->parent != NO_ID )  {
         (void)sprintf( message, "agm(put_collection_parent): collection parent already defined; modify with 'Replace' instead." );
         return( -3 );
      } else
         mptr->parent = parentcollectionid;
   else { /* mdcolmisc is empty */
      mptr = glob_collection_ptr->mdcolmiscptr = new_node( Mdcolmisc );
      mptr->parent = parentcollectionid;
      mptr->type = NO_TYPE;
      mptr->description = NULL;
   }

   return( 0 );
}


static int put_collection_type( Type collectiontype )
{
   Mdcolmiscptr        mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_collection_type" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_collection_type" );
      return( 2 );
   }

   if( globcollectionid == NO_ID )  {
      (void)sprintf( message,
"agm(put_collection_type): current collection id (%d) not defined for this version or a collection has not been created.",
                     globcollectionid );
      return( -1 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
                    "agm(put_collection_type): a collection is not active." );
      return( -2 );
   }

   if( (mptr = glob_collection_ptr->mdcolmiscptr) != NULL ) /* have mdcolmisc */
      if( mptr->type != NO_TYPE )  {
         (void)sprintf( message, "agm(put_collection_type): collection type already defined; modify with 'Replace' instead." );
         return( -3 );
      } else
         mptr->type = collectiontype;
   else { /* mdcolmisc is empty */
      mptr = glob_collection_ptr->mdcolmiscptr = new_node( Mdcolmisc );
      mptr->parent = NO_ID;
      mptr->type = collectiontype;
      mptr->description = NULL;
   }
   return( 0 );
}


static int put_collection_description( String description )
{
   Mdcolmiscptr        mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_collection_description" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_collection_description" );
      return( 2 );
   }

   if( globcollectionid == NO_ID )  {
      (void)sprintf( message,
"agm(put_collection_description): current collection id (%d) not defined for this version or a collection has not been created.",
                     globcollectionid );
      return( -1 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
               "agm(put_collection_description): a collection is not active." );
      return( -2 );
   }

   if( (mptr = glob_collection_ptr->mdcolmiscptr) != NULL ) /* have mdcolmisc */
      if( mptr->description != NULL )  {
         (void)sprintf( message, "agm(put_collection_description): collection description already defined; modify with 'Replace' instead." );
         return( -2 );
      } else
         mptr->description = strdup( description );
   else { /* mdcolmisc is empty */
      mptr = glob_collection_ptr->mdcolmiscptr = new_node( Mdcolmisc );
      mptr->parent = NO_ID;
      mptr->type = NO_TYPE;
      mptr->description = strdup( description );
   }
   return( 0 );
}


static int put_id_collection_misc( Id globcollectionid, Id parentcollectionid, Type collectiontype, String description )
{
   Collectionlistptr   cptr;
   Mdcolmiscptr        mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_id_collection_misc" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_id_collection_misc" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( globcollectionid == cptr->id )  {  /* matching collection */
         glob_collection_ptr = cptr;

         if( (mptr = cptr->mdcolmiscptr) != NULL )  {  /* have mdcolmisc */
            if( mptr->description )  /* replace */
               free( mptr->description );  /* size may vary */
         } else  /* mdcolmisc is empty */
            mptr = cptr->mdcolmiscptr = new_node( Mdcolmisc );

         mptr->parent = parentcollectionid;
         mptr->type = collectiontype;
         mptr->description = strdup( description );

         return( 0 );
      }

      if( cptr->next == NULL )  /* exhausted list: no matching collection */
         break;
   }

   /* get here if no matching collection found */
   if( cptr == NULL )  /* collection list is empty */
      cptr = versionlistptr->collectionlistptr = new_node( Collectionlist );
   else  {  /* no matching collection: cptr->next == NULL */
      cptr->next = new_node( Collectionlist );  /* attach to prev link */
      cptr = cptr->next;
   }
 
   if( globcollectionid > highest_collection_id )
      highest_collection_id = globcollectionid;

   versionlistptr->end_collectionlistptr = cptr;

   cptr->id = globcollectionid;
   cptr->mdcolmiscptr = new_node( Mdcolmisc );
   cptr->segmentidlistptr = glob_segment_ptr = NULL;
   cptr->attributeidlistptr = NULL;
   cptr->next = NULL;

   glob_collection_ptr = cptr;

   mptr = cptr->mdcolmiscptr;
   mptr->parent = parentcollectionid;
   mptr->type = collectiontype;
   mptr->description = strdup( description );

   return( 0 );
}


static int put_new_collection_misc( Id collectionparentid, Type collectiontype, String description )
{
   Collectionlistptr   cptr;
   Mdcolmiscptr        mptr;
   int                 rc = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_new_collection_misc" );
      return( 1 );
   }
      
   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_new_collection_misc" );
      return( 2 );
   }
 
   (void)new_collection_id();  /* must create id before appending new link */

   /* go to end of list */
   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
/*    if( cptr->mdcolmiscptr != NULL )
         if( cptr->mdcolmiscptr->parent == collectionparentid  &&
             cptr->mdcolmiscptr->type == collectiontype  &&
             strcmp( cptr->mdcolmiscptr->description, description ) == MATCH ) {
             (void) sprintf( message,
"agm(put_new_collection_misc): parent id (%d), type (%d) and description (%s) match existing collection.",
                             collectionparentid, collectiontype, description );
             (void) fprintf( stderr, "%s\n", message );
             rc = -1;
         }
leave out as is problematic.
*/

      if( cptr->next == NULL )
         break;
   }
 
   if( cptr == NULL )  /* collection list is empty */
      cptr = versionlistptr->collectionlistptr = new_node( Collectionlist );
   else  {
      cptr->next = new_node( Collectionlist );  /* attach to prev link */
      cptr = cptr->next;
   }

   if( globcollectionid > highest_collection_id )  /* new_collection_id above */
      highest_collection_id = globcollectionid;    /* set globcollectionid */

   versionlistptr->end_collectionlistptr = cptr;

   cptr->id = globcollectionid;
   cptr->mdcolmiscptr = new_node( Mdcolmisc );
   cptr->segmentidlistptr = glob_segment_ptr = NULL;
   cptr->attributeidlistptr = NULL;
   cptr->next = NULL;

   glob_collection_ptr = cptr;
 
   mptr = cptr->mdcolmiscptr;
   mptr->parent = collectionparentid;
   mptr->type = collectiontype;
   mptr->description = strdup( description );
 
   return( rc );
}


static int get_number_collection_types( unsigned *ntypes )
{
   Collectionlistptr   cptr;
   Boolean             found;
   Genericptrlistptr   typelist = NULL, tptr, nexttptr;


   *ntypes = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_collection_types" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_number_collection_types" );
      return( 2 );
   }
 
   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )
         continue;
      for( found = FALSE, tptr = typelist;  tptr;  tptr = tptr->next )  {
         if( cptr->mdcolmiscptr->type == *(Type *)tptr->genericptr )  {
            found = TRUE;
            break;
         } else if( tptr->next == NULL )
            break;
      }
      if( !found )  {
         ++(*ntypes);
         if( tptr == NULL )
            tptr = typelist = new_node( Genericptrlist );
         else if( tptr->next == NULL )  {
            tptr->next = new_node( Genericptrlist );
            tptr = tptr->next;
         }
#ifdef SUN
         tptr->genericptr = (void *)&cptr->mdcolmiscptr->type;
#endif
#ifdef CRAY
         tptr->genericptr = (char *)&cptr->mdcolmiscptr->type;
#endif
         tptr->next = NULL;
      }
   }

   for( tptr = typelist;  tptr;  tptr = nexttptr )  {
      nexttptr = tptr->next;
      free( (char *)tptr );
   }

   return( 0 );
}


static int get_nth_collection_type( unsigned nthtype, Type *type )
{
   Collectionlistptr   cptr;
   Boolean             found;
   Genericptrlistptr   typelist = NULL, tptr, nexttptr;
   int                 *ilist;
   unsigned        count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_collection_type" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_nth_collection_type" );
      return( 2 );
   }
 
   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )
         continue;
      for( found = FALSE, tptr = typelist;  tptr;  tptr = tptr->next )  {
         if( cptr->mdcolmiscptr->type == *(Type *)tptr->genericptr )  {
            glob_collection_ptr = cptr;
            found = TRUE;
            break;
         } else if( tptr->next == NULL )
            break;
      }
      if( !found )  {
         if( tptr == NULL )
            tptr = typelist = new_node( Genericptrlist );
         else if( tptr->next == NULL )  {
            tptr->next = new_node( Genericptrlist );
            tptr = tptr->next;
         }
#ifdef SUN
         tptr->genericptr = (void *)&cptr->mdcolmiscptr->type;
#endif
#ifdef CRAY
         tptr->genericptr = (char *)&cptr->mdcolmiscptr->type;
#endif
         tptr->next = NULL;
         (void) ilistalloc( (int)cptr->mdcolmiscptr->type );
         count++;
      }
   }

   if( nthtype > count )  {
      (void) sprintf( message,
        "agm(get_nth_collection_type): %dth type does not exist (%d exist(s)).",
                      nthtype, count );
      *type = (Type)NULL;
      (void) ilistfree();
      for( tptr = typelist;  tptr;  tptr = nexttptr )  {
         nexttptr = tptr->next;
         free( tptr );
      }
      return( -1 );
   }
 
   (void) ilistget( &ilist );   (void) ilistfree();
 
   qsort( (char *)ilist, count, sizeof( int ), intcompare );
 
   *type = (Type)ilist[nthtype-1];
 
   free( ilist );

   for( tptr = typelist;  tptr;  tptr = nexttptr )  {
      nexttptr = tptr->next;
      free( tptr );
   }

   return( 0 );
}


static int get_number_of_collection_type( Type collectiontype, unsigned *ncollections )
{
   Collectionlistptr   cptr;


   *ncollections = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_of_collection_type" );
      return( 1 );
   }
      
   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_number_of_collection_type" );
      return( 2 );
   }
 
   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )
         continue;
      if( cptr->mdcolmiscptr->type == collectiontype )
         (*ncollections)++;
   }

   return( 0 );
}


static int get_collection_type_nth_collection_id( Type collectiontype, unsigned nthcollection, Id *collectionid )
{
   Collectionlistptr   cptr;
   int                 *ilist;
   unsigned        count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_type_nth_collection_id" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_type_nth_collection_id" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )
         continue;
      if( cptr->mdcolmiscptr->type == collectiontype )  {
         (void) ilistalloc( cptr->id );  /* add id to list */
         count++;
      }
   }
 
   if( nthcollection > count )  {
      (void) sprintf( message,
"agm(get_collection_type_nth_collection_id): %dth collection does not exist (%d exist(s)).",
                      nthcollection, count );
      *collectionid = (Id)NULL;
      (void) ilistfree();
      return( -1 );
   }
 
   (void) ilistget( &ilist );   (void) ilistfree();
 
   qsort( (char *)ilist, count, sizeof( int ), intcompare );
 
   globcollectionid = *collectionid = ilist[nthcollection-1];
/**************** NOTE: does not set glob_collection_ptr **********************/
 
   free( ilist );

   return( 0 );
}


static int get_indexed_collection_id( unsigned nthcollection, Id *collectionid )
{
   Collectionlistptr   cptr;
/* int                 *ilist; */
   unsigned        count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_indexed_collection_id" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_indexed_collection_id" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )
         continue;
      if( cptr->mdcolmiscptr->type == restricted_collection_type )
         if( ++count == nthcollection )  {
            glob_collection_ptr = cptr;
            globcollectionid = *collectionid = cptr->id;
            return( 0 );
         }
   }

   (void) sprintf( message,
"agm(get_indexed_collection_id): %dth collection does not exist (%d exist(s)).",
                   nthcollection, count );
   *collectionid = (Id)NULL;
   return( -1 );


/*       (void) ilistalloc( cptr->id ); */ /* add id to list */
/*       count++;
      }
 
   if( nthcollection > count )  {
      (void) sprintf( message,
"agm(get_indexed_collection_id): %dth collection does not exist (%d exist(s)).",
                      nthcollection, count );
      *collectionid = (Id)NULL;
      (void) ilistfree();
      return( -1 );
   }
 
   (void) ilistget( &ilist );   (void) ilistfree();
 
   qsort( (char *)ilist, count, sizeof( int ), intcompare );
 
   globcollectionid = *collectionid = ilist[nthcollection-1];
 
   free( ilist );

   return( 0 );
*/
}


static int get_collection_type_nth_collection_misc( Type collectiontype, unsigned nthcollection, Id *parentcollectionid, String *description )
{
   Collectionlistptr   cptr;
   unsigned        count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_type_nth_collection_misc" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_type_nth_collection_misc");
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )  {
         (void) sprintf( message,
"agm(get_collection_type_nth_collection_misc): %dth collection missing misc. collection info.",
                         nthcollection );
         return( -1 );
      }

      if( cptr->mdcolmiscptr->type != collectiontype )
         continue;

      if( ++count == nthcollection )  {
         glob_collection_ptr = cptr;
         globcollectionid = cptr->id;
         *parentcollectionid = cptr->mdcolmiscptr->parent;
         *description = cptr->mdcolmiscptr->description;

         return( 0 );
      }   
   }   

   (void) sprintf( message,
"agm(get_collection_type_nth_collection_misc): %dth collection of specified type not found.",
                   nthcollection );
   return( -2 );
}


static int get_collection_parent_id( Id *parentcollectionid )
{
   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_parent_id" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_parent_id");
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
                 "agm(get_collection_parent_id): a collection is not active." );
      return( -1 );
   }

   if( glob_collection_ptr->mdcolmiscptr == NULL )  {
      (void) sprintf( message,
"agm(get_collection_parent_id): collection id (%d) missing misc. collection info.",
                      globcollectionid );
      return( -2 );
   }

   *parentcollectionid = glob_collection_ptr->mdcolmiscptr->parent;

   return( 0 );
}   


static int get_collection_description( String *description )
{
   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_description" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_description");
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
               "agm(get_collection_description): a collection is not active." );
      return( -1 );
   }

   if( glob_collection_ptr->mdcolmiscptr == NULL )  {
      (void) sprintf( message,
"agm(get_collection_description): collection id (%d) missing misc. collection info.",
                      globcollectionid );
      return( -2 );
   }

   *description = glob_collection_ptr->mdcolmiscptr->description;

   return( 0 );
}   


static int get_collection_type( Type *type )
{
   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_type" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_type");
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
               "agm(get_collection_type): a collection is not active." );
      return( -1 );
   }

   if( glob_collection_ptr->mdcolmiscptr == NULL )  {
      (void) sprintf( message,
  "agm(get_collection_type): collection id (%d) missing misc. collection info.",
                      globcollectionid );
      return( -2 );
   }

   *type = glob_collection_ptr->mdcolmiscptr->type;

   return( 0 );
}   


static int get_collection_type_nth_collection_segments( Type collectiontype, unsigned nthcollection, unsigned *nsegments, unsigned **segmentsnpts, Tupleptr **segments )
{
/* static unsigned   lastnsegments = NULL, *lastsegmentsnpts = NULL;
   static Tupleptr       *lastsegments = NULL;
*/

   Collectionlistptr   cptr;
   unsigned        segment, count = 0, totalpts;


/* if( lastsegmentsnpts )	DANGEROUS: let applic garbage collect
      free( lastsegmentsnpts );
   if( lastsegments )  {
      for( segment = 0;  segment < lastnsegments;  segment++ )
         free( lastsegments[segment] );
      free( lastsegments );
   }
*/

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_type_nth_collection_segments" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_type_nth_collection_segments");
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )
         continue;
      if( cptr->mdcolmiscptr->type != collectiontype )
         continue;

      if( ++count == nthcollection )  {
         glob_collection_ptr = cptr;
         globcollectionid = cptr->id;

         if( connect_segments )  {
            get_collection_num_segs_pts( cptr->segmentidlistptr, nsegments,
                                         &totalpts );
            totalpts += 1 - *nsegments;  /* account for duplicate endpts */
/*          lastnsegments = *nsegments = 1;
            lastsegmentsnpts = *segmentsnpts =
               (unsigned *) malloc( sizeof( unsigned ) );
            lastsegments = *segments = (Tupleptr *) malloc( sizeof( Tupleptr ));
*/
            *nsegments = 1;
            *segmentsnpts = (unsigned *) malloc( sizeof( unsigned ) );
            *segments = (Tupleptr *) malloc( sizeof( Tupleptr ));

            **segmentsnpts = totalpts;
            **segments = (Tupleptr) malloc( totalpts * sizeof( Tuple ) );
            copy_segments( cptr->segmentidlistptr, *segments );
         } else {
/* allow INORDER specification */

            get_collection_num_segs( cptr->segmentidlistptr, nsegments );

/*          lastnsegments = *nsegments;
            lastsegmentsnpts = *segmentsnpts =
               (unsigned *) malloc( *nsegments * sizeof( unsigned ) );
            lastsegments = *segments =
               (Tupleptr *) malloc( *nsegments * sizeof( Tupleptr ) );
*/
            *segmentsnpts = (unsigned *)malloc( *nsegments * sizeof( unsigned));
            *segments = (Tupleptr *) malloc( *nsegments * sizeof( Tupleptr ) );

            get_collection_num_seg_pts( cptr->segmentidlistptr, *segmentsnpts );
            for( segment = 0;  segment < *nsegments;  segment++ )
               (*segments)[segment] = (Tupleptr)
                           malloc( (*segmentsnpts)[segment] * sizeof( Tuple ) );
            copy_segments( cptr->segmentidlistptr, *segments );
         }

         return( 0 );
      }   
   }   

   (void) sprintf( message,
 "agm(get_collection_type_nth_collection_segments): %dth collection of specified type not found.",
                   nthcollection );
   return( -1 );
}


static int get_collection_segments( unsigned *nsegments, unsigned **segmentsnpts, Tupleptr **segments )
{
/* static unsigned   lastnsegments = NULL, *lastsegmentsnpts = NULL;
   static Tupleptr       *lastsegments = NULL;
*/

   unsigned        segment, totalpts;


/* if( lastsegmentsnpts )	DANGEROUS: let applic garbage collect
      free( lastsegmentsnpts );
   if( lastsegments )  {
      for( segment = 0;  segment < lastnsegments;  segment++ )
         free( lastsegments[segment] );
      free( lastsegments );
   }
*/

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_segments" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_segments");
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
                 "agm(get_collection_segments): a collection is not active." );
      return( -1 );
   }

   if( connect_segments )  {
      get_collection_num_segs_pts( glob_collection_ptr->segmentidlistptr,
                                   nsegments, &totalpts );
      totalpts += 1 - *nsegments;  /* account for duplicate endpts */
/*    lastnsegments = *nsegments = 1;
      lastsegmentsnpts = *segmentsnpts =
         (unsigned *) malloc( sizeof( unsigned ) );
      lastsegments = *segments = (Tupleptr *) malloc( sizeof( Tupleptr ) );
*/
      *nsegments = 1;
      *segmentsnpts = (unsigned *) malloc( sizeof( unsigned ) );
      *segments = (Tupleptr *) malloc( sizeof( Tupleptr ) );

      **segmentsnpts = totalpts;
      **segments = (Tupleptr) malloc( totalpts * sizeof( Tuple ) );
      copy_segments( glob_collection_ptr->segmentidlistptr, *segments );
   } else {
      get_collection_num_segs( glob_collection_ptr->segmentidlistptr,
                               nsegments );
/*    lastnsegments = *nsegments;
      lastsegmentsnpts = *segmentsnpts =
         (unsigned *) malloc( *nsegments * sizeof( unsigned ) );
      lastsegments = *segments =
         (Tupleptr *) malloc( *nsegments * sizeof( Tupleptr ) );
*/
      *segmentsnpts = (unsigned *) malloc( *nsegments * sizeof( unsigned ) );
      *segments = (Tupleptr *) malloc( *nsegments * sizeof( Tupleptr ) );

      get_collection_num_seg_pts( glob_collection_ptr->segmentidlistptr,
                                  *segmentsnpts );
      for( segment = 0;  segment < *nsegments;  segment++ )
         (*segments)[segment] = (Tupleptr)
                           malloc( (*segmentsnpts)[segment] * sizeof( Tuple ) );
      copy_segments( glob_collection_ptr->segmentidlistptr, *segments );
   }

   return( 0 );
}   


static int delete_collection_type( Type collectiontype )
{
   static String	function_name = "delete_collection_type";

   Idlistptr		iptr, nextiptr, oiptr;
   Collectionlistptr	cptr, prev_cptr = NULL, next_cptr, ocptr;
   Boolean		found = FALSE, seg_found, atb_found;


   if( modellistptr == NULL )  {
      handle_empty_model_list( function_name );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( function_name );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = next_cptr )  {
      next_cptr = cptr->next;

      if( cptr->mdcolmiscptr == NULL )
         continue;

      if( cptr->mdcolmiscptr->type == collectiontype )  {
         found = TRUE;

         if( cptr == glob_collection_ptr )
            glob_collection_ptr = NULL;

         if( !prev_cptr )
            versionlistptr->collectionlistptr = next_cptr;
         else
            prev_cptr->next = next_cptr;

         if( cptr->mdcolmiscptr->description != NULL )
            free( (char *)cptr->mdcolmiscptr->description );

         free( (char *)cptr->mdcolmiscptr );

         for( iptr = cptr->segmentidlistptr;  iptr;  iptr = nextiptr )  {
            nextiptr = iptr->next;

            /* check if segment belongs to anyone else; if not, delete it */
            seg_found = FALSE;
            for( ocptr = versionlistptr->collectionlistptr;  ocptr;
                 ocptr = ocptr->next )
               if( ocptr != cptr )  {
                  for( oiptr = ocptr->segmentidlistptr;  oiptr;
                       oiptr = oiptr->next )
                     if( oiptr->id == iptr->id )  {
                        seg_found = TRUE;
                        if( oiptr == glob_segment_ptr )
                           glob_segment_ptr = NULL;
                        break;
                     }
                  if( seg_found )
                     break;
               }
            if( !seg_found )
               delete_segment( iptr->id );

            free( (char *)iptr );
         }

         for( iptr = cptr->attributeidlistptr;  iptr;  iptr = nextiptr )  {
            nextiptr = iptr->next;

            /* check if attribute belongs to anyone else; if not, delete it */
            atb_found = FALSE;
            for( ocptr = versionlistptr->collectionlistptr;  ocptr;
                 ocptr = ocptr->next )
               if( ocptr != cptr )  {
                  for( oiptr = ocptr->attributeidlistptr;  oiptr;
                       oiptr = oiptr->next )
                     if( oiptr->id == iptr->id )  {
                        atb_found = TRUE;
                        break;
                     }
                  if( atb_found )
                     break;
               }
            if( !atb_found )
               delete_attribute( iptr->id );

            free( (char *)iptr );
         }

         free( (char *)cptr );

         if( next_cptr == NULL )
            if( prev_cptr )
               versionlistptr->end_collectionlistptr = prev_cptr;
            else
               versionlistptr->end_collectionlistptr =
                  versionlistptr->collectionlistptr;
      } else
         prev_cptr = cptr;
   }

   if( !found )  {
      (void) sprintf( message, "agm(%s): collection type (%d) not found.",
                      function_name, collectiontype );
      return( -1 );
   } else
      return( 0 );
}


static int get_number_collection_segment_links( unsigned *nlinks )
{
   Collectionlistptr   cptr;
   Idlistptr           sptr;


   *nlinks = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_collection_segment_links" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_number_collection_segment_links" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
      for( sptr = cptr->segmentidlistptr;  sptr;  sptr = sptr->next )
         (*nlinks)++;

   return( 0 );
}


static int get_nth_collection_segment_link( unsigned nthlink, Id *collectionid, Id *segmentid )
{
   static String	function_name = "get_nth_collection_segment_link";

   Collectionlistptr   cptr;
   Idlistptr           sptr;
   unsigned        count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( function_name );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( function_name );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
      for( sptr = cptr->segmentidlistptr;  sptr;  sptr = sptr->next )
         if( ++count == nthlink )  {
            glob_collection_ptr = cptr;
            glob_segment_ptr = sptr;
            *collectionid = globcollectionid = cptr->id;
            *segmentid = globsegmentid = sptr->id;

            return( 0 );
         }

   (void) sprintf( message, "agm(%s): '%dth' link does not exist.\n",
                   function_name, nthlink );
   return( -1 );
}


static int get_next_collection_segment_link( Id *collectionid, Id *segmentid )
{
   static String	function_name = "get_next_collection_segment_link";


   if( modellistptr == NULL )  {
      handle_empty_model_list( function_name );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( function_name );
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message, "agm(%s): a collection is not active.",
                     function_name );
      return( -1 );
   }

   if( glob_segment_ptr == NULL )  {
      (void)sprintf( message, "agm(%s): a segment is not active.",
                     function_name );
      return( -2 );
   }

   if( glob_segment_ptr->next == NULL )
      if( glob_collection_ptr->next == NULL )  {
         (void)sprintf( message,
                        "agm(%s): 'next' segment association does not exist.\n",
                        function_name );
         return( -3 );
      } else {
         for( glob_collection_ptr = glob_collection_ptr->next;
              glob_collection_ptr;
              glob_collection_ptr = glob_collection_ptr->next )
            if( (glob_segment_ptr = glob_collection_ptr->segmentidlistptr)
                != NULL )
               break;
         if( glob_segment_ptr == NULL )  {
            (void)sprintf( message,
                        "agm(%s): 'next' segment association does not exist.\n",
                           function_name );
           return( -4 );
         }
      }
   else
      glob_segment_ptr = glob_segment_ptr->next;
   
   *collectionid = globcollectionid = glob_collection_ptr->id;
   *segmentid = globsegmentid = glob_segment_ptr->id;

   return( 0 );
}


static int put_id_collection_segment_link( Id globcollectionid, Id globsegmentid )
{
   Collectionlistptr   cptr;
   Idlistptr           sptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_id_collection_segment_link" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_id_collection_segment_link" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( globcollectionid == cptr->id )  {  /* matching collection */
         glob_collection_ptr = cptr;
         for( sptr = cptr->segmentidlistptr;  sptr;  sptr = sptr->next )  {
            if( globsegmentid == sptr->id )  {
               (void) sprintf( message,
"agm(put_id_collection_segment_link): attempt to put existing segment id (%d) in collection (%d) segment list.",
                               globsegmentid, globcollectionid );
               return( -1 );
            }

            if( sptr->next == NULL )  /* exhausted list */
               break;
         }

         /* get here if no matching segment id found */
         if( sptr == NULL )  /* segment id list is empty */
            sptr = cptr->segmentidlistptr = new_node( Idlist );
         else  {  /* no matching segment id: sptr->next == NULL */
            sptr->next = new_node( Idlist );  /* attach to prev link */
            sptr = sptr->next;
         }

         if( globsegmentid > highest_segment_id )
            highest_segment_id = globsegmentid;

         glob_segment_ptr = sptr;

         sptr->id = globsegmentid;
         sptr->next = NULL;

         return( 0 );
      }

      if( cptr->next == NULL )  /* exhausted list: no matching collection */
         break;
   }

   /* get here if no matching collection found */
   if( cptr == NULL )  /* collection list is empty */
      cptr = versionlistptr->collectionlistptr = new_node( Collectionlist );
   else  {  /* no matching collection: cptr->next == NULL */
      cptr->next = new_node( Collectionlist );  /* attach to prev link */
      cptr = cptr->next;
   }

   if( globcollectionid > highest_collection_id )
      highest_collection_id = globcollectionid;
 
   versionlistptr->end_collectionlistptr = cptr;

   cptr->id = globcollectionid;
   cptr->mdcolmiscptr = NULL;
   cptr->segmentidlistptr = new_node( Idlist );
   cptr->attributeidlistptr = NULL;
   cptr->next = NULL;

   glob_collection_ptr = cptr;

   if( globsegmentid > highest_segment_id )
      highest_segment_id = globsegmentid;

   sptr = cptr->segmentidlistptr;
   sptr->id = globsegmentid;
   sptr->next = NULL;

   glob_segment_ptr = sptr;

   return( 0 );
}


static int put_segment_link( Id globsegmentid )
{
   Idlistptr           mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_segment_link" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_segment_link" );
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
                     "agm(put_segment_link): a collection is not active." );
      return( -1 );
   }

   for( mptr = glob_collection_ptr->segmentidlistptr;  mptr;
        mptr = mptr->next )  {
      if( globsegmentid == mptr->id )  {
         (void) sprintf( message,
"agm(put_segment_link): attempt to put existing segment id (%d) in collection (%d) segment list.",
                         globsegmentid, glob_collection_ptr->id );
         return( -1 );
      }

      if( mptr->next == NULL )  /* exhausted list */
         break;
   }

   /* get here if no matching segment id found */
   if( mptr == NULL )  /* segment id list is empty */
      mptr = glob_collection_ptr->segmentidlistptr = new_node( Idlist );
   else  {  /* no matching segment id: mptr->next == NULL */
      mptr->next = new_node( Idlist );  /* attach to prev link */
      mptr = mptr->next;
   }

   if( globsegmentid > highest_segment_id )
      highest_segment_id = globsegmentid;

   glob_segment_ptr = mptr;

   mptr->id = globsegmentid;
   mptr->next = NULL;

   return( 0 );
}


static int create_attribute( Id attributeid )
{
   Attributelistptr   aptr;
   unsigned       hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "create_attribute" );
      return( 1 );
   }

   if( attributeid != 0 )  {
      hashaddr = atb_hash( globattributeid = attributeid );

      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )  {
         if( attributeid == aptr->id )  {
            (void)sprintf( message,
      "agm(create_attribute): attribute with attribute id (%d) already exists.",
                           attributeid );
            return( -1 );
         }
         if( aptr->next == NULL )  /* exhausted hash table row attribute list */
            break;
      }
   } else {
      hashaddr = atb_hash( new_attribute_id() );

      /* go to end of hash table element linked list */
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         if( aptr->next == NULL )  /* exhausted hash table row attribute list */
            break;
   }
 
   if( aptr == NULL )  /* hash table row is empty */
      aptr = modellistptr->attributepool[hashaddr] = new_node( Attributelist );
   else  {
      aptr->next = new_node( Attributelist );
      aptr = aptr->next;
   }

   aptr->id = globattributeid;
   aptr->abbreviation = NULL;
   aptr->locationlistptr = NULL;
   aptr->componentlistptr = NULL;
   aptr->attributesetptr = NULL;
   aptr->next = NULL;

   return( 0 );
}


static int activate_attribute( Id attributeid )
{
   Attributelistptr	aptr;
   unsigned		hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "activate_attribute" );
      return( 1 );
   }

   hashaddr = atb_hash( globattributeid = attributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( attributeid == aptr->id )  {
/*       globattributeid = attribute_id; */  /* already done */
         return( 0 );
      }
 
   (void)sprintf( message,
    "agm(activate_attribute): attribute with attribute id (%d) does not exist.",
                  attributeid );
   return( -1 );
}


static int activate_collection_indexed_attribute( unsigned index )
{
   Idlistptr		aptr;
   unsigned		count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "activate_collection_indexed_attribute" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "activate_collection_indexed_attribute" );
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
    "agm(activate_collection_indexed_attribute): a collection is not active." );
      return( -1 );
   }

   for( aptr = glob_collection_ptr->attributeidlistptr;  aptr;
        aptr = aptr->next )
      if( ++count == index )  {
         globattributeid = aptr->id;
         return( 0 );
      }

   (void)sprintf( message,
"agm(activate_collection_indexed_attribute): indexed attribute (%d) does not exist.",
                  index );
   return( -2 );
}


static int put_attribute_abbreviation( String abbreviation )
{
   Attributelistptr   aptr;
   unsigned       hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_attribute_abbreviation" );
      return( 1 );
   }

   if( globattributeid == NO_ID )  {
      (void) sprintf( message,
"agm(put_attribute_abbreviation): current attribute id (%d) not defined for the attribute pool.",
                      globattributeid );
      return( -1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr; aptr = aptr->next )
      if( globattributeid == aptr->id )
         if( aptr->abbreviation )  {
            (void) sprintf( message,
          "agm(put_attribute_abbreviation): abbreviation (%s) already defined.",
                            abbreviation );
            return( -2 );
         } else {
            aptr->abbreviation = strdup( abbreviation );
            return( 0 );
         }

   (void) sprintf( message,
"agm(put_attribute_abbreviation): current attribute id (%d) not found in the attribute pool.",
                   globattributeid );
   return( -3 );
}


static int put_attribute_component( double component )
{
   Attributelistptr	aptr;
   Componentlistptr	cptr;
   Id			componentid;
   unsigned		hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_attribute_component" );
      return( 1 );
   }

   if( globattributeid == NO_ID )  {
      (void) sprintf( message,
"agm(put_attribute_component): current attribute id (%d) not defined for the attribute pool.",
                      globattributeid );
      return( -1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( globattributeid == aptr->id )  {
         componentid = new_attribute_component_id( aptr->componentlistptr );

         /* go to end of component list */
         for( cptr = aptr->componentlistptr;  cptr;  cptr = cptr->next )
            if( cptr->next == NULL )
               break;

         if( cptr == NULL )
            cptr = aptr->componentlistptr = new_node( Componentlist );
         else {
            cptr->next = new_node( Componentlist );
            cptr = cptr->next;
         }

         cptr->id = componentid;
         cptr->component = component;
         cptr->next = NULL;

         return( 0 );
      }

   (void) sprintf( message,
"agm(put_attribute_component): current attribute id (%d) not found in the attribute pool.",
                   globattributeid );
   return( -2 );
}


static int put_attribute_components( unsigned ncomponents, float *components )
{
   Attributelistptr	aptr;
   Componentlistptr	cptr;
   Id			componentid;
   unsigned		hashaddr, i;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_attribute_components" );
      return( 1 );
   }

   if( globattributeid == NO_ID )  {
      (void) sprintf( message,
"agm(put_attribute_components): current attribute id (%d) not defined for the attribute pool.",
                      globattributeid );
      return( -1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( globattributeid == aptr->id )  {
         /* go to end of component list */
         for( cptr = aptr->componentlistptr;  cptr;  cptr = cptr->next )
            if( cptr->next == NULL )
               break;

         for( i = 0;  i < ncomponents;  i++ )  {
            componentid = new_attribute_component_id( aptr->componentlistptr );

            if( cptr == NULL )
               cptr = aptr->componentlistptr = new_node( Componentlist );
            else {
               cptr->next = new_node( Componentlist );
               cptr = cptr->next;
            }

            cptr->id = componentid;
            cptr->component = components[i];
            cptr->next = NULL;
         }

         return( 0 );
      }

   (void) sprintf( message,
"agm(put_attribute_components): current attribute id (%d) not found in the attribute pool.",
                   globattributeid );
   return( -2 );
}


static int put_attribute_location( Location *location )
{
   Attributelistptr	aptr;
   Locationlistptr	lptr;
   Id			locationid;
   unsigned		hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_attribute_location" );
      return( 1 );
   }

   if( globattributeid == NO_ID )  {
      (void) sprintf( message,
"agm(put_attribute_location): current attribute id (%d) not defined for the attribute pool.",
                      globattributeid );
      return( -1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( globattributeid == aptr->id )  {
         locationid = new_attribute_location_id( aptr->locationlistptr );

         /* go to end of location list */
         for( lptr = aptr->locationlistptr;  lptr;  lptr = lptr->next )
            if( lptr->next == NULL )
               break;

         if( lptr == NULL )
            lptr = aptr->locationlistptr = new_node( Locationlist );
         else {
            lptr->next = new_node( Locationlist );
            lptr = lptr->next;
         }

         lptr->id = locationid;
         lptr->location.x = location->x;
         lptr->location.y = location->y;
         lptr->location.z = location->z;
         lptr->next = NULL;

         return( 0 );
      }

   (void) sprintf( message,
"agm(put_attribute_location): current attribute id (%d) not found in the attribute pool.",
                   globattributeid );
   return( -2 );
}


static int put_attribute_locations( unsigned nlocations, Location *locations )
{
   Attributelistptr	aptr;
   Locationlistptr	lptr;
   Id			locationid;
   unsigned		hashaddr, i;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_attribute_locations" );
      return( 1 );
   }

   if( globattributeid == NO_ID )  {
      (void) sprintf( message,
"agm(put_attribute_locations): current attribute id (%d) not defined for the attribute pool.",
                      globattributeid );
      return( -1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( globattributeid == aptr->id )  {
         /* go to end of location list */
         for( lptr = aptr->locationlistptr;  lptr;  lptr = lptr->next )
            if( lptr->next == NULL )
               break;

         for( i = 0;  i < nlocations;  i++ )  {
            locationid = new_attribute_location_id( aptr->locationlistptr );

            if( lptr == NULL )
               lptr = aptr->locationlistptr = new_node( Locationlist );
            else {
               lptr->next = new_node( Locationlist );
               lptr = lptr->next;
            }

            lptr->id = locationid;
            lptr->location.x = locations[i].x;
            lptr->location.y = locations[i].y;
            lptr->location.z = locations[i].z;
            lptr->next = NULL;
         }

         return( 0 );
      }

   (void) sprintf( message,
"agm(put_attribute_locations): current attribute id (%d) not found in the attribute pool.",
                   globattributeid );
   return( -2 );
}


static int put_attribute_set( String filename, unsigned nelements, float *attribute_set )
{
   extern String	agm_io_generate_dsn( void );

   Attributelistptr	aptr;
   unsigned		hashaddr, rc;
   Id			collection_parentid;
   String		dsn;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_attribute_set" );
      return( 1 );
   }

   if( globattributeid == NO_ID )  {
      (void) sprintf( message,
"agm(put_attribute_set): current attribute id (%d) not defined for the attribute pool.",
                      globattributeid );
      return( -1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( globattributeid == aptr->id )  {
         if( aptr->attributesetptr == NULL )
            aptr->attributesetptr = new_node( Attributeset );
         aptr->attributesetptr->nelements = nelements;
         aptr->attributesetptr->elements = attribute_set;

         collection_parentid = globcollectionid;
         if( (rc = create_collection( 0 )) != 0 )
            return( rc );
         if( (rc = put_collection_type( DATA_SET )) != 0 )
            return( rc );
         if( (rc = put_collection_parent( collection_parentid )) != 0 )
            return( rc );
         if( filename == NULL )
            dsn = agm_io_generate_dsn();
         else
            dsn = filename;
         if( (rc = put_collection_description( dsn )) != 0 )
            return( rc );
         if( (rc = activate_collection( collection_parentid )) != 0 )
            return( rc );

         return( 0 );
      }

   (void) sprintf( message,
"agm(put_attribute_set): current attribute id (%d) not found in the attribute pool.",
                   globattributeid );
   return( -2 );
}


static int get_attribute_set( unsigned *nelements, float **attribute_set )
{
   Attributelistptr	aptr;
   unsigned		hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_attribute_set" );
      return( 1 );
   }

   if( globattributeid == NO_ID )  {
      (void) sprintf( message,
"agm(get_attribute_set): current attribute id (%d) not defined for the attribute pool.",
                      globattributeid );
      return( -1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( globattributeid == aptr->id )  {
         if( aptr->attributesetptr == NULL )  {
            (void)sprintf( message,
"agm(get_attribute_set): an attribute set is not defined for this attribute." );
            return( -2 );
         }

         *nelements = aptr->attributesetptr->nelements;
         *attribute_set = aptr->attributesetptr->elements;

         return( 0 );
      }

   (void) sprintf( message,
"agm(get_attribute_set): current attribute id (%d) not found in the attribute pool.",
                   globattributeid );
   return( -3 );
}


static int get_number_collection_attribute_links( unsigned *nlinks )
{
   Collectionlistptr   cptr;
   Idlistptr           aptr;


   *nlinks = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_collection_attribute_links" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_number_collection_attribute_links" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
      for( aptr = cptr->attributeidlistptr;  aptr;  aptr = aptr->next )
         (*nlinks)++;

   return( 0 );
}


static int get_nth_collection_attribute_link( unsigned nthlink, Id *collectionid, Id *attributeid )
{
   Collectionlistptr   cptr;
   Idlistptr           aptr;
   unsigned        count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_collection_attribute_link" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_nth_collection_attribute_link" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
      for( aptr = cptr->attributeidlistptr;  aptr;  aptr = aptr->next )
         if( ++count == nthlink )  {
            glob_collection_ptr = cptr;
            *collectionid = globcollectionid = cptr->id;
            *attributeid = globattributeid = aptr->id;
            return( 0 );
         }

   (void) sprintf( message,
        "agm(get_nth_collection_attribute_link): '%dth' link does not exist.\n",
                   nthlink );
   return( -1 );
}


static int get_id_collection_attribute_ids( Id collectionid, Id **attributeids, unsigned *nattributeids )
{
   Collectionlistptr   cptr;
   Idlistptr           aptr;
   unsigned        i;


   *nattributeids = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_id_collection_attribute_ids" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_id_collection_attribute_ids" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
      if( collectionid == cptr->id )  {
         glob_collection_ptr = cptr;
         for( aptr = cptr->attributeidlistptr;  aptr;  aptr = aptr->next )
            ++*nattributeids;
         if( *nattributeids > 0 )  {
            *attributeids = (Id *)malloc( *nattributeids * sizeof( Id ) );
            for( i = 0, aptr = cptr->attributeidlistptr;  aptr;
                 i++, aptr = aptr->next )
               (*attributeids)[i] = aptr->id;
         }
         break;
      }

   return( 0 );
}

    
static int put_id_collection_attribute_link( Id globcollectionid, Id attributeid )
{
   Collectionlistptr   cptr;
   Idlistptr           mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_id_collection_attribute_link" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_id_collection_attribute_link" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( globcollectionid == cptr->id )  {  /* matching collection */
         glob_collection_ptr = cptr;

         for( mptr = cptr->attributeidlistptr;  mptr;  mptr = mptr->next )  {
            if( attributeid == mptr->id )  {
               (void) sprintf( message,
"agm(put_id_collection_attribute_link): attempt to put existing attribute id (%d) in collection (%d) attribute list.",
                               attributeid, globcollectionid );
               return( -1 );
            }

            if( mptr->next == NULL )  /* exhausted list */
               break;
         }

         /* get here if no matching attributeid found */
         if( mptr == NULL )  /* attribute id list is empty */
            mptr = cptr->attributeidlistptr = new_node( Idlist );
         else  {  /* no matching attributeid: mptr->next == NULL */
            mptr->next = new_node( Idlist );  /* attach to prev link */
            mptr = mptr->next;
         }

         mptr->id = attributeid;
         mptr->next = NULL;

         return( 0 );
      }

      if( cptr->next == NULL )  /* exhausted list: no matching collection */
         break;
   }

   /* get here if no matching collection found */
   if( cptr == NULL )  /* collection list is empty */
      cptr = versionlistptr->collectionlistptr = new_node( Collectionlist );
   else  {  /* no matching collection: cptr->next == NULL */
      cptr->next = new_node( Collectionlist );  /* attach to prev link */
      cptr = cptr->next;
   }
 
   if( globcollectionid > highest_collection_id )
      highest_collection_id = globcollectionid;

   versionlistptr->end_collectionlistptr = cptr;

   cptr->id = globcollectionid;
   cptr->mdcolmiscptr = NULL;
   cptr->segmentidlistptr = glob_segment_ptr = NULL;
   cptr->attributeidlistptr = new_node( Idlist );
   cptr->next = NULL;

   glob_collection_ptr = cptr;

   mptr = cptr->attributeidlistptr;
   mptr->id = attributeid;
   mptr->next = NULL;

   return( 0 );
}


static int get_type_nth_collection_attribute_ids( Type collectiontype, unsigned nthcollection, Id **attributeids, unsigned *nattributeids )
{
   Collectionlistptr   cptr;
   Idlistptr           aptr;
   unsigned        i, count = 0;


   *nattributeids = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_type_nth_collection_attribute_ids" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_type_nth_collection_attribute_ids" );
      return( 2 );
   }

   for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )  {
      if( cptr->mdcolmiscptr == NULL )
         continue;
      if( cptr->mdcolmiscptr->type == collectiontype )
         if( ++count == nthcollection )  {
            globcollectionid = cptr->id;
            glob_collection_ptr = cptr;

            for( aptr = cptr->attributeidlistptr;  aptr;  aptr = aptr->next )
               ++*nattributeids;

            if( *nattributeids > 0 )  {
               *attributeids = (Id *)malloc( *nattributeids * sizeof( Id ) );
               for( i = 0, aptr = cptr->attributeidlistptr;  aptr;
                    i++, aptr = aptr->next )
                  (*attributeids)[i] = aptr->id;
            }

            return( 0 );
         }
   }

   (void) sprintf( message,
       "agm(get_type_nth_collection_attribute_ids): %dth collection does not exist (%d exist(s)).",
                   nthcollection, count );
   return( -1 );
}


static int get_number_attribute_misc( unsigned *nmisc )
{
   Attributemiscptr   mptr;


   *nmisc = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_attribute_misc" );
      return( 1 );
   }

   for( mptr = modellistptr->attributemiscptr;  mptr;  mptr = mptr->next )
      ++(*nmisc);

   return( 0 );
}


static int get_nth_attribute_misc( unsigned nthmisc, String *abbrev, Unit *unit, Factor *factor, String *description )
{
   Attributemiscptr   mptr;
   unsigned       count = 0;


   *abbrev = *unit = *description = NULL;
   *factor = 0.0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_attribute_misc" );
      return( 1 );
   }

   for( mptr = modellistptr->attributemiscptr;  mptr;  mptr = mptr->next )
      if( ++count == nthmisc )  {
         *abbrev = mptr->abbreviation;
         *unit = mptr->unit;
         *factor = mptr->factor;
         *description = mptr->description;
         return( 0 );
      }

   (void) sprintf( message,
       "agm(get_nth_attribute_misc): %dth attribute misc does not exist (%d exist(s)).",
                   nthmisc, count );
   return( -1 );
}


static int put_attribute_misc( String abbreviation, Unit unit, Factor factor, String description )
{
   Attributemiscptr   mptr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_attribute_misc" );
      return( 1 );
   }

   for( mptr = modellistptr->attributemiscptr;  mptr;  mptr = mptr->next )  {
      if( strcmp( abbreviation, mptr->abbreviation ) == MATCH )  { /* replace */
         free( mptr->abbreviation );
         mptr->abbreviation = strdup( abbreviation );
         if( mptr->unit )
            free( mptr->unit );
         mptr->unit = strdup( unit );
         mptr->factor = factor;
         if( mptr->description )
            free( mptr->description );
         mptr->description = strdup( description );

         return( 0 );
      }

      if( mptr->next == NULL )  /* exhausted abbreviation table */
         break;
   }

   /* get here if no matching attribute abbreviation found */
   if( mptr == NULL )  /* attribute abbreviation table is empty */
      mptr = modellistptr->attributemiscptr = new_node( Attributemisc );
   else  {  /* no matching attribute abbreviation: mptr->next == NULL */
      mptr->next = new_node( Attributemisc );
      mptr = mptr->next;
   }

   mptr->abbreviation = strdup( abbreviation );
   mptr->unit = strdup( unit );
   mptr->factor = factor;
   mptr->description = strdup( description );
   mptr->next = NULL;

   return( 0 );
}


static int get_number_attribute_abbreviations( unsigned *nabbreviations )
{
   Attributelistptr   aptr;
   unsigned       hashaddr;
   int                rc = 0;


   *nabbreviations = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_attribute_abbreviations" );
      return( 1 );
   }

   for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         if( aptr->abbreviation == NULL )  {
            (void) sprintf( message, "agm(get_number_attribute_abbreviations): found attribute(s) without abbreviation(s).  Last attribute id was %d.",
                            aptr->id );
            rc = -1;
         } else
            ++(*nabbreviations);

   return( rc );
}


static int get_nth_attribute_abbreviation( unsigned nthabbreviation, Id *attributeid, String *abbreviation )
{
   Attributelistptr   aptr;
   unsigned       hashaddr, count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_attribute_abbreviation" );
      return( 1 );
   }

   for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         if( ++count == nthabbreviation )  {
            *attributeid = aptr->id;
            *abbreviation = aptr->abbreviation;

            return( 0 );
         }

   (void) sprintf( message,
"agm(get_nth_attribute_abbreviation): %dth attribute abbreviation does not exist.  (%d exist(s).)",
                   nthabbreviation, count );
   return( -1 );
}


static int put_id_attribute_abbreviation( Id attributeid, String abbreviation )
{
   Attributelistptr   aptr;
   unsigned       hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_id_attribute_abbreviation" );
      return( 1 );
   }

   hashaddr = atb_hash( attributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )  {
      if( attributeid == aptr->id )  {
         (void) sprintf( message,
"agm(put_id_attribute_abbreviation): attribute id (%d) already exists in attribute pool.",
                         attributeid );
         return( -1 );
      }

      if( aptr->next == NULL )  /* exhausted hash table row attribute list */
         break;
   }

   /* get here if no duplicate attribute id found */
   if( aptr == NULL )  /* hash table row is empty */
      aptr = modellistptr->attributepool[hashaddr] = new_node( Attributelist );
   else  {  /* no duplicate attribute id: aptr->next == NULL */
      aptr->next = new_node( Attributelist );
      aptr = aptr->next;
   }

   aptr->id = attributeid;
   aptr->abbreviation = strdup( abbreviation );
   aptr->locationlistptr = NULL;
   aptr->componentlistptr = NULL;
   aptr->attributesetptr = NULL;
   aptr->next = NULL;

   return( 0 );
}


static int get_id_attribute_abbreviation( Id attributeid, String *abbreviation )
{
   Attributelistptr   aptr;
   unsigned       hashaddr;


   *abbreviation = NULL;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_id_attribute_abbreviation" );
      return( 1 );
   }

   hashaddr = atb_hash( attributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )  {
      if( attributeid == aptr->id )  {
         *abbreviation = strdup( aptr->abbreviation );  /* hide data */
         return( 0 );
      }

      if( aptr->next == NULL )  /* exhausted hash table row attribute list */
         break;
   }

   (void) sprintf( message,
        "agm(get_id_attribute_abbreviation): attribute id (%d) does not exist.",
                   attributeid );
   return( -1 );
}


static int get_collection_attribute_abbreviations( unsigned *nabbrevs, String **abbreviations )
{
   Idlistptr		aptr;
   Attributelistptr	haptr;
   unsigned		i, hashaddr;


   *nabbrevs = 0;
   *abbreviations = NULL;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_attribute_abbreviations" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_attribute_abbreviations" );
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
   "agm(get_collection_attribute_abbreviations): a collection is not active." );
      return( -1 );
   }

   for( aptr = glob_collection_ptr->attributeidlistptr;  aptr;
        aptr = aptr->next )
      ++*nabbrevs;

   if( *nabbrevs > 0 )  {
      *abbreviations = (String *)malloc( *nabbrevs * sizeof( String ) );

      for( i = 0, aptr = glob_collection_ptr->attributeidlistptr;  aptr;
           i++, aptr = aptr->next )  {
         (*abbreviations)[i] = NULL;
         hashaddr = atb_hash( aptr->id );

         for( haptr = modellistptr->attributepool[hashaddr];  haptr;
              haptr = haptr->next )
            if( aptr->id == haptr->id )  {
               (*abbreviations)[i] = haptr->abbreviation;
               break;
            }
      }
   }

   return( 0 );
}


static int loccompare( Location *i, Location *j )
{
   if( i->x < j->x )
      return( -1 );
   else if( i->x > j->x )
      return( 1 );
   else if( i->y < j->y )
      return( -1 );
   else if( i->y > j->y )
      return( 1 );
   else if( i->z < j->z )
      return( -1 );
   else if( i->z > j->z )
      return( 1 );
   else
      return( 0 );
}



static int get_collection_number_locations( unsigned *nuniquelocations )
{
   Idlistptr		aptr;
   Attributelistptr	haptr;
   Locationlistptr	lptr, locationlist = NULL, listptr, nextlistptr;
   Location		*locations;
   unsigned		i, nabbrevs = 0, nlocations = 0, hashaddr;


   *nuniquelocations = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_collection_number_locations" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "get_collection_number_locations" );
      return( 2 );
   }

   if( glob_collection_ptr == NULL )  {
      (void)sprintf( message,
          "agm(get_collection_number_locations): a collection is not active." );
      return( -1 );
   }

   for( aptr = glob_collection_ptr->attributeidlistptr;  aptr;
        aptr = aptr->next )
      ++nabbrevs;

   if( nabbrevs > 0 )  {
      for( aptr = glob_collection_ptr->attributeidlistptr;  aptr;
           aptr = aptr->next )  {
         hashaddr = atb_hash( aptr->id );

         for( haptr = modellistptr->attributepool[hashaddr];  haptr;
              haptr = haptr->next )
            if( aptr->id == haptr->id )  {
               for( lptr = haptr->locationlistptr;  lptr;  lptr = lptr->next ) {
                  ++nlocations;
                  if( locationlist == NULL )
                      listptr = locationlist = new_node( Locationlist );
                  else  {
                      listptr->next = new_node( Locationlist );
                      listptr = listptr->next;
                  }
                  listptr->location.x = lptr->location.x;
                  listptr->location.y = lptr->location.y;
                  listptr->location.z = lptr->location.z;
                  listptr->next = NULL;
               }
               break;
            }
      }

      if( nlocations > 0 )  {
         *nuniquelocations = 1;
         locations = (Location *)malloc( nlocations * sizeof( Location ) );

         for( i = 0, listptr = locationlist;  listptr;
              i++, listptr = nextlistptr )  {
            nextlistptr = listptr->next;
            locations[i].x = listptr->location.x;
            locations[i].y = listptr->location.y;
            locations[i].z = listptr->location.z;
            free( (char *)listptr );
         }

         qsort( (char *)locations, nlocations, sizeof( Location ), loccompare );

         for( i = 1;  i < nlocations;  i++ )
            if( locations[i].x != locations[i-1].x  ||
                locations[i].y != locations[i-1].y  ||
                locations[i].z != locations[i-1].z )
               ++*nuniquelocations;

         free( (char *)locations );
      }
   }

   return( 0 );
}


static int get_number_attribute_components( unsigned *ncomponents )
{
   Attributelistptr   aptr;
   Componentlistptr   cptr;
   unsigned       hashaddr;


   *ncomponents = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_attribute_components" );
      return( 1 );
   }

   for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         for( cptr = aptr->componentlistptr;  cptr;  cptr = cptr->next )
            ++(*ncomponents);

   return( 0 );
}


static int get_nth_attribute_component( unsigned nthcomponent, Id *attributeid, Id *componentid, float *component )
{
   Attributelistptr   aptr;
   Componentlistptr   cptr;
   unsigned       hashaddr, count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_attribute_component" );
      return( 1 );
   }

   for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         for( cptr = aptr->componentlistptr;  cptr;  cptr = cptr->next )
            if( ++count == nthcomponent )  {
               *attributeid = aptr->id;
               *componentid = cptr->id;
               *component = cptr->component;

               return( 0 );
            }

   (void) sprintf( message,
"agm(get_nth_attribute_component): %dth attribute component does not exist.  (%d exist(s).)",
                   nthcomponent, count );
   return( -1 );
}


static int get_attribute_components( unsigned *ncomponents, float **components )
{
   Attributelistptr   aptr;
   Componentlistptr   cptr;
   unsigned       hashaddr, i;


   *ncomponents = 0;
   *components = NULL;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_attribute_components" );
      return( 1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( globattributeid == aptr->id )  {
         for( cptr = aptr->componentlistptr;  cptr;  cptr = cptr->next )
            ++*ncomponents;

         *components = (float *)malloc( *ncomponents * sizeof( float ) );

         for( i = 0, cptr = aptr->componentlistptr;  cptr;
              i++, cptr = cptr->next )
            (*components)[i] = cptr->component;

         return( 0 );
      }

   (void) sprintf( message,
"agm(get_attribute_components): attribute id (%d) not found in hash table.",
                   globattributeid );
   return( -1 );
}


static int get_id_attribute_nth_component( Id attributeid, unsigned nthcomponent, Id *componentid, float *component )
{
   Attributelistptr   aptr;
   Componentlistptr   cptr;
   unsigned       hashaddr, count = 0;


   *componentid = (Id)NULL;
   *component = 0.0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_id_attribute_nth_component" );
      return( 1 );
   }

   hashaddr = atb_hash( attributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( attributeid == aptr->id )  {
         for( cptr = aptr->componentlistptr;  cptr;  cptr = cptr->next )
            if( ++count == nthcomponent )  {
               *componentid = cptr->id;
               *component = cptr->component;

               return( 0 );
            }

         (void) sprintf( message,
"agm(get_id_attribute_nth_component): %th attribute component does not exist.  (%d exist(s).)",
                         nthcomponent, count );
         return( -1 );
      }

   (void) sprintf( message,
       "agm(get_id_attribute_nth_component): attribute id (%d) does not exist.",
                   attributeid );
   return( -2 );
}


static int put_id_attribute_component( Id attributeid, Id componentid, double component )
{
   Attributelistptr   aptr;
   Componentlistptr   cptr;
   unsigned       hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_id_attribute_component" );
      return( 1 );
   }

   hashaddr = atb_hash( attributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )  {
      if( attributeid == aptr->id )  {
         for( cptr = aptr->componentlistptr;  cptr;  cptr = cptr->next )  {
            if( componentid == cptr->id )  {
               (void) sprintf( message,
"agm(put_id_attribute_component): component id (%d) already exists for attribute id (%d).",
                               componentid, attributeid );
               return( -1 );
            }

            if( cptr->next == NULL )
               break;
         }

         if( cptr == NULL )
            cptr = aptr->componentlistptr = new_node( Componentlist );
         else {
            cptr->next = new_node( Componentlist );
            cptr = cptr->next;
         }

         cptr->id = componentid;
         cptr->component = component;
         cptr->next = NULL;

         return( 0 );
      }

      if( aptr->next == NULL )  /* exhausted hash table row attribute list */
         break;
   }

   /* get here if no duplicate attribute id found */
   if( aptr == NULL )  /* hash table row is empty */
      aptr = modellistptr->attributepool[hashaddr] = new_node( Attributelist );
   else  {  /* no duplicate attribute id: aptr->next == NULL */
      aptr->next = new_node( Attributelist );
      aptr = aptr->next;
   }

   aptr->id = attributeid;
   aptr->abbreviation = NULL;
   aptr->locationlistptr = NULL;
   aptr->componentlistptr = new_node( Componentlist );
   aptr->attributesetptr = NULL;
   aptr->next = NULL;

   cptr = aptr->componentlistptr;
   cptr->id = componentid;
   cptr->component = component;
   cptr->next = NULL;

   return( 0 );
}


static int get_number_attribute_locations( unsigned *nlocations )
{
   Attributelistptr	aptr;
   Locationlistptr	lptr;
   unsigned		hashaddr;


   *nlocations = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_attribute_locations" );
      return( 1 );
   }

   for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         for( lptr = aptr->locationlistptr;  lptr;  lptr = lptr->next )
            ++(*nlocations);

   return( 0 );
}


static int get_nth_attribute_location( unsigned nthlocation, Id *attributeid, Id *locationid, Location *location )
{
   Attributelistptr   aptr;
   Locationlistptr    lptr;
   unsigned       hashaddr, count = 0;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_attribute_location" );
      return( 1 );
   }

   for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         for( lptr = aptr->locationlistptr;  lptr;  lptr = lptr->next )
            if( ++count == nthlocation )  {
               *attributeid = aptr->id;
               *locationid = lptr->id;
               location->x = lptr->location.x;
               location->y = lptr->location.y;
               location->z = lptr->location.z;

               return( 0 );
            }

   (void) sprintf( message, "agm(get_nth_attribute_location): %dth attribute location does not exist.  (%d exist(s).)",
                   nthlocation, count );
   return( -1 );
}


static int get_id_attribute_nth_location( Id attributeid, unsigned nthlocation, Id *locationid, Location *location )
{
   Attributelistptr   aptr;
   Locationlistptr    lptr;
   unsigned       hashaddr, count = 0;


   *locationid = (Id)NULL;
   location->x = location->y = location->z = 0.0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_id_attribute_nth_location" );
      return( 1 );
   }

   hashaddr = atb_hash( attributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( attributeid == aptr->id )  {
         for( lptr = aptr->locationlistptr;  lptr;  lptr = lptr->next )
            if( ++count == nthlocation )  {
               *locationid = lptr->id;
               location->x = lptr->location.x;
               location->y = lptr->location.y;
               location->z = lptr->location.z;

               return( 0 );
            }

         (void) sprintf( message,
"agm(get_id_attribute_nth_location): attribute %dth location does not exist.  (%d exist(s).)",
                         nthlocation, count );
         return( -1 );
      }

   (void) sprintf( message,
        "agm(get_id_attribute_nth_location): attribute id (%d) does not exist.",
                   attributeid );
   return( -2 );
}


static int get_attribute_locations( unsigned *nlocations, Location **locations )
{
   Attributelistptr   aptr;
   Locationlistptr    lptr;
   unsigned       hashaddr, i;


   *nlocations = 0;
   *locations = NULL;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_attribute_locations" );
      return( 1 );
   }

   hashaddr = atb_hash( globattributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )
      if( globattributeid == aptr->id )  {
         for( lptr = aptr->locationlistptr;  lptr;  lptr = lptr->next )
            ++*nlocations;

         *locations = (Location *)malloc( *nlocations * sizeof( Location ) );

         for( i = 0, lptr = aptr->locationlistptr;  lptr;
              i++, lptr = lptr->next )  {
            (*locations)[i].x = lptr->location.x;
            (*locations)[i].y = lptr->location.y;
            (*locations)[i].z = lptr->location.z;
         }

         return( 0 );
      }

   (void) sprintf( message,
"agm(get_attribute_locations): attribute id (%d) not found in hash table.",
                   globattributeid );
   return( -1 );
}


static int put_id_attribute_location( Id attributeid, Id locationid, Location *location )
{
   Attributelistptr   aptr;
   Locationlistptr    lptr;
   unsigned       hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_id_attribute_location" );
      return( 1 );
   }

   hashaddr = atb_hash( attributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )  {
      if( attributeid == aptr->id )  {
         for( lptr = aptr->locationlistptr;  lptr;  lptr = lptr->next )  {
            if( locationid == lptr->id )  {
               (void) sprintf( message,
"agm(put_id_attribute_location): location id (%d) already exists for attribute id (%d).",
                               locationid, attributeid );
               return( -1 );
            }

            if( lptr->next == NULL )
               break;
         }

         if( lptr == NULL )
            lptr = aptr->locationlistptr = new_node( Locationlist );
         else {
            lptr->next = new_node( Locationlist );
            lptr = lptr->next;
         }

         lptr->id = locationid;
         lptr->location.x = location->x;
         lptr->location.y = location->y;
         lptr->location.z = location->z;
         lptr->next = NULL;

         return( 0 );
      }

      if( aptr->next == NULL )  /* exhausted hash table row attribute list */
         break;
   }

   /* get here if no duplicate attribute id found */
   if( aptr == NULL )  /* hash table row is empty */
      aptr = modellistptr->attributepool[hashaddr] = new_node( Attributelist );
   else  {  /* no duplicate attribute id: aptr->next == NULL */
      aptr->next = new_node( Attributelist );
      aptr = aptr->next;
   }

   aptr->id = attributeid;
   aptr->abbreviation = NULL;
   aptr->locationlistptr = new_node( Locationlist );
   aptr->componentlistptr = NULL;
   aptr->attributesetptr = NULL;
   aptr->next = NULL;

   lptr = aptr->locationlistptr;
   lptr->id = locationid;
   lptr->location.x = location->x;
   lptr->location.y = location->y;
   lptr->location.z = location->z;
   lptr->next = NULL;

   return( 0 );
}


static int put_attribute( String abbreviation, unsigned ncomponents, float *components, unsigned nlocations, Location *locations )
{
   Attributelistptr	aptr;
   Componentlistptr	cptr;
   Locationlistptr	lptr;
   unsigned		hashaddr, i;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_attribute" );
      return( 1 );
   }

   if( globattributeid == NO_ID )  {
      (void) sprintf( message,
"agm(put_attribute): current attribute id (%d) not defined for the attribute pool.",
                      globattributeid );
      return( -1 );
   }

   hashaddr = atb_hash( globattributeid );

   /* go to end of attribute list */
   for( aptr = modellistptr->attributepool[hashaddr]; aptr;  aptr = aptr->next )
      if( aptr->next == NULL )
         break;

   if( aptr == NULL )  /* attribute list is empty */
      aptr = modellistptr->attributepool[hashaddr] = new_node( Attributelist );
   else  {
      aptr->next = new_node( Attributelist );  /* attach to prev link */
      aptr = aptr->next;
   }

   aptr->id = globattributeid;
   aptr->abbreviation = strdup( abbreviation );
   aptr->locationlistptr = NULL;
   aptr->componentlistptr = NULL;
   aptr->attributesetptr = NULL;
   aptr->next = NULL;

   for( i = 0;  i < ncomponents;  i++ )  {
      if( aptr->componentlistptr == NULL )
         cptr = aptr->componentlistptr = new_node( Componentlist );
      else  {
         cptr->next = new_node( Componentlist );
         cptr = cptr->next;
      }
      cptr->id = i + 1;
      cptr->component = components[i];
      cptr->next = NULL;
   }
   for( i = 0;  i < nlocations;  i++ )  {
      if( aptr->locationlistptr == NULL )
         lptr = aptr->locationlistptr = new_node( Locationlist );
      else  {
         lptr->next = new_node( Locationlist );
         lptr = lptr->next;
      }
      lptr->id = i + 1;
      lptr->location.x = locations[i].x;
      lptr->location.y = locations[i].y;
      lptr->location.z = locations[i].z;
      lptr->next = NULL;
   }
 
   return( 0 );
}


static int create_segment( Id segmentid )
{
   Segmentlistptr   sptr;
   unsigned     hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "create_segment" );
      return( 1 );
   }

   if( segmentid != (Id)NULL )  {
      hashaddr = seg_hash( globsegmentid = segmentid );

      for( sptr = modellistptr->segmentpool[hashaddr];  sptr;
           sptr = sptr->next )  {
         if( segmentid == sptr->id )  {
            (void)sprintf( message,
            "agm(create_segment): segment with segment id (%d) already exists.",
                           segmentid );
            return( -1 );
         }
         if( sptr->next == NULL )  /* exhausted hash table row segment list */
            break;
      }
   } else {
      hashaddr = seg_hash( new_segment_id() );

      /* go to end of hash table element linked list */
      for( sptr = modellistptr->segmentpool[hashaddr];  sptr;
           sptr = sptr->next )
         if( sptr->next == NULL )  /* exhausted hash table row segment list */
            break;
   }
 
   if( sptr == NULL )  /* hash table row is empty */
      sptr = modellistptr->segmentpool[hashaddr] = new_node( Segmentlist );
   else  {
      sptr->next = new_node( Segmentlist );
      sptr = sptr->next;
   }
 
   if( globsegmentid > highest_segment_id )
      highest_segment_id = globsegmentid;

   sptr->id = globsegmentid;
   sptr->maxpointid = NO_ID;
   sptr->pointlistptr = NULL;
   sptr->next = NULL;
 
   return( 0 );
}


static int activate_segment( Id segmentid )
{
   Segmentlistptr   sptr;
   unsigned     hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "activate_segment" );
      return( 1 );
   }

   hashaddr = seg_hash( globsegmentid = segmentid );

   for( sptr = modellistptr->segmentpool[hashaddr];  sptr;  sptr = sptr->next )
      if( segmentid == sptr->id )  {
/*       globsegmentid = segment_id; */  /* already done */
         return( 0 );
      }
 
   (void)sprintf( message,
          "agm(activate_segment): segment with segment id (%d) does not exist.",
                  segmentid );
   return( -1 );
}


static int get_number_segments( unsigned *nsegments )
{
   Segmentlistptr   sptr;
   unsigned     hashaddr;


   *nsegments = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_number_segments" );
      return( 1 );
   }

   for( hashaddr = 0;  hashaddr < SEGMENT_HASH_TABLE_SIZE;  hashaddr++ )
      for( sptr = modellistptr->segmentpool[hashaddr];  sptr;
           sptr = sptr->next )
         ++(*nsegments);

   return( 0 );
}


static int get_nth_segment( unsigned nthsegment, Id *segmentid, Tupleptr *segment, unsigned *npts )
{
   Segmentlistptr   sptr;
   unsigned     hashaddr, count = 0;


   *segmentid = globsegmentid = 0;
   *segment = NULL;
   *npts = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( "get_nth_segment" );
      return( 1 );
   }

   for( hashaddr = 0;  hashaddr < SEGMENT_HASH_TABLE_SIZE;  hashaddr++ )
      for( sptr = modellistptr->segmentpool[hashaddr];  sptr;
           sptr = sptr->next )
         if( ++count == nthsegment )  {
            glob_seg_hash_addr = hashaddr;
            glob_segment_list_ptr = sptr;
            *segmentid = globsegmentid = sptr->id;
            *npts = sptr->maxpointid;
            *segment = (Tupleptr) malloc( *npts * sizeof( Tuple ) );
            if( sptr->pointlistptr )
               (void)memcpy( (char *)*segment, (char *)sptr->pointlistptr,
                              sptr->maxpointid * sizeof( Tuple ) );
            else
               (void)fprintf( stderr,
            "agm(get_nth_segment): attempted to copy from NULL point list.\n" );

            return( 0 );
         }

   (void) sprintf( message,
                   "agm(get_nth_segment): '%dth' segment does not exist.\n",
                   nthsegment );
   return( -1 );
}


static int get_next_segment( Id *segmentid, Tupleptr *segment, unsigned *npts )
{
   static String	function_name = "get_next_segment";


   *segmentid = globsegmentid = 0;
   *segment = NULL;
   *npts = 0;

   if( modellistptr == NULL )  {
      handle_empty_model_list( function_name );
      return( 1 );
   }

   if( glob_seg_hash_addr < 0 )  {
      (void)sprintf( message,
                     "agm(%s): a reference segment is not defined.\n",
                     function_name );
      return( -1 );
   }

   if( glob_segment_list_ptr == NULL )  {
      (void)sprintf( message,
                     "agm(%s): a reference segment is not defined.\n",
                     function_name );
      return( -2 );
   }

   if( (glob_segment_list_ptr = glob_segment_list_ptr->next) == NULL )  {
      for( ++glob_seg_hash_addr;
           glob_seg_hash_addr < SEGMENT_HASH_TABLE_SIZE;
           ++glob_seg_hash_addr )
         if( (glob_segment_list_ptr =
                 modellistptr->segmentpool[glob_seg_hash_addr]) != NULL )  {
            *segmentid = globsegmentid = glob_segment_list_ptr->id;
            *npts = glob_segment_list_ptr->maxpointid;
            *segment = (Tupleptr)malloc( *npts * sizeof( Tuple ) );
            if( glob_segment_list_ptr->pointlistptr )
               (void)memcpy( (char *)*segment,
                           (char *)glob_segment_list_ptr->pointlistptr,
                           *npts * sizeof( Tuple ));
            else
               (void)fprintf( stderr,
           "agm(get_next_segment): attempted to copy from NULL point list.\n" );

            return( 0 );
         }

      (void)sprintf( message, "agm(%s): a 'next' segment does not exist.\n",
                     function_name );
      return( -3 );
   }

   *segmentid = globsegmentid = glob_segment_list_ptr->id;
   *npts = glob_segment_list_ptr->maxpointid;
   *segment = (Tupleptr)malloc( *npts * sizeof( Tuple ) );
   if( glob_segment_list_ptr->pointlistptr )
      (void)memcpy( (char *)*segment,
                  (char *)glob_segment_list_ptr->pointlistptr,
                  *npts * sizeof( Tuple ));
   else
      (void)fprintf( stderr,
           "agm(get_next_segment): attempted to copy from NULL point list.\n" );

   return( 0 );
}


static int put_segment_point( Id globsegmentid, Id pointid, Location *location )
{
   Segmentlistptr   sptr;
   unsigned     hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_segment_point" );
      return( 1 );
   }

   if( globsegmentid <= 0 )  {
      (void) sprintf( message,
                      "agm(put_segment_point): segment id (%d) must be >0.",
                      globsegmentid );
      return( -1 );
   }

   if( pointid <= 0 )  {
      (void) sprintf( message,
                      "agm(put_segment_point): point id (%d) must be >0.",
                      pointid );
      return( -2 );
   }

   hashaddr = seg_hash( globsegmentid );

   for( sptr = modellistptr->segmentpool[hashaddr];  sptr;
        sptr = sptr->next )  {
      if( globsegmentid == sptr->id )  {
         if( pointid > sptr->maxpointid )  {  /* get extra memory */
            sptr->maxpointid = pointid;
#ifdef PURIFY_DEBUG
printf( "reallocating pointlist to %d pts\n", sptr->maxpointid );
#endif
            sptr->pointlistptr = (Tupleptr) realloc( sptr->pointlistptr,
                                           sptr->maxpointid * sizeof( Tuple ) );
         }

         /* note: don't bitch if same point id, just overwrite */
         (sptr->pointlistptr+pointid-1)->x = location->x;
         (sptr->pointlistptr+pointid-1)->y = location->y;
         (sptr->pointlistptr+pointid-1)->z = location->z;

         return( 0 );
      }

      if( sptr->next == NULL )  /* exhausted hash table row segment list */
         break;
   }

   /* get here if no duplicate segment id found */
   if( sptr == NULL )  /* hash table row is empty */
      sptr = modellistptr->segmentpool[hashaddr] = new_node( Segmentlist );
   else  {  /* no duplicate segment id: sptr->next == NULL */
      sptr->next = new_node( Segmentlist );
      sptr = sptr->next;
   }

   if( globsegmentid > highest_segment_id )
      highest_segment_id = globsegmentid;

   sptr->id = globsegmentid;
   sptr->maxpointid = pointid;
#ifdef PURIFY_DEBUG
printf( "allocating pointlist to %d pts\n", pointid );
#endif
   sptr->pointlistptr = (Tupleptr) malloc( pointid * sizeof( Tuple ) );
   sptr->next = NULL;

   (sptr->pointlistptr+pointid-1)->x = location->x;
   (sptr->pointlistptr+pointid-1)->y = location->y;
   (sptr->pointlistptr+pointid-1)->z = location->z;

   return( 0 );
}


static int put_2d_segment( Tuple2Dptr pointlistptr, unsigned npoints )
{
   Segmentlistptr   mptr;
   unsigned     hashaddr, i;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_2d_segment" );
      return( 1 );
   }

   if( globsegmentid == NO_ID )  {
      (void) sprintf( message,
"agm(put_2d_segment): current segment id (%d) not defined for the segment pool.",
                      globsegmentid );
      return( -1 );
   }

   hashaddr = seg_hash( globsegmentid );

   for( mptr = modellistptr->segmentpool[hashaddr];  mptr;  mptr = mptr->next )
      if( mptr->id == globsegmentid )  {
         if( mptr->maxpointid != 0 )  {
            (void)sprintf( message, "agm(put_2d_segment): segment data already exists; specify 'Replace' instead." );
            return( -2 );
         }

         mptr->maxpointid = npoints;
         mptr->pointlistptr = (Tupleptr) malloc( npoints * sizeof( Tuple ) );
         mptr->next = NULL;
         for( i = 0;  i < npoints;  i++ )  {
            (mptr->pointlistptr+i)->x = (pointlistptr+i)->x;
            (mptr->pointlistptr+i)->y = 0.0;
            (mptr->pointlistptr+i)->z = (pointlistptr+i)->y;
         }
         return( 0 );
      }
 
   (void) sprintf( message,
"agm(put_2d_segment): current segment id (%d) not found in the segment pool.",
                   globsegmentid );
   return( -3 );
}


static int put_segment( Tupleptr pointlistptr, unsigned npoints )
{
   Segmentlistptr   mptr;
   unsigned     hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_segment" );
      return( 1 );
   }

   if( globsegmentid == NO_ID )  {
      (void) sprintf( message,
  "agm(put_segment): current segment id (%d) not defined for the segment pool.",
                      globsegmentid );
      return( -1 );
   }

   hashaddr = seg_hash( globsegmentid );

   for( mptr = modellistptr->segmentpool[hashaddr];  mptr;  mptr = mptr->next )
      if( mptr->id == globsegmentid )  {
         if( mptr->maxpointid != 0 )  {
            (void)sprintf( message, "agm(put_segment): segment data already exists; specify 'Replace' instead." );
            return( -2 );
         }

         mptr->maxpointid = npoints;
         mptr->pointlistptr = (Tupleptr) malloc( npoints * sizeof( Tuple ) );
         mptr->next = NULL;
         (void)memcpy( (char *)mptr->pointlistptr, (char *)pointlistptr,
                       npoints * sizeof( Tuple ) );
         return( 0 );
      }
 
   (void) sprintf( message,
"agm(put_segment): current segment id (%d) not found in the segment pool.",
                   globsegmentid );
   return( -3 );
}


static int replace_segment( Tupleptr pointlistptr, unsigned npoints )
{
   Segmentlistptr   mptr;
   unsigned     hashaddr;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "replace_segment" );
      return( 1 );
   }

   if( globsegmentid == NO_ID )  {
      (void) sprintf( message,
"agm(replace_segment): current segment id (%d) not defined in the segment pool.",
                      globsegmentid );
      return( -1 );
   }

   hashaddr = seg_hash( globsegmentid );

   for( mptr = modellistptr->segmentpool[hashaddr];  mptr;  mptr = mptr->next )
      if( mptr->id == globsegmentid )  {
         if( mptr->maxpointid == 0 )  {
            (void)sprintf( message, "agm(replace_segment): segment data does not exist; specify 'Put' instead." );
            return( -2 );
         }

         mptr->maxpointid = npoints;
         if( mptr->pointlistptr )
            mptr->pointlistptr = (Tupleptr)realloc( (char *)mptr->pointlistptr,
                                                    npoints * sizeof( Tuple ) );
         else
            mptr->pointlistptr = (Tupleptr)malloc( npoints * sizeof( Tuple ) );
         mptr->next = NULL;
         (void)memcpy( (char *)mptr->pointlistptr, (char *)pointlistptr,
                       npoints * sizeof( Tuple ) );
         return( 0 );
      }
 
   (void) sprintf( message,
"agm(replace_segment): current segment id (%d) not found in the segment pool.",
                   globsegmentid );
   return( -3 );
}


static int get_collection_num_segs_pts( Idlistptr segmentidlistptr, unsigned *nsegments, unsigned *totalpts )
{
   Idlistptr        sptr;
   Segmentlistptr   hptr;
   unsigned     hashaddr;


   *nsegments = *totalpts = 0;

   /* cycle through segments belonging to collection */
   for( sptr = segmentidlistptr;  sptr;  sptr = sptr->next )  {
      /* find segment in segment pool hash table */
      hashaddr = seg_hash( sptr->id );

      /* scan along hash table's linked segment list until find segment match */      for( hptr = modellistptr->segmentpool[hashaddr];  hptr;
           hptr = hptr->next )
         if( sptr->id == hptr->id )  {
            ++(*nsegments);
            *totalpts += hptr->maxpointid;
            break;
         }
   }

   return( 0 );
}


static int get_collection_num_segs( Idlistptr segmentidlistptr, unsigned *nsegments )
{
   Idlistptr        sptr;
   Segmentlistptr   hptr;
   unsigned     hashaddr;


   *nsegments = 0;

   /* cycle through segments belonging to collection */
   for( sptr = segmentidlistptr;  sptr;  sptr = sptr->next )  {
      /* find segment in segment pool hash table */
      hashaddr = seg_hash( sptr->id );

      /* scan along hash table's linked segment list until find segment match */      for( hptr = modellistptr->segmentpool[hashaddr];  hptr;
           hptr = hptr->next )
         if( sptr->id == hptr->id )  {
            ++(*nsegments);
            break;
         }
   }
 
   return( 0 );
}


static int get_collection_num_seg_pts( Idlistptr segmentidlistptr, unsigned *nsegpoints )
{
   Idlistptr        sptr;
   Segmentlistptr   hptr;
   unsigned     hashaddr, segment;


   segment = 0;

   /* cycle through segments belonging to collection */
   for( sptr = segmentidlistptr;  sptr;  sptr = sptr->next )  {
      /* find segment in hash table (segment pool) */
      hashaddr = seg_hash( sptr->id );

      /* scan along hash table's linked segment list until find segment match */      for( hptr = modellistptr->segmentpool[hashaddr];  hptr;
           hptr = hptr->next )
         if( sptr->id == hptr->id )  {
            nsegpoints[segment++] = hptr->maxpointid;
            break;
         }
   }

   return( 0 );
}


static int copy_segments( Idlistptr segmentidlistptr, Tupleptr *segments )
{
   Idlistptr        sptr;
   Segmentlistptr   hptr;
   Tupleptr         farendpt, tptr, tsptr;
   Boolean          connected = TRUE, firstsegment = TRUE;
   int              frontsegid = NO_SEGMENT, backsegid = NO_SEGMENT;
   unsigned     hashaddr, pt, pttally = 0, segment = 0;


   if( connect_segments )
      /* cycle until connect every intersecting segment */
      while( connected )
         /* cycle through segments belonging to collection */
         for( connected = FALSE, sptr = segmentidlistptr;  sptr;
              sptr = sptr->next )  {
            if( sptr->id == frontsegid  ||  sptr->id == backsegid )
               continue;  /* already have this segment */

            /* find segment in hash table (segment pool) */
            hashaddr = seg_hash( sptr->id );

            /* scan hash table linked segment list until find endpoint match */
            for( hptr = modellistptr->segmentpool[hashaddr];  hptr;
                 hptr = hptr->next )
               if( sptr->id == hptr->id )  {  /* found matching seg */
                  if( !hptr->pointlistptr ) {
                     (void)fprintf( stderr,
              "agm(copy_segments): attempted to copy from NULL point list.\n" );
                     return( -1 );
                  }

                  if( firstsegment )  {  /* order of copy doesn't matter */
                     firstsegment = FALSE;
                     (void)memcpy( (char *)*segments,
                                   (char *)hptr->pointlistptr,
                                   hptr->maxpointid * sizeof( Tuple ) );

                     frontsegid = sptr->id;  /* don't use this segment again */
                     pttally += hptr->maxpointid;  /* copied all segment pts */
                     connected = TRUE;   backsegid = sptr->id;
                  } else if(
                        hptr->pointlistptr->x == (*segments)->x  &&
                        hptr->pointlistptr->y == (*segments)->y  &&
                        hptr->pointlistptr->z == (*segments)->z ) {

                     /* shift tallying segment */
                     for( tptr = *segments+pttally+hptr->maxpointid-2,
                          tsptr = *segments+pttally-1;
                          tptr >= *segments+hptr->maxpointid-1;
                          tptr--, tsptr-- )
                        (void) memcpy( (char *)tptr, (char *)tsptr,
                                       sizeof( Tuple ) );
                     /* backward copy order */
                     for( pt = 0, tptr = hptr->pointlistptr+hptr->maxpointid-1;
                          pt < hptr->maxpointid-1;
                          pt++, tptr-- )
                        (void) memcpy( (char *)(*segments+pt),
                                       (char *)tptr, sizeof( Tuple ) );
                     pttally += hptr->maxpointid-1; /* don't dup common endpt */
                     connected = TRUE;   frontsegid = sptr->id;
                  } else if(
                        hptr->pointlistptr->x == (*segments+pttally-1)->x  &&
                        hptr->pointlistptr->y == (*segments+pttally-1)->y  &&
                        hptr->pointlistptr->z == (*segments+pttally-1)->z ) {
                     /* forward copy order */
                     (void)memcpy( (char *)(*segments+pttally),
                                   (char *)(hptr->pointlistptr+1),
                                   (hptr->maxpointid-1) * sizeof( Tuple ) );
                     pttally += hptr->maxpointid-1; /* don't dup common endpt */
                     connected = TRUE;   backsegid = sptr->id;
                  } else {
                     farendpt = hptr->pointlistptr + hptr->maxpointid - 1;
                     if( farendpt->x == (*segments+pttally-1)->x  &&
                         farendpt->y == (*segments+pttally-1)->y  &&
                         farendpt->z == (*segments+pttally-1)->z )  {
                        /* backward copy order */
                        for( pt = 0, farendpt--;  pt < hptr->maxpointid-1;
                             pt++, farendpt-- )
                           (void) memcpy( (char *)(*segments+pttally+pt),
                                          (char *)farendpt, sizeof( Tuple ) );
                        pttally += hptr->maxpointid - 1;
                        connected = TRUE;   backsegid = sptr->id;
                     } else if( farendpt->x == (*segments)->x  &&
                                farendpt->y == (*segments)->y  &&
                                farendpt->z == (*segments)->z )  {
                        /* shift tallying segment */
                        for( tptr = *segments+pttally+hptr->maxpointid-2,
                             tsptr = *segments+pttally-1;
                             tptr >= *segments+hptr->maxpointid-1;
                             tptr--, tsptr-- )
                           (void) memcpy( (char *)tptr, (char *)tsptr,
                                          sizeof( Tuple ) );
                        /* forward copy order */
                        (void) memcpy( (char *)*segments,
                                       (char *)(farendpt-(hptr->maxpointid-1)),
                                       (hptr->maxpointid-1) * sizeof( Tuple ) );
                        pttally += hptr->maxpointid - 1;
                        connected = TRUE;   frontsegid = sptr->id;
                     } /* else: redundant recycling of segment :: ignore */
                  }   

                  break;
               }

            if( !hptr )  {
               (void) fprintf( stderr,
                  "agm(copy_segments): segment (%d) not found in hash table.\n",
                               sptr->id );
               return( -2 );
            }
         }   
   else
      for( sptr = segmentidlistptr;  sptr;  sptr = sptr->next )  {
         /* find segment in hash table (segment pool) */
         hashaddr = seg_hash( sptr->id );

         for( hptr = modellistptr->segmentpool[hashaddr];  hptr;
              hptr = hptr->next )
            if( sptr->id == hptr->id )  {  /* found matching seg */
               if( hptr->pointlistptr )
                  (void)memcpy( (char *)segments[segment++],
                                (char *)hptr->pointlistptr,
                                hptr->maxpointid * sizeof( Tuple ) );
               else
                  (void)fprintf( stderr,
              "agm(copy_segments): attempted to copy from NULL point list.\n" );
               break;
            }

         if( !hptr )  {
            (void) fprintf( stderr,
                  "agm(copy_segments): segment (%d) not found in hash table.\n",
                            sptr->id );
            return( -2 );
         }
      }
 
   return( 0 );
}


static void delete_segment( Id segmentid )
{
   Segmentlistptr	sptr, prevsptr;
   unsigned		hashaddr;


   globsegmentid = NO_ID;
   hashaddr = seg_hash( segmentid );

   for( sptr = modellistptr->segmentpool[hashaddr];  sptr;
        sptr = sptr->next )  {
      if( sptr->id == segmentid )  {
         if( sptr->id == highest_segment_id )
            --highest_segment_id;

         if( sptr == modellistptr->segmentpool[hashaddr] )
            modellistptr->segmentpool[hashaddr] = sptr->next;
         else
            prevsptr->next = sptr->next;

#ifdef PURIFY_DEBUG
printf( "freeing sptr->pointlistptr\n" );
#endif
         free( sptr->pointlistptr );
         free( sptr );

         break;
      }

      prevsptr = sptr;
   }
}


static void delete_attribute( Id attributeid )
{
   Attributelistptr	aptr, prevaptr;
   Componentlistptr	cptr, nextcptr;
   Locationlistptr	lptr, nextlptr;
   unsigned		hashaddr;


   hashaddr = atb_hash( attributeid );

   for( aptr = modellistptr->attributepool[hashaddr];  aptr;
        aptr = aptr->next )  {
      if( aptr->id == attributeid )  {
         if( aptr == modellistptr->attributepool[hashaddr] )
            modellistptr->attributepool[hashaddr] = aptr->next;
         else
            prevaptr->next = aptr->next;

         if( aptr->abbreviation != NULL )
            free( aptr->abbreviation );

         for( cptr = aptr->componentlistptr;  cptr;  cptr = nextcptr )  {
            nextcptr = cptr->next;
            free( cptr );
         }

         for( lptr = aptr->locationlistptr;  lptr;  lptr = nextlptr )  {
            nextlptr = lptr->next;
            free( lptr );
         }

         free( aptr );

         break;
      }
      prevaptr = aptr;
   }
}


static int put_2d_grid_info( Id collectionid, double xorigin, double zorigin, double xintsize, double zintsize, unsigned numintvx, unsigned numintvz )
{
   Units	units;
   Factors	factors;
   Extents	extents;
   int		rc;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "put_2d_grid_info" );
      return( 1 );
   }

   if( versionlistptr == NULL )  {
      handle_empty_version_list( "put_2d_grid_info" );
      return( 2 );
   }

   if( (rc = get_model_world( &units, &factors, &extents )) != 0 )
      return( rc );

   if( (rc = put_attribute_misc( "XORIGIN", units.x, factors.x,
                                 "X-axis origin" )) != 0 )
      return( rc );
   if( (rc = put_attribute_misc( "ZORIGIN", units.z, factors.z,
                                 "Z-axis origin" )) != 0 )
      return( rc );
   if( (rc = put_attribute_misc( "XINTSIZE", units.x, factors.x,
                                 "X-axis interval size" )) != 0 )
      return( rc );
   if( (rc = put_attribute_misc( "ZINTSIZE", units.z, factors.z,
                                 "Z-axis interval size" )) != 0 )
      return( rc );
   if( (rc = put_attribute_misc( "XNUMINTV", "unity", 1.0,
                                 "X-axis number of intervals" )) != 0 )
      return( rc );
   if( (rc = put_attribute_misc( "ZNUMINTV", "unity", 1.0,
                                 "Z-axis number of intervals" )) != 0 )
      return( rc );

   if( (rc = create_attribute( 0 )) != 0 )
      return( rc );
   if( (rc = put_attribute_abbreviation( "XORIGIN" )) != 0 )
      return( rc );
   if( (rc = put_attribute_component( xorigin )) != 0 )
      return( rc );
   if( (rc = put_id_collection_attribute_link( collectionid, globattributeid ))
       != 0 )
      return( rc );

   if( (rc = create_attribute( 0 )) != 0 )
      return( rc );
   if( (rc = put_attribute_abbreviation( "ZORIGIN" )) != 0 )
      return( rc );
   if( (rc = put_attribute_component( zorigin )) != 0 )
      return( rc );
   if( (rc = put_id_collection_attribute_link( collectionid, globattributeid ))
       != 0 )
      return( rc );

   if( (rc = create_attribute( 0 )) != 0 )
      return( rc );
   if( (rc = put_attribute_abbreviation( "XINTSIZE" )) != 0 )
      return( rc );
   if( (rc = put_attribute_component( xintsize )) != 0 )
      return( rc );
   if( (rc = put_id_collection_attribute_link( collectionid, globattributeid ))
       != 0 )
      return( rc );

   if( (rc = create_attribute( 0 )) != 0 )
      return( rc );
   if( (rc = put_attribute_abbreviation( "ZINTSIZE" )) != 0 )
      return( rc );
   if( (rc = put_attribute_component( zintsize )) != 0 )
      return( rc );
   if( (rc = put_id_collection_attribute_link( collectionid, globattributeid ))
       != 0 )
      return( rc );

   if( (rc = create_attribute( 0 )) != 0 )
      return( rc );
   if( (rc = put_attribute_abbreviation( "XNUMINTV" )) != 0 )
      return( rc );
   if( (rc = put_attribute_component( (double)numintvx )) != 0 )
      return( rc );
   if( (rc = put_id_collection_attribute_link( collectionid, globattributeid ))
       != 0 )
      return( rc );

   if( (rc = create_attribute( 0 )) != 0 )
      return( rc );
   if( (rc = put_attribute_abbreviation( "ZNUMINTV" )) != 0 )
      return( rc );
   if( (rc = put_attribute_component( (double)numintvz )) != 0 )
      return( rc );
   if( (rc = put_id_collection_attribute_link( collectionid, globattributeid ))
       != 0 )
      return( rc );

   return 0;
}


/*
static int make_attribute_set( String attrib_abbrev, unsigned nx, unsigned ny, unsigned nz )
{
   Attributelistptr	aptr;
   float		*attrib_set;
   unsigned		hashaddr, loc_hash;
   int			rc;


   if( modellistptr == NULL )  {
      handle_empty_model_list( "make_attribute_set" );
      return( 1 );
   }

   attrib_set = (float *)malloc( nx*ny*nz * sizeof( float ) );
   if( attrib_set == NULL )  {
      (void)sprintf( message,
"agm(make_attribute_set): Unable to allocate storage for %d*%d*%d elements.",
 nx, ny, nz );
      return( 2 );
   }

   if( (rc = init_location_hash()) != NULL )
      return( rc );
*/

   /* count number of components for specified attribute abbreviation */
   /* Note: attribute values must be sorted by location: keep unique locs */
/* for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         if( aptr->abbreviation != NULL )
            if( strcmp( aptr->abbreviation, attrib_abbrev ) == MATCH )  {
*/
               /* physical properties should consist of 1 component only */
/*             loc_hash = location_hash( aptr->locationlistptr->location.x, */
/* commented out loc_hash to prevent compiler warning; this is dead code anyhow */
/*             (void)location_hash( aptr->locationlistptr->location.x,
                                         aptr->locationlistptr->location.y,
                                         aptr->locationlistptr->location.z );
*/
/* loc_hash should return the array offset for storing into the attribute set */
/*
            }


   return( 0 );
}
*/


/* static Boolean		dim_2d;
static float		x_scale_factor, y_scale_factor, z_scale_factor;
*/


/*
static int init_location_hash( void )
{
   Modelinfoptr		iptr;
   Mdmodwrldptr		mptr;


   if( (iptr = modellistptr->modelinfoptr) == NULL )  {
      (void)sprintf( message,
"agm(init_location_hash): Model extents must be defined before making an attribute set." );
      return( 1 );
   } else if( (mptr = iptr->mdmodwrldptr) == NULL )  {
      (void)sprintf( message,
"agm(init_location_hash): Model extents must be defined before making an attribute set." );
      return( 2 );
   } else if ( mptr->extents.min.x == mptr->extents.max.x  || 
               mptr->extents.min.z == mptr->extents.max.z )  {
      (void)sprintf( message,
"agm(init_location_hash): Model x and z min and max extents must not be the same." );
      return( 3 );
   }

   if( mptr->extents.min.y == mptr->extents.max.y )
      dim_2d = TRUE;
   else
      dim_2d = FALSE;

   if( *mptr->units.x == 'k' ) */  /* assume kilo... */
/*    if( mptr->extents.max.x - mptr->extents.min.x < 1000.0 )
         x_scale_factor = 1000.0;
      else if( mptr->extents.max.x - mptr->extents.min.x < 10000.0 )
         x_scale_factor = 100.0;
      else if( mptr->extents.max.x - mptr->extents.min.x < 100000.0 )
         x_scale_factor = 10.0;
      else
         x_scale_factor = 1.0;
   else if( mptr->extents.max.x - mptr->extents.min.x < 10.0 )
      x_scale_factor = 100000.0;
   else
      x_scale_factor = 1.0;
   if( !dim_2d )
      if( *mptr->units.y == 'k' )
         y_scale_factor = 1000.0;
      else if( mptr->extents.max.y - mptr->extents.min.y < 10.0 )
         y_scale_factor = 100000.0;
      else
         y_scale_factor = 1.0;
   if( *mptr->units.z == 'k' )
      if( mptr->extents.max.z - mptr->extents.min.z < 1000.0 )
         z_scale_factor = 1000.0;
      else if( mptr->extents.max.z - mptr->extents.min.z < 10000.0 )
         z_scale_factor = 100.0;
      else if( mptr->extents.max.z - mptr->extents.min.z < 100000.0 )
         z_scale_factor = 10.0;
      else
         z_scale_factor = 1.0;
   else if( mptr->extents.max.z - mptr->extents.min.z < 10.0 )
      z_scale_factor = 100000.0;
   else
      z_scale_factor = 1.0;

   return( 0 );
}
*/


/*
static unsigned location_hash( float x, float y, float z )
{
   if( dim_2d )
      if( x_scale_factor != 1.0 )
         if( z_scale_factor != 1.0 )
            return( (int)(z*z_scale_factor) << 6  |  (int)(x*x_scale_factor) );
         else
            return( (int)z << 6  |  (int)(x*x_scale_factor) );
      else
         if( z_scale_factor != 1.0 )
            return( (int)(z*z_scale_factor) << 6  |  (int)x );
         else
            return( (int)z << 6  |  (int)x );
   else
      if( x_scale_factor != 1.0 )
         if( y_scale_factor != 1.0 )
            if( z_scale_factor != 1.0 )
               return( (int)(z*z_scale_factor) << 12  |
                       (int)(y*y_scale_factor) <<  6  |
                       (int)(x*x_scale_factor) );
            else
               return( (int)z << 12  | (int)(y*y_scale_factor) <<  6  |
                       (int)(x*x_scale_factor) );
         else
            if( z_scale_factor != 1.0 )
               return( (int)(z*z_scale_factor) << 12  | (int)y <<  6  |
                       (int)(x*x_scale_factor) );
            else
               return( (int)z << 12  | (int)y <<  6  |
                       (int)(x*x_scale_factor) );
      else
         if( y_scale_factor != 1.0 )
            if( z_scale_factor != 1.0 )
               return( (int)(z*z_scale_factor) << 12  |
                       (int)(y*y_scale_factor) <<  6  | (int)x );
            else
               return( (int)z << 12  | (int)(y*y_scale_factor) <<  6  |
                       (int)x );
         else
            if( z_scale_factor != 1.0 )
               return( (int)(z*z_scale_factor) << 12  | (int)y <<  6  |
                       (int)x );
            else
               return( (int)z << 12  | (int)y <<  6  | (int)x );
}
*/


static void handle_empty_model_list( String source )
{


   (void) sprintf( message, concat( "agm(", source, "): model list is empty.",
                                    NULL ) );
   (void) fprintf( stderr, "%s\n", message );
}


static void handle_empty_version_list( String source )
{


   (void) sprintf( message, concat( "agm(", source, "): version list is empty.",
                                    NULL ) );
   (void) fprintf( stderr, "%s\n", message );
}


static Id new_collection_id( void )
{
   Collectionlistptr	cptr;
   Id			max_id = 0;


   if( highest_collection_id == NO_ID )  {
      for( cptr = versionlistptr->collectionlistptr;  cptr;  cptr = cptr->next )
         if( cptr->id > max_id )
            max_id = cptr->id;

      globcollectionid = max_id + 1;
   } else
      globcollectionid = highest_collection_id + 1;

   /* do not set highest_collection_id here since may not be used */

   return( globcollectionid );
}


static Id new_segment_id( void )
{
   unsigned		hashaddr;
   Segmentlistptr	sptr;
   Id			max_id = 0;


   if( highest_segment_id == NO_ID )  {
      for( hashaddr = 0;  hashaddr < SEGMENT_HASH_TABLE_SIZE;  hashaddr++ )
         for( sptr = modellistptr->segmentpool[hashaddr];  sptr;
              sptr = sptr->next )
            if( sptr->id > max_id )
               max_id = sptr->id;
 
      globsegmentid = max_id + 1;
   } else
      globsegmentid = highest_segment_id + 1;

   /* do not set highest_segment_id here since may not be used */

   return( globsegmentid );
}


static Id new_attribute_id( void )
{
   unsigned		hashaddr;
   Attributelistptr	aptr;
   Id			max_id = 0;


   for( hashaddr = 0;  hashaddr < ATTRIBUTE_HASH_TABLE_SIZE;  hashaddr++ )
      for( aptr = modellistptr->attributepool[hashaddr];  aptr;
           aptr = aptr->next )
         if( aptr->id > max_id )
            max_id = aptr->id;

   globattributeid = max_id + 1;

   return( globattributeid );
}


static Id new_attribute_component_id( Componentlistptr crootptr )
{
   Componentlistptr	cptr;
   Id			componentid, max_id = 0;


   for( cptr = crootptr;  cptr;  cptr = cptr->next )
      if( cptr->id > max_id )
         max_id = cptr->id;

   componentid = max_id + 1;

   return( componentid );
}


static Id new_attribute_location_id( Locationlistptr lrootptr )
{
   Locationlistptr	lptr;
   Id			locationid, max_id = 0;


   for( lptr = lrootptr;  lptr;  lptr = lptr->next )
      if( lptr->id > max_id )
         max_id = lptr->id;

   locationid = max_id + 1;

   return( locationid );
}


static int intcompare( int *i, int *j )
{
   return( *i - *j );
}


static int rtend( String s )  /* return the length of the blank delimited string. */
{
   char *p = s + strlen( s ) - 1;


   while( *p == ' ' )
      --p;

   return( p - s + 1 );
}


#define BLOCK_SIZE    100
#define BLOCK_BYTES   BLOCK_SIZE * sizeof( int )

 
typedef struct ilinklist {
   int                *ilist;
   struct ilinklist   *next;
} Ilink, *Ilinkptr;
 
 
static Ilinkptr   root = NULL, linknode;
static int        count = 0, offset = 0;
 
 
static int ilistalloc( int i )  /* general purpose integer link list builder. */
{
   if( !root )  {
      linknode = root = new_node( Ilink );
      linknode->ilist = (int *) malloc( BLOCK_BYTES );
      linknode->next = NULL;
   } else if( count % BLOCK_SIZE == 0 )  {
      linknode->next = new_node( Ilink );
      linknode = linknode->next;
      linknode->ilist = (int *) malloc( BLOCK_BYTES );
      linknode->next = NULL;
      offset = 0;
   }
 
   *(linknode->ilist+offset) = i;
   count++;  offset++;
 
   return( 0 );
}
 
 
static int ilistget( int **ilist )
{
   int   i, n;


   *ilist = (int *) malloc( (n = count * sizeof( int )) );
 
   for( linknode = root, i = 0;  n > 0;  n -= BLOCK_BYTES, i++, linknode = linknode->next )
      (void) memcpy( (char *)(*ilist+i*BLOCK_SIZE), (char *)(linknode->ilist),
                     MIN( n, BLOCK_BYTES ) );

   return( 0 );
}


static int ilistfree( void )
{
   Ilinkptr   deadlink;
   int        i;


   for( linknode = root, i = 0;  i < (count + BLOCK_SIZE - 1) / BLOCK_SIZE;  i++ ) {      deadlink = linknode;  linknode = linknode->next;
      (void) free( deadlink );
   }

   linknode = root = NULL;   count = offset = 0;

   return( 0 );
}


static char *allocstr( String s )
{
   char *p;


   if( s == NULL ) return NULL;

   p = malloc( (size_t)( strlen( s ) + 1 ) );
   if( p == NULL ) {
      fprintf( stderr, "allocstr: malloc failure.\n" );
      return p;
   }

   (void) strcpy( p, s );
   return p;
}


/*
	Notes: strdup obtains the space for the new string using malloc(3C).
		realloc'ing this space is dicey since realloc may be linked
		with malloc(3X).
		(The malloc(3X)  routines  are  space-efficient,  but have
		slower performance.
		The standard, fully  SCD-compliant  malloc(3C)  routines
		are a trade-off between performance and space-efficiency.)
*/


static String concat( String s, ... )
{
	va_list		args;
	String		compoundString = NULL;
	unsigned	newlen;

	va_start( args, s );
	while( s )
	{
		if( compoundString )
			(void)strcat(
				compoundString = realloc( compoundString,
					(newlen+=(size_t)strlen(s)) + 1 ),
				s );
		else
#if defined(sun) && defined(__SVR4)
		{
			/* strlen/strdup combo unsafe on SOLARIS */
			compoundString = (String)malloc( (newlen=(size_t)strlen(s))+1 );
			(void)strcpy( compoundString, s );
		}
#else
			newlen = strlen( compoundString = strdup( s ) );
#endif

		s = va_arg( args, String );
	}

	va_end( args );

	return compoundString;
}
