/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  animating.
*/

#include "xdisplayP.h"               /* Header file for global variables. */
#include "prototyping.h"


extern int window_list[MAX_IMAGES],list_count;  /* List of window id. */


static Widget animate_window=NULL;
static Widget animate_form=NULL;
Widget scale_speed=NULL;

int animate_list[MAX_IMAGES],animate_count; /* List of window id to animate. */
int step_count=0;	        /* Current count into window list.*/
Boolean animate_flag=False;	/* Indicates if an animation window exist. */


/*
  Function to create animation
  window.
*/
void animateCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget main_window;
  int image_count;
  long id;
  long n;	/* RJM: handle 64-bit architectures */
  int width_temp,height_temp;
/*Boolean dual_flag=False; */	/* Indicates if dual sliders are needed. */

  if (list_count==0)
    return;

  if (animate_flag) {              /* If there is already an animation */
    if( animate_window ) {	/* RJM: added check */
/*    XtDestroyWidget(animate_window); RJM: deleting an animation window no
      longer calls the destroyCallback via xdisplay_image. Hence, do explicitly:
*/
      for (n=0; n<MAX_IMAGES; n++)
        if( xdisplay[n].init==-1
        &&  strcmp(xdisplay[n].filename,"Animation")==0) {
	  if( xdisplay[n].window != animate_window )
		(void)fprintf( stderr,
			       "animate_window(=%x) != xdisplay[%d].window(=%x)\n", 
			       animate_window, n, xdisplay[n].window);
          delete_windowCB(NULL, (XtPointer)n, NULL ); /* RJM: added */
          animate_window=NULL;
          break;
        }
    }

    if( animate_window ) {
      error_message( "Delete existing animation window first." );
      return;
    }
  }
  
  animate_flag=True;                     /* Set flag indicating an animation
					 window is being displayed. */
  step_count=0;

  animate_count=list_count;         /* Copy the global list of windows into */
  for (n=0; n<animate_count; n++) { /* the animation list of windows. So    */
    animate_list[n]=window_list[n]; /* other global operation can be done   */
				    /* without corrupting the animation.    */
/*  if ((xdisplay[animate_list[n]].inter_parent!=0)||
	(xdisplay[animate_list[n]].dual_flag))
      dual_flag=True;
obsolete
*/
  }

  id=animate_list[0];		/* Set id to the first window in the list. */
  image_count=next_image();     /* Get new window id. */

				/* Create toplevel for animation. */
  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;	/* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;	/* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;	/* RJM: added */
  XtSetArg(args[n],XtNdepth,screenDepth); n++;	/* RJM: added */
/*animate_window=XtAppCreateShell("xsd","animation",
                               topLevelShellWidgetClass,display,args,n);
RJM commented out 1/17/97 */
  animate_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);

  quit_frame(animate_window);
  copy_attributes(image_count,id); /* Copy window attributes. */

  width_temp=xdisplay[id].image->width;
  height_temp=xdisplay[id].image->height;

				/* Malloc memory to store image. */
  raster[image_count]=(unsigned char *)malloc(width_temp*height_temp*sizeof(char));

				/* Copy the first window in 
				   the animation window's memory. */
  memcpy((char *)raster[image_count],(char *)raster[id],width_temp*height_temp*sizeof(char));


				/* Create ximage for animation window. */
  xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
                                           0,(char *)raster[image_count],
					   width_temp,height_temp,screenDepth,0);

  screen_size(id,&width_temp,&height_temp);  /* Find best screen size. */

				/* Set filename to "Animation" so other
				   windows know it is a animation window. */
  strcpy(xdisplay[image_count].filename,"Animation");
  window_title(buf,animate_list[0]);        /* Create title for window. */

  XtVaSetValues(animate_window,
		XmNtitle,buf,
		NULL);
  
  main_window=XmCreateMainWindowVa(animate_window,"child_form",
				   XmNwidth,width_temp,
				   XmNheight,height_temp+10+MIN_HEIGHT,
				   XmNshowSeparator,True,
				   NULL);

  animate_form=XmCreateFormVa(main_window,"animation",NULL);

				/* Creates drop-down menus. */
  app_menus(animate_form,image_count,False);

  XmRemoveTabGroup(animate_form);

                                /* Indicate general mode. */
  xdisplay[image_count].mode=1;
  set_mode_label(1,image_count);

				/* Create drawing area with scrollbars. */
  xdisplay_image(image_count,animate_window,        
		 animate_form,width_temp,height_temp); 

  XtManageChild(xdisplay[image_count].menu);

  XtRealizeWidget(animate_window);
}


/*
  Steps back one frame.
*/
void step_backwardCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id; /* RJM: handle 64-bit architectures */

  id=(long)client_data;

  step_count--;
				/* Check if step_count is before the
				   first window. */
  if (step_count<0) step_count=animate_count-1;
  if (step_count<0) step_count=0;

				/* Expose current animation window. */
  expose_animation(id,animate_list[step_count]);

				/* Updates window title. */
  window_title(buf,animate_list[step_count]);
  XtVaSetValues(animate_window,
		XmNtitle,buf,
		NULL);
}



/*
  Steps forward one frame.
*/
void step_forwardCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id; /* RJM: handle 64-bit architectures */

  id=(long)client_data;

  step_count++;
				/* Check if step_count is after the
				   last window. */
  if (step_count>=animate_count) step_count=0;

				/* Exposes the current animation window. */
  expose_animation(id,animate_list[step_count]);

				/* Updates window title. */
  window_title(buf,animate_list[step_count]);
  XtVaSetValues(animate_window,
		XmNtitle,buf,
		NULL);
}



/*
  Plays through all the frames.
*/
void playCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  char *str;
  int speed;
  int n;
  long id; /* RJM: handle 64-bit architectures */

  id=(long)client_data;
				/* Gets the current speed setting. */
  XtVaGetValues(scale_speed,
		XmNvalue,&str,
		NULL);
  sscanf(str,"%d",&speed);
  speed*=1000;
  XtFree(str);

				/* Loop throught the window list. */
  for (n=0; n<animate_count; n++) {
				/* Expose the current animation window. */
    expose_animation(id,animate_list[n]);
				/* Delay for reducing animation speed. */
    usleep(speed);
  }

				/* Set step_count to the last window. */
  step_count=animate_count-1;

/*
  window_title(buf,animate_list[step_count]);
  XtVaSetValues(animate_window,
		XmNtitle,buf,
		NULL);
*/
}



/*
  Expose the animation window.
*/
void expose_animation(long id, long id_anim)
{
				/* Put image in the animation window. */
  XPutImage(display,xdisplay[id].top,xdisplay[id].gc,
	    xdisplay[id_anim].image,0,0,0,0,
	    xdisplay[id_anim].image->width,
	    xdisplay[id_anim].image->height);

  expose_picks_animation(id,id_anim);

				/* Update the colormap according 
				   to the contrast and bias. */
  contrast_bias(id,id_anim); 

				/* Make sure the screen is current. */
  XmUpdateDisplay(xdisplay[id].window);
}



/*
  Clears the animate flag
  indicating that the 
  animation window has been
  destroyed.
*/
void reset_animateCB(Widget w, XtPointer client_data, XtPointer call_data)
{
/*  XtDestroyWidget(animate_window);
    RJM: deleting an animation window no longer calls the destroyCallback via
    xdisplay_image. But don't call delete_windowCB here delete_windowCB calls
    this function.
*/

  animate_flag=False;
}
