/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  contrast and bias adjustments. 
*/


#include "xdisplayP.h"
#include "prototyping.h"
#include "stringutils.h"

extern int body_init;
extern Boolean animate_flag;
extern Widget scale_speed;

Widget draw_vel;
Widget text_min;
Widget text_max;
Widget draw_color[MAX_IMAGES];
Widget global_toggle[MAX_IMAGES];
Widget scale_bias[MAX_IMAGES];      /* Bias slider. */
Widget scale_contrast[MAX_IMAGES];  /* Contrast slider. */
Widget scale_bias1[MAX_IMAGES];     /* Second bias slider for dual mode. */
Widget scale_contrast1[MAX_IMAGES]; /* Second contrast slider 
					      for dual mode. */

static CB_PROTO( cancel_color_dialogCB )

static Widget pick_color_dialog=NULL;

Window vel_top;
GC vel_gc;

int global_bias;
int global_contrast;
int global_bias1;
int global_contrast1;
float bar_scale;


/*
  This function creates the sliders for 
  the contrast and bias controls.
*/
void color_sliders(Widget main_form, long id)
{
  Widget form;
  Widget frame;
  Widget label;
  Widget row_column;
  Widget button;
  Widget scroll;
  int width_tmp;
  MinMaxRec	minmaxRec;

  scale_bias1[id]=0;

  if (strcmp(xdisplay[id].filename,"Animation")==0) {
    frame=XmCreateFrameVa(main_form,"frame",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNtopAttachment,XmATTACH_FORM,
			  NULL);
    
    form=XmCreateFormVa(frame,"form",NULL);
    
    row_column=XmCreateRowColumnVa(form,"buttons",
				  XmNpacking,XmPACK_COLUMN,
				  XmNnumColumns,5,
				  XmNleftAttachment,XmATTACH_FORM,
				  XmNtopAttachment,XmATTACH_FORM,
				  NULL);
    XmAddTabGroup(row_column);
    
    button=XmCreatePushButtonVa(row_column,"Play",NULL);
    XtAddCallback(button,XmNactivateCallback,playCB,(XtPointer)id);
    
    button=XmCreatePushButtonVa(row_column,"< Step",NULL);
    XtAddCallback(button,XmNactivateCallback,step_backwardCB,(XtPointer)id);
    
    button=XmCreatePushButtonVa(row_column,"Step >",NULL);
    XtAddCallback(button,XmNactivateCallback,step_forwardCB,(XtPointer)id);
    
    button=XmCreatePushButtonVa(row_column,"Quit",NULL);
/*  XtAddCallback(button,XmNactivateCallback,reset_animateCB,(XtPointer)0); RJM commented out */
    XtAddCallback(button,XmNactivateCallback,delete_windowCB,(XtPointer)id);/* RJM: changed to delete_windowCB which does proper cleanup (including reset_animateCB */
    
    label=XmCreateLabelVa(form,"Movie Delay (ms)",
			  XmNleftAttachment,XmATTACH_WIDGET,
			  XmNleftWidget,row_column,
			  XmNleftOffset,10,
			  XmNtopAttachment,XmATTACH_FORM,
			  XmNtopOffset,6,
/*			  XmNbottomAttachment,XmATTACH_FORM, RJM */
/* CAN'T DO BOTTOM ATTACHMENT BECAUSE xdisplay[id].label BELOW ATTACHES TO SAME
FORM BOTTOM */
			  NULL);
    
    sprintf(buf,"0");
    
    scale_speed=XmCreateTextVa(form,"text", 
			       XmNvalue,buf,
                XmNmaxLength,5,
			       XmNcolumns,5,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,label,
			       XmNtopAttachment,XmATTACH_FORM,  
			       NULL);
    XmAddTabGroup(scale_speed);

    frame=XmCreateFrameVa(main_form,"frame",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,frame,
			  NULL);
  } else {
    frame=XmCreateFrameVa(main_form,"frame",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNtopAttachment,XmATTACH_FORM,
			  NULL);
  }
  form=XmCreateFormVa(frame,"form",NULL);

  label=XmCreatePushButtonVa(form,"Cont",
			     XmNleftAttachment,XmATTACH_FORM,
			     XmNtopAttachment,XmATTACH_FORM,	/* RJM */
/*			     XmNbottomAttachment,XmATTACH_FORM, RJM */
/* CAN'T DO BOTTOM ATTACHMENT BECAUSE xdisplay[id].label BELOW ATTACHES TO SAME
FORM BOTTOM */
			     NULL);
  XmAddTabGroup(label);
  
  scale_contrast[id]=XmCreateScaleVa(form,"scale",
				     XmNshowValue,True,
				     XmNorientation,XmHORIZONTAL,
				     XmNprocessingDirection,XmMAX_ON_RIGHT,
				     XmNtopAttachment,XmATTACH_FORM,
				     XmNleftAttachment,XmATTACH_WIDGET,
				     XmNleftWidget,label,
				     XmNminimum,-100,
				     XmNmaximum,100,
				     XmNdecimalPoints,2,
				     XmNscaleMultiple,1,
				     NULL);
  XtAddCallback(scale_contrast[id],XmNvalueChangedCallback,contrastCB,(XtPointer)id);
  XtAddCallback(scale_contrast[id],XmNdragCallback,contrastCB,(XtPointer)id);
  XmScaleSetValue(scale_contrast[id],global_contrast);

                                         /* Set call after scale is created. */
  XtAddCallback(label,XmNactivateCallback,resetCB,scale_contrast[id]);
  XtAddCallback(label,XmNactivateCallback,contrastCB,(XtPointer)id);
  XmAddTabGroup(scale_contrast[id]);

  
  label=XmCreatePushButtonVa(form,"Bias",
			     XmNleftAttachment,XmATTACH_WIDGET,
			     XmNleftWidget,scale_contrast[id],
			     XmNtopAttachment,XmATTACH_FORM,	/* RJM */
/*			     XmNbottomAttachment,XmATTACH_FORM, RJM */
/* CAN'T DO BOTTOM ATTACHMENT BECAUSE xdisplay[id].label BELOW ATTACHES TO SAME
FORM BOTTOM */
			     NULL);
  XmAddTabGroup(label);
  
  scale_bias[id]=XmCreateScaleVa(form,"scale",
				 XmNshowValue,True, 
				 XmNorientation,XmHORIZONTAL,
				 XmNprocessingDirection,XmMAX_ON_RIGHT,
				 XmNtopAttachment,XmATTACH_FORM,
				 XmNleftAttachment,XmATTACH_WIDGET,
				 XmNleftWidget,label,
				 XmNminimum,-100,
				 XmNmaximum,100,
				 XmNdecimalPoints,2,
				 XmNscaleMultiple,1,
				 NULL);
  XtAddCallback(scale_bias[id],XmNvalueChangedCallback,biasCB,(XtPointer)id);
  XtAddCallback(scale_bias[id],XmNdragCallback,biasCB,(XtPointer)id);
  XmScaleSetValue(scale_bias[id],global_bias);
  
                                         /* Set call after scale is created. */
  XtAddCallback(label,XmNactivateCallback,resetCB,scale_bias[id]);
  XtAddCallback(label,XmNactivateCallback,biasCB,(XtPointer)id);
  XmAddTabGroup(scale_bias[id]);

  global_toggle[id]=XmCreateToggleButtonVa(form,"Global",
				   XmNleftAttachment,XmATTACH_WIDGET,
				   XmNleftWidget,scale_bias[id],
				   XmNrightAttachment,XmATTACH_FORM,
				   XmNtopAttachment,XmATTACH_FORM,/*RJM*/
/*				   XmNbottomAttachment,XmATTACH_FORM, RJM */
/* CAN'T DO BOTTOM ATTACHMENT BECAUSE xdisplay[id].label BELOW ATTACHES TO SAME
FORM BOTTOM */
				   NULL);
  XtAddCallback(global_toggle[id],XmNvalueChangedCallback,set_toggleCB,(XtPointer)id);
  XmAddTabGroup(global_toggle[id]);

  frame=XmCreateFrameVa(main_form,"frame",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,frame,
			XmNleftAttachment,XmATTACH_WIDGET,
			XmNleftWidget,frame,
			XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,frame,
			NULL);
  
/*form=XmCreateFormVa(frame,"Color",NULL); RJM */
  
  sprintf(buf,"  Scale\n %1.4e ",xdisplay[id].scalar);
  
/*xdisplay[id].scalar_offset=XmCreateLabelVa(form,buf, RJM */
  xdisplay[id].scalar_offset=XmCreateLabelVa(frame,buf,
/*					     XmNtopAttachment,XmATTACH_FORM,
					     XmNleftAttachment,XmATTACH_FORM,
					     XmNbottomAttachment,XmATTACH_FORM,
*/
					     XmNlabelString,XMstr(buf),
					     NULL);

  frame=XmCreateFrameVa(main_form,"Mode",
			XmNtopAttachment,XmATTACH_FORM,
/*			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,frame,
*/
			XmNleftAttachment,XmATTACH_WIDGET,
			XmNleftWidget,frame,
			XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,frame,
			XmNrightAttachment,XmATTACH_FORM, /* RJM */
			NULL);
  
/*form=XmCreateFormVa(frame,"Mode",NULL); RJM */
  
  sprintf(buf,"Mode:\n Picking             ");
/*xdisplay[id].mode_label=XmCreateLabelVa(form,"mode", RJM */
  xdisplay[id].mode_label=XmCreateLabelVa(frame,"mode",
					  XmNlabelString,XMstr(buf),
					  XmNalignment,XmALIGNMENT_BEGINNING,
					  NULL);

  /* RJM: if put color palette back in window, do here */

  if ((xdisplay[id].mode==18)||(xdisplay[id].mode==28)) {
    bar_scale=4.0;
  
    frame=XmCreateFrameVa(main_form,"frame",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNrightAttachment,XmATTACH_FORM,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,frame,
			  NULL);
    
    form=XmCreateFormVa(frame,"Color",NULL);
    
    label=XmCreateLabelVa(form,"VMin",
			  XmNcolumns,5,
			  XmNvalue,buf,
			  XmNtopAttachment,XmATTACH_FORM,
/*			  XmNbottomAttachment,XmATTACH_FORM, RJM */
			  XmNleftAttachment,XmATTACH_FORM,
			  NULL);
    
    sprintf(buf,"%d",global_min);
    
    text_min=XmCreateTextVa(form,"text",
			    XmNcolumns,5,
			    XmNvalue,buf,
			    XmNtopAttachment,XmATTACH_FORM,
			    XmNleftAttachment,XmATTACH_WIDGET,
			    XmNleftWidget,label,
			    NULL);

    minmaxRec.id = id;
    minmaxRec.isMin = True;
    XtAddCallback(text_min,XmNactivateCallback,min_maxCB,(XtPointer)&minmaxRec);
    XmAddTabGroup(text_min);

    width_tmp=MAX_WIDTH*.23;
    scroll=XmCreateScrolledWindowVa(form,"scroll",
				    XmNheight,46,
				    XmNwidth,width_tmp,
				    XmNtopAttachment,XmATTACH_FORM,
				    XmNbottomAttachment,XmATTACH_FORM,
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,text_min,
				    XmNscrollingPolicy,XmAUTOMATIC,
				    NULL);
    width_tmp=bar_scale*(int)(end_color-start_color+1)+50;
    draw_vel=XmCreateDrawingAreaVa(scroll,"draw",
				   XmNheight,15,
				   XmNwidth,width_tmp,
				   XmNleftAttachment,XmATTACH_FORM,
				   XmNrightAttachment,XmATTACH_FORM,
				   XmNtopAttachment,XmATTACH_FORM,
				   XmNbottomAttachment,XmATTACH_FORM,
				   NULL);

    sprintf(buf,"%d",global_max);
    
    text_max=XmCreateTextVa(form,"text",
			    XmNcolumns,5,
			    XmNvalue,buf,
			    XmNtopAttachment,XmATTACH_FORM,
			    XmNleftAttachment,XmATTACH_WIDGET,
			    XmNleftWidget,scroll,
			    NULL);
    minmaxRec.id = id;
    minmaxRec.isMin = False;
    XtAddCallback(text_max,XmNactivateCallback,min_maxCB,(XtPointer)&minmaxRec);
    XmAddTabGroup(text_max);
    
    label=XmCreateLabelVa(form,"VMax",
			  XmNcolumns,5,
			  XmNvalue,buf,
			  XmNtopAttachment,XmATTACH_FORM,
/*			  XmNbottomAttachment,XmATTACH_FORM, RJM */
			  XmNleftAttachment,XmATTACH_WIDGET,
			  XmNleftWidget,text_max,
			  NULL);
  }
  
  /*frame=XmCreateFrameVa(xdisplay[id].menu,"frame",
    xdisplay[id].menu IS main_form! RJM */
 
  /* The follow kludge to fix on linux animation not showing this frame */
  if (strcmp(xdisplay[id].filename,"Animation")==0) {
    frame=XmCreateFrameVa(main_form,"frame",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNrightAttachment,XmATTACH_FORM,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,frame,
			  XmNheight,80,  
			  NULL);
    form=XmCreateFormVa(frame,"Color",
			XmNresizePolicy,XmRESIZE_GROW, 
			NULL);
  } else {
    frame=XmCreateFrameVa(main_form,"frame",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNrightAttachment,XmATTACH_FORM,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,frame,
			  NULL);
    form=XmCreateFormVa(frame,"Color",NULL);
  }
 
  sprintf(buf,"Record  Trace  Sample      Value  %s  %s  %s",xdisplay[id].data1,
	  xdisplay[id].data2,xdisplay[id].data3);
  
  xdisplay[id].label=XmCreateLabelVa(form,buf,
				     XmNtopAttachment,XmATTACH_FORM,
				     XmNleftAttachment,XmATTACH_FORM,
				     XmNalignment,XmALIGNMENT_BEGINNING,
				     NULL);
  
  xdisplay[id].values=XmCreateLabelVa(form,"                                                  ",
				      XmNleftAttachment,XmATTACH_FORM, 
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,xdisplay[id].label,
				      XmNalignment,XmALIGNMENT_END,
				      NULL);

/* DON'T CREATE TEXT WIDGET HERE SINCE ATTACHMENTS ALREADY FLOW LEFT TO RIGHT */
/*xdisplay[id].number_text=XmCreateTextVa(form,"text",
					  XmNrightAttachment,XmATTACH_FORM,
					  XmNcolumns,3,
					  XmNsensitive,False,
					  NULL);
  XtAddCallback(xdisplay[id].number_text,XmNactivateCallback,
		select_by_numberCB,(XtPointer)id);
  XmAddTabGroup(xdisplay[id].number_text);
*/
  
  xdisplay[id].number_label=XmCreateLabelVa(form,"Segment #",
					    XmNtopAttachment,XmATTACH_FORM,
					    XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
					    XmNbottomWidget,xdisplay[id].values,
/* BAD! BAD!			            XmNrightAttachment,XmATTACH_WIDGET,
				            XmNrightWidget,xdisplay[id].number_text,
RJM */
					    XmNleftAttachment,XmATTACH_WIDGET,/* RJM */
					    XmNleftWidget,xdisplay[id].label,/* RJM */
					    XmNleftOffset,5,
					    XmNsensitive,False,
					    NULL);

  xdisplay[id].number_text=XmCreateTextVa(form,"text",
					  XmNtopAttachment,XmATTACH_FORM,
					  XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
					  XmNbottomWidget,xdisplay[id].values,
					  XmNleftAttachment,XmATTACH_WIDGET,
					  XmNleftWidget,xdisplay[id].number_label,
					  XmNrightAttachment,XmATTACH_FORM,
					  XmNcolumns,3,
					  XmNsensitive,False,
					  NULL);
  XtAddCallback(xdisplay[id].number_text,XmNactivateCallback,
		select_by_numberCB,(XtPointer)id);
  XmAddTabGroup(xdisplay[id].number_text);

  xdisplay[id].pick_color=black;
}


void pick_color_dialogCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	Widget	form, row_column, *buttons, toggle;
	Pixel	m;
	String	tmp;
	long	id = (long)client_data;	/* RJM: handle 64-bit architectures */

	if (pick_color_dialog!=NULL)
		XtDestroyWidget(pick_color_dialog);
  
	pick_color_dialog=XmCreateFormDialogVa(w,"Color",
		XmNdialogTitle, XMstr( tmp = concat( "Window ",
						itostr( xdisplay[id].sequence ),
						" Pick Colors",
						NULL ) ),
		XmNvisual, visual,
		XmNdepth, screenDepth,
/*		XmNcolormap, xdisplay[id].cmap, causes Dialog to try to allocate colors which fail */
		XtNmanageChild,False,
		NULL);
	free( tmp );

	form=XmCreateFormVa(pick_color_dialog,"form",
		NULL);
  
	row_column=XmCreateRowColumnVa(form,"row_column",
		XmNpacking,XmPACK_COLUMN,
		XmNnumColumns,6,
		XmNspacing,0,
		XmNtopAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		NULL);
  
	(void)XmCreatePushButtonVa(row_column,"  ",
		XmNarmColor,black,
		XmNbackground,white,	/* in default cmap: don't need XSetWindowColormap */
		XmNtopShadowColor, black,
		XmNbottomShadowColor, black,
		XmNhighlightColor, white,
		XmNselectColor, black,
		XmNactivateCallback,
			CBl( set_pick_colorCB, (XtPointer)((id<<8)|white) ),
		NULL);
  
	(void)XmCreatePushButtonVa(row_column,"  ",
		XmNarmColor,black,
		XmNbackground,black,	/* in default cmap: don't need XSetWindowColormap */
		XmNtopShadowColor, black,
		XmNbottomShadowColor, black,
		XmNhighlightColor, white,
		XmNselectColor, black,
		XmNactivateCallback,
			CBl( set_pick_colorCB, (XtPointer)((id<<8)|black) ),
		NULL);
  
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
	buttons = (Widget*)malloc( (end_pick_color-start_pick_color+1) * sizeof( Widget ) );
#endif

	for (m=start_pick_color; m<=end_pick_color; m++)
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
		buttons[m-start_pick_color] = XmCreatePushButtonVa(row_column,"  ",
#else
		(void)XmCreatePushButtonVa(row_column,"  ",
#endif
			XmNarmColor,black,
			XmNbackground,(Pixel)m,
			XmNtopShadowColor, black,
			XmNbottomShadowColor, black,
			XmNhighlightColor, white,
			XmNselectColor, black,
			XmNactivateCallback,
				CBl( set_pick_colorCB, (XtPointer)((id<<8)|m) ),
			NULL);
  
	toggle=XmCreateToggleButtonVa(form,"Hide Segments",	/* RJM: added */
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,row_column,
		XmNleftAttachment,XmATTACH_FORM,
		XmNvalueChangedCallback,
			CBlist( set_flagCB, (XtPointer)&xdisplay[id].segment_flag,
				refresh_imageCB, (XtPointer)id,
				NULL ),
		NULL);

	(void)XmCreatePushButtonVa(form,"Cancel",	/* RJM: added */
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,toggle,
		XmNleftAttachment,XmATTACH_FORM,
		XmNactivateCallback,
			CBl( cancel_color_dialogCB, (XtPointer)NULL ),
		NULL);

	XtManageChild(pick_color_dialog);

	XSetWindowColormap(display,XtWindow(XtParent(pick_color_dialog)),xdisplay[id].cmap);
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
	for( m = 0; m < end_pick_color-start_pick_color+1; m++ )
		XSetWindowColormap(display,XtWindow(buttons[m]),xdisplay[id].cmap);
	free( buttons );
#endif
}


static CB_DECL( cancel_color_dialogCB )
{
  if (pick_color_dialog!=NULL) {	/* RJM: added */
    XtDestroyWidget(pick_color_dialog);
    pick_color_dialog=NULL;
  }
}


void honor_allCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Boolean flag;
  int n;

  flag=XmToggleButtonGetState(w);

  for (n=0; n<MAX_IMAGES; n++)
    if (xdisplay[n].init==-1) {
      xdisplay[n].record_flag=flag;
      if (!xdisplay[n].hide_flag) {
	if (strcmp(xdisplay[n].filename,"Animation")==0) {
	  expose_animation(n,animate_list[step_count]);
	} else {
	  expose_image(n);
	  expose_picks(n);
	}
      }
    }
}


/* 
  This function updates the sliders
  according to if the user wants
  the bias and contrast to be global.
*/
void set_toggleCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;
  long id, id1;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

                                              /* Check for animation window. */
  if (strcmp(xdisplay[id].filename,"Animation")==0) {
    /* RJM:
       We're going to set the global toggle for window[id1] only according to
       what it was just set to in window[id], which could be the same window.
       What about (un)setting the global toggle in the other windows??? Hmmm?
       Also, the code segment immediately following this block of code overrides
       what's done here if the toggle was just put in the set state!
    */
    id1=animate_list[step_count];
    XmToggleButtonSetState(global_toggle[id1],XmToggleButtonGetState(global_toggle[id]),False);

    if (!XmToggleButtonGetState(global_toggle[id])) {	/* RJM: added if cond */
      XmScaleGetValue(scale_bias[id],&global_bias);
      XmScaleGetValue(scale_contrast[id],&global_contrast);
      if (scale_bias1[id]!=0) {
        XmScaleGetValue(scale_bias1[id],&global_bias1);
        XmScaleGetValue(scale_contrast1[id],&global_contrast1);
      }
    }
  }

				/* If global_toggle is set to True then
				   all the other global_toggles are set to
				   True and their sliders are set also. */
  if (XmToggleButtonGetState(global_toggle[id])) {
    XmScaleGetValue(scale_bias[id],&global_bias);
    XmScaleGetValue(scale_contrast[id],&global_contrast);
    if (scale_bias1[id]!=0) {
      XmScaleGetValue(scale_bias1[id],&global_bias1);
      XmScaleGetValue(scale_contrast1[id],&global_contrast1);
    }
    for (n=0; n<MAX_IMAGES; n++) 
      if (xdisplay[n].init==-1)
	XmToggleButtonSetState(global_toggle[n],XmToggleButtonGetState(global_toggle[id]),False);
    set_all_sliders();
  }
}


/*
  This function resets slider.
*/
void resetCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmScaleSetValue((Widget)client_data,0);
  XmScaleSetValue((Widget)client_data,0);
}


/*
  This function is called when the
  bias slider is changed.
*/
void biasCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id,id1;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  set_animate_bias(id);

				/* If True set the global bias. */
  if (XmToggleButtonGetState(global_toggle[id])) {
    XmScaleGetValue(scale_bias[id],&global_bias);
    if (scale_bias1[id]!=0) {
      XmScaleGetValue(scale_bias1[id],&global_bias1);
    }
    set_all_sliders();
  } else {
    if (strcmp(xdisplay[id].filename,"Animation")==0) {
      id1=animate_list[step_count];
      contrast_bias(id1,id1);
      contrast_bias(id1,id);
      contrast_bias(id,id);
    } else {
      contrast_bias(id,id);
    }
  }
}


/*
  This function is called when the
  contrast slider is changed.
*/
void contrastCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id,id1;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  set_animate_contrast(id);

				/* If True set the global contrast. */
  if (XmToggleButtonGetState(global_toggle[id])) {
    XmScaleGetValue(scale_contrast[id],&global_contrast);
    if (scale_bias1[id]!=0) {
      XmScaleGetValue(scale_contrast1[id],&global_contrast1);
    }
    set_all_sliders();
  } else {
    if (strcmp(xdisplay[id].filename,"Animation")==0) {
      id1=animate_list[step_count];
      contrast_bias(id1,id1);
      contrast_bias(id1,id);
      contrast_bias(id,id);
    } else {
      contrast_bias(id,id);
    }
  }
}


/*
  This function is called when the
  bias slider is changed is an
  animation window.
*/
void set_animate_bias(long id)
{
  long id1;	/* RJM: handle 64-bit architectures */
  int temp;

                                              /* Check for animation window. */
  if (strcmp(xdisplay[id].filename,"Animation")==0) {
    id1=animate_list[step_count];
    XmScaleGetValue(scale_bias[id],&temp);
    XmScaleSetValue(scale_bias[id1],temp);
  }
}


/*
  This function is called when the
  contrast slider is changed is an
  animation window.
*/
void set_animate_contrast(long id)
{
  long id1;
  int temp;

                                              /* Check for animation window. */
  if (strcmp(xdisplay[id].filename,"Animation")==0) {
    id1=animate_list[step_count];
    XmScaleGetValue(scale_contrast[id],&temp);
    XmScaleSetValue(scale_contrast[id1],temp);
  }
}


/* 
  This function changes the colormap
  according to the bias and contrast
  values.
*/
void contrast_bias(long id1, long id)
{
  int contrast_value;
  int bias_value;
  XColor color[256];
  XColor color1[256];
  int n,start,temp,temp1,temp2;
  float temp_color,color_scale;

  if (xdisplay[id1].init!=-1) {
    error_message("Expose the windows being animated at least once. Then you can hide the windows.");
    return;
  }

  if (scale_bias1[id]!=0) {
    contrast_bias_half(id1,id);
    return;
  }

  XmScaleGetValue(scale_bias[id],&bias_value);
  XmScaleGetValue(scale_contrast[id],&contrast_value);

  if (id!=id1) {
    XmScaleSetValue(scale_bias[id1],bias_value);
    XmScaleSetValue(scale_contrast[id1],contrast_value);
    XmToggleButtonSetState(global_toggle[id1],XmToggleButtonGetState(global_toggle[id]),False);
  }

  for (n=0; n<=end_color; n++)
    color[n].pixel=n;

  XQueryColors(display,xdisplay[id1].cmap,color,(int)end_color+1);

/*XSetWindowColormap(display,XtWindow(xdisplay[id1].window),xdisplay[id1].cmap);
RJM: setting window colormap here isn't needed as it's already associated!
*/

  for (n=start_color; n<=end_color; n++) {
    color[n].red=(int)*(raster_color_red[id]+n)<<8;
    color[n].green=(int)*(raster_color_green[id]+n)<<8;
    color[n].blue=(int)*(raster_color_blue[id]+n)<<8;
  }

  for (n=start_color; n<=end_color; n++) {    
    color1[n].red=color[n].red;
    color1[n].blue=color[n].blue;
    color1[n].green=color[n].green;
  } 

  temp=(int)((int)(end_color-start_color)*(bias_value/100.0));  /* Find middle. */
  if (contrast_value<0) 
    start=(int)((int)(end_color-start_color)*(10*contrast_value/200.0));
  else
    start=(int)((int)(end_color-start_color)*(contrast_value/200.0));
  temp1=(int)start_color+start+temp;
  temp2=(int)end_color-start+temp;
  if (temp1<start_color) temp1=start_color;
  if (temp2>end_color) temp2=end_color;
  for (n=start_color; n<temp1; n++)
    if ((n>=start_color)&&(n<=end_color)) {
      color[n].red=color1[start_color].red;
      color[n].green=color1[start_color].green;
      color[n].blue=color1[start_color].blue;
    }
  for (n=temp2+1; n<=end_color; n++)
    if ((n>=start_color)&&(n<=end_color)) {
      color[n].red=color1[end_color].red;
      color[n].green=color1[end_color].green;
      color[n].blue=color1[end_color].blue;
    }
  temp_color=start_color;
  temp1=(int)start_color+start+temp;
  temp2=(int)end_color-start+temp;
  color_scale=(float)(int)(end_color-start_color)/(float)(temp2-temp1);
  for (n=temp1; n<=temp2; n++) {    
    if ((n>=start_color)&&(n<=end_color)) {
      color[n].red=color1[(int)temp_color].red;
      color[n].green=color1[(int)temp_color].green;
      color[n].blue=color1[(int)temp_color].blue;
    }
    temp_color+=color_scale;
  } 

  for (n=start_pick_color-3; n<=end_pick_color; n++) {
    color[n].red=(int)*(raster_color_red[id]+n)<<8;
    color[n].green=(int)*(raster_color_green[id]+n)<<8;
    color[n].blue=(int)*(raster_color_blue[id]+n)<<8;
  }
    
  XStoreColors(display,xdisplay[id1].cmap,color,(int)end_color+1);

  return;
}


/*
  This function sets all the
  sliders if they are global.
*/
void set_all_sliders(void)
{
  int n;

				/* Update all the global sliders. */
  for (n=0; n<MAX_IMAGES; n++) 
    if (xdisplay[n].init==-1) {
      if (XmToggleButtonGetState(global_toggle[n])) {
	XmScaleSetValue(scale_bias[n],global_bias);
	XmScaleSetValue(scale_contrast[n],global_contrast);
	if (scale_bias1[n]!=0) {
	  XmScaleSetValue(scale_bias1[n],global_bias1);
	  XmScaleSetValue(scale_contrast1[n],global_contrast1);
	}
	contrast_bias(n,n);
      }
    }
}


/*
  This function sets the current
  pick color for a window.
*/
void set_pick_colorCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id;	/* RJM: handle 64-bit architectures */

/*if (pick_color_dialog!=NULL) { RJM: LEAVE UP, LET CANCEL POPDOWN.
    XtDestroyWidget(pick_color_dialog);
    pick_color_dialog=NULL;
  }
*/

  id =(long)client_data>>8;
  xdisplay[id].pick_color = (long)client_data&0xff;
}


/*
  This function sets the initial
  GC for the drawing area. It also
  handles all expose events.
*/
void expose_velCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XGCValues values;
 
  if (body_init) {
    show_vel();
    return;
  }
 
                                /* Execute once per window. */
  body_init=True;
 
  vel_top=XtWindow(w);

  values.foreground = black;
  values.background = white;
  values.line_width=0;
  values.font=XLoadFont(display,"9x15");

				/* Create GC for the window. */
  vel_gc = XCreateGC( display, vel_top, 
                              GCForeground|GCBackground|GCLineWidth|GCFont,
                              &values );

  show_vel();
}
 
 
void show_vel(void)
{
  int m,x;
  Pixel n;

  for (n=start_color; n<=end_color; n++) {
    XSetForeground(display,vel_gc,(Pixel)n);
    x=bar_scale*((int)n-(int)start_color)+20;
    for (m=0; m<bar_scale; m++) {
      XDrawLine(display,vel_top,vel_gc,x+m,0,x+m,15);
    }
  }
}
