/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/************************************************************************
 * Routine: DRMVDUPPOINTS
 * Purpose: Remove duplicate points along curve segments.
 * Author:  Bob Mars
 * Date:    3-1-89
 * Major remod for speed: 12/17/92
 ***********************************************************************/


#include <math.h>
#include <memory.h>


#define EPSILON		1.0e-13


typedef struct {
	double	x;
	double	y;
} Dtuple2D, *Dtuple2Dptr;


void drmvduppoints( Dtuple2D **crvs, int *ncrvs, int *ncrvpts )
{
	register Dtuple2D	**cptr, *pptr, *nextpptr, *eptr;
	register int		i, *nptr, npts;


/*	for( cptr = crvs, nptr = ncrvpts; cptr < crvs + *ncrvs; cptr++, nptr++ ) REQUIRES THAT ALL CURVE STARTING ADDRESSES BE IN A CONTIGUOUS BLOCK OF MEMORY */
	for( i = 0, cptr = crvs, nptr = ncrvpts; i < *ncrvs; ++i, cptr=&crvs[i], nptr=&ncrvpts[i] )
	{
		pptr = *cptr;
		eptr = *cptr + *nptr - 1;	/* cptr base changes */
		nextpptr = pptr + 1;

		while( pptr < eptr )
		{
			if( fabs( pptr->x - nextpptr->x ) < EPSILON
			&&  fabs( pptr->y - nextpptr->y ) < EPSILON )
			{
				if( (npts = eptr - pptr) > 0 )
					(void)memcpy( (char *)pptr,
							(char *)nextpptr,
						npts * sizeof( Dtuple2D ) );

				--*nptr;
				--eptr;
			}
			else
				pptr = nextpptr++;
		}
	}
}
