/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions
  for the file selection box. 
*/


#include "xdisplayP.h"
#include "prototyping.h"

extern char recover[1024];
extern int window_list[MAX_IMAGES],list_count;

static Widget file_select_color=NULL;
static Widget file_select_pick=NULL;

int filer_type;
char *filename;
char *pickdir;
char *colordir;


/*
  This function simply sets the global
  variable indicating the file type.
*/
void set_typeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  filer_type=(long)client_data & 0xffffffff;
}

/*
  This function prompts the user for a 
  filename with a file selection box.
*/
void filer_promptCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  static int	init=0;
  int		n=0;
  char          *mask;

  /* Create file selection boxes once. */

  if (init==0) {
    init=1;
    chdir(colordir);
    file_select_color=XmCreateFileSelectionDialogVa(top_level, "file_selection",
		XmNdialogTitle, XMstr("Filer Box"),
		XmNdeleteResponse, XmDO_NOTHING,
		XtNmanageChild,False,
		NULL);

    XtAddCallback(file_select_color,XmNokCallback,get_nameCB,client_data);
    XtAddCallback(file_select_color,XmNapplyCallback,get_nameCB,client_data); 
    XtAddCallback(file_select_color,XmNcancelCallback,unmanageCB,file_select_color);
    XtAddCallback(file_select_color,XmNhelpCallback,helpCB,"file.help");

    chdir(pickdir);
    file_select_pick=XmCreateFileSelectionDialogVa(top_level, "file_selection",
		XmNdialogTitle, XMstr("Filer Box"),
		XmNdeleteResponse, XmDO_NOTHING,
		XtNmanageChild,False,
		NULL);

    XtAddCallback(file_select_pick,XmNokCallback,get_nameCB,client_data);
    XtAddCallback(file_select_pick,XmNapplyCallback,get_nameCB,client_data);
    XtAddCallback(file_select_pick,XmNcancelCallback,unmanageCB,file_select_pick);
    XtAddCallback(file_select_pick,XmNhelpCallback,helpCB,"file.help");
  } 

  /* Update new callback with the correct data. */
  XtRemoveAllCallbacks(file_select_color,XmNokCallback);
  XtRemoveAllCallbacks(file_select_pick,XmNokCallback);
  XtAddCallback(file_select_color,XmNokCallback,get_nameCB,client_data);
  XtAddCallback(file_select_pick,XmNokCallback,get_nameCB,client_data);

  /* xsd image file has "*.xsd". */
  n=0;
  XtSetArg(args[n],XmNlistVisibleItemCount,25); n++;
  mask = (char*)malloc(strlen(colordir)+strlen(pickdir)+7);
  if ((filer_type==6)||(filer_type==7)||(filer_type==10)) {
    if (colordir && colordir[0]) {
      strcpy(mask,colordir);
      strcat(mask,"/*");
    } else {
      strcpy(mask,"*");
    }
  } else if ((filer_type==2)||(filer_type==3)||(filer_type==11)) {
    if (pickdir && pickdir[0]) {
      strcpy(mask,pickdir);
      strcat(mask,"/*.xsdH");
    } else {
      strcpy(mask,"*.xsdH");
    }
  } else {
    if (pickdir && pickdir[0]) {
      strcpy(mask,pickdir);
      strcat(mask,"/*");
    } else {
      strcpy(mask,"*");
    }
  }
  XtSetArg(args[n],XmNdirMask,XMstr(mask)); n++;
  free(mask);

  if ((filer_type==6)||(filer_type==7)||(filer_type==10)) {
    /* Color file type. */
    XtSetValues(file_select_color,args,n);
    XtManageChild(file_select_color);
  } else {
    /* Pick or other file type. */
    XtSetValues(file_select_pick,args,n);
    XtManageChild(file_select_pick);
  }
}


/*
  This function simply unmanages a widget.
*/
void unmanageCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtUnmanageChild((Widget)client_data);
}


/*
  This function gets the 
  filename from the prompt.
*/
void get_nameCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmFileSelectionBoxCallbackStruct *CBst = (XmFileSelectionBoxCallbackStruct*)call_data;
  int n,rc;
  struct stat file_stat;
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */

				/* Set if a filename was entered. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&filename);

				/* Try to move to that directory. */
  /* RJM: Using chdir(2) in conjunction with getcwd can give unpredictable results. */
  rc=chdir(filename);

				/* Update the colordir and pickdir. */
  if ((filer_type==6)||(filer_type==7)||(filer_type==10)) {
    if (colordir) free(colordir);
    colordir=(char *)getcwd(NULL,255);
  } else {
    if (pickdir) free(pickdir);
    pickdir=(char *)getcwd(NULL,255);
  }

				/* Hack job here. :) */
				/* Check if chdir error if so assume
				   that you have a filename. Later
				   the program check if it is really
				   a valid filename. */
  if (rc==-1) { 
    /* Check filer_type to read or write. */
    switch (filer_type) {
    case 0: load_picks(id,filename,0);
      break;
    case 1: rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      save_picks(id,filename);
      break;
    case 2: load_image(id,filename);
      break;
    case 3: 
      if (strcmp(&filename[strlen(filename)-4],"xsdH")==0) strcpy(buf,filename);
      else sprintf(buf,"%s.xsdH",filename);
      rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      save_image(filename);
      break;
    case 4: load_defaults(filename,id);
      break;
    case 5: rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      save_defaults(filename,id);
      break;
    case 6: raster_color_red[id]=global_red;
      raster_color_green[id]=global_green;
      raster_color_blue[id]=global_blue;
      load_color_file(filename,-1); 
      break;
    case 7: rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      save_color_file(filename);
      break;
    case 8: load_labels(filename,id);
      break;
    case 9: rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      save_labels(filename,id);
      break;
    case 10: load_color(id);
      load_color_file(filename,id);
      break;
    case 11: delete_images(filename);
      break;
    case 12: rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      save_vel(filename);
      break;
    case 13: load_vel(filename,id,True);
      break;
    case 14: load_picks(id,filename,1);
      break;
    case 15: rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      /* save_dump(filename);  No longer used. */
      break;
    case 16: rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      save_vel(filename); 
      create_vel_tapeCB(xdisplay[id].window,client_data,call_data);
      break;
    case 17: load_vel(filename,id,True); 
      model(id);
      break;
    case 18: load_vel(filename,id,False); 
      model(id);
      break;
    case 19: rc=stat(filename,&file_stat);
      if (rc==0) {
	overwrite_verify(id);
	return;
      }
      export_trace_picks(id,filename);
      break;
    case 20: for (n=0; n<list_count; n++) {
               load_color(window_list[n]);
	       load_color_file(filename,window_list[n]);
	     }
      break;
    }
    XtUnmanageChild(file_select_color);
    XtUnmanageChild(file_select_pick); 
  } else {
    /* Update file selection box. */
    XmFileSelectionDoSearch(file_select_color,NULL);
    XmFileSelectionDoSearch(file_select_pick,NULL);
  }
}



/*
  This function asks the user
  if the old file should be 
  overwritten.
*/
void overwrite_verify(long id)
{
  int n,root_x,root_y;
  Widget dialog;

  XtUnmanageChild(file_select_color);
  XtUnmanageChild(file_select_pick); 

  XBell(display,100);

  locate_cursor(&root_x,&root_y);

  n=0;
  XtSetArg(args[n],XmNdefaultPosition,False); n++;
  XtSetArg(args[n],XmNx,root_x); n++;
  XtSetArg(args[n],XmNy,root_y); n++;
  XtSetArg(args[n],XmNdialogTitle,XMstr("OverWrite Verification")); n++;
  XtSetArg(args[n],XmNokLabelString,XMstr(" Yes ")); n++;
  XtSetArg(args[n],XmNcancelLabelString,XMstr(" No ")); n++;

				/* If writing an image the stuff is append 
				   to the file (it does not overwrite it. */
  if (filer_type==3) {
    XtSetArg(args[n],XmNmessageString,
	     XMstr("Do you want to append to the old image file?")); n++;
  } else {
    XtSetArg(args[n],XmNmessageString,
	     XMstr("Do you want to overwrite the old file?")); n++;
  }
  dialog=XmCreateQuestionDialog(top_level,"Overwrite Verification",args,n);
  XtManageChild(dialog);

  XtAddCallback(dialog,XmNokCallback,overwrite_fileCB,(XtPointer)id);
  XtAddCallback(dialog,XmNokCallback,destroyCB,dialog);
  XtAddCallback(dialog,XmNcancelCallback,destroyCB,dialog);
}



/*
  This function overwrites
  the old pick file.
*/
void overwrite_fileCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */

				/* Check filer_type to read or write. */
  switch (filer_type) {
  case 1: save_picks(id,filename);
    break;
  case 3: save_image(filename);
    break;
  case 5: save_defaults(filename,id);
    break;
  case 7: save_color_file(filename);
    break;
  case 9: save_labels(filename,id);
    break;
  case 12: save_vel(filename);
    break;
/*case 15: save_dump(filename);
    break;
No longer used.
*/
  case 16: save_vel(filename);
    create_vel_tapeCB(xdisplay[id].window,client_data,call_data);
    break;
  case 19: export_trace_picks(id,filename);
    break;
  }
}


/*
  This function deletes the image file.
*/
void delete_images(char *filename)
{
  if (strcmp(&filename[strlen(filename)-4],"xsdH")==0)
    sprintf(buf,"rm %s",filename);
  else
    sprintf(buf,"rm %s.xsdH",filename);
  
  system(buf);
  
  if (strcmp(&filename[strlen(filename)-4],"xsdH")==0) {
    strcpy(&filename[strlen(filename)-4],"xsdI");
    sprintf(buf,"rm -r %s",filename);
  } else
    sprintf(buf,"rm -r %s.xsdI",filename);

  system(buf);
}


/*
  This function saves the state
  of the program so the user can
  recover from a crash. (Hopefully this never happens).
*/
void save_stateCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;
  char filename[1024];

  if (strcmp(&recover[strlen(recover)-1],"/")!=0) 
    strcat(recover,"/");

  strcpy(filename,recover);
  strcat(filename,"xsd.backup");

  list_count=0;
  for (n=0; n<MAX_IMAGES; n++)
    if (xdisplay[n].init==-1) {
      window_list[list_count]=n;
      list_count++;
    }
  delete_images(filename);
  save_image(filename);
  save_picks(0,filename);
}


/*
  This function allows the user
  to recover the state of the program
  after a crash.
*/
void recover_stateCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id;	/* RJM: handle 64-bit architectures */
  char filename[1024];

  id=(long)client_data;

  if (strcmp(&recover[strlen(recover)-1],"/")!=0) 
    strcat(recover,"/");

  strcpy(filename,recover);
  strcat(filename,"xsd.backup.xsdH");

  load_image(0,filename);

  strcpy(filename,recover);
  strcat(filename,"xsd.backup");

  load_picks(id,filename,0);
  
  expose_all_picks();
}
