/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MessageB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>	/* free */
#include "std.h"
#include "XmCreateVa.h"
#include "Xgoodies.h"
#include "motifutils.h"
#include "stringutils.h"


extern int	getFormatTypes( String **formats, int *nFormats );

String		getFormatString( Widget parent, String fn );
static CB_PROTO( setSelTextCB )
static CB_PROTO( changedTextCB )
static CB_PROTO( okCB )
static CB_PROTO( cancelCB )
static void	ErrorMessage( String );
static CB_PROTO( errorOkCB )

static Widget	formDialog = NULL;
static Widget	list;
static Widget	errorDialog;
static Boolean	processEvents;
static String	formatString = NULL;

static Widget	selectionText;


String getFormatString( Widget parent, String fn )
{
	static Widget	label;
	Widget		frame, form, separator;
	XtAppContext    context;
	XmStringTable	strTbl;
	String		tmp;
	int		nFormats;
	String		*formats;
 
        if( formDialog )
        {
		XtVaSetValues( label,
			XmNlabelString, XMstr(
			tmp = concat( "Specify format of \"", fn, "\"", NULL )),
			NULL );
		free( tmp );
                XtManageChild( formDialog );

		if( formatString )
			XtFree( formatString );
		formatString = NULL;

                processEvents = True;
                context = XtWidgetToApplicationContext( parent );
                while( processEvents || XtAppPending( context ) )
                        XtAppProcessEvent( context, XtIMAll );
                return formatString;
	}

	getFormatTypes( &formats, &nFormats );

	formDialog = XmCreateFormDialogVa( parent, "formDialog",
		XmNtitle, "Seismic Data Format",
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XtNmanageChild, False,
		(String)NULL );

	frame = XmCreateFrameVa( formDialog, "frame",
		XmNmarginWidth, 10,
		XmNmarginHeight, 10,
		NULL );

	form = XmCreateFormVa( frame, "form", NULL );

	label = XmCreateLabelVa( form,
			tmp = concat( "Specify format of \"", fn, "\"", NULL ),
		XmNtopAttachment, XmATTACH_FORM,
		(String)NULL );
	free( tmp );

	list = XmCreateScrolledListVa( form, "list",
		XmNitems, strTbl = create_string_table_from_list(
			nFormats, formats ),
		XmNitemCount, nFormats,
		XmNvisibleItemCount, 5,
		XmNdefaultActionCallback,	/* double clicked */
			CBl( okCB, (XtPointer)NULL ),
		XmNbrowseSelectionCallback,	/* item selected */
			CBl( setSelTextCB, (XtPointer)NULL ),
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label,
		(String)NULL );
	free_string_table( strTbl );

	label = XmCreateLabelVa( form,
		"Selection (key in if desired format not in list)",
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, list,
		XmNtopOffset, 20,
		(String)NULL );

	selectionText = XmCreateTextVa( form, "selectionText",
		XmNresizeWidth, True,
		XmNactivateCallback, CBl( okCB, (XtPointer)NULL ),
		XmNvalueChangedCallback, CBl( changedTextCB, (XtPointer)NULL ),
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label,
		(String)NULL );

	separator = XmCreateSeparatorVa( form, "separator",
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, selectionText,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		(String)NULL );

	(void)OkCancelHelpButtons( form, separator, okCB, cancelCB, NULL);
 
	XtManageChild( formDialog );
  
	if( formatString )
		XtFree( formatString );
	formatString = NULL;
	processEvents = True;
	context = XtWidgetToApplicationContext( parent );
	while( processEvents || XtAppPending( context ) )
		XtAppProcessEvent( context, XtIMAll );

	return formatString;
}


static CB_DECL( setSelTextCB )
{
	XmListCallbackStruct	*CBst = (XmListCallbackStruct*)call_data;
 
	XmStringGetLtoR( CBst->item, XmSTRING_DEFAULT_CHARSET, &formatString );
 
	XtVaSetValues( selectionText, XmNvalue, formatString, NULL );
}


static CB_DECL( changedTextCB )
{
	int	count;

	XtVaGetValues( list, XmNselectedItemCount, &count, NULL );

	if( count > 0 )
	{
		XtUnmanageChild( list );
		XtVaSetValues( list,
			XmNselectedItemCount, 0,
			NULL );
		XtManageChild( list );
	}
}


static CB_DECL( okCB )
{
	formatString = XmTextGetString( selectionText );

	if( strlen( formatString ) == 0 )
	{
		XtVaSetValues( list,
			XmNselectedItemCount, 0,
			NULL );

		XtUnmanageChild( formDialog );
		XtVaSetValues( formDialog,
			XmNdialogStyle, XmDIALOG_MODELESS,
			NULL );
		XtManageChild( formDialog );

		ErrorMessage( "No format specified." );

		XtFree( formatString );
		formatString = NULL;

		return;
	}

	XtUnmanageChild( formDialog );
	processEvents = False;
}


static CB_DECL( cancelCB )
{
	XtUnmanageChild( formDialog );
	processEvents = False;
	formatString = NULL;
}


static void ErrorMessage( String msg )
{
	extern void	locate_cursor( int*, int* );
	extern Display	*display;

	int	root_x,root_y;
 
	XBell( display, 100 );
 
	errorDialog = XmCreateErrorDialogVa( formDialog, "errorDialog",
		XmNmessageString, XMstr( msg ),
		XmNdialogTitle, XMstr( "Error Message" ),
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XmNokCallback,CBl( errorOkCB, (XtPointer)NULL ),
		NULL);
	XtUnmanageChild( XmMessageBoxGetChild( errorDialog, XmDIALOG_CANCEL_BUTTON ) );
	XtUnmanageChild( XmMessageBoxGetChild( errorDialog, XmDIALOG_HELP_BUTTON ) );
 
	locate_cursor( &root_x, &root_y );
 
	if( (root_x!=0) || (root_y!=0) )
	{
		XtVaSetValues( errorDialog,
			XmNdefaultPosition, False,
			XmNx, root_x,
			XmNy, root_y,
			NULL );
	}
}


static CB_DECL( errorOkCB )
{
	XtUnmanageChild( formDialog );
	XtVaSetValues( formDialog,
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		NULL );
	XtManageChild( formDialog );

	XtDestroyWidget( errorDialog );
}
