/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "std.h"
#include "stringutils.h"
 
 
int getFormatTypes( String **formats, int *nFormats )
{
	extern void	error_message( String );

	const int	BlockSize = 20;

	FILE    *fp;
	String	fn, tmp;
	char	buf[1024];
	int	n, nBlocks;
 
   /* DWN 10/19/97 change XSD_DIR to XSD_HELP_DIR */

/*
	fn = getenv( "XSD_DIR" );
	fp = fopen( tmp = concat( fn, "/data/seismic.formats", NULL ), "r" );
*/

	fn = getenv( "XSD_HELP_DIR" );
	fp = fopen( tmp = concat( fn, "seismic.formats", NULL ), "r" );
	free( tmp );
	if( fp == NULL )
	{
		error_message( tmp = concat( "Can't open ", fn, ".", NULL ) );
		free( tmp );
		return 1;
	}

	*formats = NULL;
	*nFormats = 0;

	while( fscanf( fp, "%1023[^\n]%n%*[\n]", buf, &n ) != EOF )
	{
		buf[n] = '\0';

		if( *nFormats % BlockSize == 0 )
			if( *formats == NULL )
				*formats = (String*)malloc(
					(nBlocks=1)*BlockSize *sizeof(String*));
			else
				*formats = (String*)realloc( *formats,
					(++nBlocks)*BlockSize *sizeof(String*));

		(*formats)[(*nFormats)++] = strdup( buf );
	}

	fclose( fp );

	return 0;
}
