/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  creating, deleting, saving and writing
  labels.
*/

#include "xdisplayP.h"
#include "prototyping.h"


static Widget text_label=NULL;
static Widget toggle_size[4];
static Widget toggle_back[3];

static int current_label,old_mode;
static int old_x=(-1),old_y=(-1);
static int label_size=2,label_back=0;


/*
  This function prompts the user
  to enter a label with size and matting.
*/
void add_labelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget label;
  Widget button;
  long id;	/* RJM: handle 64-bit architectures */
  ClientData *message;

  id=(long)client_data;


  
  dialog_form=XmCreateFormDialogVa(w,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("Label Window"),
				   XtNmanageChild,False,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"labels.help");

  
  label=XmCreateLabelVa(dialog_form,"Label",
			XmNleftAttachment,XmATTACH_FORM,
			XmNtopAttachment,XmATTACH_FORM,
			NULL);
  
  text_label=XmCreateTextVa(dialog_form,"text",
			    XmNcolumns,40,
			    XmNtopAttachment,XmATTACH_FORM,
			    XmNleftAttachment,XmATTACH_WIDGET,
			    XmNleftWidget,label,
			    XmNrightAttachment,XmATTACH_FORM,
			    NULL);
  
  dialog_window=XmCreateRadioBoxVa(dialog_form,"row_column",
				   XmNnumColumns,4,
				   XmNtopAttachment,XmATTACH_WIDGET,
				   XmNtopWidget,text_label,
				   XmNleftAttachment,XmATTACH_FORM,
				   XmNrightAttachment,XmATTACH_FORM,
				   NULL);

  toggle_size[0]=XmCreateToggleButtonVa(dialog_window,"Small",NULL);
  toggle_size[1]=XmCreateToggleButtonVa(dialog_window,"Medium",NULL);
  toggle_size[2]=XmCreateToggleButtonVa(dialog_window,"Large",NULL);
  toggle_size[3]=XmCreateToggleButtonVa(dialog_window,"Extra Large",NULL);

  XmToggleButtonSetState(toggle_size[label_size],True,False);

  
  label=XmCreateLabelVa(dialog_form,"Matting type: ",
			XmNnumColumns,4,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,dialog_window,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);

  
  dialog_window=XmCreateRadioBoxVa(dialog_form,"row_column",
				   XmNnumColumns,4,
				   XmNtopAttachment,XmATTACH_WIDGET,
				   XmNtopWidget,dialog_window,
				   XmNleftAttachment,XmATTACH_WIDGET,
				   XmNleftWidget,label,
				   XmNrightAttachment,XmATTACH_FORM,
				   NULL);

  toggle_back[0]=XmCreateToggleButtonVa(dialog_window,"None",NULL);
  toggle_back[1]=XmCreateToggleButtonVa(dialog_window,"Black",NULL);
  toggle_back[2]=XmCreateToggleButtonVa(dialog_window,"White",NULL);

  XmToggleButtonSetState(toggle_back[label_back],True,False);

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  
  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,dialog_window,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNleftAttachment,XmATTACH_FORM,
			      NULL);
  XtAddCallback(button,XmNactivateCallback,get_labelCB,message);

  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,dialog_window,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNrightAttachment,XmATTACH_FORM,
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);


  XtManageChild(dialog_form);
}



/*
  This function gets the label from
  the prompt dialog.
*/
void get_labelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message=(ClientData *)client_data;
  char *str;
  long id; 	/* RJM: handle 64-bit architectures */

  id=message->id;

  old_mode=xdisplay[id].mode;
  
				/* User screwed up. */
  if (old_mode==14)
    old_mode=1;

				/* Put mouse into label mode. */
  xdisplay[id].mode=14;
  set_mode_label(14,id);

				/* Get label string. */
  XtSetArg(args[0],XmNvalue,&str);
  XtGetValues(text_label,args,1);

				/* Get next available label id. */
  current_label=next_label();

				/* Set some initial parameters. */
  labels[current_label].init=(-1);
  labels[current_label].id=id;
  labels[current_label].color=xdisplay[id].pick_color;
  labels[current_label].string=(char *)malloc((strlen(str)+1)*sizeof(char)+1);
  strcpy(labels[current_label].string,str);
  XtFree(str);

				/* Get font type. */
  if (XmToggleButtonGetState(toggle_size[0])) {
    label_size=0;
    strcpy(labels[current_label].font,"fixed");
  }
  if (XmToggleButtonGetState(toggle_size[1])) {
    label_size=1;
    strcpy(labels[current_label].font,"9x15");
  }
  if (XmToggleButtonGetState(toggle_size[2])) {
    label_size=2;
    strcpy(labels[current_label].font,"10x20");
  }
  if (XmToggleButtonGetState(toggle_size[3])) {
    label_size=3;
    strcpy(labels[current_label].font,"12x24");
  }

				/* Get matting type. */
  if (XmToggleButtonGetState(toggle_back[0])) {
    label_back=0;
    labels[current_label].type=0;
  }
  if (XmToggleButtonGetState(toggle_back[1])) {
    label_back=1;
    labels[current_label].type=1;
  }
  if (XmToggleButtonGetState(toggle_back[2])) {
    label_back=2;
    labels[current_label].type=2;
  }
  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}



/*
  This function positions the label
  a the current mouse location.
*/
void position_label(XEvent *event, long id)
{
  int x,y;
  XGCValues value_GC;

  x=event->xbutton.x;
  y=event->xbutton.y;

				/* Loads the font type. */
  value_GC.font=XLoadFont(display,labels[current_label].font);

				/* Change the font in the GC. */
  XChangeGC(display,xdisplay[id].gc,GCFont,&value_GC );

				/* Set GC for rubberband mode. */
  XSetFunction(display,xdisplay[id].gc,GXequiv);

				/* Draw the string to erase the old one. */
  if (old_x!=-1)
    XDrawString(display,xdisplay[id].top,xdisplay[id].gc,old_x,old_y,
		labels[current_label].string,strlen(labels[current_label].string));

				/* Draw the string at the current location. */
  XDrawString(display,xdisplay[id].top,xdisplay[id].gc,x,y,
	      labels[current_label].string,strlen(labels[current_label].string));
  old_x=x;
  old_y=y;

				/* Reset the GC mode. */
  XSetFunction(display,xdisplay[id].gc,GXcopy);
}



/*
  This function positions the label
  a the current mouse location and
  stores the value.
*/
void set_position_label(XEvent *event, long id)
{
				/* Reset the mouse mode. */
  xdisplay[id].mode=old_mode;
  set_mode_label(old_mode,id);
  
				/* Store the current location. */
  labels[current_label].x=event->xbutton.x;
  labels[current_label].y=event->xbutton.y;

				/* Reset old_x for new label. */
  old_x=(-1);

  expose_image(id);
}



/*
  This function display a selection box
  of all the labels. The user click on
  one to delete it.
*/
void delete_labelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int m,n;
  long id;	/* RJM: handle 64-bit architectures */
  Widget list;
  XmString item[MAX_LABELS+1];
  ClientData *message;

  id=(long)client_data;

  m=0;
  for (n=0; n<MAX_LABELS; n++) 
    if ((labels[n].id==id)&&(labels[n].init==-1)) {
      sprintf(buf,"%d %s (x=%d,y=%d)",n,labels[n].string,
	      labels[n].x,labels[n].y);
      item[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    }

  item[m]=NULL;


  list=XmCreateSelectionDialogVa(w,"Line Header",
				 XmNlistVisibleItemCount,25,
				 XmNlistLabelString,XMstr("List of Labels"),
				 XmNdialogTitle,XMstr("Delete Labels"),
				 NULL);
  if (m!=0) {
    XtVaSetValues(list,
		  XmNlistItems,item,
		  XmNlistItemCount,m,
		  NULL);
  }

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=list;
  message->id=id;
  XtAddCallback(list,XmNhelpCallback,helpCB,"delete.help");
  XtAddCallback(list,XmNokCallback,delete_label_valueCB,message);
  XtAddCallback(list,XmNcancelCallback,destroyCB,list);

  for (n=0; n<m; n++)
    XmStringFree(item[n]);

  XtUnmanageChild(XmSelectionBoxGetChild(list,XmDIALOG_APPLY_BUTTON));
}


/*
  This function delete a label.
*/
void delete_label_valueCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct *CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  char *str;
  int n,error;
  long id;	/* RJM: handle 64-bit architectures */

  id=message->id;

				/* Get input from selection box. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

				/* Check if there was a selection. */
  if (! *str) { 
    if( message->w != NULL )
        XtDestroyWidget( message->w );
    free(message);
    return;
  }

				/* Get label id number. */
  error=sscanf(str,"%d ",&n);
  XtFree(str);

  if (error==1) {
    labels[n].init=0;
    labels[n].x=0;
    labels[n].y=0;
    if(labels[n].string)
      free(labels[n].string);
    labels[n].string=NULL;
  }

  expose_image(id);

  if( message->w != NULL )
      XtDestroyWidget( message->w );
  free(message);
}


/*
  This function display a selection box
  of all the labels. The user click on
  one to rename it.
*/
void rename_labelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int m,n;
  long id;	/* RJM: handle 64-bit architectures */
  Widget list;
  XmString item[MAX_LABELS+1];
  ClientData *message;

  id=(long)client_data;

  m=0;
  for (n=0; n<MAX_LABELS; n++) 
    if ((labels[n].id==id)&&(labels[n].init==-1)) {
      sprintf(buf,"%d %s (x=%d,y=%d)",n,labels[n].string,
	      labels[n].x,labels[n].y);
      item[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    }

  item[m]=NULL;


  list=XmCreateSelectionDialogVa(w,"Line Header",
				 XmNlistVisibleItemCount,25,
				 XmNlistLabelString,XMstr("List of Labels"),
				 XmNdialogTitle,XMstr("Rename Labels"),
				 NULL);
  if (m!=0) {
    XtVaSetValues(list,
		  XmNlistItems,item,
		  XmNlistItemCount,m,
		  NULL);
  }

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=list;
  message->id=id;
  XtAddCallback(list,XmNhelpCallback,helpCB,"label_rename.help");
  XtAddCallback(list,XmNokCallback,rename_label_valueCB,message);
  XtAddCallback(list,XmNcancelCallback,destroyCB,list);

  for (n=0; n<m; n++)
    XmStringFree(item[n]);

  XtUnmanageChild(XmSelectionBoxGetChild(list,XmDIALOG_APPLY_BUTTON));
}


/*
  This function renames a label.
*/
void rename_label_valueCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct *CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  ClientData *message1;
  Widget prompt;
  char *str;
  int error;
  long id,label_id;	/* RJM: handle 64-bit architectures */

  id=message->id;

				/* Get input from selection box. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

				/* Check if there was a selection. */
  if (! *str) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

				/* Get label id number. */
  error=sscanf(str,"%d ",&label_id);
  XtFree(str);

  if (error==1) {
    
    prompt=XmCreatePromptDialogVa(xdisplay[id].window,"Scaling Values",
				  XmNdialogTitle,XMstr("Rename Label"),
				  XmNselectionLabelString,
				  XMstr("New name for label"),
				  NULL);

    message1=(ClientData *)malloc(sizeof(ClientData));
    message1->w=prompt;
    message1->id=label_id;
    XmRemoveTabGroup(prompt);
    XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_TEXT));
    XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_HELP_BUTTON));
    
    XtAddCallback(prompt,XmNokCallback,renameCB,message1);
    XtAddCallback(prompt,XmNokCallback,refresh_imageCB,(XtPointer)id);
    XtAddCallback(prompt,XmNcancelCallback,destroyCB,prompt);
  }
  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}



void renameCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct *CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  int current_label;
  char *str;

  current_label=message->id;

                                /* Get scale factors. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);
 
  if (! *str) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

  labels[current_label].string=(char *)malloc((strlen(str)+1)*sizeof(char));
  strcpy(labels[current_label].string,str);
  XtFree(str);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function display a selection box
  of all the labels. The user click on
  one to move it.
*/
void move_labelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int m,n;
  long id;	/* RJM: handle 64-bit architectures */
  Widget list;
  XmString item[MAX_LABELS+1];
  ClientData *message;

  id=(long)client_data;

  m=0;
  for (n=0; n<MAX_LABELS; n++) 
    if ((labels[n].id==id)&&(labels[n].init==-1)) {
      sprintf(buf,"%d %s (x=%d,y=%d)",n,labels[n].string,
	      labels[n].x,labels[n].y);
      item[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    }

  item[m]=NULL;


  list=XmCreateSelectionDialogVa(w,"Line Header",
				 XmNlistVisibleItemCount,25,
				 XmNlistLabelString,XMstr("List of Labels"),
				 XmNdialogTitle,XMstr("Move Labels"),
				 NULL);
  if (m!=0) {
    XtVaSetValues(list,
		  XmNlistItems,item,
		  XmNlistItemCount,m,
		  NULL);
  }

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=list;
  message->id=id;
  XtAddCallback(list,XmNhelpCallback,helpCB,"label_move.help");
  XtAddCallback(list,XmNokCallback,move_label_valueCB,message);
  XtAddCallback(list,XmNcancelCallback,destroyCB,list);

  for (n=0; n<m; n++)
    XmStringFree(item[n]);

  XtUnmanageChild(XmSelectionBoxGetChild(list,XmDIALOG_APPLY_BUTTON));
}


/*
  This function moves a label.
*/
void move_label_valueCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct *CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  char *str;
  int n,error;
  long id;	/* RJM: handle 64-bit architectures */

  id=message->id;

				/* Get input from selection box. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

				/* Check if there was a selection. */
  if (! *str) { 
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

  old_mode=xdisplay[id].mode;
				/* Put mouse into label mode. */
  xdisplay[id].mode=14;
  set_mode_label(14,id);

				/* Get label id number. */
  error=sscanf(str,"%d ",&n);
  XtFree(str);

  if (error==1) {
    current_label=n;
  }

  expose_image(id);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function display a selection box
  of all the labels. The user click on
  one to copy it.
*/
void copy_labelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int m,n;
  long id;	/* RJM: handle 64-bit architectures */
  Widget list;
  XmString item[MAX_LABELS+1];
  ClientData *message;

  id=(long)client_data;

  m=0;
  for (n=0; n<MAX_LABELS; n++) 
    if ((labels[n].id==id)&&(labels[n].init==-1)) {
      sprintf(buf,"%d %s (x=%d,y=%d)",n,labels[n].string,
	      labels[n].x,labels[n].y);
      item[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    }

  item[m]=NULL;


  list=XmCreateSelectionDialogVa(w,"Line Header",
				 XmNlistVisibleItemCount,25,
				 XmNlistLabelString,XMstr("List of Labels"),
				 XmNdialogTitle,XMstr("Copy Labels"),
				 NULL);
  if (m!=0) {
    XtVaSetValues(list,
		  XmNlistItems,item,
		  XmNlistItemCount,m,
		  NULL);
  }

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=list;
  message->id=id;
  XtAddCallback(list,XmNhelpCallback,helpCB,"label_copy.help");
  XtAddCallback(list,XmNokCallback,copy_label_valueCB,message);
  XtAddCallback(list,XmNcancelCallback,destroyCB,list);

  for (n=0; n<m; n++)
    XmStringFree(item[n]);

  XtUnmanageChild(XmSelectionBoxGetChild(list,XmDIALOG_APPLY_BUTTON));
}


/*
  This function copies a label.
*/
void copy_label_valueCB(Widget w, XtPointer client_data, XtPointer call_data ) 
{
  XmSelectionBoxCallbackStruct *CBst = (XmSelectionBoxCallbackStruct*)call_data;

  ClientData *message=(ClientData *)client_data;
  char *str;
  int n,error;
  long id;	/* RJM: handle 64-bit architectures */

  id=message->id;

				/* Get input from selection box. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

				/* Check if there was a selection. */
  if (! *str) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

  old_mode=xdisplay[id].mode;
				/* Put mouse into label mode. */
  xdisplay[id].mode=14;
  set_mode_label(14,id);

				/* Get label id number. */
  error=sscanf(str,"%d ",&n);
  XtFree(str);

  if (error==1) {
				/* Get next available label id. */
    current_label=next_label();

				/* Set some initial parameters. */
    labels[current_label].init=(-1);
    labels[current_label].id=labels[n].id;
    labels[current_label].color=xdisplay[id].pick_color;
    labels[current_label].string=(char *)malloc((strlen(labels[n].string)+1)
						*sizeof(char));
    strcpy(labels[current_label].string,labels[n].string);
    strcpy(labels[current_label].font,labels[n].font);
    labels[current_label].type=labels[n].type;
  }

  expose_image(id);
  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}



/*
  This function destroys all the
  labels associated with id.
*/
void destroy_labels(long id)
{
  int n;

  for (n=0; n<MAX_LABELS; n++) 
    if ((labels[n].id==id)&&(labels[n].init==-1)) {
      labels[n].init=0;
      labels[n].x=0;
      labels[n].y=0;
      if(labels[n].string)
        free(labels[n].string);
      labels[n].string=NULL;
    }
}


/*
  This function return the next available 
  id for creating a new label.
*/
int next_label(void)
{
  int n;
				/* Search through label id for an empty one. */
  for (n=0; n<MAX_LABELS; n++)
    if (labels[n].init==0) {
      labels[n].init=-2;
      return(n);
    }

				/* Too many labels. */
  error_message("Too many labels being display.");

  return(0);
}



/*
  This function saves out the window labels.
*/
void save_labels(char *filename, long id)
{
  FILE *out;
  int n;

  out=fopen(filename,"w");

  for (n=0; n<MAX_LABELS; n++)
    if ((labels[n].id==id)&&(labels[n].init==-1)) {
      fprintf(out,"Text: %d %d %d %s %d\n",labels[n].x,labels[n].y,
	      (int)labels[n].color,labels[n].font,labels[n].type);
      strcpy(buf,labels[n].string);
      fputs(buf,out);
      fprintf(out,"\n");
    }
  fclose(out);
}



/*
  This function loads in the window labels.
*/
void load_labels(char *filename, long id)
{
  FILE *in;
  char *error;
  int n;

  in=fopen(filename,"r");


  error=fgets(buf,1024,in);
  while (error!=NULL) {
    n=next_label();
    sscanf(buf,"Text: %d %d %ld %s %d",&labels[n].x,&labels[n].y,
	   &labels[n].color,labels[n].font,&labels[n].type);
    labels[n].init=(-1);
    labels[n].id=id;
    error=fgets(buf,1024,in);
    buf[strlen(buf)-1] = '\0';
    labels[n].string=(char *)malloc((strlen(buf)+1)*sizeof(char));
    strcpy(labels[n].string,buf);
    error=fgets(buf,1024,in);
  }    
    
  fclose(in);
}





