/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  loading image files.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
/* #ifdef SUN */	/* RJM: commented out */
#if defined(sun)
#include <rasterfile.h>
#else
#include "rasterfile.h"
#endif

#include <ctype.h>      /* isascii */
#include "xdisplayP.h"
#include "prototyping.h"
#include <localsys.h>
#include "ut_defs.h"

extern int window_list[MAX_IMAGES],list_count;

static void	loadImageTraceH( String, String, int, long);

static Widget text_x=NULL;
static Widget text_y=NULL;
static Widget list_image=NULL;
XmString item_image[MAX_IMAGES+1];
static Widget toggle_hidden=NULL;

Boolean hidden_flag=False;

				/* Filename of images. */
static int zoom_x,zoom_y;
char buf_file[MAX_IMAGES][1024];

void load_image(long id, char *filename)
{
  FILE *in;
  char *error,command[1024], fn[1024];
  int n,image_count,ierror,flag_value;
  int	nrecs, ntrcperrec, tottraces;

				/* Open header file. */
  in=fopen(filename,"r");
  if (in==NULL) {
    error_message("Can't open file.");
    return;
  }

				/* Parse buf with directory name. */
  strcpy(buf,filename);
  strcpy(&buf[strlen(buf)-4],"xsdI");
				/* Change to image directory. */
  chdir(buf);

  error=fgets(buf,1024,in);
  ierror=sscanf(buf,"%s",command);

  for (n=0; n<(int)strlen(command); n++)
    if (isascii(command[n])==0)
      ierror=0;

      
  if (ierror==0) {
    error_message("Error reading image file.");
    return;
  }

				/* Get next available window id. */
  image_count=next_image();

				/* Set some initial values for that window. */
  copy_attributes(image_count,id);
  xdisplay[image_count].axis_units[0]=1.0;
  xdisplay[image_count].axis_units[1]=1.0;
  xdisplay[image_count].axis_units[2]=1.0;
  xdisplay[image_count].init=-3;

				/* Load all the parameters. */
  while (error!=NULL) {
    if (strcmp(command,"File:")==0)
      sscanf(buf,"File: %s",xdisplay[image_count].filename);
    else if (strcmp(command,"Comment:")==0)
      sscanf(buf,"Comment: %s",xdisplay[image_count].comment);
    else if (strcmp(command,"Type:")==0)
      sscanf(buf,"Type: %s",xdisplay[image_count].type);
    else if (strcmp(command,"Sort:")==0)
      sscanf(buf,"Sort: %d",&xdisplay[image_count].sort); 
    else if (strcmp(command,"Axis:")==0)
    {
      sscanf(buf,"Axis: %d",&flag_value);
      xdisplay[image_count].axis_flag = flag_value?True:False;
    }
    else if (strcmp(command,"Dual:")==0)
    {
      sscanf(buf,"Dual: %d",&flag_value);
      xdisplay[image_count].dual_flag = flag_value?True:False;
    }
    else if (strcmp(command,"Record:")==0)
      sscanf(buf,"Record: %d %d %d %d ",&nrec[image_count],&srec[image_count],
	     &erec[image_count],&irec[image_count]);
    else if (strcmp(command,"Trace:")==0)
      sscanf(buf,"Trace: %d%d %d %d ",&ntrace[image_count],&strace[image_count],
	     &etrace[image_count],&itrace[image_count]);
    else if (strcmp(command,"Sample:")==0)
      sscanf(buf,"Sample: %d %d %d %d ",&nsamp[image_count],&ssamp[image_count],
	     &esamp[image_count],&isamp[image_count]);
    else if (strcmp(command,"Value:")==0)
      sscanf(buf,"Value: %d %e ",&xdisplay[image_count].offset,
	     &xdisplay[image_count].scalar);
    else if (strcmp(command,"Scale:")==0) {
      sscanf(buf,"Scale: %f %f ",&xdisplay[image_count].pick_x,
	     &xdisplay[image_count].pick_y);
      xdisplay[image_count].pick_x=1.0/xdisplay[image_count].pick_x;
      xdisplay[image_count].pick_y=1.0/xdisplay[image_count].pick_y;
    }
    else if (strcmp(command,"Units:")==0)
      sscanf(buf,"Units: %f %f %f %f %f %f ",&xdisplay[image_count].axis_units[0],&xdisplay[image_count].axis_units[1],&xdisplay[image_count].axis_units[2],&xdisplay[image_count].axis_offset[0],&xdisplay[image_count].axis_offset[1],&xdisplay[image_count].axis_offset[2]);
    else if (strcmp(command,"Time:")==0)
      sscanf(buf,"Time: %s",xdisplay[image_count].time);
    else if (strcmp(command,"Date:")==0)
      sscanf(buf,"Date: %s",xdisplay[image_count].date);
    else if (strcmp(command,"Image:")==0)
      sscanf(buf,"Image: %s ",&buf_file[image_count][0]);
    else if (strcmp(command,"Traces1:")==0)	/* RJM: added Traces[1,3] */
      sscanf(buf,"%*s %s",trace_data1);
    else if (strcmp(command,"FileTraces1:")==0)
    {
      sscanf(buf,"%*s %s",fn);
      nrecs = (erec[image_count]-srec[image_count]) / irec[image_count] + 1;
      ntrcperrec = (etrace[image_count]-strace[image_count]) / itrace[image_count] + 1;
      tottraces = nrecs * ntrcperrec;
      loadImageTraceH( fn, trace_data1, tottraces, image_count );
    }
    else if (strcmp(command,"Traces2:")==0)
      sscanf(buf,"%*s %s",trace_data2);
    else if (strcmp(command,"FileTraces2:")==0)
    {
      sscanf(buf,"%*s %s",fn);
      nrecs = (erec[image_count]-srec[image_count]) / irec[image_count] + 1;
      ntrcperrec = (etrace[image_count]-strace[image_count]) / itrace[image_count] + 1;
      tottraces = nrecs * ntrcperrec;
      loadImageTraceH( fn, trace_data2, tottraces, image_count );
    }
    else if (strcmp(command,"Traces3:")==0)
      sscanf(buf,"%*s %s",trace_data3);
    else if (strcmp(command,"FileTraces3:")==0)
    {
      sscanf(buf,"%*s %s",fn);
      nrecs = (erec[image_count]-srec[image_count]) / irec[image_count] + 1;
      ntrcperrec = (etrace[image_count]-strace[image_count]) / itrace[image_count] + 1;
      tottraces = nrecs * ntrcperrec;
      loadImageTraceH( fn, trace_data3, tottraces, image_count );
    }
    else if (strcmp(command,"End:")==0) {	/* End of a window. */
      strcpy(xdisplay[image_count].data1,trace_data1); /* RJM: added */
      strcpy(xdisplay[image_count].data2,trace_data2); /* RJM: added */
      strcpy(xdisplay[image_count].data3,trace_data3); /* RJM: added */

      image_count=next_image();
      copy_attributes(image_count,id);
      xdisplay[image_count].axis_units[0]=1.0;
      xdisplay[image_count].axis_units[1]=1.0;
      xdisplay[image_count].axis_units[2]=1.0;
      
      xdisplay[image_count].init=-3;
    }
    error=fgets(buf,1024,in);
    ierror=sscanf(buf,"%s",command);
    if (ierror==0) {
      error_message("Error reading image file.");
      return;
    }
  }
  xdisplay[image_count].init=0;
  fclose(in);
 
				/* Display the possible windows to load. */
  select_load();

  return;
}



/*
  This function display the windows
  available to be loaded.
*/
void select_load(void)
{
  Widget list_window;
  Widget list_form;
  Widget label;
  Widget frame;
  Widget row_column;
  Widget button;
  char buf_temp[1024];
  int n,m;
  ClientData *message;

  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*list_window=XtAppCreateShell("xsd","load",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  list_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(list_window);

  list_form=XmCreateFormVa(list_window,"form",
			   XmNmarginHeight,10,
			   XmNmarginWidth,10,
			   XmNwidth,MAX_WIDTH,
			   XmNdialogTitle,XMstr("Image List"),
			   XtNmanageChild,False,
			   NULL);
  XtAddCallback(list_form,XmNhelpCallback,helpCB,"images.help");

  label=XmCreateLabelVa(list_form,"Image List (Double click on an item to delete from list)",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
  
  frame=XmCreateFrameVa(list_form,"frame",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,label,
			XmNrightAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);

  m=0;
  for (n=0; n<MAX_IMAGES; n++)
    if (xdisplay[n].init==-3) {
      window_title(buf,n);
      sprintf(buf_temp," %4.2f %4.2f ",1.0/xdisplay[n].pick_x,1.0/xdisplay[n].pick_y);
      strcat(buf,buf_temp);
      strcat(buf,xdisplay[n].type);
      item_image[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    }
  item_image[m]=NULL;
    
  list_image=XmCreateScrolledListVa(frame,"Window List",
				    XmNlistSizePolicy,XmCONSTANT,
				    XmNvisibleItemCount,10,
				    NULL);
  XtAddCallback(list_image,XmNdefaultActionCallback,delete_itemCB,0);
  if (m!=0) {
    XtVaSetValues(list_image,
		  XmNitemCount,m,
		  XmNitems,item_image,
		  NULL);
  }

  for (n=0; n<m; n++)
    XmStringFree(item_image[n]);
  
  row_column=XmCreateRowColumnVa(list_form,"row_column",
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,frame,
				 XmNleftAttachment,XmATTACH_FORM,
				 XmNbottomAttachment,XmATTACH_FORM,
				 XmNpacking,XmPACK_COLUMN,
				 XmNnumColumns,6,
				 XmNspacing,10,
				 NULL);

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=list_window;
  message->id=0;
  button=XmCreatePushButtonVa(row_column,"Load Images",NULL);
  XtAddCallback(button,XmNactivateCallback,loadingCB,message);

  button=XmCreatePushButtonVa(row_column," Cancel",NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,list_window);
  XtAddCallback(button,XmNactivateCallback,delete_allCB,list_window);
  
  toggle_hidden=XmCreateToggleButtonVa(row_column,"Hide Windows",NULL);
  XmToggleButtonSetState(toggle_hidden,hidden_flag,False);

  row_column=XmCreateRowColumnVa(list_form,"row_column",
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,frame,
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNbottomAttachment,XmATTACH_FORM,
				 XmNpacking,XmPACK_COLUMN,
				 XmNnumColumns,6,
				 XmNspacing,10,
				 NULL);

  label=XmCreateLabelVa(row_column,"Hor. Zoom",
			NULL);
  
  text_x=XmCreateTextVa(row_column,"text",
			XmNvalue,"1",
			XmNcolumns,5,
			NULL);
  
  label=XmCreateLabelVa(row_column,"Ver. Zoom",
			NULL);
  
  text_y=XmCreateTextVa(row_column,"text",
			XmNvalue,"1",
			XmNcolumns,5,
			NULL);
  
  XtManageChild(list_form);

  XtRealizeWidget(list_window);
}


/*
  This function deletes an item
  from the image retreive list.
*/
void delete_itemCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmListCallbackStruct	*CBst = (XmListCallbackStruct*)call_data;
  int junk;
  long id;	/* RJM: handle 64-bit architectures */
  char *str;

  XmStringGetLtoR(CBst->item,XmSTRING_DEFAULT_CHARSET,&str);
  sscanf(str,"%d Window: %d",&junk,&id);
  XtFree(str);
  xdisplay[id].init=0;

  XmListDeletePos(list_image,CBst->item_position);
}



/*
  This deletes all the windows
  form the retreival list.
*/
void delete_allCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;

  for (n=0; n<MAX_IMAGES; n++)
    if (xdisplay[n].init==-3)
      xdisplay[n].init=0;
}


/*
  This function loads and displays
  each image.
*/
void loadingCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message=(ClientData *)client_data;
  Widget load_window;
  Widget main_window;
  Widget load_form;
  int n,image_count,width_temp,height_temp;
  char *str;

  XtSetArg(args[0],XmNvalue,&str);
  XtGetValues(text_x,args,1);
  sscanf(str,"%d",&zoom_x);
  XtFree(str);

  XtGetValues(text_y,args,1);
  sscanf(str,"%d",&zoom_y);
  XtFree(str);

  hidden_flag=XmToggleButtonGetState(toggle_hidden);
  
  for (image_count=0; image_count<MAX_IMAGES; image_count++) 
    if (xdisplay[image_count].init==-3)
				/* Check for error when reading image. */
      if (load_raster(image_count,&width_temp,&height_temp)==-1)
	xdisplay[image_count].init=0; /* Make id available again. */
      else
      {
        if( traceH[image_count] == NULL )  /* RJM moved here from load_raster */
	  traceH[image_count] = (unsigned char *)calloc( width_temp,
		256 * sizeof( unsigned char ) );
	else	/* RJM: added realloc: */
	{
	  (void)fprintf( stderr, "loadingCB: traceH[%d] was not null,=%x, realloc'ing to %d*256bytes\n", image_count, traceH[image_count], width_temp );
	  traceH[image_count] = (unsigned char *)realloc( traceH[image_count],
		width_temp * 256 * sizeof( unsigned char ) );
	}

	xdisplay[image_count].pick_x/=zoom_x;
	xdisplay[image_count].pick_y/=zoom_y;

	window_title(buf,image_count);	/* RJM */

	n=0;
	XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
	XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
	XtSetArg(args[n],XmNtitle,buf); n++;	/* RJM */
	if (hidden_flag) {
	  XtSetArg(args[n],XmNmappedWhenManaged,False); n++;
	}
	XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
        XtSetArg(args[n],XtNvisual,visual); n++;
        XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*	load_window=XtAppCreateShell("xsd","load",
				     topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
	load_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
				     topLevelShellWidgetClass,display,args,n);
	quit_frame(load_window);
	
	strcpy(xdisplay[image_count].type,"Image");
	
	xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
						 0,(char *)raster[image_count],
						 width_temp,height_temp,screenDepth,0);
	
	main_window=XmCreateMainWindowVa(load_window,"child_form",
					 XmNshowSeparator,True,
					 NULL);

	screen_size(xdisplay[image_count].parent,&width_temp,&height_temp);
	
/*	window_title(buf,image_count);
	XtVaSetValues(main_window,	RJM: wrong window dude
		      XmNtitle,buf,
		      NULL);
*/

	load_form=XmCreateFormVa(main_window,"form",
				 XmNwidth,width_temp,
				 XmNheight,height_temp+MIN_HEIGHT,
				 NULL);
	
                                /* Indicate general mode. */
	xdisplay[image_count].mode=1;

	app_menus(load_form,image_count,xdisplay[image_count].dual_flag);
	
	xdisplay_image(image_count,load_window,load_form,
		       width_temp,height_temp);
	
	XtRealizeWidget(load_window);
      }
  if (hidden_flag) {
    msg_message("Done loading images");
  }
  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function loads the image file.
*/
int load_raster(long id, int *width, int *height)
{
#ifdef CRAY 
  int buf1[4];
#else
  struct rasterfile header;
#endif
  int n,length,in;
  char trash[1];
  int x1,y1,skip,width_temp;
  unsigned char *ptr1,*ptr2,*ras_temp;

				/* Open image file. */
  in=open(&buf_file[id][0],O_RDONLY);
  if (in==-1)
    return(-1);

#ifdef CRAY
				/* Read header and compute width, 
				   height and length. */
  read(in,buf1,32);
  *width=buf1[0]&0xffffffff;
  *height=buf1[1]>>32;
  length=buf1[3]&0xffffffff;
#else
				/* Read header and compute width, 
				   height and length. */
  read(in,&header,sizeof(header));

#ifdef LINUXSYSTEM
fprintf(stderr,"LINUX SYSTEM detected\n");
  /* DWN 1/6/99 swap bytes on linux so it appears in sun byte order */
  *width=ntohl(header.ras_width);
  *height=ntohl(header.ras_height);
  length=ntohl(header.ras_maplength);
#else
  *width=header.ras_width;
  *height=header.ras_height;
  length=header.ras_maplength;
#endif 

#endif 

				/* Get space for image. */
  raster[id]=(unsigned char *)malloc((*width)*(*height)*sizeof(char));

				/* Skip over colormap. */
  lseek(in,length,1);

				/* Special case for odd widths. */
  if (*width%2 ==0)
    read(in,raster[id],(*width)*(*height)*sizeof(char));
  else
    for (n=0; n<*height; n++) {
      read(in,(raster[id]+n*(*width)),*width);
      read(in,trash,1);
    }

  if ((zoom_x!=1)&&(zoom_y!=0)) {
    width_temp=*width*zoom_x;

				/* Get space for image. */
    ras_temp=(unsigned char *)malloc(width_temp*(*height*zoom_y)*sizeof(char));
    
    ptr1=ras_temp;
    ptr2=raster[id];
    
    for (y1=0; y1<*height; y1++) {
      for (x1=0; x1<*width; x1++) {
	for (skip=0; skip<zoom_x; skip++) {
	  *(ptr1)=*(ptr2);
	  ptr1++;
	}
	ptr2++;
      }
      for (skip=1; skip<zoom_y; skip++) {
	memcpy((char *)ptr1,(char *)ptr1-width_temp,sizeof(char)*width_temp);
	ptr1+=width_temp;
      }
    }
    *width=width_temp;
    *height*=zoom_y;
    if(raster[id])
      free((char*)raster[id]);
    raster[id]=ras_temp;
  }

  close(in);

  return(0);
}


static void loadImageTraceH( String fn, String name, int tottraces, long id )
{
	int	fd, toffset, i, *vec;

	if( (fd = open( fn, 0 )) == -1 )
	{
		(void)fprintf( stderr, "Can't open '%s'\n", fn );
		return;
	}

	vec = (int*)malloc( tottraces * sizeof( int ) );
	read( fd, vec, tottraces * sizeof( int ) );
	close( fd );

#ifdef LINUXSYSTEM
/* DWN 1/6/99 swap on Linux from Sun byte order */
          for (i=0; i<tottraces; i++) vec[i]=ntohl(vec[i]);
#endif

	if( traceH[id] == NULL )
		traceH[id]=(unsigned char *)calloc( tottraces,
			256 * sizeof(unsigned char) );

	for( toffset = i = 0; toffset < tottraces*256; toffset+=256, i++ )
                C_SAVEW( (int*)(traceH[id]+toffset), name, (char*)(long)vec[i], 1 );

	if( vec )
	  free( (char *)vec );
}
