/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  creating the main menus.
*/

#include "xdisplayP.h"
#include "prototyping.h"
#include "ut_defs.h"

extern Boolean disco_flag;
extern Widget draw_vel;
extern XtIntervalId time_out;

Widget model_window;

/*
  This function build the model 
  window.
*/
void build_model(long id, char *vel_filename)
{
  Widget model_form;
  Widget main_window;
  int image_count,m,n,error,ntrc,nsmp;
  int width_temp,height_temp;
  short temp;
  char filename[1024],*header;
  struct location_struct location;
  struct values_struct values;
  long tmp;

/* fprintf( stderr, "build_model:vel_filename='%s'\n", vel_filename ); */
  if (model_mode!=0) {		/* If there is already a model window */
    if (xdisplay[model_mode].hide_flag) {
                                /* If window is hidden map it. */
      XtMapWidget(xdisplay[model_mode].window);
      xdisplay[model_mode].hide_flag=False;
    } else {
                                /* If window is not hidden unmap then map. */
      XtUnmapWidget(xdisplay[model_mode].window);
      XtMapWidget(xdisplay[model_mode].window);
    }
    return;
  }

  changed_picks=False;		/* Bodies are going to be regenerated anyway */

  image_count=next_image();

  model_mode=image_count;	/* Set flag indicating an animation
				   window is being displayed. */
/* fprintf( stderr, "build_model:set model_mode to %d\n", model_mode ); */


  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*model_window=XtAppCreateShell("xsd","model",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  model_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(model_window);

  copy_attributes(image_count,id);

  strcpy(xdisplay[image_count].filename,vel_filename);

  if (strlen(xdisplay[image_count].filename)!=0) {
    if( strstr( ServerName, "dds" ) )
	if( !autoFormatDetectionWidget
	||  XmToggleButtonGetState( autoFormatDetectionWidget ) )
		amoco_detect_format();
	else
		specifyFormat( top_level, xdisplay[image_count].filename );

    error=amoco_check_server(buf);
    if (error==-1) {
#ifndef NO_TIME_OUT
      XtRemoveTimeOut(time_out);  /* abort error dialog pop-up */
#endif
      error_message(buf);
      error_message("Server error (8). Try restarting server.");
      return;
    }
    error=amoco_read_line_header(&header,xdisplay[image_count].filename);
    if (error < 0) {
      reportDSerror( error );

      if( model_window ) {	/* RJM: added check */
/*      XtDestroyWidget(model_window); RJM: deleting a model window no longer
        calls the destroyCallback via xdisplay_image. Hence, do explicitly:
*/
	if( xdisplay[model_mode].window != model_window )
	  (void)fprintf( stderr, "xdisplay[%d].window(%x)!= model_window(%x)\n",
		model_mode, xdisplay[model_mode].window, model_window );
        tmp = model_mode;
        delete_windowCB(NULL, (XtPointer)tmp, NULL );  /* RJM: added */
        model_window=NULL;
      }
      model_mode=0;
      return;
    }
    if (error==2) {
      error_message("Cannot use model build on disco data sets.");
      if( model_window ) {	/* RJM: added check */
/*      XtDestroyWidget(model_window); RJM: deleting a model window no longer
        calls the destroyCallback via xdisplay_image. Hence, do explicitly:
*/
	if( xdisplay[model_mode].window != model_window )
	  (void)fprintf( stderr, "xdisplay[%d].window(%x)!= model_window(%x)\n",
		model_mode, xdisplay[model_mode].window, model_window );
        tmp = model_mode;
        delete_windowCB(NULL, (XtPointer)tmp, NULL );  /* RJM: added */
        model_window=NULL;
      }
      model_mode=0;
      return;
    }
    C_SAVER((int*)header,"NumTrc",&ntrc,0);
    C_SAVER((int*)header,"NumSmp",&nsmp,0);
    if(header)
      free(header);
    model_width=ntrc/fill_skip;
    model_height=nsmp/fill_skip;
    real_width=ntrc;
    if (nsmp<real_height)
      model_height=real_height/fill_skip;
    else
      real_height=nsmp;
  }

  if (id!=0) {
				/* Round picks within round factor. */
    for (n=0; n<MAX_PICKS; n++)
                                /* Check if pick exists and is visible. */
      if ((picks[n].init==-1)&&(picks[n].size>1))
	for (m=0; m<picks[n].size; m+=picks[n].size-1) {
	  if (*(picks[n].record+m)==1) {
/*	    location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id); RJM */
	    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id?id:picks[n].id);
	    if (location.x<round_factor)
	      location.x=0;
	    if (location.x+1>(xdisplay[id].image->width-round_factor))
	      location.x=xdisplay[id].image->width+1;
/*	    values=get_values(location.x,location.y,id); RJM */
	    values=get_values(location.x,location.y,picks[n].id);
	    *(picks[n].record+m)=values.record;
	    *(picks[n].trace+m)=values.trace;
	  }
	}
  }

				/* Set window attributes. */
  xdisplay[image_count].flip_flag=xdisplay[id].flip_flag;
  xdisplay[image_count].pick_x=1.0;
  xdisplay[image_count].pick_y=1.0;
  nrec[image_count]=1;
  ntrace[image_count]=model_width;
  nsamp[image_count]=model_height;
  srec[image_count]=1;
  erec[image_count]=1;
  irec[image_count]=1;
  strace[image_count]=1;
  etrace[image_count]=model_width*fill_skip;
/*   etrace[image_count]=real_width; */
  itrace[image_count]=fill_skip;
  ssamp[image_count]=1;
  esamp[image_count]=model_height*fill_skip;
  isamp[image_count]=fill_skip;

				/* Set the color range. */
  scale_range(global_min,global_max,image_count);

  width_temp=model_width*fill_skip;
  height_temp=model_height*fill_skip;

                                    /* Allocate memory for data. */
  raster[image_count]=(unsigned char *)malloc(width_temp*height_temp*sizeof(char));

                                /* Allocate memory for trace header. */
/*traceH[image_count]=(unsigned char *)malloc(width_temp*256*sizeof(char));
  memset((char *)traceH[image_count],0,width_temp*256*sizeof(char));
RJM */
  traceH[image_count]=(unsigned char *)calloc(width_temp, 256*sizeof(char));

				/* Smaller version of raster image. */
  vel_raster=(unsigned char *)malloc(model_width*model_height*sizeof(char));

				/* Set memory to white. */
  memset((char *)raster[image_count],(int)(white&0xffffffff),width_temp*height_temp*sizeof(char));
  memset((char *)vel_raster,(int)(white&0xffffffff),model_width*model_height*sizeof(char));

				/* Check for a backdrop. */
  if (strlen(xdisplay[image_count].filename)==0) {
    if(vel_old)
      free((char*)vel_old);
    vel_old=(unsigned short *)malloc(model_width*model_height*sizeof(unsigned short));
    if(vel_tape)
      free((char*)vel_tape);
    vel_tape=(unsigned short *)malloc(model_width*model_height*sizeof(unsigned short));
    for (n=0; n<model_width*model_height; n++) {
      *(vel_old+n)=0;
      *(vel_tape+n)=0;
    }
  } else {
				/* Read in the backdrop. */
    error=amoco_check_server(buf);
    if (error==-1) {
#ifndef NO_TIME_OUT
      XtRemoveTimeOut(time_out);  /* abort error dialog pop-up */
#endif
      error_message(buf);
      error_message("Server error (9). Try restarting server.");
      return;
    }
    if(vel_old)
      free((char*)vel_old);
    vel_old=(unsigned short *)malloc(model_width*model_height*sizeof(unsigned short));
    if(vel_tape)
      free((char*)vel_tape);
    vel_tape=(unsigned short *)malloc(model_width*model_height*sizeof(unsigned short));
 
    error=amoco_read_data((unsigned char *)vel_tape,traceH[image_count],
			  xdisplay[image_count].filename,srec[image_count],
			  erec[image_count],irec[image_count],
			  strace[image_count],etrace[image_count],
			  itrace[image_count],ssamp[image_count],
			  esamp[image_count],isamp[image_count],
			  4,0, 1.0, 0.0, 0,False,False);
    if (error < 0) {
      reportDSerror( error );
      return;
    }
    
                                /* Flip vtap. */
    if (xdisplay[image_count].flip_flag) {
      for (m=0; m<model_height; m++)
        for (n=0; n<(model_width/2); n++) {
          temp=*(vel_tape+n+m*model_width);
          *(vel_tape+n+m*model_width)=*(vel_tape+(model_width-n-1)+m*model_width);
          *(vel_tape+(model_width-n-1)+m*model_width)=temp;
        }
    }
      
    memcpy((char *)vel_old,(char *)vel_tape,model_width*model_height*sizeof(unsigned short));
    
  }

  itrace[image_count]=1;
  isamp[image_count]=1;

  model_index=(short *)malloc(model_width*model_height*sizeof(short));
  
  xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
                                           0,(char *)raster[image_count],
					width_temp, height_temp,screenDepth,0);


				/* Find best screen size. */
  screen_size(id,&width_temp,&height_temp);

  main_window=XmCreateMainWindowVa(model_window,"child_form",
				   XmNshowSeparator,True,
				   NULL);

				/* Mark window as a Model. */
  strcpy(xdisplay[image_count].type,"Model");
  window_title(buf,image_count);

  XtVaSetValues(model_window,
		XmNtitle,buf,
		NULL);

  model_form=XmCreateFormVa(main_window,"main",
			    XmNwidth,width_temp,
			    XmNheight,height_temp+MIN_HEIGHT,
			    NULL);

				/* Indicate model mode. */
  xdisplay[image_count].mode=18;
  set_mode_label(18,image_count);

				/* Create drop-down menus. */
  model_menus(main_window,model_form,image_count,0);

				/* Create image. */
  xdisplay_image(image_count,model_window,model_form,
                 width_temp,height_temp);

  XtRealizeWidget(model_window);

                                /* The enviroment variable XSD_DIR
                                   contains the path to the color files. */

  /* DWN 10/19/97 change XSD_DIR to XSD_COLOR_DIR */

  if (getenv("XSD_DIR")==NULL) {
    error_message("Error reading color file.");
    return;
  }
 
                                /* Get path of the color files. */
  strcpy(filename,getenv("XSD_COLOR_DIR"));
/* DWN 10/19/97
  strcat(filename,"color/velocity");
*/
  strcat(filename,"velocity");
  load_color(image_count);
  load_color_file(filename,image_count);

  tmp = image_count;
  XtAddCallback(draw_vel,XmNexposeCallback,expose_velCB,(XtPointer)tmp);

  XtAddEventHandler(draw_vel,ButtonPressMask,False,button_push_velEH,(XtPointer)tmp);
  XtAddEventHandler(draw_vel,ButtonReleaseMask,False,button_release_velEH,(XtPointer)tmp);
  XtAddEventHandler(draw_vel,PointerMotionMask,False,moving_mouse_velEH,(XtPointer)tmp);

  XmUpdateDisplay(model_window);

				/* Generate bodies. */
  regenerateCB(model_window,(XtPointer)tmp,0);
}


/*
  This function returns the pixel
  value at location x,y.
*/
Pixel pixelread(int x, int y)
{
  Pixel tmp;

  if ((x<0)||(y<0)||
      (x>(model_width-1))||
      (y>(model_height-1))) 
    return 0L;
  tmp = *(vel_raster+x+y*model_width);

  return(tmp);
}


/*
  This function store a pixel
  at location x,y.
*/
void pixelwrite(int x, int y, Pixel nv)
{
  if ((x<0)||(y<0)||
      (x>model_width)||
      (y>model_height)) 
    return;

  *(vel_raster+x+y*model_width) = nv & 0xffffffff;
}


/*
  This function return the model
  index at location x,y.
*/
int modelread(int x, int y)
{
  if ((x<0)||(y<0)||
      (x>model_width)||
      (y>model_height)) 
    return(-1);
  return(*(model_index+x+y*model_width));
}


/*
  This function store the index
  value at location x,y.
*/
void modelwrite(int x, int y, int nv)
{
  if ((x<0)||(y<0)||
      (x>model_width)||
      (y>model_height)) 
    return;

  *(model_index+x+y*model_width)=nv;
}
