/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  inputing, saving ,loading picks.
*/

#include "xdisplayP.h"
#include "prototyping.h"
#include "ut_defs.h"

extern char *filename;
extern int current_segment;
extern int amoco_offset(void);
extern char theader[62][42];

struct values_struct get_values(int x, int y, long id);
struct location_struct get_location(int record, int trace, int sample, long id);
struct location_struct get_abs_location(int trace, int sample, long id);
static Widget sort_toggle=NULL;
static Widget honor_toggle=NULL;
static Widget agm_toggle=NULL;
static Widget pos_toggle=NULL;
static Widget neg_toggle=NULL;
static Widget text[6];
static Widget agm_text[4];
static Widget text_auto[3];
static Widget trace_value[62];
static Widget toggle_every=NULL;

FILE *out;
Boolean honor_flag;
static int start_x,start_y,end_x,end_y;
static int pick_x[MAX_P_LIST],pick_y[MAX_P_LIST];
static int pick_count=0;
static Boolean pick_flag=False;
static int auto_direction=1;
static int auto_incr=5;
static int auto_size=8;
static float auto_weight=0.0;
static float axis_units[3],axis_offset[3];
static Boolean sort_flag;

/*
  This function returns the
  values for the mouse location.
*/
void pick_meter(XEvent *event, long id, long id_anim)
{
  int x,y,data1,data2,data3,trace_offset,id_parent,width;
  float offset,scalar,temp;
  struct values_struct values;
  XmString xmstring;

				/* If seismic is interleave the seismic
				   value is invalid so set it to zero. */
  if (strcmp(xdisplay[id_anim].type,"Interleave")==0)
    id=xdisplay[id_anim].inter_parent;

				/* Compute offset for seismic value. */
/*offset=((end_color-start_color+1)/2+start_color); RJM: commented out */
  offset=(float)(end_color-start_color)/2+(int)start_color; /* RJM: unbias */
  offset+=(xdisplay[id_anim].offset*(int)(end_color-start_color+1))/100.0;

#ifdef DEBUG
  fprintf( stderr, "color offset=%f, offset=%f, xdisplay[%d].offset=%f\n", (float)((int)(end_color-start_color+1)/2+start_color), offset, id_anim, xdisplay[id_anim].offset );
#endif

				/* Compute scalar for seismic value. */
  scalar=100.0*xdisplay[id_anim].scalar;

#ifdef DEBUG
  fprintf( stderr, "scalar=%f, xdisplay[%d].scalar=%f\n", scalar, id_anim, xdisplay[id_anim].scalar);
#endif

  x=event->xbutton.x;
  y=event->xbutton.y;
  if (x>(xdisplay[id_anim].image->width-1)) x=xdisplay[id_anim].image->width-1;
  if (y>(xdisplay[id_anim].image->height-1)) y=xdisplay[id_anim].image->height-1;

				/* Compute the seismic value. */
  /* DWN 1/15/97 avoid division by zero - fixed for Murph */
  if (scalar==0.0)
    temp=0.0;
  else
    temp=((float)XGetPixel(xdisplay[id_anim].image,x,y)-offset)/scalar;


#ifdef DEBUG
  fprintf( stderr, "XGetPixel(xdisplay[%d].image,%d,%d)=%lu\n", id_anim, x, y, XGetPixel(xdisplay[id_anim].image,x,y) );
  fprintf( stderr, "temp[((float)XGetPixel(xdisplay[id_anim].image,x,y)-offset)/scalar]=%f\n", temp );
#endif

				/* Compute x and y. */
  x=(int)(xdisplay[id_anim].pick_x*event->xbutton.x);
/*x=(int)(xdisplay[id_anim].pick_x*event->xbutton.x+0.5); RJM: incorrect */
  y=(int)(xdisplay[id_anim].pick_y*event->xbutton.y);
/*y=(int)(xdisplay[id_anim].pick_y*event->xbutton.y+0.5); RJM: incorrect */

				/* Get record, trace, and sample. */
  values=get_values(x,y,id_anim);

  id_parent=xdisplay[id_anim].parent;

				/* Compute width. */
  width=(((erec[id_parent]-srec[id_parent])/irec[id_parent])+1)*
    (((etrace[id_parent]-strace[id_parent])/itrace[id_parent])+1);

				/* Find trace_offset for trace header. */
  if (xdisplay[id_anim].sort)
    trace_offset=256*((values.record-srec[id_parent])/irec[id_parent])+
      (((values.trace-strace[id_parent])/itrace[id_parent])*
       ceil((float)(erec[id_parent]-srec[id_parent]+1)/(float)irec[id_parent])*256);
  else
    trace_offset=256*((values.trace-strace[id_parent])/itrace[id_parent])+
      (((values.record-srec[id_parent])/irec[id_parent])*
       ceil((float)(etrace[id_parent]-strace[id_parent]+1)/(float)itrace[id_parent])*256);

				/* Make sure trace_offset is valid. */
  if (trace_offset>256*width)
    trace_offset=256*(width-1);

				/* Check if the data was a time slice. */
  if (ssamp[id_parent]!=esamp[id_parent]) {
    C_SAVER((int*)(traceH[id_parent]+trace_offset),xdisplay[id_anim].data1,&data1,1);
    C_SAVER((int*)(traceH[id_parent]+trace_offset),xdisplay[id_anim].data2,&data2,1);
    C_SAVER((int*)(traceH[id_parent]+trace_offset),xdisplay[id_anim].data3,&data3,1);
  } else {
				/* No trace header available for time slice. */
    data1=0;
    data2=0;
    data3=0;
  }

				/* Compute record, trace and sample 
				   according to scale and offset. */
  values.record=xdisplay[id_anim].axis_units[0]*values.record+
    xdisplay[id_anim].axis_offset[0];
  values.trace=xdisplay[id_anim].axis_units[1]*values.trace+
    xdisplay[id_anim].axis_offset[1];
  values.sample=xdisplay[id_anim].axis_units[2]*values.sample+
    xdisplay[id_anim].axis_offset[2];
  values.value=temp;

  if (xdisplay[id_anim].mode==18) {	/* Get 16-bit true velocity value. */
    if (x>=xdisplay[id_anim].image->width) x=xdisplay[id_anim].image->width-1;
    if (y>=xdisplay[id_anim].image->height) y=xdisplay[id_anim].image->height-1;
    values.value=*(vel_tape+(int)(x/fill_skip)+(int)(y/fill_skip)*model_width);
  }

  if (xdisplay[id_anim].mode==28) {	/* Get 16-bit true velocity value. */
    if (x>=xdisplay[id_anim].image->width) x=xdisplay[id_anim].image->width-1;
    if (y>=xdisplay[id_anim].image->height) y=xdisplay[id_anim].image->height-1;
    values.value=*(vel_tape+x+y*etrace[id_anim]);
  }


  if (values.value<0) 
    if( xdisplay[id_anim].swap_flag )	/* RJM */
      sprintf(buf,"%6d %6d  %6d %1.3e  %6d  %6d  %6d",values.record,
	    values.sample,values.trace,values.value,data1,data2,data3);
    else
      sprintf(buf,"%6d %6d  %6d %1.3e  %6d  %6d  %6d",values.record,
	    values.trace,values.sample,values.value,data1,data2,data3);
  else
    if( xdisplay[id_anim].swap_flag )	/* RJM */
      sprintf(buf,"%6d %6d  %6d  %1.3e  %6d  %6d  %6d",values.record,
	    values.sample,values.trace,values.value,data1,data2,data3);
    else
      sprintf(buf,"%6d %6d  %6d  %1.3e  %6d  %6d  %6d",values.record,
	    values.trace,values.sample,values.value,data1,data2,data3);

  
				/* Update the value on the main window. */
  XtVaSetValues(xdisplay[id].values,
		XmNlabelString,XMstr(buf),
		NULL);
}


/*
  This function returns the
  values for the mouse location.
*/
void moving_pick(XEvent *event, long id, long id_anim)
{
  int x,y,data1,data2,data3,trace_offset,id_parent,width;
  float offset,scalar,temp;
  struct values_struct values;

				/* If seismic is interleave the seismic
				   value is invalid so set it to zero. */
  if (strcmp(xdisplay[id_anim].type,"Interleave")==0)
    id=xdisplay[id_anim].inter_parent;

				/* Compute offset for seismic value. */
/*offset=((end_color-start_color+1)/2+start_color); RJM: commented out */
  offset=(float)(end_color-start_color)/2+(int)start_color; /* RJM: unbias */
  offset+=(xdisplay[id_anim].offset*(int)(end_color-start_color+1))/100.0;

				/* Compute scalar for seismic value. */
  scalar=100.0*xdisplay[id_anim].scalar;

  x=event->xbutton.x;
  y=event->xbutton.y;
  if (x>(xdisplay[id_anim].image->width-1)) x=xdisplay[id_anim].image->width-1;
  if (y>(xdisplay[id_anim].image->height-1)) y=xdisplay[id_anim].image->height-1;

				/* Compute the seismic value. */
  /* DWN 1/15/97 avoid division by zero - fixed for Murph */
  if (scalar==0.0)
    temp=0.0;
  else
    temp=((float)XGetPixel(xdisplay[id_anim].image,x,y)-offset)/scalar;

				/* Compute x and y. */
  x=(int)(xdisplay[id_anim].pick_x*event->xbutton.x);
/*x=(int)(xdisplay[id_anim].pick_x*event->xbutton.x+0.5); RJM: incorrect */
  y=(int)(xdisplay[id_anim].pick_y*event->xbutton.y);
/*y=(int)(xdisplay[id_anim].pick_y*event->xbutton.y+0.5); RJM: incorrect */

				/* Get record, trace, and sample. */
  values=get_values(x,y,id_anim);

  id_parent=xdisplay[id_anim].parent;

				/* Compute width. */
  width=(((erec[id_parent]-srec[id_parent])/irec[id_parent])+1)*
    (((etrace[id_parent]-strace[id_parent])/itrace[id_parent])+1);

				/* Find trace_offset for trace header. */
  if (xdisplay[id_anim].sort)
    trace_offset=256*((values.record-srec[id_parent])/irec[id_parent])+
      (((values.trace-strace[id_parent])/itrace[id_parent])*
       ceil((float)(erec[id_parent]-srec[id_parent]+1)/(float)irec[id_parent])*256);
  else
    trace_offset=256*((values.trace-strace[id_parent])/itrace[id_parent])+
      (((values.record-srec[id_parent])/irec[id_parent])*
       ceil((float)(etrace[id_parent]-strace[id_parent]+1)/(float)itrace[id_parent])*256);

				/* Make sure trace_offset is valid. */
  if (trace_offset>256*width)
    trace_offset=256*(width-1);

				/* Check if the data was a time slice. */
  if (ssamp[id_parent]!=esamp[id_parent]) {
    C_SAVER((int*)(traceH[id_parent]+trace_offset),xdisplay[id_anim].data1,&data1,1);
    C_SAVER((int*)(traceH[id_parent]+trace_offset),xdisplay[id_anim].data2,&data2,1);
    C_SAVER((int*)(traceH[id_parent]+trace_offset),xdisplay[id_anim].data3,&data3,1);
  } else {
				/* No trace header available for time slice. */
    data1=0;
    data2=0;
    data3=0;
  }
/* fprintf( stderr, "traceH[id_parent]=%x, traceH[id_anim]=%x, data1=%d\n", traceH[id_parent], traceH[id_anim], data1 ); */

				/* Compute record, trace and sample 
				   according to scale and offset. */
  values.record=xdisplay[id_anim].axis_units[0]*values.record+
    xdisplay[id_anim].axis_offset[0];
  values.trace=xdisplay[id_anim].axis_units[1]*values.trace+
    xdisplay[id_anim].axis_offset[1];
  values.sample=xdisplay[id_anim].axis_units[2]*values.sample+
    xdisplay[id_anim].axis_offset[2];
  values.value=temp;

  if (xdisplay[id_anim].mode==18) {	/* Get 16-bit true velocity value. */
    if (x>=xdisplay[id_anim].image->width) x=xdisplay[id_anim].image->width-1;
    if (y>=xdisplay[id_anim].image->height) y=xdisplay[id_anim].image->height-1;
    values.value=*(vel_tape+(int)(x/fill_skip)+(int)(y/fill_skip)*model_width);
  }

  if (xdisplay[id_anim].mode==28) {	/* Get 16-bit true velocity value. */
    if (x>=xdisplay[id_anim].image->width) x=xdisplay[id_anim].image->width-1;
    if (y>=xdisplay[id_anim].image->height) y=xdisplay[id_anim].image->height-1;
    values.value=*(vel_tape+x+y*etrace[id_anim]);
  }

  if (values.value<0) 
    if( xdisplay[id_anim].swap_flag )	/* RJM */
      sprintf(buf,"%6d %6d  %6d %1.3e  %6d  %6d  %6d",values.record,
	    values.sample,values.trace,values.value,data1,data2,data3);
    else
      sprintf(buf,"%6d %6d  %6d %1.3e  %6d  %6d  %6d",values.record,
	    values.trace,values.sample,values.value,data1,data2,data3);
  else
    if( xdisplay[id_anim].swap_flag )	/* RJM */
      sprintf(buf,"%6d %6d  %6d  %1.3e  %6d  %6d  %6d",values.record,
	    values.sample,values.trace,values.value,data1,data2,data3);
    else
      sprintf(buf,"%6d %6d  %6d  %1.3e  %6d  %6d  %6d",values.record,
	    values.trace,values.sample,values.value,data1,data2,data3);
  
				/* Update the value on the main window. */
  
  XtVaSetValues(xdisplay[id_anim].values,
		XmNlabelString,XMstr(buf),
		NULL);

				/* Check if user is picking. */
  if (!pick_flag) return;

				/* Set to rubberband mode. */
  XSetFunction(display,xdisplay[id].gc,GXequiv);

  XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
	    start_x,start_y,end_x,end_y);

  end_x=event->xbutton.x;
  end_y=event->xbutton.y;
  
  XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
	    start_x,start_y,end_x,end_y);

				/* Turn off rubberband mode. */
  XSetFunction(display,xdisplay[id].gc,GXcopy);
}



/*
  This function handles the button
  events when in the picking mode
  for a single point pick.
*/
void single_pick_button(XEvent *event, long id)
{
  int x,y,picks_count;
  struct values_struct values;

				/* Input a pick point. */
  if (event->xbutton.button==Button1) {     
    start_x=event->xbutton.x;
    start_y=event->xbutton.y;
    changed_picks=True;		/* Mark that a pick has been added. */

				/* Create space to store picks. */
    picks_count=next_picks();
    picks[picks_count].id = id;	/* RJM: added */
    picks[picks_count].record=(int *)malloc(sizeof(int));
    picks[picks_count].trace=(int *)malloc(sizeof(int));
    picks[picks_count].sample=(int *)malloc(sizeof(int));
    x=(int)(event->xbutton.x*xdisplay[id].pick_x);
/*  x=(int)(event->xbutton.x*xdisplay[id].pick_x+0.5); RJM: incorrect */
    y=(int)(event->xbutton.y*xdisplay[id].pick_y);
/*  y=(int)(event->xbutton.y*xdisplay[id].pick_y+0.5); RJM: incorrect */
    values=get_values(x,y,id);
    *(picks[picks_count].record)=values.record;
    *(picks[picks_count].trace)=values.trace;
    *(picks[picks_count].sample)=values.sample;
    picks[picks_count].size=1;
    picks[picks_count].color=xdisplay[id].pick_color;
  }

  expose_image(id);
}


/*
  This function handles the button
  events when in the picking mode.
*/
void pick_button(XEvent *event, long id, long id_anim)
{
  int x,y,picks_count,n;
  struct values_struct values;

				/* Input a pick point. */
  if (event->xbutton.button==Button1) {     
    XSetForeground(display,xdisplay[id].gc,xdisplay[id].pick_color);
    XSetLineAttributes(display,xdisplay[id].gc,line_width,
                     LineSolid,CapNotLast,JoinRound);

				/* Check if this is the first pick. */
    if (pick_count!=0) {
      if (xdisplay[id_anim].auto_flag) 
	auto_picking(id,id_anim,start_x,start_y,event->xbutton.x,event->xbutton.y);
      else
	XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		  start_x,start_y,event->xbutton.x,event->xbutton.y);
    }
    XSetLineAttributes(display,xdisplay[id].gc,0,
		       LineSolid,CapNotLast,JoinRound);
    start_x=event->xbutton.x;
    start_y=event->xbutton.y;
    end_x=start_x;
    end_y=start_y;
/*  if ((!(xdisplay[id_anim].auto_flag))||(pick_count==0)) { RJM: don't want this pick (i.e., non max/min ampl pick) if auto_flag && pick_count==0!!! */
    if ( !xdisplay[id_anim].auto_flag ) {
      pick_x[pick_count]=start_x;
      pick_y[pick_count]=start_y;
      pick_count++;
    } else if( pick_count == 0 )	/* RJM: added */
      auto_picking(id,id_anim,start_x,start_y,event->xbutton.x,event->xbutton.y);

				/* Check if there are too many picks. */
    if (pick_count>=MAX_P_LIST) {
      error_message("Too many picks are being used.");
      event->xbutton.button=Button3;
    }
    pick_flag=True;
  }

				/* Button2 undoes the last pick one. */
  if (event->xbutton.button==Button2) {
				/* Make sure there are at least two points. */
    if (pick_count<2) return;
    start_x=pick_x[pick_count-2];
    start_y=pick_y[pick_count-2];
    end_x=start_x;
    end_y=start_y;
    pick_count--;
				/* Update the display. */
    if (strcmp(xdisplay[id].filename,"Animation")==0) {
      expose_animation(id,id_anim); 
    } else {
      expose_image(id_anim);
      expose_all_picks();
    }
    XSetLineAttributes(display,xdisplay[id].gc,line_width,
                     LineSolid,CapNotLast,JoinRound); 
    XSetForeground(display,xdisplay[id].gc,xdisplay[id].pick_color);

				/* Redraw the segment. */
    for (n=1; n<pick_count; n++)
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		pick_x[n-1],pick_y[n-1],pick_x[n],pick_y[n]);
    XSetLineAttributes(display,xdisplay[id].gc,0,
                     LineSolid,CapNotLast,JoinRound);
  }

				/* Button3 ends the picking. */
  if (event->xbutton.button==Button3) {
    if (pick_count>1) {		/* Make sure there are at least two picks. */

      changed_picks=True;	/* Mark that a pick has been added. */

				/* Create space to store picks. */
      picks_count=next_picks();
      picks[picks_count].id = id_anim;	/* RJM: added */
if(id!=id_anim)
  fprintf( stderr, "pick_button: ***NOTE***: id=%d, id_anim=%d\n", id, id_anim );
      picks[picks_count].record=(int *)malloc(pick_count*sizeof(int));
      picks[picks_count].trace=(int *)malloc(pick_count*sizeof(int));
      picks[picks_count].sample=(int *)malloc(pick_count*sizeof(int));
      for (n=0; n<pick_count; n++) {
	x=(int)(pick_x[n]*xdisplay[id_anim].pick_x);
/*	x=(int)(pick_x[n]*xdisplay[id_anim].pick_x+0.5); RJM: incorrect */
  	y=(int)(pick_y[n]*xdisplay[id_anim].pick_y);
/*	y=(int)(pick_y[n]*xdisplay[id_anim].pick_y+0.5); RJM: incorrect */
	values=get_values(x,y,id_anim);
	*(picks[picks_count].record+n)=values.record;
	*(picks[picks_count].trace+n)=values.trace;
	*(picks[picks_count].sample+n)=values.sample;
      }
      picks[picks_count].size=pick_count;
      picks[picks_count].color=xdisplay[id].pick_color;
      if ((edit_mode!=0)&&(xdisplay[id_anim].mode==17))  {
	xdisplay[id_anim].mode=2;	/* Need to return to edit mode after
				   adding picks. (when in edit mode) */
	set_mode_label(2,id);
      }
    }
    pick_count=0;
    pick_flag=False;

    XSetFunction(display,xdisplay[id].gc,GXequiv);
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
	      start_x,start_y,end_x,end_y);
    XSetFunction(display,xdisplay[id].gc,GXcopy);

    if (strcmp(xdisplay[id].filename,"Animation")==0) {
      expose_animation(id,id_anim); 
    } else {
      expose_image(id_anim);
      expose_all_picks();
    }
  }
}


/*
  This function preforms automatic
  picking according to amplitute.
*/
void auto_picking(long id, long id_anim, int x1, int y1, int x2, int y2)
{
  int x,y,y_max,max,y_min,min,size,temp;
  float slope,b;

				/* Make sure the guide line is not vertical. */
/*if ((x2-x1)==0) { RJM: Bohemian logic */
  if (x2 == x1) {
    /* RJM: added single pt handling: START: */
    x=x1;
    y=y1;
    if (auto_direction==1) {	/* Positive amplitude. */
      max=0;
				/* Check window for amplitude value. */
      for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	   size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	    (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	  if (((int)XGetPixel(xdisplay[id_anim].image,x,size)-temp)>max) {
	    max=XGetPixel(xdisplay[id_anim].image,x,size);
	    y_max=size;
	  }
	}
      }
      pick_x[pick_count]=x;
      pick_y[pick_count]=y_max;
      pick_count++;
      if( pick_count > 1 )
         XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		pick_x[pick_count-2],pick_y[pick_count-2],
		pick_x[pick_count-1],pick_y[pick_count-1]);
    } else {
      min=255;
				/* Check window for amplitude value. */
      for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	   size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	    (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	  if (((int)XGetPixel(xdisplay[id_anim].image,x,size)+temp)<min) {
	    min=XGetPixel(xdisplay[id_anim].image,x,size);
	    y_min=size;
	  }
	}
      }
      pick_x[pick_count]=x;
      pick_y[pick_count]=y_min;
      pick_count++;
      if( pick_count > 1 )
         XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		pick_x[pick_count-2],pick_y[pick_count-2],
		pick_x[pick_count-1],pick_y[pick_count-1]);
    }
    /* RJM: added single pt handling: END */

    return;
  }
				/* Compute the slope and y-intersect. */
  slope=(float)(y2-y1)/(float)(x2-x1);
  b=(float)y1-((float)x1*slope);

  if (x1<x2) {
    if (auto_direction==1) {	/* Positive amplitude. */
				/* Increment through the guide line. */
/*    for (x=x1; x<x2; x+=(auto_incr/xdisplay[id_anim].pick_x)) { RJM: already have 1st x now */
      for (x=x1+auto_incr/xdisplay[id_anim].pick_x; x<x2; x+=(auto_incr/xdisplay[id_anim].pick_x)) {
/*	y=(int)((float)x*slope+b); RJM */
	y=(int)((float)x*slope+b+0.5);
	max=0;
				/* Check window for amplitude value. */
	for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	     size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	  temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
          if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	      (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	    if (((int)XGetPixel(xdisplay[id_anim].image,x,size)-temp)>max) {
	      max=XGetPixel(xdisplay[id_anim].image,x,size);
	      y_max=size;
	    }
	  }
	}
	pick_x[pick_count]=x;
	pick_y[pick_count]=y_max;
	pick_count++;
	XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		  pick_x[pick_count-2],pick_y[pick_count-2],
		  pick_x[pick_count-1],pick_y[pick_count-1]);
      }
      x=x2;
/*    y=(float)x*slope+b; RJM */
      y=(float)x*slope+b+0.5;
      max=0;
				/* Check window for amplitude value. */
      for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	   size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	    (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	  if (((int)XGetPixel(xdisplay[id_anim].image,x,size)-temp)>max) {
	    max=XGetPixel(xdisplay[id_anim].image,x,size);
	    y_max=size;
	  }
	}
      }
      pick_x[pick_count]=x;
      pick_y[pick_count]=y_max;
      pick_count++;
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		pick_x[pick_count-2],pick_y[pick_count-2],
		pick_x[pick_count-1],pick_y[pick_count-1]);
    } else {
				/* Increment through the guide line. */
/*    for (x=x1; x<x2; x+=(auto_incr/xdisplay[id_anim].pick_x)) { RJM: already handle 1st x now */
      for (x=x1+auto_incr/xdisplay[id_anim].pick_x; x<x2; x+=(auto_incr/xdisplay[id_anim].pick_x)) {
/*	y=(float)x*slope+b; RJM */
	y=(float)x*slope+b+0.5;
	min=255;
				/* Check window for amplitude value. */
	for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	     size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	  temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	  if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	      (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	    if (((int)XGetPixel(xdisplay[id_anim].image,x,size)+temp)<min) {
	      min=XGetPixel(xdisplay[id_anim].image,x,size);
	      y_min=size;
	    }
	  }
	}
	pick_x[pick_count]=x;
	pick_y[pick_count]=y_min;
	pick_count++;
	XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		  pick_x[pick_count-2],pick_y[pick_count-2],
		  pick_x[pick_count-1],pick_y[pick_count-1]);
      }
      x=x2;
/*    y=(float)x*slope+b; RJM */
      y=(float)x*slope+b+0.5;
      min=255;
				/* Check window for amplitude value. */
      for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	   size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	    (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	  if (((int)XGetPixel(xdisplay[id_anim].image,x,size)+temp)<min) {
	    min=XGetPixel(xdisplay[id_anim].image,x,size);
	    y_min=size;
	  }
	}
      }
      pick_x[pick_count]=x;
      pick_y[pick_count]=y_min;
      pick_count++;
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		pick_x[pick_count-2],pick_y[pick_count-2],
		pick_x[pick_count-1],pick_y[pick_count-1]);
    }
  } else {
    if (auto_direction==1) {	/* Positive amplitude. */
				/* Increment through the guide line. */
      for (x=x1; x>x2; x-=(auto_incr/xdisplay[id_anim].pick_x)) {
/*	y=(float)x*slope+b; RJM */
	y=(float)x*slope+b+0.5;
	max=0;
				/* Check window for amplitude value. */
	for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	     size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	  temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	  if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	      (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	    if (((int)XGetPixel(xdisplay[id_anim].image,x,size)-temp)>max) {
	      max=XGetPixel(xdisplay[id_anim].image,x,size);
	      y_max=size;
	    }
	  }
	}
	pick_x[pick_count]=x;
	pick_y[pick_count]=y_max;
	pick_count++;
	XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		  pick_x[pick_count-2],pick_y[pick_count-2],
		  pick_x[pick_count-1],pick_y[pick_count-1]);
      }
      x=x2;
/*    y=(float)x*slope+b; RJM */
      y=(float)x*slope+b+0.5;
      max=0;
				/* Check window for amplitude value. */
      for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	   size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	    (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	  if (((int)XGetPixel(xdisplay[id_anim].image,x,size)-temp)>max) {
	    max=XGetPixel(xdisplay[id_anim].image,x,size);
	    y_max=size;
	  }
	}
      }
      pick_x[pick_count]=x;
      pick_y[pick_count]=y_max;
      pick_count++;
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		pick_x[pick_count-2],pick_y[pick_count-2],
		pick_x[pick_count-1],pick_y[pick_count-1]);
    } else {
				/* Increment through the guide line. */
      for (x=x1; x>x2; x-=(auto_incr/xdisplay[id_anim].pick_x)) {
/*	y=(float)x*slope+b; RJM */
	y=(float)x*slope+b+0.5;
	min=255;
				/* Check window for amplitude value. */
	for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	     size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	  temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	  if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	      (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	    if (((int)XGetPixel(xdisplay[id_anim].image,x,size)+temp)<min) {
	      min=XGetPixel(xdisplay[id_anim].image,x,size);
	      y_min=size;
	    }
	  }
	}
	pick_x[pick_count]=x;
	pick_y[pick_count]=y_min;
	pick_count++;
	XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		  pick_x[pick_count-2],pick_y[pick_count-2],
		  pick_x[pick_count-1],pick_y[pick_count-1]);
      }
      x=x2;
/*    y=(float)x*slope+b; RJM */
      y=(float)x*slope+b+0.5;
      min=255;
				/* Check window for amplitude value. */
      for (size=y-(auto_size/2/xdisplay[id_anim].pick_y); /* RJM: changed to auto_size/2 */
	   size<=y+(auto_size/2/xdisplay[id_anim].pick_y); size++) {/* RJM: changed to auto_size/2 */
	temp=(size-y)*(auto_weight/xdisplay[id_anim].pick_y);
	if ((x>=0)&&(x<xdisplay[id_anim].image->width)&&
	    (size>=0)&&(size<xdisplay[id_anim].image->height)) {
	  if (((int)XGetPixel(xdisplay[id_anim].image,x,size)+temp)<min) {
	    min=XGetPixel(xdisplay[id_anim].image,x,size);
	    y_min=size;
	  }
	}
      }
      pick_x[pick_count]=x;
      pick_y[pick_count]=y_min;
      pick_count++;
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		pick_x[pick_count-2],pick_y[pick_count-2],
		pick_x[pick_count-1],pick_y[pick_count-1]);
    }
  }
  return;
}


/*
  This function returns the next available 
  slot for storing a set of picks.
*/
int next_picks(void)
{
  int n;

  for (n=0; n<MAX_PICKS; n++)
    if (picks[n].init==0) {
      picks[n].init=-1;
      picks[n].group=0;
      strcpy(picks[n].label,"");
      return(n);
    }

  error_message("Too many segment used.");
  return(n);
}



/*
  This function returns the record, trace, sample, and amplitude at the x,y
  location.
*/
struct values_struct get_values(int x, int y, long id)
{
  struct values_struct values;
  int temp,parent;
  Boolean flag;
  
  flag=False;
  parent=xdisplay[id].parent;

/* DWN 10/29/97 diagnostics
  if (verbose)
    fprintf(stderr,"flip %x  upside %x  swap %x\n",
     xdisplay[id].flip_flag,xdisplay[id].upside_flag,xdisplay[id].swap_flag);
*/

/*if( xdisplay[id].flip_flag ) RJM */
  if( xdisplay[id].flip_flag && !xdisplay[id].swap_flag
   || xdisplay[id].swap_flag && xdisplay[id].upside_flag )
    x = xdisplay[id].image->width*xdisplay[id].pick_x - x - 1;

/*if( xdisplay[id].upside_flag ) RJM */
  if( xdisplay[id].upside_flag && !xdisplay[id].swap_flag
   || xdisplay[id].swap_flag && xdisplay[id].flip_flag )
    y = xdisplay[id].image->height*xdisplay[id].pick_y - y - 1;
/*  y=(xdisplay[id].image->height*xdisplay[id].pick_y-y)-1 + 0.5; RJM: incorrect */

				/* Check if x > boundary */
  if (x==(int)(xdisplay[id].pick_x*xdisplay[id].image->width)) 
    x=(xdisplay[id].image->width-1)*xdisplay[id].pick_x;

				/* Check if y > boundary */
  if (y==(int)(xdisplay[id].pick_y*xdisplay[id].image->height)) 
    y=(xdisplay[id].image->height-1)*xdisplay[id].pick_y;
/*  y=(xdisplay[id].image->height-1)*xdisplay[id].pick_y + 0.5; RJM: incorrect */

  if (xdisplay[id].sort) {
    if( xdisplay[id].swap_flag )
    {
      temp=ceil((float)(erec[parent]-srec[parent]+1)/
        (float)abs(irec[parent]));
      values.sample=(itrace[id]*(int)(y/temp))+strace[id];
      values.record=y-(temp*(values.sample-strace[id])/itrace[id]);
      values.record=values.record*abs(irec[id])+srec[id];
      values.trace=x*isamp[id]+ssamp[id]; 
      while (values.record>erec[parent]) {
	values.record -= (int)((erec[parent]-srec[parent])
			/irec[parent])*irec[parent]+1;
	values.sample+=itrace[id];
	flag=True;
      }
      if (flag)
	values.record-=(irec[parent]-1);
    }
    else
    {
      temp=ceil((float)(erec[parent]-srec[parent]+1)/
        (float)abs(irec[parent]));
      values.trace=(itrace[id]*(int)(x/temp))+strace[id];
      values.record=x-(temp*(values.trace-strace[id])/itrace[id]);
      values.record=values.record*abs(irec[id])+srec[id];
      values.sample=y*isamp[id]+ssamp[id]; 
      while (values.record>erec[parent]) {
	values.record   -= (int)((erec[parent]-srec[parent])
			/irec[parent])*irec[parent]+1;
	values.trace+=itrace[id];
	flag=True;
      }
      if (flag)
	values.record-=(irec[parent]-1);
    }
  } else {
    if( xdisplay[id].swap_flag )
    {
      temp=ceil((float)(esamp[parent]-ssamp[parent]+1)
	  / (float)abs(isamp[parent]));
      values.record=(irec[id]*(int)(x/temp))+srec[id];
      values.trace=x-(temp*(values.record-srec[id])/irec[id]);
      values.trace=values.trace*abs(isamp[id])+ssamp[id];
      values.sample=y*itrace[id]+strace[id]; 
      if (itrace[id]<0)
	  values.trace=(esamp[id]-ssamp[id]+2)-values.trace;
      while (values.trace>esamp[parent]) {
	  values.trace -= (int)((esamp[parent]-ssamp[parent])
			  /isamp[parent])*isamp[parent]+1;
	  values.record++;
	  flag=True;
      }
      if (flag)
	  values.trace-=(isamp[parent]-1);
    }
    else
    {
      temp=ceil((float)(etrace[parent]-strace[parent]+1)
	  / (float)abs(itrace[parent]));
      values.record=(irec[id]*(int)(x/temp))+srec[id];
      values.trace=x-(temp*(values.record-srec[id])/irec[id]);
/*    values.trace=x-(int)(temp*(values.record-srec[id])/irec[id]+0.5); RJM: incorrect */
      values.trace=values.trace*abs(itrace[id])+strace[id];
      values.sample=y*isamp[id]+ssamp[id]; 
      if (itrace[id]<0)
	  values.trace=(etrace[id]-strace[id]+2)-values.trace;
      while (values.trace>etrace[parent]) {
	  values.trace -= (int)((etrace[parent]-strace[parent])
			  /itrace[parent])*itrace[parent]+1;
	  values.record++;
	  flag=True;
      }
      if (flag)
	  values.trace-=(itrace[parent]-1);
    }
  }

  if (x>(int)(xdisplay[id].pick_x*xdisplay[id].image->width)) {
    values.record=erec[id];
    if( xdisplay[id].swap_flag )
      values.trace=esamp[id];
    else
      values.trace=etrace[id];
  }
  if (y>(int)(xdisplay[id].pick_y*xdisplay[id].image->height)) 
    if( xdisplay[id].swap_flag )
      values.sample=etrace[id];
    else
      values.sample=esamp[id];

				/* Check if this is a time slice. */
  if (ssamp[parent]==esamp[parent] && !xdisplay[id].swap_flag )	/* RJM */
  {
    temp = values.record;
    values.record=(values.sample-ssamp[parent])+srec[parent];
    values.sample=(temp-srec[parent])+ssamp[parent];
  }

  if (values.record<1) values.record=1;
  if (values.trace<1) values.trace=1;
  if (values.sample<1) values.sample=1;

  return values;
}


/*
  This function returns the x,y location from the record, trace, and sample.
*/
struct location_struct get_location(int record, int trace, int sample, long id)
{
  struct location_struct values;
  int temp,parent;
/* fprintf( stderr, "pick.c: get_location: record=%d, trace=%d, sample=%d, id=%ld\n", record, trace, sample, id ); */

				/* Check if this is a time slice. */
  if (ssamp[id]==esamp[id] && !xdisplay[id].swap_flag )	/* RJM */
  {
    temp=sample;
    sample=(record-srec[id])+ssamp[id];
    record=(temp-ssamp[id])+srec[id];
  }

/* fprintf( stderr, "pick.c: get_location: srec[id]=%d, erec[id]=%d\n", srec[id], erec[id] ); */

				/* Check if record is not being honored. */
  if (!xdisplay[id].record_flag) {
    values=get_abs_location(trace,sample,id);
    return values;
  }

  parent=xdisplay[id].parent;
  
  if (xdisplay[id].sort) {
/*  if (xdisplay[id].flip_flag) RJM */
    if( xdisplay[id].flip_flag && !xdisplay[id].swap_flag
     || xdisplay[id].swap_flag && xdisplay[id].upside_flag )
    {
      temp=ceil((float)(erec[parent]-srec[parent]+1)/(float)irec[parent]);
		/* 3/13/97: RJM: if data are plotted in cross-line order
         (i.e., span records, single trace), srec!=erec and values.x calc is OK.
         If plot 1 record, srec==erec and values.x calc is OK.
         However, if plot multiple records of multiple traces in one display,
         srec!=erec and all picks bunch up on left side of screen (values.x=0).
      */
/*    if( srec[id] == erec[id] ) */ /* RJM: added 2/17/97 */
      if( srec[id] == erec[id] || strace[id] != etrace[id] ) /* RJM: added 3/13/97 */
        values.x=(record-srec[id])/irec[id]+(temp*(trace-strace[id])/itrace[id]);
      else	/* RJM: added 2/17/97 */
        values.x=(record-srec[id])/irec[id]; /* RJM: added 2/17/97 */
      values.x=(xdisplay[id].image->width*xdisplay[id].pick_x)-values.x;
    } else {
      temp=ceil((float)(erec[parent]-srec[parent]+1)/(float)irec[parent]);
/*    if( srec[id] == erec[id] ) */ /* RJM: added 2/17/97 */
      if( srec[id] == erec[id] || strace[id] != etrace[id] ) /* RJM: added 3/13/97 */
        values.x=(record-srec[id])/irec[id]+(temp*(trace-strace[id])/itrace[id]);
      else	/* RJM: added 2/17/97 */
        values.x=(record-srec[id])/irec[id]; /* RJM: added 2/17/97 */
    }
    values.y=(sample-ssamp[id])/isamp[id];
  } else {
/*  if (xdisplay[id].flip_flag) RJM */
    if( xdisplay[id].flip_flag && !xdisplay[id].swap_flag
     || xdisplay[id].swap_flag && xdisplay[id].upside_flag )
    {
/* fprintf( stderr, "pick.c: get_location: case 1\n" ); */
      temp=ceil((float)(etrace[parent]-strace[parent]+1)/(float)abs(itrace[parent]));
/*    if( srec[id] == erec[id] ) */ /* RJM: added 2/17/97 */
      if( srec[id] == erec[id] || strace[id] != etrace[id] ) /* RJM: added 3/13/97 */
        values.x=(etrace[id]-trace)/itrace[id]+(temp*(erec[id]-record)/irec[id]);
      else	/* RJM: added 2/17/97 */
        values.x=(erec[id]-record)/irec[id]; /* RJM: added 2/17/97 */
    } else {
/* fprintf( stderr, "pick.c: get_location: case 2\n" ); */
      temp=ceil((float)(etrace[parent]-strace[parent]+1)/(float)abs(itrace[parent]));
/*    if( srec[id] == erec[id] ) */ /* RJM: added 2/17/97 */
      if( srec[id] == erec[id] || strace[id] != etrace[id] ) /* RJM: added 3/13/97 */
        values.x=(trace-strace[id])/itrace[id]+(temp*(record-srec[id])/irec[id]);
      else	/* RJM: added 2/17/97 */
        values.x=(record-srec[id])/irec[id]; /* RJM: added 2/17/97 */
    }
/* fprintf( stderr, "pick.c: get_location: temp=%d, values.x=%d\n", temp, values.x ); */
/* fprintf( stderr, "pick.c: get_location: parent=%d, strace=%d, etrace=%d, itrace=%d\n", parent, strace[parent], etrace[parent], itrace[parent] ); */
/* fprintf( stderr, "pick.c: get_location: id=%d, strace=%d, etrace=%d, itrace=%d\n", id, strace[id], etrace[id], itrace[id] ); */
    values.y=(sample-ssamp[id])/isamp[id];
  }

/*if (xdisplay[id].upside_flag) RJM */
  if( xdisplay[id].upside_flag && !xdisplay[id].swap_flag
   || xdisplay[id].swap_flag && xdisplay[id].flip_flag )
    values.y=(xdisplay[id].image->height*xdisplay[id].pick_y-values.y)-1;
/*  values.y=(xdisplay[id].image->height*xdisplay[id].pick_y-values.y)-1 + 0.5; RJM: incorrect */

  return values;
}


/*
  This function returns the x,y location from the trace and sample.
  Ignores the record.
*/
struct location_struct get_abs_location(int trace, int sample, long id)
{
  struct location_struct values;
  int temp,temp1,parent;

  parent=xdisplay[id].parent;

  if (xdisplay[id].sort) {
    temp=1;
/*  if (xdisplay[id].flip_flag) RJM */
    if( xdisplay[id].flip_flag && !xdisplay[id].swap_flag
     || xdisplay[id].swap_flag && xdisplay[id].upside_flag )
    {
      temp1=ceil((float)(etrace[id]-strace[id]+1)/
		 (float)itrace[id]);
      temp1--; temp1=temp1*itrace[id]+1;
      values.x=(temp*(temp1-trace)/itrace[id]);
    } else {
      values.x=(temp*(trace-strace[id])/itrace[id]);
    }
    values.y=(sample-ssamp[id])/isamp[id];
  } else {
/*  if (xdisplay[id].flip_flag) RJM */
    if( xdisplay[id].flip_flag && !xdisplay[id].swap_flag
     || xdisplay[id].swap_flag && xdisplay[id].upside_flag )
    {
      temp=ceil((float)(etrace[parent]-strace[parent]+1)/
		(float)abs(itrace[parent]));
      values.x=(etrace[id]-trace)/itrace[id];
    } else {
      temp=ceil((float)(etrace[parent]-strace[parent]+1)/
		(float)abs(itrace[parent]));
      values.x=(trace-strace[id])/itrace[id];
    }
    values.y=(sample-ssamp[id])/isamp[id];
  }

/*if (xdisplay[id].upside_flag) RJM */
  if( xdisplay[id].upside_flag && !xdisplay[id].swap_flag
   || xdisplay[id].swap_flag && xdisplay[id].flip_flag )
    values.y=(xdisplay[id].image->height*xdisplay[id].pick_y-values.y)-1;
/*  values.y=(xdisplay[id].image->height*xdisplay[id].pick_y-values.y)-1 + 0.5; RJM: incorrect */

  return values;
}


/*
  This function loads in picks
  from a file.
*/
void load_picks(long id, char *filename, int group)
{
  FILE *in;
  char *eof,buf1[122],buf2[20];
  int error,m,pick_count,junk,n=-1;
  float record,trace,sample;
  float pick_record[MAX_P_LIST],pick_trace[MAX_P_LIST],pick_sample[MAX_P_LIST];
  float unit_rec,unit_trace,unit_samp;
  float offset_rec,offset_trace,offset_samp;
  int temp_pick_color;

  if( id == 0 ) {	/* RJM: added */
    /* unsafe to load segments into window 0 which == main menu */
    error_message("Unsafe attempt to load segments into main menubar window." );
    return;
  }
				/* Open the file to read. */
  in=fopen(filename,"r");

  if (in==NULL) {
    error_message("Cannot open pick file.");
    return;
  }

				/* Get the first line to see if the file 
				   is a normal pick file or an agm file. */
  fgets(buf,1024,in);

  if (verbose) fprintf(stderr,"%s",buf);

  error=sscanf(buf,"Units %f %f %f %d %d %d Offset %f %f %f",
	       &unit_rec,&unit_trace,&unit_samp,&junk,&junk,&junk,
	       &offset_rec,&offset_trace,&offset_samp);

				/* If the "Units" line is missing 
				   try the agm format. */
  if (error<3) {
    fclose(in);	/* RJM: note: fclose, NOT close! */
/* #ifdef SUN */	/* RJM: commented out */
#if defined(sun) || defined(__sgi)
    convert_to_picks(id,filename);
#endif
  } else {
				/* Must be a normal pick file. */
    eof=fgets(buf,120,in);
    
    m=0;
				/* Read until the end of file. */
    while (eof!=NULL) {

      if (verbose) fprintf(stderr,"%s",buf);

/* DWN 12/11/97 ALL label buffers are 20 bytes, so read 19 w/ 1 byte for \0 
      error=sscanf(buf,"%s = %d Name %20s color = %d",buf1,&junk,buf2,&temp_pick_color);
*/
      error=sscanf(buf,"%s = %d Name %19s color = %d",buf1,&junk,buf2,&temp_pick_color);

      if (error==3)
	temp_pick_color=xdisplay[id].pick_color-start_pick_color;
      if (error<4)
	error=sscanf(buf,"%s = %d color = %d",buf1,&junk,&temp_pick_color);
      if (error==2)
	temp_pick_color=xdisplay[id].pick_color;
      if (strcmp(buf1,"Segment")==0) {
	if (m!=0) {
 	  pick_count=m;
          picks[n].id = id;	/* RJM: added */
/*        picks[n].init=-1; */	/* RJM: added */ /* RJM: took back out: done in next_picks() */
	  picks[n].record=(int *)malloc(pick_count*sizeof(int));
	  picks[n].trace=(int *)malloc(pick_count*sizeof(int));
	  picks[n].sample=(int *)malloc(pick_count*sizeof(int));
	  for (m=0; m<pick_count; m++) {
	    *(picks[n].record+m)=(int)pick_record[m];
	    *(picks[n].trace+m)=(int)pick_trace[m];
	    *(picks[n].sample+m)=(int)pick_sample[m];
	  }
	  picks[n].size=pick_count;
        } else {
/*	
   Fixed on 11/10/93. When loading in two different files with
   only one pick the first pick was destroyed??? Initial set
   n to -1.
*/
	  if (n!=-1)
	    picks[n].init=0;
	}
	m=0;
	n=next_picks();
	temp_pick_color+=start_pick_color;
	if (temp_pick_color>end_pick_color) temp_pick_color=start_pick_color;
	picks[n].color=temp_pick_color;
	picks[n].group=group;
	xdisplay[id].overlay_flag=False;
	if (strcmp(buf2,"NO_PICK_NAME_HERE")==0)
	  strcpy(picks[n].label,"");
	else
	  strcpy(picks[n].label,buf2);
	strcpy(buf2,"");
      } else {
	sscanf(buf,"%f %f %f",&record,&trace,&sample);
/*   Change so picks are rounded.
     
     Doug Horn 2/1/94

	record=(int)((record-offset_rec)/unit_rec);
	trace=(int)((trace-offset_trace)/unit_trace);
	sample=(int)((sample-offset_samp)/unit_samp);
*/
	record=(int)((record+.5-offset_rec)/unit_rec);
	trace=(int)((trace+.5-offset_trace)/unit_trace);
	sample=(int)((sample+.5-offset_samp)/unit_samp);
	
	pick_record[m]=record;
	pick_trace[m]=trace;
	pick_sample[m]=sample;
	m++;
	if (m>=MAX_P_LIST) {
	  error_message("Too many picks are being used.");
	  picks[n].init=0;
	  fclose(in);
	  expose_all_picks();
	  return;
	}
      }
      eof=fgets(buf,120,in);
    }
    if (m!=0) {
      pick_count=m;
      picks[n].id = id;		/* RJM: added */
/*    picks[n].init=-1; */	/* RJM: added */ /* RJM: took back out: done in next_picks() */
      picks[n].record=(int *)malloc(pick_count*sizeof(int));
      picks[n].trace=(int *)malloc(pick_count*sizeof(int));
      picks[n].sample=(int *)malloc(pick_count*sizeof(int));
      for (m=0; m<pick_count; m++) {
	*(picks[n].record+m)=pick_record[m];
	*(picks[n].trace+m)=pick_trace[m];
	*(picks[n].sample+m)=pick_sample[m];
      }
      picks[n].size=pick_count;
    }
    
    fclose(in);
  }
  expose_all_picks();
}


/*
  This function prompts the user
  for parameter to write out the picks.
*/
void save_picks(long id, char *filename)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget label;
  Widget button;
  int root_x,root_y;
  ClientData *message;

				/* Initialize the units and offset. */
  axis_units[0]=1.0;
  axis_units[1]=1.0;
  axis_units[2]=1.0;
  axis_offset[0]=0.0;
  axis_offset[1]=0.0;
  axis_offset[2]=0.0;

  out=fopen(filename,"w");
  if (out==NULL) {
    error_message("Cannot open file.");
    return;
  }
  locate_cursor(&root_x,&root_y);

  
  dialog_form=XmCreateFormDialogVa(top_level,"form",
				   XmNdefaultPosition,False,
				   XmNx,root_x,
				   XmNy,root_y,
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("Save Picks"),
				   XtNmanageChild,False,
				   NULL);  
  
  sprintf(buf,"The picks will be saved with these Units and Offset.");
  label=XmCreateLabelVa(dialog_form,"label",
			XmNlabelString,XMstr(buf),
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);  
  
  
  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,3,
				    XmNtopAttachment,XmATTACH_WIDGET,
				    XmNtopWidget,label,
				    XmNtopOffset,10,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNrightAttachment,XmATTACH_FORM,
				    NULL);  
  
  (void)XmCreateLabelVa(dialog_window," ",NULL);
  (void)XmCreateLabelVa(dialog_window,"Record",NULL);
  (void)XmCreateLabelVa(dialog_window,"Trace",NULL);
  (void)XmCreateLabelVa(dialog_window,"Sample",NULL);
  
  (void)XmCreateLabelVa(dialog_window,"Units",NULL);
  
  sprintf(buf,"%f",xdisplay[id].axis_units[0]);
  
  text[0]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,buf,
			 XmNcolumns,8,
			 NULL);  
  
  sprintf(buf,"%f",xdisplay[id].axis_units[1]);
  
  text[1]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,buf,
			 XmNcolumns,8,
			 NULL);  
  
  sprintf(buf,"%f",xdisplay[id].axis_units[2]);
  
  text[2]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,buf,
			 XmNcolumns,8,
			 NULL);  
  
  (void)XmCreateLabelVa(dialog_window,"Offset",NULL);
  
  sprintf(buf,"%f",xdisplay[id].axis_offset[0]);
  
  text[3]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,buf,
			 XmNcolumns,8,
			 NULL);  
  
  sprintf(buf,"%f",xdisplay[id].axis_offset[1]);
  
  text[4]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,buf,
			 XmNcolumns,8,
			 NULL);  
  
  sprintf(buf,"%f",xdisplay[id].axis_offset[2]);
  
  text[5]=XmCreateTextVa(dialog_window,"text",
			 XmNvalue,buf,
			 XmNcolumns,8,
			 NULL);  
  
  sort_toggle=XmCreateToggleButtonVa(dialog_form,"Sort by Record Numbers",
				     XmNtopAttachment,XmATTACH_WIDGET,
				     XmNtopWidget,dialog_window,
				     XmNleftAttachment,XmATTACH_FORM,
				     NULL);  
  XmToggleButtonSetState(sort_toggle,False,False);
  
  
  honor_toggle=XmCreateToggleButtonVa(dialog_form,"Honor Record Numbers",
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,sort_toggle,
				      XmNleftAttachment,XmATTACH_FORM,
				      NULL);  
  XmToggleButtonSetState(honor_toggle,True,False);
  
  
  agm_toggle=XmCreateToggleButtonVa(dialog_form,"Save picks in AGM format",
				    XmNtopAttachment,XmATTACH_WIDGET,
				    XmNtopWidget,honor_toggle,
				    XmNleftAttachment,XmATTACH_FORM,
				    NULL);  
  XmToggleButtonSetState(agm_toggle,False,False);
  
  
  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  
  
  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,agm_toggle,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNleftAttachment,XmATTACH_FORM,
			      NULL);  
  XtAddCallback(button,XmNactivateCallback,save_picksCB,message);
  
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,agm_toggle,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNrightAttachment,XmATTACH_FORM,
			      NULL);  
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);
  
  XtManageChild(dialog_form);

  return;
}


void save_picksCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message=(ClientData *)client_data;
  long id;	/* RJM: handle 64-bit architectures */
  char *number;

  id=message->id;

  XtSetArg(args[0],XmNvalue,&number);

  XtGetValues(text[0],args,1);
  sscanf(number,"%f",&axis_units[0]);
  XtGetValues(text[1],args,1);
  sscanf(number,"%f",&axis_units[1]);
  XtGetValues(text[2],args,1);
  sscanf(number,"%f",&axis_units[2]);

  XtGetValues(text[3],args,1);
  sscanf(number,"%f",&axis_offset[0]);
  XtGetValues(text[4],args,1);
  sscanf(number,"%f",&axis_offset[1]);
  XtGetValues(text[5],args,1);
  sscanf(number,"%f",&axis_offset[2]);
  
  honor_flag=XmToggleButtonGetState(honor_toggle);
  sort_flag=XmToggleButtonGetState(sort_toggle);
    
  save_out_picks(id);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function saves picks
  to a file.
*/
void save_out_picks(long id)
{
  int m,n,temp_count=1,count=0,count_max=0;
/*int tmp, *ptr; */
  struct pick_struct tmp_pick_struct;
  Boolean flag=True;
  float record,trace,sample;
/*char tmp_label[20]; */
  
  if (XmToggleButtonGetState(agm_toggle)) {
    fclose(out);
    agm_parameters(id);
  } else {    
    if (sort_flag) {
      while (flag) {
	flag=False;
	for (n=0; n<MAX_PICKS-1; n++) 
	  if (picks[n].init==-1) {
	    if (visible_segment(id,picks[n].group)) {
	      m=n+1;
	      while ((picks[m].init!=-1)&&(m!=MAX_PICKS)) {
		m++;
		if (m==MAX_PICKS) {
		  n=MAX_PICKS;
		  m=MAX_PICKS;
		}
	      }
	      if (picks[m].init==-1) 
		while (!(visible_segment(id,picks[m].group))&&
		       (m!=MAX_PICKS)) {
		  m++;
		  if (m==MAX_PICKS) {
		    n=MAX_PICKS;
		    m=MAX_PICKS;
		  }
		}
	      if (picks[m].init==-1)
		if (visible_segment(id,picks[m].group))
		  if (*(picks[n].record)>*(picks[m].record)) {
		    flag=True;

		    tmp_pick_struct = picks[n];	/* RJM: better method! */
		    picks[n] = picks[m];
		    picks[m] = tmp_pick_struct;

/*		    ptr=picks[n].record;
		    picks[n].record=picks[m].record;
		    picks[m].record=ptr;
		    ptr=picks[n].trace;
		    picks[n].trace=picks[m].trace;
		    picks[m].trace=ptr;
		    ptr=picks[n].sample;
		    picks[n].sample=picks[m].sample;
		    picks[m].sample=ptr;
		    
		    tmp=picks[n].size;
		    picks[n].size=picks[m].size;
		    picks[m].size=tmp;
		    
		    tmp=picks[n].group;
		    picks[n].group=picks[m].group;
		    picks[m].group=tmp;
		    
		    tmp=picks[n].color;
		    picks[n].color=picks[m].color;
		    picks[m].color=tmp;
		    
		    tmp=picks[n].offset_x;
		    picks[n].offset_x=picks[m].offset_x;
		    picks[m].offset_x=tmp;
		    
		    tmp=picks[n].offset_y;
		    picks[n].offset_y=picks[m].offset_y;
		    picks[m].offset_y=tmp;

		    strcpy(tmp_label,picks[n].label);
		    strcpy(picks[n].label,picks[m].label);
		    strcpy(picks[m].label,tmp_label);
*/
		  }
	    }
	  }
      }
    }
    
				/* Count the number of segments. */
    for (n=0; n<MAX_PICKS; n++) 
      if (picks[n].init==-1) {
	if (visible_segment(id,picks[n].group)) {
	  count++;
	  if (picks[n].size>count_max)
	    count_max=picks[n].size;
	}
      }
	  
    fprintf(out,"Units %12.6f %12.6f %12.6f ",axis_units[0],
	    axis_units[1],axis_units[2]);
    fprintf(out,"%5d %5d %5d ",nrec[id],ntrace[id],nsamp[id]);
    fprintf(out,"Offset %12.6f %12.6f %12.6f ",axis_offset[0],
	    axis_offset[1],axis_offset[2]);
    fprintf(out,"Count %5d %5d\n",count,count_max);

    
    for (n=0; n<MAX_PICKS; n++) {
      if (picks[n].init==-1) {
	if (visible_segment(id,picks[n].group)) {
	  fprintf(out,"Segment = %5d ",temp_count);
	  if ((int)strlen(picks[n].label)>0)
	    fprintf(out,"Name %20s",picks[n].label);
	  else
	    fprintf(out,"Name %20s ","NO_PICK_NAME_HERE");
	  fprintf(out," color = %5d",picks[n].color-start_pick_color);
	  fprintf(out," picks = %5d\n",picks[n].size);
	  temp_count++;
	  for (m=0; m<picks[n].size; m++) {
	    if (honor_flag) 
	      record=((float)*(picks[n].record+m)*axis_units[0])+axis_offset[0];
	    else
	      record=(1.0*axis_units[0])+axis_offset[0];
	    
	    trace=((float)*(picks[n].trace+m)*axis_units[1])+axis_offset[1];
	    sample=((float)*(picks[n].sample+m)*axis_units[2])+axis_offset[2];
	    fprintf(out,"%12.6f %12.6f %12.6f\n",record,trace,sample);
	  } 
	}
      }
    }
    fclose(out);
  }
}


/*
  This function check if a segment
  is visible or not (by group number).
*/
int visible_segment(long id, int group)
{
  int i;

  for (i=0; i<10; i++)
    if (xdisplay[id].groups[i]==group) {
      return(1);
    }

  return(0);
}




/*
  This function prompts the user
  for the parameter for auto picking.
*/
void auto_pickCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget row_column;
  Widget button;
  long id;	/* RJM: handle 64-bit architectures */
  ClientData *message;

  id=(long)client_data;
  xdisplay[id].auto_flag=False;

  dialog_form=XmCreateFormDialogVa(w,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,
				   XMstr("Auto Picking Parameters"),
				   XtNmanageChild,False,
				   NULL);  
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"autopick.help");
  
  
  row_column=XmCreateRowColumnVa(dialog_form,"row_column",
				 XmNpacking,XmPACK_COLUMN,
				 XmNnumColumns,2,
				 XmNleftAttachment,XmATTACH_FORM,
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNtopAttachment,XmATTACH_FORM,
				 NULL);  
  
  (void)XmCreateLabelVa(row_column,"Trace Incr.",NULL);
  (void)XmCreateLabelVa(row_column,"Window Size",NULL);
  (void)XmCreateLabelVa(row_column,"Weight Factor",NULL);
  
  sprintf(buf,"%d",auto_incr);
  
  text_auto[0]=XmCreateTextVa(row_column,"text",
			      XmNvalue,buf,
			      XmNcolumns,5,
			      NULL);  
  
  sprintf(buf,"%d",auto_size);
  
  text_auto[1]=XmCreateTextVa(row_column,"text",
			      XmNvalue,buf,
			      XmNcolumns,5,
			      NULL);  
  
  sprintf(buf,"%f",auto_weight);
  
  text_auto[2]=XmCreateTextVa(row_column,"text",
			      XmNvalue,buf,
			      XmNcolumns,5,
			      NULL);  
  
  
  row_column=XmCreateRadioBoxVa(dialog_form,"row_column",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,row_column,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				NULL);  
  

  pos_toggle=XmCreateToggleButtonVa(row_column,"Positive (peak)",NULL);
  neg_toggle=XmCreateToggleButtonVa(row_column,"Negative (trough)",NULL);
  
  if (auto_direction==1)
    XmToggleButtonSetState(pos_toggle,True,False);
  else
    XmToggleButtonSetState(neg_toggle,True,False);
  
  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  
  button=XmCreatePushButtonVa(dialog_form,"  On  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,row_column,
			      XmNleftAttachment,XmATTACH_FORM,
			      XmNbottomAttachment,XmATTACH_FORM,
			      NULL);  
  XtAddCallback(button,XmNactivateCallback,set_autoCB,message);
  
  
  button=XmCreatePushButtonVa(dialog_form," Off  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,row_column,
			      XmNrightAttachment,XmATTACH_FORM,
			      XmNbottomAttachment,XmATTACH_FORM,
			      NULL);  
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);
  
  XtManageChild(dialog_form);
}


/*
   This function gets the parameters
   for auto picking.
*/
void set_autoCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message=(ClientData *)client_data;
  char *str;

  xdisplay[message->id].auto_flag=True;

  XtSetArg(args[0],XmNvalue,&str);

  XtGetValues(text_auto[0],args,1);
  sscanf(str,"%d",&auto_incr);
  XtFree(str);

  XtGetValues(text_auto[1],args,1);
  sscanf(str,"%d",&auto_size);
  XtFree(str);

  XtGetValues(text_auto[2],args,1);
  sscanf(str,"%f",&auto_weight);
  XtFree(str);

  if (XmToggleButtonGetState(pos_toggle))
    auto_direction=1;
  else
    auto_direction=(-1);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function prompts the user
  for agm paramters.
*/
void agm_parameters(long id)
{
  Widget dialog_form;
  Widget label;
  Widget row_column;
  Widget button;
  ClientData *message;
	char	modelname[9], *s;

  dialog_form=XmCreateFormDialogVa(top_level,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("AGM Parameters"),
				   XtNmanageChild,False,
				   NULL);  
  
  label=XmCreateLabelVa(dialog_form,"Below are the parameters needed to create an AGM file",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);  
  
  row_column=XmCreateRowColumnVa(dialog_form,"row_column",
				 XmNpacking,XmPACK_COLUMN,
				 XmNnumColumns,2,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,label,
				 XmNtopOffset,10,
				 XmNleftAttachment,XmATTACH_FORM,
				 XmNrightAttachment,XmATTACH_FORM,
				 NULL);  
  
  (void)XmCreateLabelVa(row_column,"Units Y (record)",NULL);
  (void)XmCreateLabelVa(row_column,"Units X (trace)",NULL);
  (void)XmCreateLabelVa(row_column,"Units z (sample)",NULL);
  (void)XmCreateLabelVa(row_column,"Modelname (limit to 8 char)",NULL);
  
  agm_text[0]=XmCreateTextVa(row_column,"text",
			     XmNvalue,"Meters",
			     XmNcolumns,8,
			     NULL);  
  
  agm_text[1]=XmCreateTextVa(row_column,"text",
			     XmNvalue,"Meters",
			     XmNcolumns,8,
			     NULL);  
  
  agm_text[2]=XmCreateTextVa(row_column,"text",
			     XmNvalue,"Meters",
			     XmNcolumns,8,
			     NULL);  

/*sprintf(buf,"%-8s",filename);	RJM: commented out: Horn obviously clued out */
  (void)memset( modelname, 0, 9 );
  if( (s = strrchr( filename, '/' )) )
	(void)strncpy( modelname, s+1, MIN( strlen(s+1), 8 ) );
  else
   (void)strncpy( modelname, filename, MIN( strlen(filename), 8 ) );
  if( (s = strchr( modelname, '.' )) )
	*s = '\0';

  agm_text[3]=XmCreateTextVa(row_column,"text",
			     XmNvalue,modelname,
			     XmNcolumns,8,
			     XmNwidth,8,	/* RJM: added */
			     NULL);  
  
  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  
  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,row_column,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNleftAttachment,XmATTACH_FORM,
			      NULL);  
  XtAddCallback(button,XmNactivateCallback,agm_parameterCB,message);
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,row_column,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNrightAttachment,XmATTACH_FORM,
			      NULL);  
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);
  
  XtManageChild(dialog_form);
}



/*
   This function get the parameters
   for the agm format.
   */
typedef struct {
    char *x;
    char *y;
    char *z;
} Units;

void agm_parameterCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  extern convert_to_agm( int, char*, char*, Units* );
  ClientData *message=(ClientData *)client_data;
  char modelname[1024];
  char *str;
  Units units;
#if defined(sun) || defined(__sgi)
  long id;	/* RJM: handle 64-bit architectures */
  
  id=message->id;
#endif
  
  XtSetArg(args[0],XmNvalue,&str);
  
  XtGetValues(agm_text[0],args,1);
  sscanf(str,"%s",buf);
  XtFree(str);
  units.y=(char *)malloc((strlen(buf)+1)*sizeof(char));
  strcpy(units.y,buf);
  
  XtGetValues(agm_text[1],args,1);
  sscanf(str,"%s",buf);
  XtFree(str);
  units.x=(char *)malloc((strlen(buf)+1)*sizeof(char));
  strcpy(units.x,buf);
  
  XtGetValues(agm_text[2],args,1);
  sscanf(str,"%s",buf);
  XtFree(str);
  units.z=(char *)malloc((strlen(buf)+1)*sizeof(char));
  strcpy(units.z,buf);
  
  XtGetValues(agm_text[3],args,1);
  sscanf(str,"%s",modelname);
  XtFree(str);
  modelname[9] = '\0';

/* #ifdef SUN */	/* RJM: commented out */
#if defined(sun) || defined(__sgi)
  convert_to_agm(id,filename,modelname,&units);
#endif

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function prompts the user
  for parameter to write out the picks.
*/
void export_trace_picks(long id, char *filename)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget scroll;
  Widget label;
  Widget button;
  int m;

  out=fopen(filename,"w");
  if (out==NULL) {
    error_message("Cannot open file.");
    return;
  }
  
  dialog_form=XmCreateFormDialogVa(top_level,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,
				   XMstr("Trace Header for Picks"),
				   XtNmanageChild,False,
				   NULL);  
  
  
  label=XmCreateLabelVa(dialog_form,"The picks will be saved with these trace header values.",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);  
  
  
  scroll=XmCreateScrolledWindowVa(dialog_form,"scroll",
				  XmNwidth,500,
				  XmNheight,500,
				  XmNscrollingPolicy,XmAUTOMATIC,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,label,
				  XmNtopOffset,10,
				  XmNleftAttachment,XmATTACH_FORM,
				  XmNrightAttachment,XmATTACH_FORM,
				  NULL);  
  
  
  dialog_window=XmCreateRowColumnVa(scroll,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,1,
				    NULL);  
  
  for (m=0; m<62; m++) {
    trace_value[m]=XmCreateToggleButtonVa(dialog_window,&theader[m][0],NULL);
  }
  
  
  toggle_every=XmCreateToggleButtonVa(dialog_form,"Output pick at every trace",
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,scroll,
				      XmNtopOffset,10,
				      XmNleftAttachment,XmATTACH_FORM,
				      NULL);  
  
  
  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,toggle_every,
			      XmNtopOffset,10,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNleftAttachment,XmATTACH_FORM,
			      NULL);  
  XtAddCallback(button,XmNactivateCallback,export_trace_picksCB,(XtPointer)id);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);
  
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,toggle_every,
			      XmNtopOffset,10,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNrightAttachment,XmATTACH_FORM,
			      NULL);  
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);
  
  XtManageChild(dialog_form);

  return;
}


void export_trace_picksCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id,id_parent;	/* RJM: handle 64-bit architectures */
  int m,m1,n,x,y,start_x,start_y,end_x,end_y,temp_count=1,count=0,count_max=0;
  int trace_offset,width,tvalue;
  int dx;
  float record,trace,sample,temp,offset,scalar,tmp_y,slope;
  char tword[10];
  struct location_struct location;
  struct values_struct values;

  id=(long)client_data;
/*id_parent=xdisplay[id].parent; RJM: commented out.  parent window is a
function of the window the picks were made in! Assign id_parent in picks loop.*/
  
				/* Compute width. */
/*width=(((erec[id_parent]-srec[id_parent])/irec[id_parent])+1)*
    (((etrace[id_parent]-strace[id_parent])/itrace[id_parent])+1);
RJM: can't do this because it assumes that every window (with picks) has
the same number of traces.
*/

				/* Count the number of segments. */
  for (n=0; n<MAX_PICKS; n++) 
    if (picks[n].init==-1) {
      if (visible_segment(id,picks[n].group)) {
	count++;
	if (picks[n].size>count_max)
	  count_max=picks[n].size;
      }
    }
  fprintf(out,"No_Seg     %17.6f\n",(float)count);
  fprintf(out,"Max_Pick   %17.6f\n",(float)count_max);
  fprintf(out,"UnitRec    %17.6f\n",xdisplay[id].axis_units[0]);
  fprintf(out,"UnitTrc    %17.6f\n",xdisplay[id].axis_units[1]);
  fprintf(out,"UnitSmp    %17.6f\n",xdisplay[id].axis_units[2]);
  fprintf(out,"OffsetRec  %17.6f\n",xdisplay[id].axis_offset[0]);
  fprintf(out,"OffsetTrc  %17.6f\n",xdisplay[id].axis_offset[1]);
  fprintf(out,"OffsetSmp  %17.6f\n",xdisplay[id].axis_offset[2]);
  fprintf(out,"NumRec     %17.6f\n",(float)nrec[id]);
  fprintf(out,"NumTrc     %17.6f\n",(float)ntrace[id]);
  fprintf(out,"NumSmp     %17.6f\n",(float)nsamp[id]);

				/* Check if pick is written at every trace. */
  if (XmToggleButtonGetState(toggle_every)) {
    for (n=0; n<MAX_PICKS; n++) {
      if (picks[n].init==-1) {
/*	if (visible_segment(id,picks[n].group)) { RJM */
	if (visible_segment(picks[n].id,picks[n].group)) {
	  id_parent = picks[n].id; /* RJM: correct place to put realize parent*/

	  fprintf(out,"Segment    %17.6f\n",(float)temp_count);
	  if ((int)strlen(picks[n].label)>0)
	    fprintf(out,"Name       %20s\n",picks[n].label);
	  else
	    fprintf(out,"Name       %20s\n","NO_PICK_NAME_HERE");
	  fprintf(out,"Color      %17.6f\n",(float)(int)(picks[n].color-start_pick_color));
	  fprintf(out,"Picks      %17.6f\n",(float)picks[n].size);
	  temp_count++;
	  for (m=0; m<picks[n].size-1; m++) {
/* fprintf( out, "getting picks(n=%d) pick(m=%d) location for record %d, trace %d, sample %d\n", n,m, picks[n].record[m], picks[n].trace[m], picks[n].sample[m] );
fprintf( out, "id=%d, xdisplay[id].parent=%d, picks[n].id=%d\n", id, xdisplay[id].parent, picks[n].id );
fprintf( out, "strace[id]=%d, etrace[id]=%d\n", strace[id], etrace[id] );
fprintf( out, "srec[id]=%d, erec[id]=%d\n", srec[id], erec[id] );
fprintf( out, "test: erec[2]=%d, srec[2]=%d\n", erec[2], srec[2] );
fprintf( out, "test: etrace[2]=%d, strace[2]=%d\n", etrace[2], strace[2] );
*/

/*	    if( picks[n].trace[m] == picks[n].trace[m+1] )
		continue; */	/* RJM: added to handle dup pts problem Paul
		Garossino was having, but then took back out because fails
		for plot with many records, 1 trace/record display */

/*	    location=get_location(*(picks[n].record+m),*(picks[n].trace+m),
				  *(picks[n].sample+m),id);
id may not correspond to window (record) picks were made in!!!!
*/
	    location=get_location(picks[n].record[m],picks[n].trace[m],
				  picks[n].sample[m],
				  picks[n].id);
	    start_x=location.x;
	    start_y=location.y;
/*	    location=get_location(*(picks[n].record+m+1),*(picks[n].trace+m+1),
				  *(picks[n].sample+m+1),id);
id may not correspond to window (record) picks were made in!!!!
*/
	    location=get_location(picks[n].record[m+1],picks[n].trace[m+1],
				  picks[n].sample[m+1],
				  picks[n].id);
	    end_x=location.x;
	    end_y=location.y;
	    if( start_x == end_x )	/* RJM: added */
		continue;

	    tmp_y=(float)start_y;
	    if (start_x!=end_x) {
	      slope=(float)(end_y-start_y)/(float)(end_x-start_x);
	    } else {
	      slope=0;
	    }

	    if( m < picks[n].size-1-1 )   /* RJM: avoid repeating interior pt */
		end_x += start_x<end_x ? -1 : 1;
	    dx = start_x <= end_x ? +1 : -1;	/* RJM: added */
	    for (x=start_x; start_x<=end_x ? x<=end_x : x>=end_x; x+=dx) {
/*	    for (x=start_x; x<=end_x; x++){RJM: FAILS for right to left picks!*/
/*	      y=(int)tmp_y; */
	      y=(int)(tmp_y+0.5);	/* RJM */
	      tmp_y+=slope;
/*	      values=get_values(x,y,id); RJM */
	      values=get_values(x,y,picks[n].id);	/* RJM: changed */
	      record=(float)values.record;
	      trace=(float)values.trace;
	      sample=(float)values.sample;
	      fprintf(out,"Pick       \n");
	      fprintf(out,"Record     %17.6f\n",record);
	      fprintf(out,"Trace      %17.6f\n",trace);
	      fprintf(out,"Sample     %17.6f\n",sample);
		
				/* Compute offset for seismic value. */
/*	      offset=((end_color-start_color+1)/2+start_color); RJM: commented out */
	      offset=(float)(end_color-start_color)/2+(int)start_color; /* RJM: unbias */
/*	      offset+=(xdisplay[id].offset*(int)(end_color-start_color+1))/100.0; RJM */
	      offset+=(xdisplay[picks[n].id].offset*(int)(end_color-start_color+1))/100.0;
	    
				/* Compute scalar for seismic value. */
/*	      scalar=100.0*xdisplay[id].scalar; RJM */
	      scalar=100.0*xdisplay[picks[n].id].scalar;
	      
	    
				/* Compute the seismic value. */
/*	      temp=((float)XGetPixel(xdisplay[id].image,x,y)-offset)/scalar; RJM */
	      temp=((float)XGetPixel(xdisplay[picks[n].id].image,x,y)-offset)/scalar;
	      fprintf(out,"RasValue   %17.6f\n",temp);
	      
				/* Find trace_offset for trace header. */
/*	      if (xdisplay[id].sort) RJM */
	      if (xdisplay[picks[n].id].sort)
		trace_offset=256*((record-srec[id_parent])/irec[id_parent])+
		  (((trace-strace[id_parent])/itrace[id_parent])*
		   ceil((float)(erec[id_parent]-srec[id_parent]+1)/
			(float)irec[id_parent])*256);
	      else
		trace_offset=256*((trace-strace[id_parent])/itrace[id_parent])+
		  (((record-srec[id_parent])/irec[id_parent])*
		   ceil((float)(etrace[id_parent]-strace[id_parent]+1)/
			(float)itrace[id_parent])*256);
	      
	/* RJM: put width calc here as is a function of changing id_parent */
              width=(((erec[id_parent]-srec[id_parent])/irec[id_parent])+1)*
                  (((etrace[id_parent]-strace[id_parent])/itrace[id_parent])+1);

				/* Make sure trace_offset is valid. */

	      if (trace_offset>256*(width-1))
		trace_offset=256*(width-1);
	      
	      for (m1=0; m1<62; m1++) 
		if (XmToggleButtonGetState(trace_value[m1])) {
		  sscanf(&theader[m1][0],"%s",tword);
		  C_SAVER((int*)(traceH[id_parent]+trace_offset),tword,&tvalue,1);
		  fprintf(out,"%-10s %17.6f\n",tword,(float)tvalue);
		}
	    }
	  }
	}
      }
    }
  } else {
    for (n=0; n<MAX_PICKS; n++) {
      if (picks[n].init==-1) {
/*	if (visible_segment(id,picks[n].group)) { RJM */
	if (visible_segment(picks[n].id,picks[n].group)) {
	  id_parent = picks[n].id; /* RJM: correct place to put realize parent*/

	  fprintf(out,"Segment    %17.6f\n",(float)temp_count);
	  if ((int)strlen(picks[n].label)>0)
	    fprintf(out,"Name       %20s\n",picks[n].label);
	  else
	    fprintf(out,"Name       %20s\n","NO_PICK_NAME_HERE");
	  fprintf(out,"Color      %17.6f\n",(float)(int)(picks[n].color-start_pick_color));
	  fprintf(out,"Picks      %17.6f\n",(float)picks[n].size);
	  temp_count++;
	  for (m=0; m<picks[n].size; m++) {

	    record=(float)*(picks[n].record+m);
	    trace=(float)*(picks[n].trace+m);
	    sample=(float)*(picks[n].sample+m);
	    fprintf(out,"Pick       \n");
	    fprintf(out,"Record     %17.6f\n",record);
	    fprintf(out,"Trace      %17.6f\n",trace);
	    fprintf(out,"Sample     %17.6f\n",sample);
	    
				/* Compute offset for seismic value. */
/*	    offset=((end_color-start_color+1)/2+start_color); RJM: commented out */
	    offset=(float)(end_color-start_color)/2+(int)start_color; /* RJM: unbias */
/*	    offset+=(xdisplay[id].offset*(int)(end_color-start_color+1))/100.0; RJM */
	    offset+=(xdisplay[picks[n].id].offset*(int)(end_color-start_color+1))/100.0;
	    
				/* Compute scalar for seismic value. */
/*	    scalar=100.0*xdisplay[picks[n].id].scalar; RJM */
	    scalar=100.0*xdisplay[id].scalar;
	    
/*	    location=get_location((int)record,(int)trace,(int)sample,id);
id may not correspond to window (record) picks were made in!!!!
*/
	    location=get_location((int)record,(int)trace,(int)sample,
		picks[n].id);
	    
				/* Compute the seismic value. */
/*	    temp=((float)XGetPixel(xdisplay[id].image,location.x,location.y) RJM */
	    temp=((float)XGetPixel(xdisplay[picks[n].id].image,location.x,location.y)
		  -offset)/scalar;
	    fprintf(out,"RasValue   %17.6f\n",temp);
	    
				/* Find trace_offset for trace header. */
	    if (xdisplay[picks[n].id].sort)
	      trace_offset=256*((record-srec[id_parent])/irec[id_parent])+
		(((trace-strace[id_parent])/itrace[id_parent])*
		 ceil((float)(erec[id_parent]-srec[id_parent]+1)/
		      (float)irec[id_parent])*256);
	    else
	      trace_offset=256*((trace-strace[id_parent])/itrace[id_parent])+
		(((record-srec[id_parent])/irec[id_parent])*
		 ceil((float)(etrace[id_parent]-strace[id_parent]+1)/
		      (float)itrace[id_parent])*256);
	    
	/* RJM: put width calc here as is a function of changing id_parent */
            width=(((erec[id_parent]-srec[id_parent])/irec[id_parent])+1)*
                  (((etrace[id_parent]-strace[id_parent])/itrace[id_parent])+1);

				/* Make sure trace_offset is valid. */
	    if (trace_offset>256*(width-1))
	      trace_offset=256*(width-1);
	    
	    for (m1=0; m1<62; m1++) 
	      if (XmToggleButtonGetState(trace_value[m1])) {
		sscanf(&theader[m1][0],"%s",tword);
		C_SAVER((int*)(traceH[id_parent]+trace_offset),tword,&tvalue,1);
		fprintf(out,"%-10s %17.6f\n",tword,(float)tvalue);
	      }
	  }
	}
      }
    }
  }
  
  fclose(out);
}
