/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  loading image files.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
/* #ifdef SUN */        /* RJM: commented out */
#if defined(sun)
#include <rasterfile.h>
#else
#include "rasterfile.h"
#endif
#include "xdisplayP.h"
#include "prototyping.h"
#include <localsys.h>
#include "ut_defs.h"
#include "stringutils.h"

extern int window_list[MAX_IMAGES],list_count;

static void getTrcHdrVec( unsigned char*, int, String, int**, int* );

/*
  Save data to an image file.
*/
void save_image(char *filename)
{
  FILE *out;
  char buf1[1024], image_fn[32];
  int i,n,append=0;
  long id;	/* RJM: handle 64-bit architectures */
  Boolean flag=False;
  String	fn;
  int		fd, nbytes, *vec;

				/* Fix filename to contain filename.xsdH. */
  if (strcmp(&filename[strlen(filename)-4],"xsdH")==0)
    strcpy(buf1,filename);
  else
    sprintf(buf1,"%s.xsdH",filename);

				/* Open header file to read. */
  out=fopen(buf1,"r");
				/* Indicate the file might not exist. */
  if (out==NULL)
    flag=True;

  fclose(out);

				/* Open file as write or append. */
  if (flag) {
    out=fopen(buf1,"w");
    if (out==NULL) {
      error_message("Can't open file.");
      return;
    }
    fprintf(out,"Append: %5d\n",append);
  } else {
    out=fopen(buf1,"a+");
    if (out==NULL) {
      error_message("Can't open file.");
      return;
    }
				/* Increment the append number. */
    fseek(out,0,0);
    fgets(buf,1024,out);
    sscanf(buf,"Append: %d",&append);
    append++;
    fseek(out,0,0);
    fprintf(out,"Append: %5d\n",append);
    fseek(out,0,2);
  }

				/* Fix filename to be the directory. */
  if (strcmp(&filename[strlen(filename)-4],"xsdH")==0) {
    strcpy(&filename[strlen(filename)-4],"xsdI");
    strcpy(buf,filename);
  } else
    sprintf(buf,"%s.xsdI",filename);

  mkdir(buf,0777);		/* Try to make the directory. */

				/* Loop through the window list and 
				   write out the parameters. */
  for (n=0; n<list_count; n++) {
    id=window_list[n];
    if (strcmp(xdisplay[id].filename,"Animation")==0) {
      error_message("Cannot save animation windows.");
    } else {
      fprintf(out,"File: %s\n",xdisplay[id].filename);
      fprintf(out,"Comment: %s\n",xdisplay[id].comment);
      fprintf(out,"Type: %s\n",xdisplay[id].type);
      fprintf(out,"Sort: %d\n",xdisplay[id].sort);
      fprintf(out,"Axis: %d\n",xdisplay[id].axis_flag?1:0);
      fprintf(out,"Dual: %d\n",xdisplay[id].dual_flag?1:0);
      fprintf(out,"Record: %d %d %d %d\n",nrec[id],srec[id],erec[id],irec[id]);
      fprintf(out,"Trace: %d %d %d %d\n",ntrace[id],strace[id],etrace[id],itrace[id]);
      fprintf(out,"Sample: %d %d %d %d\n",nsamp[id],ssamp[id],esamp[id],isamp[id]);
      fprintf(out,"Value: %d %e\n",xdisplay[id].offset,xdisplay[id].scalar);
      fprintf(out,"Scale: %f %f\n",1.0/xdisplay[id].pick_x,1.0/xdisplay[id].pick_y);
      fprintf(out,"Units: %f %f %f %f %f %f\n",xdisplay[id].axis_units[0],
	      xdisplay[id].axis_units[1],xdisplay[id].axis_units[2],
	      xdisplay[id].axis_offset[0],xdisplay[id].axis_offset[1],
	      xdisplay[id].axis_offset[2]);
      fprintf(out,"Time: %s\n",xdisplay[id].time);
      fprintf(out,"Date: %s\n",xdisplay[id].date);
      sprintf( image_fn, "Image.%d.%d", append,id);
      fprintf(out,"Image: Image.%d.%d\n",append,id);

      if( (int)strlen( xdisplay[id].data1 ) > 0
	&& ssamp[xdisplay[id].parent] != esamp[xdisplay[id].parent] )/*^tslice*/
      {
        fn = concat( buf, "/", xdisplay[id].data1, ".", image_fn, NULL );
	if( (fd = creat( fn, 0666 )) != -1 )
        {
	  getTrcHdrVec( traceH[xdisplay[id].parent], xdisplay[id].parent,
		xdisplay[id].data1, &vec, &nbytes );

#ifdef LINUXSYSTEM
/* DWN 1/6/99 swap on Linux to Sun byte order */
          for (i=0; i<(nbytes/sizeof(int)); i++) vec[i]=htonl(vec[i]);
#endif

	  write( fd, vec, nbytes );
	  if( vec )
	    free( (char *)vec );
	  close( fd );
          fprintf( out, "Traces1: %s\n", xdisplay[id].data1 );
          fprintf( out, "FileTraces1: %s\n", fn );
	}
	else 
		(void)fprintf( stderr, "Can't create '%s'\n", fn );
        free( fn );
      }

      if( (int)strlen( xdisplay[id].data2 ) > 0
	&& ssamp[xdisplay[id].parent] != esamp[xdisplay[id].parent] )/*^tslice*/
      {
        fn = concat( buf, "/", xdisplay[id].data2, ".", image_fn, NULL );
	if( (fd = creat( fn, 0666 )) != -1 )
        {
	  getTrcHdrVec( traceH[xdisplay[id].parent], xdisplay[id].parent,
		xdisplay[id].data2, &vec, &nbytes );

#ifdef LINUXSYSTEM
/* DWN 1/6/99 swap on Linux to Sun byte order */
          for (i=0; i<(nbytes/sizeof(int)); i++) vec[i]=htonl(vec[i]);
#endif

	  write( fd, vec, nbytes );
	  if( vec )
	    free( (char *)vec );
	  close( fd );
          fprintf( out, "Traces2: %s\n", xdisplay[id].data2 );
          fprintf( out, "FileTraces2: %s\n", fn );
	}
	else 
		(void)fprintf( stderr, "Can't create '%s'\n", fn );
        free( fn );
      }

      if( (int)strlen( xdisplay[id].data3 ) > 0
	&& ssamp[xdisplay[id].parent] != esamp[xdisplay[id].parent] )/*^tslice*/
      {
        fn = concat( buf, "/", xdisplay[id].data3, ".", image_fn, NULL );
	if( (fd = creat( fn, 0666 )) != -1 )
        {
	  getTrcHdrVec( traceH[xdisplay[id].parent], xdisplay[id].parent,
		xdisplay[id].data3, &vec, &nbytes );

#ifdef LINUXSYSTEM
/* DWN 1/6/99 swap on Linux to Sun byte order */
          for (i=0; i<(nbytes/sizeof(int)); i++) vec[i]=htonl(vec[i]);
#endif

	  write( fd, vec, nbytes );
	  if( vec )
	    free( (char *)vec );
	  close( fd );
          fprintf( out, "Traces3: %s\n", xdisplay[id].data3 );
          fprintf( out, "FileTraces3: %s\n", fn );
	}
	else 
		(void)fprintf( stderr, "Can't create '%s'\n", fn );
        free( fn );
      }

      fprintf(out,"End:\n");
    }
  }
    
  fclose(out);

  chdir(buf);			/* Move into the directory. */

				/* Loop through the windows and 
				   write out the rasterfile. */
  for (id=0; id<list_count; id++) {
    if (strcmp(xdisplay[window_list[id]].filename,"Animation")!=0) {
      sprintf(buf,"Image.%d.%d",append,window_list[id]);
      save_raster(window_list[id],buf);
    }
  }
  return;
}



/*
  This function write out a rasterfile.
*/
void save_raster(long id, char *buf)
{
#ifdef CRAY
  int buf1[4];
#else
  struct rasterfile header;
  struct rasterfile swap;
#endif
  int n,out;

  out=open(buf,O_WRONLY|O_TRUNC|O_CREAT,0666);
  if (out==-1) {
    error_message("Can't open file.");
    return;
  }

  header.ras_magic=RAS_MAGIC;
  header.ras_width=xdisplay[id].image->width;
  header.ras_height=xdisplay[id].image->height;
  header.ras_depth=8;
  if (header.ras_width%2 == 0)
    header.ras_length=header.ras_width*header.ras_height;
  else
    header.ras_length=(header.ras_width+1)*header.ras_height;
  header.ras_type=RT_STANDARD;
  header.ras_maptype=RMT_EQUAL_RGB;
  header.ras_maplength=768;

#ifdef CRAY
  buf1[0]=(header.ras_magic<<32)+(header.ras_width&0xffffffff);
  buf1[1]=(header.ras_height<<32)+(header.ras_depth&0xffffffff);
  buf1[2]=(header.ras_length<<32)+(header.ras_type&0xffffffff);
  buf1[3]=(header.ras_maptype<<32)+(header.ras_maplength&0xffffffff);
  write(out,buf1,32);
#else

#ifdef LINUXSYSTEM
  /* DWN 1/6/99 swap bytes on linux so it appears in sun byte order */
  swap.ras_magic=htonl(header.ras_magic);
  swap.ras_width=htonl(header.ras_width);
  swap.ras_height=htonl(header.ras_height);
  swap.ras_depth=htonl(header.ras_depth);
  swap.ras_length=htonl(header.ras_length);
  swap.ras_type=htonl(header.ras_type);
  swap.ras_maptype=htonl(header.ras_maptype);
  swap.ras_maplength=htonl(header.ras_maplength);
  write(out,(void*)&swap,sizeof(swap));
#else
  write(out,(void*)&header,sizeof(header));
#endif

#endif

  write(out,raster_color_red[id],256);
  write(out,raster_color_green[id],256);
  write(out,raster_color_blue[id],256);

  if (header.ras_width%2 == 0)
    write(out,raster[id],header.ras_width*header.ras_height*sizeof(char));
  else
    for (n=0; n<header.ras_height; n++) {
      write(out,(raster[id]+n*header.ras_width),header.ras_width*sizeof(char));
      write(out,raster[id],1);
    }

  close(out);

  return;
}


static void getTrcHdrVec( unsigned char *traceH, int parent, String name,
	int** vec, int *size )
{
	int	nrecs, ntrcperrec, tottraces, toffset, i;
	
	nrecs = (erec[parent]-srec[parent]) / irec[parent] + 1;
	ntrcperrec = (etrace[parent]-strace[parent]) / itrace[parent] + 1;
	tottraces = nrecs * ntrcperrec;

	*size = tottraces * sizeof( int );
	*vec = (int*)malloc( *size );

	for( toffset = i = 0; toffset < tottraces*256; toffset+=256, i++ )
		C_SAVER( (int*)(traceH+toffset), name, &(*vec)[i], 1 );
}
