/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _stringutils
#define _stringutils

#include "C++ExternC.h"
#include "std.h"
#include "funcproto.h"

/* C++ Functions: */
#if defined(__cplusplus) || defined(c_plusplus)

	extern char	**splitArgs( char* args, int argc );

#endif

/* C Functions */
_CPLUSPLUSEXTERNCBEGIN

#if NeedFunctionPrototypes
extern String	allocstr( String string2dup );
extern String	concat( String s1, String s2, ... );
extern Boolean	isfloat( String s, float *output_float );
extern void	itoa( int input_int, char output_char_buf[] );
extern String	itostr( int input_int );
extern String	lowercase( String s );
extern int	numcmp( String num_s1, String num_s2 );
extern int	nwords( String wordlist );
extern String	replace( String s, char oldchar, char newchar );
extern void	reverse( String s );
extern int	rtend( String s );
extern void	squeeze( String s, int character );
extern String	strreplace( String s, String oldstring, String newstring );
extern String	strscan( String s, String substr );
extern String	tokenize( String s, String start_delim, String end_delim );
extern String	uppercase( String s );
extern int	wildmatch( String s, String wildcards );
extern String	word( String s, int nthword );
#else
extern String	allocstr();
extern String	concat();
extern Boolean	isfloat();
extern void	itoa();
extern String	itostr();
extern String	lowercase();
extern int	numcmp();
extern int	nwords();
extern String	replace();
extern void	reverse();
extern int	rtend();
extern void	squeeze();
extern String	strreplace();
extern String	strscan();
extern String	tokenize();
extern String	uppercase();
extern int	wildmatch();
extern String	word();
#endif

_CPLUSPLUSEXTERNCEND

#endif /* _stringutils */
