/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* zip.h 
 * Taken from GNU's gzip.h freeware.
 */
#include <stdio.h>
#include <string.h>

typedef unsigned char  uch;
typedef unsigned short ush;
typedef unsigned long  ulg;

#define DEFLATED    8          /* Deflate method (see algorithm.doc) */
#define WSIZE       0x8000     /* window size--must be a power of two */
#define	GZIP_MAGIC  "\037\213" /* Magic header for zip buf, 1F 8B */

#define ALLOC(type, array, size) { \
      array = (type*)calloc((size_t)(((size)+1L)/2), 2*sizeof(type)); \
      if (array == NULL) fprintf(stderr, \
      "\nzip error: insufficient memory\n"); \
   }
#define FREE(array) {if (array != NULL) free((char*)array), array=NULL;}

/* Macros for getting two-byte and four-byte header values */
#define SH(p) ((ush)(uch)((p)[0]) | ((ush)(uch)((p)[1]) << 8))
#define LG(p) ((ulg)(SH(p)) | ((ulg)(SH((p)+2)) << 16))

	/* in util.c: */
extern uch get_byte();
extern void flush_window(uch*, unsigned);

	/* in inflate.c */
extern int inflate ();

















