/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  zooming data.
*/

#include "xdisplayP.h"
#include "prototyping.h"

extern Boolean prompt_flag;
extern Widget edit_window;
extern int paint_index;

static int start_x,start_y;
static int width,height;
static int s_x,s_y,e_x,e_y;
static Boolean zoom_flag=False;

/*
  This function zooms the
  whole image.
*/
void zoom_allCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  end_zoom(w,(XEvent *)call_data,(long)client_data,1);
}



/*
  This function stores the starting
  point of the zoom drag box.
*/
void start_zoom(XEvent *event)
{
  if (event->xbutton.button!=Button1) return;

  s_x=event->xbutton.x; 
  s_y=event->xbutton.y;
  start_x=s_x;
  start_y=s_y;
  e_x=0;
  e_y=0;
  width=0;
  height=0;
  zoom_flag=True;
}


/*
  This function stores the end
  location of the drag box. It
  then prompts the user for the
  scaling values.
*/
void end_zoom(Widget w, XEvent *event, long id, int mode)
                               /* Flag indicates the whole image is zoomed. */
{
  Widget prompt;
  int root_x,root_y;
  ClientData *message;

  xdisplay[id].mode=1;
  set_mode_label(1,id);

  if (model_mode==id) {
    xdisplay[id].mode=18;
    set_mode_label(18,id);
  }

  if (mode!=1) {
    if (event->xbutton.button!=Button1) return;
    if (!zoom_flag) return;
  }

  zoom_flag=False;

  prompt_flag=True;

				/* The whole image is being zoomed. */
  if (mode!=0) {
    start_x=0; 
    start_y=0;
    width=xdisplay[id].image->width;
    height=xdisplay[id].image->height;
  }

  if (mode==2)
    return;        /* Dragbox for rounding. */

  locate_cursor(&root_x,&root_y);

  
  prompt=XmCreatePromptDialogVa(w,"Scaling Values",
				XmNdefaultPosition,False,
				XmNx,root_x,
				XmNy,root_y,
				XmNdialogTitle,XMstr("Scaling Values"),
				XmNselectionLabelString,
				XMstr("Horizontal and Vertical Scale Factors"),
				NULL);
  XmRemoveTabGroup(prompt);
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_TEXT));
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_HELP_BUTTON));

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=prompt;
  message->id=id;
  XtAddCallback(prompt,XmNokCallback,zoomCB,message);
  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=prompt;
  message->id=(-1);
  XtAddCallback(prompt,XmNcancelCallback,zoomCB,message);
  XtAddCallback(prompt,XmNcancelCallback,refresh_imageCB,(XtPointer)id);
  XtAddCallback(prompt,XmNhelpCallback,helpCB,"scale.help");
  XtAddCallback(prompt,XmNcancelCallback,destroyCB,prompt);

  return;
}



/*
  The function performs the zoom
  of the raster data.
*/
void zoomCB(Widget w, XtPointer client_data, XtPointer call_data )
{
  XmSelectionBoxCallbackStruct	*CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  Widget zoom_window;
  Widget main_window;
  Widget zoom_form;
  float scale_x=1.0,scale_y=1.0;
  int n,offset,image_count,old_record_flag;
  long id;	/* RJM: handle 64-bit architectures */
  int x,y,width_temp,height_temp;
  int temp1,temp2,temp3,temp4,parent;
  char *str;
  unsigned char *data;
  struct values_struct values;
  struct location_struct location;

  prompt_flag=False;

  id=message->id;

  if (id==-1) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

				/* Get scale factors. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

				/* Parse scale factors. */
  if (str!=NULL) 
  {
    sscanf(str,"%f %f",&scale_x,&scale_y);
    XtFree(str);
  }


  image_count=next_image();
  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*zoom_window=XtAppCreateShell("xsd","zoom",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  zoom_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(zoom_window);

				/* Special case. Don't zoom from parent. */
  if (strcmp(xdisplay[id].type,"Wiggle")==0)
    parent=id;
  else
    parent=xdisplay[id].parent;
  
  copy_attributes(image_count,id);

  xdisplay[image_count].parent=parent;
  xdisplay[image_count].sort=xdisplay[id].sort;
  xdisplay[image_count].middle=xdisplay[id].middle;
  xdisplay[image_count].pick_x=(1/scale_x)*xdisplay[id].pick_x;
  xdisplay[image_count].pick_y=(1/scale_y)*xdisplay[id].pick_y;

  x=(int)(xdisplay[id].pick_x*start_x);
  y=(int)(xdisplay[id].pick_y*start_y);
  values=get_values(x,y,id);
  
  srec[image_count]=values.record;
  strace[image_count]=values.trace;
  ssamp[image_count]=values.sample;

  x=(int)(xdisplay[id].pick_x*(width+start_x));
  y=(int)(xdisplay[id].pick_y*(height+start_y));
  values=get_values(x,y,id);

  erec[image_count]=values.record;
  etrace[image_count]=values.trace;
  esamp[image_count]=values.sample;

  irec[image_count]=irec[id];
  itrace[image_count]=itrace[id];
  isamp[image_count]=isamp[id];

				/* Reset record number so the correct x
				   and y will be return for zooming. */
  old_record_flag=xdisplay[xdisplay[image_count].parent].record_flag;
  xdisplay[xdisplay[image_count].parent].record_flag=True;
  

  location=get_location(srec[image_count],strace[image_count],ssamp[image_count],xdisplay[image_count].parent);
  temp1=location.x;
  temp2=location.y;

  location=get_location(erec[image_count],etrace[image_count],esamp[image_count],xdisplay[image_count].parent);
  temp3=(location.x-temp1)+1;
  temp4=(location.y-temp2)+1;

				/* Restore the record flag. */
  xdisplay[xdisplay[image_count].parent].record_flag=old_record_flag;

  temp1=temp1/xdisplay[parent].pick_x;
  temp2=temp2/xdisplay[parent].pick_y;
  temp3=temp3/xdisplay[parent].pick_x;
  temp4=temp4/xdisplay[parent].pick_y;

  data=(unsigned char *)malloc(temp3*temp4*sizeof(char));
  if (strcmp(xdisplay[id].type,"Wiggle")==0)
    parent=id;
  else
    parent=xdisplay[id].parent;

  offset=xdisplay[parent].image->bytes_per_line;
  for (y=temp2; y<temp2+temp4; y++)
    memcpy((char *)(data+(y-temp2)*temp3),
	   (xdisplay[parent].image->data+temp1+y*offset),
	   temp3*sizeof(char));

  width_temp=(int)((xdisplay[parent].pick_x*temp3)/xdisplay[image_count].pick_x); 
  height_temp=(int)((xdisplay[parent].pick_y*temp4)/xdisplay[image_count].pick_y);
  raster[image_count]=(unsigned char *)malloc(width_temp*height_temp
					      *sizeof(char));

  traceH[image_count]=traceH[id];

  offset=temp3;
  scale_x=xdisplay[image_count].pick_x/xdisplay[parent].pick_x;
  scale_y=xdisplay[image_count].pick_y/xdisplay[parent].pick_y;

  for (y=0; y<height_temp; y++)
    for (x=0; x<width_temp; x++)
      *(raster[image_count]+x+y*width_temp)=*(data+(int)(x*scale_x)+
					      (int)(y*scale_y)*offset);

  xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
                                           0,(char *)raster[image_count],
					   width_temp,height_temp,screenDepth,0);

  screen_size(id,&width_temp,&height_temp);

  main_window=XmCreateMainWindowVa(zoom_window,"child_form",
				   XmNshowSeparator,True,
				   NULL);

  strcpy(xdisplay[image_count].filename,xdisplay[id].filename);
  window_title(buf,image_count);
  
  XtVaSetValues(zoom_window,
		XmNtitle,buf,
		NULL);

  zoom_form=XmCreateFormVa(main_window,"main",
			   XmNwidth,width_temp,
			   XmNheight,height_temp+MIN_HEIGHT,
			   NULL);

                                /* Indicate general mode. */
  xdisplay[image_count].mode=1;
  set_mode_label(1,image_count);

  app_menus(zoom_form,image_count,False);

  xdisplay_image(image_count,zoom_window,zoom_form,width_temp,height_temp);

  XtRealizeWidget(zoom_window);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function prompts the user
  to enter the number of time the
  lowpass filter should be performed.
*/
void lowpassCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget working;
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */
  ClientData *message;

  working=XmCreatePromptDialogVa(w,"Performing Low Pass",
				 XmNdialogTitle,XMstr("Perform Lowpass Filter"),
				 XmNselectionLabelString,
				 XMstr("Input the number of iterations."),
				 NULL);
  XmRemoveTabGroup(working);
  XmAddTabGroup(XmSelectionBoxGetChild(working,XmDIALOG_TEXT));
  XmAddTabGroup(XmSelectionBoxGetChild(working,XmDIALOG_HELP_BUTTON));

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=working;
  message->id=id;
  XtAddCallback(working,XmNokCallback,perform_lowpassCB,message);
  XtAddCallback(working,XmNcancelCallback,destroyCB,working);
  XtAddCallback(working,XmNhelpCallback,helpCB,"lowpass.help");
}



/*
  This function performs the lowpass
  filter of the raster data.
*/
void perform_lowpassCB(Widget w, XtPointer client_data, XtPointer call_data )
{
  XmSelectionBoxCallbackStruct	*CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  int n,temp,times=1;
  long id;	/* RJM: handle 64-bit architectures */
  int width,height;
  register unsigned char *data;
  register int x,y,offset;
  char *str;

  id=message->id;

  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

  if (str!=NULL) 
  {
    sscanf(str,"%d",&times);
    XtFree(str);
  }

  height=xdisplay[id].image->height;
  width=xdisplay[id].image->width;

  offset=xdisplay[id].image->bytes_per_line;
  data=(unsigned char *)xdisplay[id].image->data;
  for (n=0; n<times; n++)
    for (y=1; y<height-1; y++)
      for (x=1; x<width-1; x++) {
	temp=(*(data+x+y*offset)*8)+*(data+(x-1)+(y-1)*offset)+
	  *(data+x+(y-1)*offset)+*(data+(x+1)+(y-1)*offset)+
	    *(data+(x-1)+y*offset)+*(data+(x+1)+y*offset)+
	      *(data+(x-1)+(y+1)*offset)+*(data+x+(y+1)*offset)+
		*(data+(x+1)+(y+1)*offset);
	*(data+x+y*offset)=temp/16;
      }

  expose_image(id);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function free up the
  resource of a destroyed image.
*/
void free_imageCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n,tally;
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */

				/* If a animation window don't free image. */
  if ((strcmp(xdisplay[id].filename,"Animation")==0)||
      (strcmp(xdisplay[id].type,"Interleave")==0)) {
				/* No children so delete all resources. */
    strcpy(xdisplay[id].comment,"");
    xdisplay[id].hide_flag=False;
    xdisplay[id].mode=1;
    set_mode_label(1,id);/* RJM: calling this seems stupid: the window's getting destroyed which means mode label widget is history!!!! */
    xdisplay[id].label_flag=False;
    xdisplay[id].number_flag=False;
    destroy_labels(id);
    if (xdisplay[id].init==-1) {
      if( xdisplay[id].cmap) /* RJM: added */
      {
        XFreeColormap(display,xdisplay[id].cmap);
	xdisplay[id].cmap = NULL;
      }
      if( xdisplay[id].gc) /* RJM: added */
      {
        XFreeGC(display,xdisplay[id].gc);
	xdisplay[id].gc = NULL;
      }
    }
    if( raster[id] )	/* RJM: added */
    {
      free((char *)raster[id]); 
      raster[id]=NULL;
    }

if( xdisplay[id].image )
if( xdisplay[id].parent > 0 && xdisplay[xdisplay[id].parent].image != xdisplay[id].image )
(void)fprintf( stderr, "free_imageCB: xdisplay[%d].image=%x != xdisplay[parent=%d].image=%x\n", id, xdisplay[id].image, xdisplay[id].parent, xdisplay[xdisplay[id].parent].image );

    xdisplay[id].image=NULL;	/* RJM: image is used by parent window */
    xdisplay[id].init=0;
    xdisplay[id].parent=(-1);
    return;
  }

  if (xdisplay[id].parent!=id)
    expose_image(xdisplay[id].parent);

				/* If in edit mode first quit. */
  if (edit_mode==id)
    quit_edit();

				/* Reset paint flag. */
  if (strcmp(xdisplay[id].type,"Paint")==0)
    paint_index=0;
				/* Check if the window has any children. */
  tally=0;
  for (n=0; n<MAX_IMAGES; n++)
    if (xdisplay[n].parent==id)
      tally++;

  if (tally==1) { /* No children so delete all resources. */
    strcpy(xdisplay[id].comment,"");
    xdisplay[id].hide_flag=False;
    xdisplay[id].mode=1;
/*  set_mode_label(1,id); */ /* RJM: calling this is stupid: the window's getting destroyed which means mode label widget is history!!!! */
    xdisplay[id].label_flag=False;
    xdisplay[id].number_flag=False;
    if(traceH[id]) {
      free((char *)traceH[id]);
      traceH[id] = NULL;
    }
    destroy_labels(id);
    if( xdisplay[id].init == 0 ) {	/* RJM: added */
	(void)fprintf( stderr,
		"free_imageCB: attempt to delete void window circumvented. "
		"xdisplay[%d].init is null.\n", id );
	xdisplay[id].parent=(-1);
	return;
    }
    else if (xdisplay[id].init==-1) {
      if( xdisplay[id].cmap) /* RJM: added */
      {
        XFreeColormap(display,xdisplay[id].cmap);
	xdisplay[id].cmap = NULL;
      }
      if( xdisplay[id].gc) /* RJM: added */
      {
        XFreeGC(display,xdisplay[id].gc);
	xdisplay[id].gc = NULL;
      }
    }

    if( xdisplay[id].image != NULL ) {	/* RJM: made safer */
      if( (char*)raster[id] != xdisplay[id].image->data )
         free((char *)raster[id]);

      (void)XDestroyImage(xdisplay[id].image);	/* RJM: frees image->data */
      xdisplay[id].image = NULL;
    } else if( raster[id] )
      free( (char*)raster[id] );
    raster[id] = (unsigned char*)NULL;

    xdisplay[id].init=0;
    xdisplay[id].parent=(-1);
  } else {
				/* Have children so delete some resources. */
    xdisplay[id].init=0;
    strcpy(xdisplay[id].comment,"");
    xdisplay[id].hide_flag=False;
    xdisplay[id].mode=1;
/*  set_mode_label(1,id); */ /* RJM: calling this is stupid: the window's getting destroyed which means mode label widget is history!!!! */
    destroy_labels(id);
    if (xdisplay[id].init==-1) {
      if( xdisplay[id].cmap) /* RJM: added */
      {
        XFreeColormap(display,xdisplay[id].cmap);
	xdisplay[id].cmap = NULL;
      }
      if( xdisplay[id].gc) /* RJM: added */
      {
        XFreeGC(display,xdisplay[id].gc);
	xdisplay[id].gc = NULL;
      }
    }
				/* Check if this is the last child. */
    tally=0;
    for (n=0; n<MAX_IMAGES; n++)
      if (xdisplay[n].parent==xdisplay[id].parent)
	tally++;

    if ((tally==1)&&
	(strcmp(xdisplay[xdisplay[id].parent].type,"Wiggle")!=0)) {
      if( xdisplay[xdisplay[id].parent].image != NULL ) { /* RJM: made safer */
        if( (char*)raster[xdisplay[id].parent]
	    != xdisplay[xdisplay[id].parent].image->data )
		free((char *)raster[xdisplay[id].parent]);

        (void)XDestroyImage(xdisplay[xdisplay[id].parent].image);/* RJM: frees image->data */
        xdisplay[xdisplay[id].parent].image=NULL;
      } else if( raster[xdisplay[id].parent])
	free((char *)raster[xdisplay[id].parent]);
      raster[xdisplay[id].parent]=(unsigned char*)NULL;
    }

    if (xdisplay[id].parent!=id) {
      if( xdisplay[id].image != NULL ) {	/* RJM: made safer */
        if( (char*)raster[id] != xdisplay[id].image->data )
           free((char *)raster[id]);

        (void)XDestroyImage(xdisplay[id].image); /* RJM: frees image->data */
        xdisplay[id].image = NULL;
      } else if( raster[id] )
        free( (char*)raster[id] );
      raster[id] = (unsigned char*)NULL;
    }

    xdisplay[id].parent=(-1);
  } 
}



/*
  This function draws the drag
  box for the zooming.
*/
void box_zoom(XEvent *event, long id)
{
  if (event->xbutton.state!=Button1Mask
  ||  !zoom_flag)
    return;

  XSetFunction(display,xdisplay[id].gc,GXequiv);

  XSetLineAttributes(display,xdisplay[id].gc,0,
                     LineSolid,CapNotLast,JoinRound);

  XDrawRectangle(display,xdisplay[id].top,xdisplay[id].gc,
		 start_x,start_y,width,height);

  e_x=event->xbutton.x-s_x;
  e_y=event->xbutton.y-s_y;

  if (e_x < 0) {
    start_x=event->xbutton.x;
    width=(-1)*e_x;
  } else {
    start_x=s_x;
    width=e_x;
  }

  if (e_y < 0) {
    start_y=event->xbutton.y;
    height=(-1)*e_y;
  } else {
    start_y=s_y;
    height=e_y;
  }

  XDrawRectangle(display,xdisplay[id].top,xdisplay[id].gc,
		 start_x,start_y,width,height);

  XSetLineAttributes(display,xdisplay[id].gc,line_width,
                     LineSolid,CapNotLast,JoinRound);

  XSetFunction(display,xdisplay[id].gc,GXcopy);
}
