C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c command line parsing subroutine

      subroutine cmdln (ntap, otap, ist, iend, irs, ire, ns, ne, 
     :     mnemonic1, mnemonic2, mnemonic3, mnemonic4,
     :     reverse, NullValue, NullReplaceValue, Swap, GeoQuest, flat, 
     :     flat1, flat2, verbos )

#include <f77/iounit.h>

c declare variable passed from calling routine

      integer ist, iend, irs, ire, ns, ne

      real NullValue, NullReplaceValue
     
      character  ntap*255, otap*255
      character  mnemonic1*6, mnemonic2*6
      character  mnemonic3*6, mnemonic4*6

      logical verbos, reverse, GeoQuest, flat, flat1, flat2, Swap

c declare local variables

      integer argis

c parse command line

      call argi4('-e',iend,0,0)
      
      flat1 = (argis('-flat1') .gt. 0 )
      flat2 = (argis('-flat2') .gt. 0 )
      flat = (argis('-flat') .gt. 0 )

      GeoQuest = (argis('-G') .gt. 0 )

      call argstr( '-hw1',mnemonic1, ' ', ' ' )
      call argstr( '-hw2',mnemonic2, ' ', ' ' )
      call argstr( '-hw3',mnemonic3, ' ', ' ' )
      call argstr( '-hw4',mnemonic4, ' ', ' ' )

      call argr4('-null', NullValue, 0., 0. )
      call argr4('-amp', NullReplaceValue, 0., 0. )
      call argi4('-ne',ne,0,0)
      call argi4('-ns',ns,0,0)

      call argstr('-N',ntap,' ',' ')

      call argstr('-O',otap,' ',' ')

      Swap = (argis('-Rswap') .gt. 0)

      call argi4('-re',ire,0,0)
      call argi4('-rs',irs,1,1)
      reverse = (argis('-R') .gt. 0)

      call argi4('-s',ist,1,1)

      verbos = (argis('-V') .gt. 0)

      if ( flat2 ) then
         reverse = .false.
         mnemonic1 = 'TrcNum'
         mnemonic2 = 'RecNum'
      endif

c do NullValue default if required

      if ( .not. reverse .and. abs(NullValue) .lt. 1.e-30 ) then
         if (GeoQuest) then
            NullValue = -1.e30
         else
            NullValue = 0.9999900E+3
         endif
      endif
      
      if ( .not. reverse ) then
         if ( flat .or. flat1 .or. Swap )reverse = .true.
      endif

      return
      end
