C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Read_xyz ( luxyz, Num_xyz, X, Y, Z, X_col, Y_col, 
     :     Z_col, verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer Num_xyz, luxyz, X_col, Y_col, Z_col

      real X(Num_xyz), Y(Num_xyz), Z(Num_xyz)

      logical verbos

c declare local variables

      integer i

      real xyzinput(3)

c initialize variables

      if ( verbos ) then
         write(LERR,*) ' '
         write(LERR,*) ' Input x,y,z Data '
         write(LERR,*) ' ----------------'
      endif

c rewind the input file

      rewind ( luxyz )

c read input flat file and assign x,y,z placements based on
c user command line input

      do i = 1, Num_xyz
         call vclr ( xyzinput, 1, 3 )
         read ( luxyz, *, end=9) (xyzinput(j), j= 1,3 )
 9       X(i) = xyzinput(X_col)
         Y(i) = xyzinput(Y_col)
         Z(i) = xyzinput(Z_col)
      enddo

      if ( verbos ) then
         do i = 1, Num_xyz
            write(LERR,*) X(i), Y(i), Z(i)
         enddo
      endif

      return
      end
