C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  xyzin Main Routine -----------------------
c
c a routine which given an arbitrary set of xyz information will
c install the z information in a dataset given that the dataset
c has xy information in the header.  No assumption of 3D indexing
c etc. is required.  The flat file is scanned to determine memory
c requirements.  Memory is allocated, the file is read into memory
c and sorted in terms of x and y.  As traces stream through the x,y
c of the trace is extracted and a value of z for that trace is 
c interpolated using the nearest neighbor search [ala vi3d].
c

c Author: Paul G.A. Garossino May 1998

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, luin, luout, nrec, ntrc, nsi 
      integer     lbytes, obytes, lbyout
      integer     argis

      character   ntap*255, otap*255, name*5

      logical     verbos

c variables used with dynamic memory allocation

      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, errcd7
      integer errcd8, errcd9, abort
      integer X_pointer, Y_pointer, neighborhood
 
      real X, Y, Z, weight, X_sorted, Y_sorted

      pointer ( mem_X, X )
      pointer ( mem_Y, Y )
      pointer ( mem_Z, Z )
      pointer ( mem_X_pointer, X_pointer(1) )
      pointer ( mem_Y_pointer, Y_pointer(1) )
      pointer ( mem_neighborhood, neighborhood(1) )
      pointer ( mem_weight, weight )
      pointer ( mem_X_sorted, X_sorted )
      pointer ( mem_Y_sorted, Y_sorted )

c dimension local variables

      integer luxyz, length, Nfound

      integer ifmt_Xhdrwrd, l_Xhdrwrd, ln_Xhdrwrd, Xhdrwrd
      integer ifmt_Yhdrwrd, l_Yhdrwrd, ln_Yhdrwrd, Yhdrwrd
      integer ifmt_Zhdrwrd, l_Zhdrwrd, ln_Zhdrwrd, Zhdrwrd
      integer StaCor, ifmt_StaCor, l_StaCor, ln_StaCor

      integer JJ, KK, min_num_desired

      real tol, z_scalar, exponent, r_Xhdrwrd, r_Yhdrwrd, r_Zhdrwrd
      real z_replacement

      character xyztap*255, c_Xhdrwrd*6, c_Yhdrwrd*6, c_Zhdrwrd*6

      logical Cosine

c Initialize variables

      data name/"XYZIN"/
      data abort/0/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif


#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, xyztap, name, tol,max_tol, Cosine, 
     :     min_num_desired, z_scalar, z_replacement, exponent, 
     :     c_Xhdrwrd, c_Yhdrwrd, c_Zhdrwrd, X_col, Y_col, Z_col, 
     :     verbos )

c Policemen

      if ( abs(tol) .lt. 1.e-30 ) then
         write(LERR,*)' '
         write(LERR,*)' Interpolation radius cannot be zero'
         write(LERR,*)' Correct and resubmit job'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'XYZIN:  Interpolation radius cannot be zero'
         write(LER,*)'        Correct and resubmit job'
         write(LER,*)'FATAL'
         stop
      endif

c if the user has not entered a maximum search radius then let us 
c open the search up to the point that the old logic functions.  That is
c let Nfound = min_num_desired rule the day.

      if ( abs(max_tol) .lt. 1.e-30 ) then

         max_tol = tol * 1.e20

      endif

c open input dataset

      call getln ( luin, ntap, 'r', 0 )

c read the input line header
         
      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if(lbytes.eq.0)then
         write(LER,*)'XYZIN: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

c glean input nrec, ntrc and global nsamp and nsi from input line header

      call saver ( itr, 'NumRec', nrec, LINEHEADER )
      call saver ( itr, 'NumTrc', ntrc, LINEHEADER )
      call saver ( itr, 'NumSmp', nsamp, LINEHEADER )
      call saver ( itr, 'SmpInt', nsi, LINEHEADER )

c open output dataset      

      call getln(luout, otap,'w', 1)

c open input xyz control file

      call alloclun(luxyz)
      length = lenth(xyztap)
      if (length .eq. 0) then
        write(LERR,*)' '
        write(LERR,*)' ERROR: xyz data file not specified'
        write(LERR,*)' FATAL'
        write(LER,*)' '
        write(LER,*)' XYZIN ERROR: xyz data file not specified'
        write(LER,*)' FATAL'
      endif
      open ( luxyz, file=xyztap(1:length), status='old', err=990 )
      call xyz_init ( luxyz, Num_xyz)

c dynamic memory allocation

      call galloc ( mem_X, Num_xyz * SZSMPD, errcd1, abort )
      call galloc ( mem_Y, Num_xyz * SZSMPD, errcd2, abort )
      call galloc ( mem_Z, Num_xyz * SZSMPD, errcd3, abort )
      call galloc ( mem_X_pointer, Num_xyz * SZSMPD, errcd4, 
     :     abort )
      call galloc ( mem_Y_pointer, Num_xyz * SZSMPD, errcd5, 
     :     abort )
      call galloc ( mem_neighborhood, Num_xyz * SZSMPD, errcd6, 
     :     abort )
      call galloc ( mem_weight, Num_xyz * SZSMPD, errcd7, 
     :     abort )
      call galloc ( mem_X_sorted, Num_xyz * SZSMPD, errcd8, 
     :     abort )
      call galloc ( mem_Y_sorted, Num_xyz * SZSMPD, errcd9, 
     :     abort )

c verify that memory was available

      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 9 * Num_xyz * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 9 * Num_xyz * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 9 * Num_xyz * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif
           
c initialize memory 

      call vclr ( X, 1, Num_xyz )
      call vclr ( Y, 1, Num_xyz )
      call vclr ( Z, 1, Num_xyz )
      call vclr ( weight, 1, Num_xyz )
      call vclr ( X_sorted, 1, Num_xyz )
      call vclr ( Y_sorted, 1, Num_xyz )

      do i = 1, Num_xyz
         X_pointer(i) = 0
         Y_pointer(i) = 0
         neighborhood(i) = 0
      enddo

c define required trace header pointers

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor,
     :     TRACEHEADER )
      call savelu ( c_Xhdrwrd, ifmt_Xhdrwrd, l_Xhdrwrd, ln_Xhdrwrd,
     :     TRACEHEADER )
      call savelu ( c_Yhdrwrd, ifmt_Yhdrwrd, l_Yhdrwrd, ln_Yhdrwrd,
     :     TRACEHEADER )
      call savelu ( c_Zhdrwrd, ifmt_Zhdrwrd, l_Zhdrwrd, ln_Zhdrwrd,
     :     TRACEHEADER )

c print historical line header to printout file

      call hlhprt ( itr, lbytes, name, 5, LERR )

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c update historical line header for current command line entry

      call savhlh( itr, lbytes, lbyout )

c write output line header

      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, xyztap, tol, max_tol, exponent, nrec, 
     :     ntrc, nsamp, nsi, Cosine, min_num_desired, z_scalar, 
     :     c_Xhdrwrd, c_Yhdrwrd, c_Zhdrwrd, X_col, Y_col, Z_col, 
     :     z_replacement, verbos )

c BEGIN PROCESSING

      call Read_xyz ( luxyz, Num_xyz, X, Y, Z, X_col, Y_col, Z_col, 
     :     verbos )

c sort the indexes pointing to x-coordinates & y-coordinates for subroutine get_neighbor
c note that I am sorting X and keeping the pointer information in X_pointer, and sorting
c Y and keeping the pointer information in Y_pointer

      call SRTIDX ( X , X_pointer , Num_xyz ) 
      call SRTIDX ( Y , Y_pointer , Num_xyz ) 

      call vmov ( X, 1, X_sorted, 1, Num_xyz )
      call vmov ( Y, 1, Y_sorted, 1, Num_xyz )

      call hsort ( Num_xyz, X_sorted )
      call hsort ( Num_xyz, Y_sorted )

c Read through USP data, retrieve X,Y data, determine appropriate
c z value and install it in Zhdrwrd.

      do JJ = 1, nrec

         do KK = 1, ntrc
               
            lbytes = 0
            call rtape ( luin, itr, lbytes )
            if ( lbytes .eq. 0 ) then
               write(LERR,*)' Premature EOF on input USP dataset '
               write(LERR,*)' WARNING'
               goto 999
            endif
            
            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

            if ( ifmt_Xhdrwrd .eq. SAVE_SHORT_DEF .or.
     :           ifmt_Xhdrwrd .eq. SAVE_LONG_DEF ) then
               call saver2(itr,ifmt_Xhdrwrd,l_Xhdrwrd, ln_Xhdrwrd,
     1              Xhdrwrd  , TRACEHEADER)
               r_Xhdrwrd = float ( Xhdrwrd )
            else
               call saver2(itr,ifmt_Xhdrwrd,l_Xhdrwrd, ln_Xhdrwrd,
     1              r_Xhdrwrd  , TRACEHEADER)
            endif


            if ( ifmt_Yhdrwrd .eq. SAVE_SHORT_DEF .or.
     :           ifmt_Yhdrwrd .eq. SAVE_LONG_DEF ) then
               call saver2(itr,ifmt_Yhdrwrd,l_Yhdrwrd, ln_Yhdrwrd,
     1              Yhdrwrd  , TRACEHEADER)
               r_Yhdrwrd = float ( Yhdrwrd )
            else
               call saver2(itr,ifmt_Yhdrwrd,l_Yhdrwrd, ln_Yhdrwrd,
     1              r_Yhdrwrd  , TRACEHEADER)
            endif

c work on live traces only

            if ( StaCor .ne. 30000 ) then

c find all functions within the radius of investigation of this location

               call Get_Neighbors ( X_sorted, Y_sorted, r_Xhdrwrd, 
     :              r_Yhdrwrd, neighborhood, weight, Nfound, X_pointer, 
     :              Y_pointer, tol, max_tol,  Num_xyz, Cosine, 
     :              min_num_desired, exponent )
               
C using the neighborhood and weights determined, compute a weighted average of the
c z value for the point in question.  If Nfound is zero then the search must
c have expanded beyond max_tol and was cut off.

               if ( Nfound .gt. 0 ) then
                  call WGTAVG ( Z, Num_xyz, weight, neighborhood, 
     :                 Nfound, r_Zhdrwrd, z_scalar ) 
               else
                  r_Zhdrwrd = Z_replacement
               endif

c load z value to output header 

               if ( ifmt_Zhdrwrd .eq. SAVE_SHORT_DEF .or.
     :              ifmt_Zhdrwrd .eq. SAVE_LONG_DEF ) then
                  Zhdrwrd = nint ( r_Zhdrwrd )
                  call savew2(itr,ifmt_Zhdrwrd,l_Zhdrwrd, ln_Zhdrwrd,
     1                 Zhdrwrd  , TRACEHEADER)
               else
                  call savew2(itr,ifmt_Zhdrwrd,l_Zhdrwrd, ln_Zhdrwrd,
     1                 r_Zhdrwrd  , TRACEHEADER)
               endif

            endif
               
c write out trace data

            call wrtape ( luout, itr, obytes )

         enddo

c end of record

      enddo

c end of input dataset

c Normal Termination

      close ( luxyz )
      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'xyzin: Normal Termination'
      write(LER,*)'xyzin: Normal Termination'
      stop

 990  continue

      write(LERR,*)' '
      write(LERR,*)' Cannot open input xyz data file ',
     :     ntap(1:le1)
      write(LERR,*)' Check spelling / existence and try again'
      write(LERR,*)' FATAL'
      write(LER,*)' '
      write(LER,*)' XYZIN: Cannot open input xyz data file ',
     :     ntap(1:le1)
      write(LER,*)'       Check spelling / existence and try again'
      write(LER,*)' FATAL'
      stop

 999  continue

      close ( luxyz )
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'xyzin: ABNORMAL Termination'
      write(LER,*)'xyzin: ABNORMAL Termination'
      stop
      end
