C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine WritePick(lupick,RecTrace,z,record,NumDepths,SeisDatum,
     :     deltaZ,Color)

      integer  lupick,NumDepths,deltaZ
      integer  Color

      real     RecTrace(*),z(*),SeisDatum
      real     recunit,trcunit,sampunit

      logical record

c
c ----- initialize variables -----
c
      
      recunit = 1.
      trcunit = 1.
      sampunit = float(deltaZ)

c
c ----- write pick file header -----
c

      write(lupick,400)recunit,trcunit,sampunit

 400  format('Units ',f12.6,1x,f12.6,1x,f12.6)

c
c ----- output picks for all RecTrace entries greater than -----
c       SeisDatum (one pick per segment)
c

      do i=1,NumDepths

         if(z(i).le.SeisDatum)then

            write(lupick,401)i,Color,1
 401   format('Segment = ',i5,' Name    NO_PICK_NAME_HERE  color = ',i5,
     :           ' picks = ',i5)

            if(record)then

c
c ----- stacked section is 1 record of many traces -----
c

               write(lupick,402)1.,RecTrace(i),(SeisDatum-z(i))
 402           format(f12.6,1x,f12.6,1x,f12.6)

            else

c
c ----- stacked section is many 1 trace records -----
c

               write(lupick,402)RecTrace(i),1.,(SeisDatum-z(i))

            endif

         endif

      enddo

      return
      end



   
