C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine zecosub(tri,nsampo,first,second,third,graph_max)

c subroutine zecosub
c
c zecosub takes data from the main program in the tri array
c searches for first, second and third zero crossings and accumulates
c occurances in the first, second and third arrays.
c

c get machine dependant variables

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c variables passed from main

      integer nsampo,graph_max

      real first(*),second(*),third(*),tri(*)

c local variables

      integer i,cross_count

      real crossover

c start subroutine

      cross_count = 0

      do i=2,nsampo

c want a sign comparison and zero check

         crossover = tri(i-1)*tri(i) 

         if(crossover.lt.1.)then
   
            cross_count = cross_count + 1

            if(cross_count.gt.3)return

            if(cross_count.eq.1) first(i) = first(i) + 1.
            if(cross_count.eq.2) second(i) = second(i) + 1.

            if(cross_count.eq.3)then

               third(i) = third(i) + 1.
               if(i.gt.graph_max)graph_max = i

            endif

         endif

      enddo

      return
      end
