C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------------zombie-----------------------------------------
c
c Changes:
c
c     added -single option and fixed bug in nextheaderindex in subroutine
c     Garossino December/96
c
c    subrountine changes on 27 Sept 1996 by:
c     James Gridley, Jacquie Vinson
c     USP Team
c     fixed bug of nonzero dot product with multiple interations
c     by using dot as an array on the first iteration only thereby
c     always knowing which traces were originally dead.
c
c
c Updated to header mnemonics and fixed header static bug August, 94
c
c Author P.G.A. Garossino:Amoco Production Research:October,91
c
c zombie reads data in USP format one record at a time.  
c any trace flagged with a 30000 static is filled with data by averaging 
c the adjacent traces.  In the case of steep or aliased dips it is 
c advisable to precondition the data with move out or vred.
c The data is output in USP format with the line header corrected for
c number of traces per record. The 30000 static is replaced with the 
c average of the static entries on either side.  
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

c get machine dependent parameters 

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 

      integer     itr( SZLNHD )
      integer     nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin, lbytes, nbytes, obytes
      integer     argis, ist, iend, irs, ire, ns, ne, JJ, KK

      character   name*6, ntap*255, otap*255

      logical     verbos

c program variables defined with dynamic memory allocation

      integer     SeismicHeaders
      integer     errcd1, errcd2, errcd3, errcd4, abort
      integer     itemHeader, itemRecord

      real        SeismicRecord, WorkSpace, dot

      pointer     (wkadr1, SeismicHeaders(200000) )
      pointer     (wkadr2, SeismicRecord(200000) )
      pointer     (wkadr3, WorkSpace(200000) )
      pointer     (memadr_dot, dot(200000))

c program variables defined with static memory allocation

      integer     indexRecord, indexHeader, NumIter
      integer     fmt_StaCor,l_StaCor,ln_StaCor
      integer     fmt_RecNum,l_RecNum,ln_RecNum
      integer     fmt_TrcNum,l_TrcNum,ln_TrcNum
      logical     StarFlag, Single

c
c       StarFlag   : true = use star pattern sameness search
c		     false = use adjacent trace average

c initialize variables 

      data name/'ZOMBIE'/
      data luin/1/
      data lbytes/0/

c get online help if necessary 

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
         call help ()
         stop
      endif

c open printout files 

#include <f77/open.h>

c get command line parameters 

      call cmdln ( ntap, otap, ist, iend, ns, ne, irs, ire, NumIter,  
     :     StarFlag, Single, verbos )

c get logical units 

      call getln ( luin, ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

c read line header, check to see if input empty 

      lbytes = 0
      call rtape(luin,itr,lbytes)

      if(lbytes .eq. 0) then
         write(LERR,*)'ZOMBIE: no header read on ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c alter line header 

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)

      call hlhprt ( itr , lbytes, name, 6, LERR )

c set up trace header mnemonic pointers to be used later

         call savelu('StaCor',fmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
         call savelu('RecNum',fmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
         call savelu('TrcNum',fmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

c handle record requests

      if(irs .eq. 0) irs = 1
      if(ire .eq. 0) ire = nrec
      nreco = ire - irs + 1

c handle trace requests

      if( ns .lt. 1 ) ns = 1
      if ( ne .lt. 1 ) ne = ntrc
      ntrco = ne - ns + 1

c handle sample requests

      ist = ist / nsi
      iend = iend / nsi
      if( ist .lt. 1 ) ist = 1
      if( iend .lt. 1 ) iend = nsamp
      nsampo = iend - ist + 1

c modify output lineheader 

      call savew( itr, 'NumRec', nreco, LINHED)
      call savew( itr, 'NumTrc', ntrco, LINHED)
      call savew( itr, 'NumSmp', nsampo, LINHED)

c determine number of output bytes

      obytes = SZTRHD + SZSMPD * nsampo

c adjust historical line header & write output line header 

      call savhlh(itr,lbytes,lbyout)
      call wrtape(luout,itr,lbyout)

c verbose printout 

      call verbal( ntap, otap, nsamp, nsampo, nsi, ntrc, ntrco, 
     :     nrec, nreco, iform, ist, iend, irs, ire, ns, ne,  NumIter, 
     :     StarFlag, Single )

c malloc only space we're going to use 

      itemRecord = ntrc * nsamp * SZSMPD
      itemHeader = ntrc * ITRWRD * SZSMPD

      call galloc( wkadr1, itemHeader, errcd1, abort)
      call galloc( wkadr2, itemRecord, errcd2, abort)
      call galloc( wkadr3, itemRecord, errcd3, abort)
      call galloc( memadr_dot, ntrco* SZSMPD, errcd4, abort)
      if (errcd1 .ne. 0
     :     .or. errcd2 .ne. 0 
     :     .or. errcd3 .ne. 0 
     :     .or. errcd4 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemHeader + 2 * itemRecord,' bytes'
         write(LERR,*) ntrco* SZSMPD,' bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemHeader + 2 * itemRecord,' bytes'
         write(LERR,*) ntrco* SZSMPD,' bytes'
         write(LERR,*)' '
      endif

c skip to start record 

      call recskp( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c skip to start trace

         call trcskp( JJ, 1, ns-1, luin, ntrc, itr )

         indexRecord = 1 - nsampo
         indexHeader = 1 - ITRWRD

         DO KK = ns, ne

            nbytes = 0
            call rtape(luin,itr,nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End Of File at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            
            indexRecord = indexRecord + nsampo
            indexHeader = indexHeader + ITRWRD

c load trace and header data

            call vmov(itr(ITHWP1+ist-1), 1, SeismicRecord(indexRecord), 
     :           1, nsampo )
            call vmov(itr, 1, SeismicHeaders(indexHeader), 1, ITRWRD )
         ENDDO

c do sample interpolation

         call zombie_sub ( SeismicRecord, SeismicHeaders, ntrc, ntrco, 
     :        nsamp, nsampo, NumIter, StarFlag, fmt_StaCor, l_StaCor, 
     :        ln_StaCor, Single, dot, verbos )

c output processed record

         indexRecord = 1 - nsampo
         indexHeader = 1 - ITRWRD

         DO KK = ns, ne

c restore trace and header data

            indexRecord = indexRecord + nsampo
            indexHeader = indexHeader + ITRWRD

c load the output trace from work to itr 

            call vmov( SeismicRecord(indexRecord), 1, itr(ITHWP1), 1, 
     :           nsampo )
            call vmov( SeismicHeaders(indexHeader), 1, itr, 1, ITRWRD )

c write out trace 

            call wrtape( luout, itr, obytes )

         ENDDO

c skip to end of record

         call trcskp(JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

 999  continue

      call lbclos(luin)
      call lbclos(luout)

      write(LERR,*)'processed ',nreco,' record(s) with ',ntrc,' traces'
      write(LER,*)'ZOMBIE: Normal Termination'

      stop
      end

