C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
***********************************************************************
      program ZSTRETCH
c_______________________________________________________________________
c     resample an irregularly sampled depth section a regularly sampled	
c     depth section.
c                                 Kurt J. Marfurt
c                                   1/15/92
c     Revised:  August 14, 1995   Mary Ann Thornton
c     Removed the calculation from the savew call and calculated the value
c        before the call.
c     Added a call to savew to insert dz*1000 in the Dz1000 slot
C***********************************************************************
      paraMeter (maxs  = 0 000 002)
      diMension s(maxs)
      pointer  (pntrs , s )
C
      IntEGER   HBEGIN
      parameter (undefined=-1.234567e+20)
      integer argis
      integer      stderr
      real      cputim(20),waltim(20)
C
      IntEGER   sheader(6000)
      character*(80) file_reg,file_irreg
      character*(80) file_zeta

C
      logical      query
      logical      verbose
      character*8  name 
C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>

      parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
c_____________________________________________________________________
c     make interpolation divisions a multiple of 64 to optimize  
c     cray memory addressing.
c     6 point interpolator will loop from -2 to +3.
c_____________________________________________________________________
      parameter (ndiv=128,iws=-2,iwe=+3)
c
      data   luprep1/61/,luprep2/62/,luzeta/63/
      data   stderr/0/    
      data name     /'ZSTRETCH'/
C***********************************************************************
c     get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
         call help()
         call exitfu(0)
      endif
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
c------------------------------------
c     open printout file
c------------------------------------
#include <f77/open.h>
c_____________________________________________________________________
c     read command line arguements
c_____________________________________________________________________
      verbose=(argis('-V') .gt. 0)
      call argstr('-N' ,file_irreg, ' ', ' ')
      call argstr('-O' ,file_reg, ' ', ' ')
      call argstr('-Z',file_zeta,' ',' ')
      if(file_zeta .ne. ' ') then
         open(luzeta,file=file_zeta,status='OLD',
     1         iostat=ioerror,form='FORMATTED')
         if(ioerror .ne. 0) then
            write(lerr,*) 'error in cmdlin'
            write(lerr,*) 'file_zeta = ',file_zeta
            write(lerr,*) 'cannot access/read file'
            close(lerr)
            call exitfu(666)        
         endif
      else
          write(lerr,*)'must supply geometry zeta file!'
          write(lerr,*)'enter file name after -Z option'
          close(lerr)
          call exitfu(666)        
      endif
c_____________________________________________________________________
c     open input and output seismic worktapes.
c_____________________________________________________________________
      call getln(luirreg,file_irreg,'r',0)
      call getln(lureg,file_reg,'w',1)
      write(lerr,'(A20,A10,t40,a50)') 'FILE UNIT', 'VALUE','FILE NAME'
      write(lerr,'(A20,I10,t40,a50)')
     2     'luirreg',luirreg,file_irreg,
     2     'lureg',lureg,file_reg,
     2     'luzeta',luzeta,file_zeta
c_____________________________________________________________________
c     read in irregular seismic worktape header.
c_____________________________________________________________________
      lenvh  = 0
      nbytes = 0
      call rtape(luirreg,sheader,lensh)
      call hlhprt(sheader,lensh,name,8,lerr)
C***********************************************************************
C     pull input data parameters oFF the line header.
C     these will serve as deFault input parameters.
C***********************************************************************
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      call saver(sheader,'NumSmp',nz_tape,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'TmSlIn',idz_1000,LINHEADER)
      dzheader=.001*idz_1000
      nz=nz_tape-1 
c
      call argr4('-dz',dzeql,-99999.,-99999.)  
      if (dzeql .eq. -99999.) dzeql = dzheader
      if(dzeql .le. 0.)   then
         write(lerr,*) 'error in routine ZSTRETCH'
         write(lerr,*) 'output depth increment dz = ',dzeql    
         write(lerr,*) 'input tape value  TmSlIn  = ',idz_1000  
         write(lerr,*) 'enter value after -dz option.'
         close(lerr)
         call exitfu(667)
      endif
C_______________________________________________________________________
c     read in the irregular sampling control information.
C_______________________________________________________________________
      read(luzeta,*,iostat=ioerr)                                      
      if(ioerr .ne. 0) then
         write(lerr,*) ' error in reading file luzeta = ',luzeta
         close(lerr)
         call exitfu(666)
      endif
      read(luzeta,*) 
      read(luzeta,*)
      read(luzeta,*) zmin,zmax,nzctrl
      if(nz .ne. nzctrl) then
         write(lerr,*) 'error in routine stretch'
         write(lerr,*) 'nz from irregular seismic data = ',nz
         write(lerr,*) 'nz from depth control file     = ',nzctrl
         close(lerr)
         call exitfu(667)
      endif
c________________________________________________________________________
c
c     nz.......input depth length in irregularly spaced samples
c     nzbuf....augmented input arrays allowing for operator edges.
c     nzeql....output depth length in equally spaced samples
c________________________________________________________________________
      nzeql=(zmax-zmin)/dzeql
      nzbuf=nz_tape+5       
      lenbuf=lenhed+max(nzeql+1,nz+1)
c
      write(lerr,'(a20,a20)') 'variable','value'
      write(lerr,'(a20,i20)') 'nzeql',nzeql,'nz',nz,'nzbuf',nzbuf,
     1                        'nzctrl',nzctrl
      write(lerr,'(a20,f20.3)') 'zmax',zmax,'zmin',zmin,'dzeql',dzeql  
      
      write(lerr,'(//,a20,3a10)')'variable name','begin','end','length'
C
      l_free=1
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80A1)') ('_',I=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80A1)') ('_',I=1,80)
c
      call mapmem('zeta',l_zeta,l_free,(nz+1),lerr)
      call mapmem('leftzeta',l_leftzeta,l_free,nzeql+1,lerr)
      call mapmem('idiv',l_idiv,l_free,nzeql+1,lerr)
      call mapmem('ueql',l_ueql,l_free,ntr*(nzeql+1),lerr)
      call mapmem('uirreg',l_uirreg,l_free,ntr*nzbuf,lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,lenbuf,lerr)
      call mapmem('trheader',l_trheader,l_free,lenhed*ntr,lerr)
      call mapmem('w',l_w,l_free,6*(ndiv+1),lerr)
C_______________________________________________________________________
C     allocate dynamic memory.                      
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for ZSTRETCH: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for ZSTRETCH: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)                   
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'   
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program ZSTRETCH aborted'
         close(lerr)
         call exitfu(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens       
C_______________________________________________________________________
C     calculate 6 point lagrange interpolation weights for ndiv
c     possible interpolation divisions.
C_______________________________________________________________________
      call getw6(s(l_w),ndiv)
C_______________________________________________________________________
C     write lineheaders for output files.     
C_______________________________________________________________________
      isamp=dzeql
      nztmp=nzeql+1
      idz_out = dzeql*1000.
      call savew(sheader,'SmpInt',isamp,LINEHEADER)
      call savew(sheader,'NumSmp',nztmp,LINEHEADER)
      call savew(sheader,'Dz1000',idz_out,LINEHEADER)
      call savew(sheader,'TmSlIn',idz_out,LINEHEADER)
      call savhlh(sheader,lensh,lbyout)
      call wrtape(lureg,sheader,lbyout)
c
      nbytes_out=(lenhed+nzeql+1)*szsmpd
c
      call zstrsub(s(l_ueql),s(l_uirreg),s(l_w),s(l_zeta),
     1 s(l_leftzeta),s(l_idiv),ndiv,nz,nzeql,nzbuf,dzeql,ntr,nrec,
     2 lerr,hbegin,lenhed,nbytes_out,iws,iwe,luzeta,lureg,luirreg,
     3 s(l_tracebuf),s(l_trheader),lenbuf,cputim,waltim)
C

      call timend(cputime,vtot,v2,waltime,wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read',cputim(1),waltim(1),
     2         'interpolate',cputim(2),waltim(2),
     3         'write',cputim(3),waltim(3),
     4         'total',cputime,waltime

      write(lerr,*)'Normal completion of ZSTRETCH'
      write(ler,*)'Normal completion of ZSTRETCH'
C
      close(lerr)
      call exitfu(0) 
      end
      subroutine  help
#include <f77/iounit.h>
        write(ler,*)' '
        write(ler,*)'Command Line Arguments for zstretch:'
        write(ler,*)'stretch irregularly sampled data to equally '  
        write(ler,*)'   sampled data in the depth domain'           
        write(ler,*)' '
        write(ler,*)'Input....................................... (def)'
        write(ler,*)' '
        write(ler,*)'-N [file_irreg] (stdin)     :'
        write(ler,*)'                input irregular sampled data'  
        write(ler,*)'-O [file_reg  ] (stdout)   :'
        write(ler,*)'                Output regular sampled data'     
        write(ler,*)'-Z [file_zeta]  (no default)    :'
        write(ler,*)'                Input irregular depth grid'      
c
      write(ler,*)'-dz[dzeql]    -- common reflection point'//
     1                             ' z increment (TmMsIn * .001)'
      write(ler,*)'-V           -- verbos printout'
      write(ler,*)' '
      write(ler,*)'Usage:'
      write(ler,*)'        zstretch -N[] -O[] -Z[] -dz[] -V '
      write(ler,*)' '

      return
      end
