/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	hlhc2is.c
	Author	:	Dean Kopesky
	Date	:	May 1988
	Changed	:	March 1990
			Changed us[ci]cti to US[CI]CTI.
			June 1991
			Changed pack() to packbytes().

	Compile with either -D IEEE or -D IBM.

	Hlhc2s translates the historical line header of an SIS file from
	CRAY-2 to SUN format.

	Hlhc2i translates the historical line header of an SIS file from
	CRAY-2 to IBM format.
*/


#include <stdio.h>
#include <sisio.h>

#ifdef CRAY
#ifdef	IEEE
#define	MODULE	"hlhc2s"
#endif
#ifdef	IBM
#define	MODULE	"hlhc2i"
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
#define	MODULE	"hlhin2s"
#endif
#ifdef	IBM
#define	MODULE	"hlhin2i"
#endif
#endif

#define	ENOTENUF	1	/* not enough data in inbuf */
#define	EOVRFLOW	2	/* buffer overflow on outbuf */
#define	EBYTES		3	/* byte count in file is wrong */
#define	EENTRIES	4	/* entry count in file is wrong */

void	exit();
char	*memcpy();


#ifdef	IEEE
void hlhin2s( inbuf, inlen, inptr, outbuf, outlen, outptr )
#endif
#ifdef	IBM
void hlhin2i( inbuf, inlen, inptr, outbuf, outlen, outptr )
#endif

	char *	inbuf;
	int	inlen;
	int	inptr;
	char *	outbuf;
	int	outlen;
	int *	outptr;

{
	int	nentries, nbytes, nbptr;
	int	entry, length, rounded;
	int	ier;
	int	c1 = 1, c2 = 2;
	int	wordsize = WORDSIZE;

#ifdef DEBUG
	fprintf(stderr,"entering %s: inbuf = %08x, inlen = %d, inptr = %d",MODULE,inbuf,inlen,inptr);
	fprintf(stderr,", outbuf = %08x, outlen = %d, outptr = %d (%08x)\n",
		outbuf,outlen,*outptr,outptr);
#endif
	if ( inlen - inptr < WORDSIZE )
	{
		fprintf( stderr, "%s:  not enough data in input record.\n",
			MODULE );
		exit( ENOTENUF );
	}
	if ( outlen - *outptr + 1 < 4 )
	{
		fprintf( stderr, "%s:  buffer overflow on output buffer.\n",
			MODULE );
		exit( EOVRFLOW );
	}

#ifdef CRAY
	memcpy( ( char * ) &nentries, inbuf + inptr, WORDSIZE );
	USICTI( &nentries, outbuf, outptr, &c1, &c2, &ier );
	inptr += WORDSIZEinbuf,;
#endif
#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef DEBUG
	fprintf(stderr,"%s: decoding number of entries\n",MODULE);
	fprintf(stderr,"number in inbuf = %d ( %04x )\n",*(short *)( inbuf + inptr ),*(short *)( inbuf + inptr ));
#endif
	nentries = *(short *)(inbuf + inptr);
	memcpy( (outbuf + *outptr - 1), (inbuf + inptr), 2 );
	CTOHS( (outbuf + *outptr - 1), 1);
	inptr += 2;
#endif
	*outptr += 2;
#ifdef DEBUG
	fprintf(stderr,"%s: nentries = %d\n",MODULE,nentries);
#endif

#ifdef CRAY
	memcpy( ( char * ) &nbytes, inbuf + inptr, WORDSIZE );
	inptr += WORDSIZE;
#endif
#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef DEBUG
	fprintf(stderr,"%s: decoding number of bytes\n",MODULE);
	fprintf(stderr,"number in inbuf = %d ( %04x )\n",*(short *)( inbuf + inptr ),*(short *)( inbuf + inptr ));
#endif
	nbytes = *(short *)(inbuf + inptr );
	inptr += 2;
#endif
	nbptr = *outptr;
	*outptr += 2;
#ifdef DEBUG
	fprintf(stderr,"%s: nbytes = %d\n",MODULE,nbytes);
#endif

	if ( nentries == 0 )
	{
		if ( inlen - inptr != 0 )
		{
		fprintf( stderr, "%s:  byte count in input record is wrong.\n",
				MODULE );
#ifdef DEBUG
	fprintf(stderr,"%s: inlen = %d, inptr = %d\n",MODULE,inlen,inptr);
#endif
			exit( EBYTES );
		}
		nbytes = 4;
#ifdef CRAY
		USICTI( &nbytes, outbuf, &nbptr, &c1, &c2, &ier );
#endif
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		*(short *)(outbuf + nbptr - 1) = nbytes;
		CTOHS((outbuf + nbptr - 1), 1);
#endif
		return;
	}

	if ( nbytes - 2 * HALFWORDSIZE != inlen - inptr )
	{
		fprintf( stderr, "%s:  byte count in input record is wrong.\n",
			MODULE );
#ifdef DEBUG
	fprintf(stderr,"%s: nybtes = %d, HALFWORDSIZE = %d, inlen = %d, inptr = %d\n",MODULE,nbytes,HALFWORDSIZE,inlen,inptr);
#endif
		exit( EBYTES );
	}

	nbytes = 4;

	for ( entry = 1; entry <= nentries; entry++ )
	{
		if ( inlen - inptr < HALFWORDSIZE )
		{
		fprintf( stderr, "%s:  entry count in input record is wrong.\n",
				MODULE );
			exit( EENTRIES );
		}
		if ( outlen - *outptr + 1 < 2 )
		{
		fprintf( stderr, "%s:  buffer overflow on output buffer.\n",
				MODULE );
			exit( EOVRFLOW );
		}
#ifdef CRAY
		memcpy( ( char * ) &length, inbuf + inptr, WORDSIZE );
		rounded = ( ( length - 1 ) / 8 + 1 ) * 8;
		USICTI( &length, outbuf, outptr, &c1, &c2, &ier );
		inptr += WORDSIZE;
#endif
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		length = *(short *)(inbuf + inptr);
		*(short *)(outbuf + *outptr - 1) = length;
		CTOHS((outbuf + *outptr - 1), 1);
		rounded = length;
		inptr += 2;
#endif
		*outptr += 2;

		if ( inlen - inptr < rounded )
		{
		fprintf( stderr, "%s:  not enough data in input record.\n",
				MODULE );
#ifdef DEBUG
		fprintf(stderr,"%s: inlen = %d, inptr = %d, rounded = %d\n",
			MODULE,inlen,inptr,rounded);
#endif
			exit( ENOTENUF );
		}
		if ( outlen - *outptr + 1 < length )
		{
		fprintf( stderr, "%s:  buffer overflow on output buffer.\n",
				MODULE );
			exit( EOVRFLOW );
		}
#ifdef CRAY
#ifdef	IEEE
		packbytes( inbuf + inptr, outbuf, *outptr, length, WORDSIZE );
#endif
#ifdef	IBM
		USCCTI( inbuf + inptr, outbuf, outptr, &length, &wordsize );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
		memcpy( (outbuf + *outptr - 1), (inbuf + inptr), length);
#endif
#endif

		inptr += rounded;
		*outptr += length;
		nbytes += length + 2;
#ifdef DEBUG
	fprintf(stderr,"length of entry #%d = %d ;",entry,length);
	  fprintf(stderr,"nbytes = %d\n",nbytes);
#endif
	}

#ifdef CRAY
	USICTI( &nbytes, outbuf, &nbptr, &c1, &c2, &ier );
#endif
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	*(short *)(outbuf + nbptr - 1) = nbytes;
	CTOHS((outbuf + nbptr - 1), 1);
#endif
}
