/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	iescti.c
	Author	:	Dean Kopesky
	Date	:	March 1990

	Uses CFCI32 to convert (Cray/Intel) floating point data to IEEE format.

	Calling sequence, C:

		iescti( inbuf, outbuf, start, number, ier );

		arg	i/o	type	description
		-----------------------------------
		inbuf	input	float[]	Cray/Intel floating point data.
		outbuf	output	long[]	Array to receive IEEE data.
		start	input	long	Byte in outbuf where data should go;
					numbered from 1.
		number	input	long	Number of values to convert.
		ier	output	int *	Error code; not used.

	Calling sequence, FORTRAN:

		CALL IESCTI( inbuf, outbuf, start, number, ier );

		arg	i/o	type	description
		-----------------------------------
		inbuf	input	real()	Cray/Intel floating point data.
		outbuf	output	int()	Array to receive IEEE data.
		start	input	integer	Byte in outbuf where data should go;
					numbered from 1.
		number	input	integer	Number of values to convert.
		ier	output	integer	Error code; not used.
*/

#define CONVERT4(word) (((word<<24)&0xff000000)|((word<<8)&0x00ff0000)|
	((word>>8)&0x0000ff00)|((word>>24)&0x000000ff))

#include	<stdio.h>

void	exit();
char *	malloc();


void	iescti( inbuf, outbuf, start, number, ier )

	float *	inbuf;
	long *	outbuf;
	long	start;
	long	number;
	int *	ier;

{
#ifdef CRAY
	long *	tmpbuf;

	tmpbuf = (long *) malloc( ( ( number + 1 ) / 2 ) * 8 );
	if ( tmpbuf == NULL )
	{
		fprintf( stderr, "iescti:  cannot malloc workspace." );
		exit( 1 );
	}

	CFCI32( inbuf, tmpbuf, &number );

	memcpy( (char *) outbuf + start - 1, (char *) tmpbuf, 4 * number );

	free( tmpbuf );
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
	int i;
	for (i=0; i<number; i++) outbuf[i+start-1] = CONVERT4(inbuf[i]);
#endif

}
void	IESCTI( inbuf, outbuf, start, number, ier )

	float *	inbuf;
	long *	outbuf;
	long *	start;
	long *	number;
	int *	ier;

{
	iescti( inbuf, outbuf, *start, *number, ier );
}
