/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	readpipe.c
	Author	:	Dean Kopesky
	Date	:	23 July 1987

	Readpipe reads nbyte bytes from file into buffer.  Since readpipe
	keeps trying until nbytes bytes are read or an I/O error occurs,
	it is suitable for reading from pipes.

	Calling sequence, C:

		int		readpipe();
		int		nread, file;
		unsigned	nbytes;
		char		buffer[ LENGTH ];

		nread = readpipe( file, buffer, nbytes );

	Calling sequence, FORTRAN:

		INTEGER		READPIPE
		INTEGER		nread, file, nbytes
		DIMENSION	buffer( LENGTH )

		nread = READPIPE( file, buffer, nbytes )

	Parameters:

		nread	result	The number of bytes actually read, 0 if EOF,
				-1 if error.
		file	input	File descriptor.
		buffer	output	The address of the area to read into.
		nbytes	input	The number of bytes to read.
*/


readpipe( file, buffer, nbytes )

	int		file;		/* input  - file descriptor */
	char		*buffer;	/* output - buffer */
	unsigned	nbytes;		/* input  - number of bytes to read */

{
	int bytesrd, thisrd;

	bytesrd = 0;
	while ( bytesrd < nbytes )
	{
		thisrd = read( file, buffer + bytesrd,
			( unsigned ) ( nbytes - bytesrd ) );
		if ( thisrd <  0 ) return( thisrd );
		if ( thisrd == 0 ) return( bytesrd );
		bytesrd += thisrd;
	}

	return( bytesrd );
}


READPIPE( file, buffer, nbytes )

	int		*file;
	char		*buffer;
	int		*nbytes;

{
	return ( readpipe( *file, buffer, ( unsigned ) *nbytes ) );
}
