/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	vftis2c.c
	Author	:	Dean Kopesky
	Date	:	May 1990
	Changed	:	June 1991
			Changed unpack() to unpackbytes().

	Compile with either -D IEEE or -D IBM.

	vfts2c translates a velocity function (format V) record from
	IEEE to Cray format.

	vfti2c translates a velocity function (format V) record from
	IBM to Cray format.

	The basis for this routine was generated by gencon with the following
	format.  It required much hand modification, however.

	6i2 1i4 1c4 1i4 2c1 19i2 1c3 1b1 1i4 1c1 1c5 1c1 1b1 1c1 1b1 2c1
	100i2 100c6 0c8
*/


#include	<stdio.h>


#define	IEEESIZE	2000
#define	CRAYSIZE	( 996 * 8 )


#ifdef	IEEE
void	vfts2c( inbuf, inlen, outbuf, outlen )
#endif
#ifdef	IBM
void	vfti2c( inbuf, inlen, outbuf, outlen )
#endif

	char *	inbuf;
	int *	inlen;
	char *	outbuf;
	int *	outlen;

{
	int	start, number, length, perword, ier;
	int	n, m, j;

	if ( *inlen != IEEESIZE )
	{
		fprintf( stderr, "vft[is]2c:  record length must be %d.\n",
			IEEESIZE );
		exit( 1 );
	}
	(void) memset( outbuf, 0, CRAYSIZE );

	start = 1;
	number = 6;
	length = 2;
	USICTC( inbuf, &start, outbuf + 0, &number, &length );
	start = 13;
	number = 1;
	length = 4;
	USICTC( inbuf, &start, outbuf + 48, &number, &length );
#ifdef	IEEE
	unpackbytes( inbuf, 17, outbuf + 56, 4, 4, ' ' );
#endif
#ifdef	IBM
	start = 17;
	number = 4;
	perword = 4;
	USCCTC( inbuf, &start, outbuf + 56, &number, &perword );
#endif
	start = 21;
	number = 1;
	length = 4;
	USICTC( inbuf, &start, outbuf + 64, &number, &length );
#ifdef	IEEE
	unpackbytes( inbuf, 25, outbuf + 72, 2, 1, ' ' );
#endif
#ifdef	IBM
	start = 25;
	number = 2;
	perword = 1;
	USCCTC( inbuf, &start, outbuf + 72, &number, &perword );
#endif
	start = 27;
	number = 19;
	length = 2;
	USICTC( inbuf, &start, outbuf + 88, &number, &length );
#ifdef	IEEE
	unpackbytes( inbuf, 65, outbuf + 240, 3, 3, ' ' );
#endif
#ifdef	IBM
	start = 65;
	number = 3;
	perword = 3;
	USCCTC( inbuf, &start, outbuf + 240, &number, &perword );
#endif
	start = 69;
	number = 1;
	length = 4;
	USICTC( inbuf, &start, outbuf + 248, &number, &length );
#ifdef	IEEE
	unpackbytes( inbuf, 73, outbuf + 256, 1, 1, ' ' );
	unpackbytes( inbuf, 74, outbuf + 264, 5, 5, ' ' );
	unpackbytes( inbuf, 79, outbuf + 272, 1, 1, ' ' );
	unpackbytes( inbuf, 81, outbuf + 280, 1, 1, ' ' );
	unpackbytes( inbuf, 83, outbuf + 288, 2, 1, ' ' );
#endif
#ifdef	IBM
	start = 73;
	number = 1;
	perword = 1;
	USCCTC( inbuf, &start, outbuf + 256, &number, &perword );
	start = 74;
	number = 5;
	perword = 5;
	USCCTC( inbuf, &start, outbuf + 264, &number, &perword );
	start = 79;
	number = 1;
	perword = 1;
	USCCTC( inbuf, &start, outbuf + 272, &number, &perword );
	start = 81;
	number = 1;
	perword = 1;
	USCCTC( inbuf, &start, outbuf + 280, &number, &perword );
	start = 83;
	number = 2;
	perword = 1;
	USCCTC( inbuf, &start, outbuf + 288, &number, &perword );
#endif

        /* Grab N, M, and J. */

        memcpy( &n, outbuf + (24 * 8), 8 );
        memcpy( &m, outbuf + (25 * 8), 8 );
        memcpy( &j, outbuf + (26 * 8), 8 );

        /* Convert 4N + M I2s to ints. */

	start = 85;
	number = 4 * n + m;
	length = 2;
	USICTC( inbuf, &start, outbuf + 304, &number, &length );

        /* Convert M A6s to full words. */

#ifdef	IEEE
	unpackbytes(inbuf, 85 + 2*(4*n+m), outbuf+304 + 8*(4*n+m), 6*m, 6, ' ');
#endif
#ifdef	IBM
	start = 85 + 2*(4*n+m);
	number = 6 * m;
	perword = 6;
	USCCTC( inbuf, &start, outbuf + 304 + 8*(4*n+m), &number, &perword );
#endif

        /* Convert interpreter's comments. */

#ifdef	IEEE
	unpackbytes( inbuf, 85 + 2*(4*n+m)+6*m, outbuf + 304 + 8*(4*n+2*m),
		j, 8, ' ' );
#endif
#ifdef	IBM
	start = 85 + 2*(4*n+m)+6*m;
	number = j;
	perword = 8;
	USCCTC( inbuf, &start, outbuf + 304 + 8*(4*n+2*m), &number, &perword );
#endif
	/* *outlen = 8 * 38 + 8 * ( 4 * n + 2 * m ) + ( (j + 7) / 8 ) * 8 ; */
	*outlen = CRAYSIZE;
}
