/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	delgreen.c	
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.
	Date	:	19 June 1987
	Changed	:	March 1990
			Changed usictc to USICTC.

	Deletes green words from an IBM TAPDSK file.
*/

#define MODULE    "delgreen"

#define NORMAL    0  /* normal termination    */
#define READ_ERR  1  /* read error on stdin   */
#define WRITE_ERR 2  /* write error on stdout */

#include <stdio.h>

#define BFRLEN 100000

main()

{ char inbuf [ BFRLEN ];
  char outbuf[ BFRLEN ];
  long inptr, start, endptr, outptr;
  long n_read, length;
  int  c1 = 1, c2 = 2;

  void USICTC();
  char *memcpy();

  endptr = 0;
  outptr = 0;

  while ( ( n_read = readpipe( 0, inbuf + endptr, BFRLEN - endptr ) ) > 0 )

  { endptr += n_read;
    inptr = 0;
    start = 1;
    USICTC( inbuf, &start, &length, &c1, &c2 );

    while ( ( inptr < endptr - 1 ) && ( inptr + length <= endptr ) )
    { memcpy( outbuf + outptr, inbuf + inptr + 8, ( int ) ( length - 8 ) );
      inptr  += length;
      outptr += length - 8;
      start = inptr + 1;
      if ( inptr < endptr - 1 )
        USICTC( inbuf, &start, &length, &c1, &c2 ); }

    memcpy( inbuf, inbuf + inptr, ( int ) ( endptr - inptr ) );
    endptr -= inptr;

    if ( write( 1, outbuf, ( unsigned ) outptr ) != outptr )
    { fprintf( stderr, "%s: write error on stdout.\n", MODULE );
      return( WRITE_ERR ); }

    outptr = 0; }

  if ( n_read < 0 )
  { fprintf( stderr, "%s: read error on stdin.\n", MODULE );
    return( READ_ERR ); }

  return( NORMAL ); }
