/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	resb.c
	Author	:	Dean Kopesky
	Date	:	August 1987
	Changed	:	June 1988
			Modified to use large buffers and to accept the input
			file as a command-line argument.
	Changed	:	March 1990
			Changed usicti to USICTI.
*/


static char	help[] =
"\
\n\
Resb reads a plain data file, adds control words, and writes to stdout a\n\
simple blocked (4) file.  Every block in the output file has the same\n\
specified length.\n\
\n\
Usage:\n\
\n\
	resb [ -H ] [ -blklen ] [ plain ]\n\
\n\
	-H		Prints this help listing.\n\
	-blklen		The desired block length (default is 32760).\n\
	plain		The plain data input file (default is stdin).\n\
\n\
";


#define	MODULE	"resb"
#define	PARAMS	"[ -H ] [ -blklen ] [ plain ]"

#define	ENORMAL	0	/* normal termination */
#define	EUSAGE	1	/* usage error */
#define	EBADIN	2	/* cannot open input file */
#define	ERDERR	3	/* premature EOF or read error on stdin */
#define	EWRERR	4	/* write error on stdout */
#define	ERANGE	6	/* block length out of range */

#define	INLEN	512*1024
#define	OUTLEN	512*1028
#define	MAXBLK	INLEN
#define	MINBLK	1024
#define	DEFBLK	32760

#include	<stdio.h>

void	exit();
void	getargs();
char *	memcpy();
void	USICTI();


main( argc, argv )

	int	argc;
	char	*argv[];

{
	int	ifd;
	int	blksize;

	int	ier;
	char	inbfr[ INLEN ];
	int	inend;
	int	inptr;
	int	nread;
	char	outbfr[ OUTLEN ];
	int	outptr;

	int	c1 = 1, c4 = 4;
	int	start;

	getargs( argc, argv, &ifd, &blksize );

	inend = 0;
	inptr = 0;
	outptr = 0;

	while ( ( nread = readpipe( ifd, inbfr + inend, INLEN - inend ) ) > 0 )
	{
		inend += nread;

		while ( inend - inptr >= blksize )
		{
			start = outptr + 1;
			USICTI( &blksize, outbfr, &start, &c1, &c4, &ier );
			outptr += 4;
			( void ) memcpy( outbfr + outptr, inbfr + inptr,
				blksize );
			inptr += blksize;
			outptr += blksize;
		}

		if ( write( 1, outbfr, ( unsigned ) outptr ) != outptr )
		{
	( void ) fprintf( stderr, "%s:  write error on stdout.\n", MODULE );
			exit( EWRERR );
		}

		outptr = 0;

		( void ) memcpy( outbfr, inbfr + inptr, inend - inptr );
		( void ) memcpy( inbfr, outbfr, inend - inptr );

		inend -= inptr;
		inptr = 0;
	}

	if ( nread < 0 )
	{
	( void ) fprintf( stderr, "%s:  read error on input file.\n", MODULE );
		exit( ERDERR );
	}

	if ( inend - inptr > 0 )
	{
		blksize = inend - inptr;
		start = outptr + 1;
		USICTI( &blksize, outbfr, &start, &c1, &c4, &ier );
		outptr += 4;
		( void ) memcpy( outbfr + outptr, inbfr + inptr, blksize );
		outptr += blksize;

		if ( write( 1, outbfr, ( unsigned ) outptr ) != outptr )
		{
	( void ) fprintf( stderr, "%s:  write error on stdout.\n", MODULE );
			exit( EWRERR );
		}
	}

	return( ENORMAL );
}


void getargs( argc, argv, ifd, blksize )

	int	argc;
	char	*argv[];
	int	*ifd;
	int	*blksize;

{
	int	i;
	int	didifd;

	*ifd = 0;
	*blksize = DEFBLK;

	if ( argc == 1 ) return;

	if ( argc > 4 )
	{
		( void ) fprintf( stderr, "usage:  %s %s\n", MODULE, PARAMS );
		exit( EUSAGE );
	}

	didifd = 0;

	for ( i = 1; i < argc; i++ )
	{
		if ( strcmp( argv[ i ], "-H" ) == 0 )
		{
			( void ) fprintf( stderr, "%s", help );
			exit( ENORMAL );
		}

		if ( sscanf( argv[ i ], "-%d", blksize ) == 1 )
		{
			if ( *blksize < MINBLK || *blksize > MAXBLK )
			{
( void ) fprintf( stderr, "%s:  block size must be in the range [ %d, %d ].\n",
					MODULE, MINBLK, MAXBLK );
				exit( ERANGE );
			}
			continue;
		}

		if ( didifd )
		{
		( void ) fprintf( stderr, "usage:  %s %s\n", MODULE, PARAMS );
			exit( EUSAGE );
		}

		didifd = 1;

		if ( ( *ifd = open( argv[ i ], 0 ) ) < 0 )
		{
	( void ) fprintf( stderr, "%s:  cannot open input file (%s).\n",
				MODULE, argv[ i ] );
			exit( EBADIN );
		}
	}
}
