/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	prfmtH.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988

	Generate subroutine calls to translate SIS historical line headers.
*/


#include	"gencon.h"


void prfmtH( direction, count, size, inptr, outptr )

	int	direction;
	int	count;
	int	size;
	int *	inptr;
	int *	outptr;

{
/* debug
	printf("prfmtH: count = %d, size = %d, inptr = %d, outptr = %d\n",
		count,size,*inptr,*outptr);
*/
	switch( direction )
	{
		case I2C:

printf( "	*outlen = %d;\n", *outptr );
printf( "	hlhi2c( inbuf, *inlen, %d, outbuf, 1000000, outlen );\n",
	*inptr + 1 );
			break;

		case S2C:

printf( "	*outlen = %d;\n", *outptr );
printf( "	hlhs2c( inbuf, *inlen, %d, outbuf, 1000000, outlen );\n",
	*inptr + 1 );
			break;

		case C2S:

printf( "	*outlen = %d;\n", *outptr + 1 );
printf( "	hlhc2s( inbuf, *inlen, %d, outbuf, 1000000, outlen );\n",
	*inptr );
printf( "	*outlen = *outlen - 1;\n" );
			break;

		case C2I:

printf( "	*outlen = %d;\n", *outptr + 1 );
printf( "	hlhc2i( inbuf, *inlen, %d, outbuf, 1000000, outlen );\n",
	*inptr );
printf( "	*outlen = *outlen - 1;\n" );
			break;

		case IN2S:

printf( "	*outlen = %d;\n", *outptr + 1 );
printf( "	hlhin2s( inbuf, *inlen, %d, outbuf, 1000000, outlen );\n",
	*inptr );
printf( "	*outlen = *outlen - 1;\n" );
			break;

		case S2IN:

printf( "	*outlen = %d;\n", *outptr );
printf( "	hlhs2in( inbuf, *inlen, %d, outbuf, 1000000, outlen );\n",
	*inptr + 1 );
			break;

		default:

			fprintf( stderr, "%s: internal error in prfmtH.\n",
				MODULE );
			exit( EINTERN );
			break;
	}
}
