/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	prfmtc.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988
	Changed	:	March 1990
			Changed uscct[ci] to USCCT[CI].
			June 1991
			Changed {un}pack() to {un}packbytes().

	Generate subroutine calls to translate character data.
*/


#include	"gencon.h"


void prfmtc( direction, count, size, inptr, outptr )

	int	direction;
	int	count;
	int	size;
	int *	inptr;
	int *	outptr;

{
/* debug
	printf("prfmtc: count = %d, size = %d, inptr = %d, outptr = %d\n",
		count,size,*inptr,*outptr);
*/
	switch( direction )
	{
		case I2C:

if ( count > 0 )
{
	printf( "\tstart = %d;\n", *inptr + 1 );
	printf( "\tnumber = %d;\n", count * size );
	printf( "\tperword = %d;\n", size );
	printf( "\tUSCCTC( inbuf, &start, outbuf + %d, &number, &perword );\n",
		*outptr );
}
else
{
	printf( "\tstart = %d;\n", *inptr + 1 );
	printf( "\tnumber = *inlen - %d;\n", *inptr );
	printf( "\tperword = %d;\n", size );
	printf( "\tUSCCTC( inbuf, &start, outbuf + %d, &number, &perword );\n",
		*outptr );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, size, WORDSIZE );
}
			*inptr += count * size;
			*outptr += count * WORDSIZE;
			break;

		case S2C:

if ( count > 0 )
	printf( "\tunpackbytes( inbuf, %d, outbuf + %d, %d, %d, ' ' );\n",
		*inptr + 1, *outptr, count * size, size );
else
{
	printf(
	"\tunpackbytes( inbuf, %d, outbuf + %d, *inlen - %d, %d, ' ' );\n",
		*inptr + 1, *outptr, *inptr, size );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, size, WORDSIZE );
}
			*inptr += count * size;
			*outptr += count * WORDSIZE;
			break;

		case C2S:

if ( count > 0 )
	printf( "	packbytes( inbuf + %d, outbuf, %d, %d, %d );\n",
		*inptr, *outptr + 1, count * size, size );
else
{
	printf(
"\tpackbytes( inbuf + %d, outbuf, %d, ( ( *inlen - %d ) / %d ) * %d, %d );\n",
		*inptr, *outptr + 1, *inptr, WORDSIZE, size, size );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, WORDSIZE, size );
}
			*inptr += count * WORDSIZE;
			*outptr += count * size;
			break;

		case C2I:

if ( count > 0 )
{
	printf( "\tstart = %d;\n", *outptr + 1 );
	printf( "\tnumber = %d;\n", count * size );
	printf( "\tperword = %d;\n", size );
	printf( "\tUSCCTI( inbuf + %d, outbuf, &start, &number, &perword );\n",
		*inptr );
}
else
{
	printf( "\tstart = %d;\n", *outptr + 1 );
	printf( "\tnumber = ( ( *inlen - %d ) / %d ) * %d;\n",
		*inptr, WORDSIZE, size );
	printf( "\tperword = %d;\n", size );
	printf( "\tUSCCTI( inbuf + %d, outbuf, &start, &number, &perword );\n",
		*inptr );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, WORDSIZE, size );
}
			*inptr += count * size;
			*outptr += count * size;
			break;

		case S2IN:
		case IN2S:
if ( count > 0 )
{
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, %d);\n",
		*outptr, *inptr, count * size);
}
else
{
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, (*inlen - %d) * %d);\n",
		*outptr, *inptr, *inptr, size );
	printf( "\t*outlen = %d + ( *inlen - %d );\n",
		*outptr, *inptr );
}
			*inptr += count * size;
			*outptr += count * size;
			break;

		default:

			fprintf( stderr, "%s: internal error in prfmtc.\n",
				MODULE );
			exit( EINTERN );
			break;
	}
}
