/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	prfmtt.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988
	Changed	:	June 1991
			Changed {un}pack() to {un}packbytes().

	Generate subroutine calls to pack and unpack data without
	conversion.
*/


#include	"gencon.h"


void prfmtt( direction, count, size, inptr, outptr )

	int	direction;
	int	count;
	int	size;
	int *	inptr;
	int *	outptr;

{
/*
	printf("prfmtt: count = %d, size = %d, inptr = %d, outptr = %d\n",
		count,size,*inptr,*outptr);
*/
	switch( direction )
	{
		case I2C:
		case S2C:

			if ( count > 0 )
printf( "\tunpackbytes( inbuf, %d, outbuf + %d, %d, %d, '\\0' );\n",
	*inptr + 1, *outptr, count * size, size );
			else
			{
printf( "\tunpackbytes( inbuf, %d, outbuf + %d, *inlen - %d, %d, '\\0' );\n",
	*inptr + 1, *outptr, *inptr, size );
printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
	*outptr, *inptr, size, WORDSIZE );
			}
			*inptr += count * size;
			*outptr += count * WORDSIZE;
			break;

		case C2S:
		case C2I:

			if ( count > 0 )
printf( "\tpackbytes( inbuf + %d, outbuf, %d, %d, %d );\n",
	*inptr, *outptr + 1, count * size, size );
			else
			{
printf(
"\tpackbytes( inbuf + %d, outbuf, %d, ( ( *inlen - %d ) / %d ) * %d, %d );\n",
	*inptr, *outptr + 1, *inptr, WORDSIZE, size, size );
printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
	*outptr, *inptr, WORDSIZE, size );
			}
			*inptr += count * WORDSIZE;
			*outptr += count * size;
			break;

		case S2IN:
		case IN2S:
			if ( count > 0 )
printf( "\tmemcpy( outbuf + %d, inbuf + %d, %d );\n",
	*inptr, *outptr, count * size );
			else
			{
printf( "\tmemcpy( outbuf + %d, inbuf + %d, (*inlen - %d) * %d );\n",
	*outptr, *inptr, *inptr, size );
printf( "\t*outlen = %d + ( *inlen - %d );\n",
	*outptr, *inptr );
			}
			*inptr += count * size;
			*outptr += count * size;
			break;

		default:

			fprintf( stderr, "%s: internal error in prfmtt.\n",
				MODULE );
			exit( EINTERN );
			break;
	}
}
