/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	prfmtv.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988

	Generate subroutine calls to copy data without conversion.
	There is no guarantee that this will generate or consume an
	integral number of Cray words!
*/


#include	"gencon.h"


void prfmtv( direction, count, size, inptr, outptr )

	int	direction;
	int	count;
	int	size;
	int *	inptr;
	int *	outptr;

{
/* debug
	printf("prfmtv: count = %d, size = %d, inptr = %d, outptr = %d\n",
		count,size,*inptr,*outptr);
*/
	switch( direction )
	{
		case I2C:
		case S2C:
		case C2S:
		case C2I:
		case S2IN:
		case IN2S:

			if ( count > 0 )
printf( "	memcpy( outbuf + %d, inbuf + %d, %d );\n",
	*outptr, *inptr, count * size );
			else
			{
printf( "	memcpy( outbuf + %d, inbuf + %d, *inlen - %d );\n",
	*outptr, *inptr, *inptr );
printf( "	*outlen = %d + ( *inlen - %d );\n",
	*outptr, *inptr );
			}
			*inptr += count * size;
			*outptr += count * size;
			break;

		default:

			fprintf( stderr, "%s: internal error in prfmtv.\n",
				MODULE );
			exit( EINTERN );
			break;
	}
}
