/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	_readit.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_Readit reads a record from the specified unit, taking into account
	large buffering.

	nread = _readit( unit, buffer, length );

	nread	return	int	Number of bytes read; 0 if EOF; < 0 if error.
	unit	input	int	Unit to read from.
	buffer	output	char *	Buffer to read into.
	length	input	int	Length of buffer.

	Modified 1/26/2001 to modify call to _readsb so check can 
	be done in that routine to determine if incoming word needs
	to be translated.		- Joe M. Wade

	$Header: /m/s1/dmk/xlate/sisio/RCS/_readit.c,v 4.3 91/09/11 08:36:10 dmk Exp $

	$Log:	_readit.c,v $
	Revision 4.3  91/09/11  08:36:10  dmk
	MODSET: 4.3
	Tests for CRAY rather than sun.
	
	Revision 4.1  90/07/13  09:00:31  dmk
	MODSET: 4.1
	Added mods for format L.  Changed calls to eliminate need for dmklib.
	Changed SUN to sun.
	
	Revision 2.1  88/07/12  15:11:41  dmk
	MODSET: 2.1
	Change tempbfr size from LGBUFSIZE to SMBUFSIZE.  Cast third readpipe
	argument to unsigned for lint.
	
	Revision 1.2  88/06/27  09:33:45  dmk
	MODSET: 1.2
	Will now flush the buffer if switching from writing to reading, rather
	than flagging an error.
	
	Revision 1.1  88/06/24  11:33:02  dmk
	Initial revision
	
--------------------------------------------------------------------------- */

#ifdef DEBUG
#include <stdio.h>
#define MODULE "_readit"
#endif

#include	"sisio.h"


int	_readit( unit, buffer, length )

	int	unit;
	char *	buffer;
	int	length;

{
	int	cword;
	int	ferror;
	int	nread;
	int	reclen;
	char	tempbfr[ SMBUFSIZE ];
	int	c1 = 1, c4 = 4;
	int	start;

	/*
		If no large buffering, then just read a record.
	*/
#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef DEBUG
	fprintf(stderr,"entering _readit\n");
	fprintf(stderr,"unit = %d\n",unit);
	fprintf(stderr,"largebuf = %d\n",_sisfit[unit].largebuf);
#endif
#endif

	if ( ! _sisfit[ unit ].largebuf )
	{
#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef DEBUG
	fprintf(stderr,"small buffering is on\n");
#endif
#endif
		if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat )
			reclen = _sisfit[ unit ].hdrlen;
		else
			reclen = _sisfit[ unit ].trclen;

		if ( _sisfit[ unit ].format == 0 ||
				_sisfit[ unit ].format == 'L' )
			reclen = 0;

		if ( reclen != 0 )
		{
			/*
				We know how long the record is, so just read
				it in and check the control word.
			*/

	nread = _readpipe( _sisfit[ unit ].filedes, _sisfit[ unit ].buffer,
		( unsigned ) ( reclen + _sisfit[ unit ].cwlen ) );

			if ( nread < 0 ) return( -E_READ );

			if ( nread == 0 ) return( 0 );

			cword = 0;  /* lint-proofing */

/*	- I think what we actually want to know here is whether
	  we are translating or not 		- j.m.wade 8/11/92

			if ( _sisfit[ unit ].cwlen == WORDSIZE )
*/
#ifdef DEBUG
	fprintf(stderr,"%s: trwhen = %d\n",MODULE,_sisfit[unit].trwhen);
#endif
			if ( _sisfit[ unit ].trwhen != W_ALWAYS &&
			  ( _sisfit[ unit ].trwhen != W_IFDISK
			     || ! ( _sisfit[ unit ].isdisk )) ) {
#ifdef DEBUG
	fprintf(stderr,"_writeit: unit %d - don't translate the green word\n",
		unit);
#endif
				( void ) memcpy( ( char * ) &cword,
					_sisfit[ unit ].buffer, WORDSIZE );
				}
			else
#ifdef	CRAY
				USICTC( _sisfit[ unit ].buffer, &c1, &cword,
					&c1, &c4 );
#else
#if ( BYTE_ORDER == LITTLE_ENDIAN )
			{
#ifdef DEBUG
		fprintf(stderr,"_readit: unit %d - translating control word\n",unit);
#endif
				memcpy(&cword, _sisfit[ unit ].buffer, c4);
				HTOCL( &cword, 1 );
			}
#else
			{
				_error( "_readit", unit, E_INTERNAL );
				exit( E_SISIO + E_INTERNAL );
			}
#endif
#endif

			if ( nread != reclen + _sisfit[ unit ].cwlen ||
					cword != reclen )
				return( -E_RECLEN );

			( void ) memcpy( buffer, _sisfit[ unit ].buffer +
				_sisfit[ unit ].cwlen, reclen );

			_sisfit[ unit ].pointer += 1;

			return( reclen );
		}

		else

		{
			/*
				We don't know how long the record is, so readsb
				the record directly into the buffer parameter,
				and set the appropriate field in the FIT.
			*/

/* - changed call to allow for checking regarding byte Cray/LITTLE_ENDIAN
     special handling				- joe m. wade 1/26/2001

			nread = _readsb( _sisfit[ unit ].filedes, buffer,
				length, _sisfit[ unit ].cwlen );
*/
			nread = _readsb( unit, buffer, length );

			if ( nread < 0 ) return( -E_READ );

			if ( nread == 0 ) return( 0 );

		if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat )
				_sisfit[ unit ].hdrlen = nread;
			else
				_sisfit[ unit ].trclen = nread;

			_sisfit[ unit ].pointer += 1;

			return( nread );
		}
	}

#ifdef DEBUG
fprintf(stderr," after small buffering check\n");
#endif
	/*
		If large buffering, fall through to here and read a bufferful,
		if there isn't at least a full record in the buffer.

		Check first to make sure we're not already writing to this
		unit.  If we are, then flush the buffer.
	*/

	if ( _sisfit[ unit ].lgoper == L_WRITE )
	{
		ferror = _flushit( unit );
		if ( ferror < 0 ) return( ferror );
	}

	_sisfit[ unit ].lgoper = L_READ;

	/*
		If there is not even a control word in the buffer, shift the
		buffer, then read a bunch.  If there is still not a control
		word, flag an EOF.
	*/

#ifdef DEBUG
  fprintf(stderr,"_readit: unit = %d, bfrend = %d, bfrbeg = %d, cwlen = %d\n",
 unit, _sisfit[ unit ].bfrend, _sisfit[ unit ].bfrbeg, _sisfit[ unit ].cwlen);
#endif

	if ( _sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg <
		_sisfit[ unit ].cwlen )
	{
		( void ) memcpy( tempbfr,
			_sisfit[ unit ].buffer + _sisfit[ unit ].bfrbeg,
			_sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg );
		( void ) memcpy( _sisfit[ unit ].buffer, tempbfr,
			_sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg );
		_sisfit[ unit ].bfrend -= _sisfit[ unit ].bfrbeg;
		_sisfit[ unit ].bfrbeg = 0;

		nread = _readpipe( _sisfit[ unit ].filedes,
			_sisfit[ unit ].buffer + _sisfit[ unit ].bfrend,
			( unsigned ) ( LGBUFSIZE - _sisfit[ unit ].bfrend ) );

#ifdef DEBUG
	fprintf(stderr,"_readit: unit %d after _readpipe - nread = %d setting bfrend\n",unit,nread);
#endif
		if ( nread < 0 ) return( -E_READ );

		_sisfit[ unit ].bfrend += nread;
	}

#ifdef DEBUG
  fprintf(stderr,"_readit: unit %d - bfrend = %d, bfrbeg = %d, cwlen = %d\n",
   unit, _sisfit[ unit ].bfrend, _sisfit[ unit ].bfrbeg, _sisfit[ unit ].cwlen);
#endif

	if ( _sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg <
			_sisfit[ unit ].cwlen )
		return( 0 );

	/*
		Translate the control word.
	*/

/*	- I think what we actually want to know here is whether
	  we are translating or not 		- j.m.wade 8/11/92

	if ( _sisfit[ unit ].cwlen == WORDSIZE )
*/
#ifdef DEBUG
	fprintf(stderr,"%s: trwhen = %d\n",MODULE,_sisfit[unit].trwhen);
#endif
	if ( _sisfit[ unit ].trwhen != W_ALWAYS &&
	  ( _sisfit[ unit ].trwhen != W_IFDISK
	     || ! ( _sisfit[ unit ].isdisk )) )
	{
#ifdef DEBUG
	fprintf(stderr,"_writeit: unit %d - don't translate the green word\n",
		unit);
#endif
#ifdef CRAY
		( void ) memcpy( ( char * ) &reclen, _sisfit[ unit ].buffer +
			_sisfit[ unit ].bfrbeg, WORDSIZE );
#else
#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef DEBUG
	fprintf(stderr,"debugging(1): unit %d - bfrend = %d\n",unit,_sisfit[ unit ].bfrend); 
#endif
		( void ) memcpy( ( char * ) &reclen, ( _sisfit[ unit ].buffer +
			_sisfit[ unit ].bfrbeg ), WORDSIZE );
#ifdef DEBUG
	fprintf(stderr,"debugging(2): unit %d - bfrend = %d\n",unit,_sisfit[ unit ].bfrend); 
	fprintf(stderr,"loc of reclen = %08x, size = %d, contents = %08x  (unit=%d)\n",
	  (long)&reclen,sizeof(reclen),*(long *)&reclen,unit);
	fprintf(stderr,"loc of unit = %08x, size = %d, contents = %08x \n",
	  (long)&unit,sizeof(unit),*(long *)&unit);
#endif
/* we shouldn't need this now
		HTOCL( &reclen, 1 );
*/
#ifdef DEBUG
	fprintf(stderr,"loc of reclen = %08x, size = %d, contents = %08x  (unit=%d)\n",
	  (long)&reclen,sizeof(reclen),*(long *)&reclen,unit);
	fprintf(stderr,"loc of unit = %08x, size = %d, contents = %08x\n",
	  (long)&unit,sizeof(unit),*(long *)&unit);
	fprintf(stderr,"debugging(3): unit %d - bfrend = %d\n",unit,_sisfit[ unit ].bfrend);
#endif
#endif
#endif
	}
	else
	{
#ifdef	CRAY
		start = _sisfit[ unit ].bfrbeg + 1;
		USICTC( _sisfit[ unit ].buffer, &start, &reclen, &c1, &c4 );
#else
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		memcpy(&reclen, _sisfit[ unit ].buffer + _sisfit[ unit ].bfrbeg, c4);
#ifdef DEBUG
	fprintf(stderr,"debugging(4): unit %d - bfrend = %d\n",unit,_sisfit[ unit ].bfrend); 
#endif
		HTOCL( &reclen, 1 );
#ifdef DEBUG
	fprintf(stderr,"debugging(5): unit %d - bfrend = %d\n",unit,_sisfit[ unit ].bfrend); 
#endif
#else
		_error( "_readit", unit, E_INTERNAL );
		exit( E_SISIO + E_INTERNAL );
#endif
#endif
	}
/*
   -- added 1/18/99 to catch bad trace green words in buffer - joe m. wade
*/
	if (( _sisfit[ unit ].pointer > 1) &&
	    ( reclen != _sisfit[ unit ].trclen )) return( -E_RECLEN );

#ifdef DEBUG
	fprintf(stderr,"debugging(6): unit %d - bfrbeg = %d\n",unit,_sisfit[ unit ].bfrbeg); 
#endif
	_sisfit[ unit ].bfrbeg += _sisfit[ unit ].cwlen;
#ifdef DEBUG
	fprintf(stderr,"debugging(7): unit %d - bfrbeg = %d\n",unit,_sisfit[ unit ].bfrbeg); 
#endif

	/*
		If there is not a full record in the buffer, shift the
		buffer, then read a bunch.  If there is still not a full
		record, flag an error.
	*/

#ifdef DEBUG
  fprintf(stderr,"_readit: unit %d - bfrend = %d, bfrbeg = %d, reclen = %d\n",
     unit,_sisfit[ unit ].bfrend, _sisfit[ unit ].bfrbeg, reclen);
#endif

	if ( _sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg < reclen )
	{
		( void ) memcpy( tempbfr,
			_sisfit[ unit ].buffer + _sisfit[ unit ].bfrbeg,
			_sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg );
		( void ) memcpy( _sisfit[ unit ].buffer, tempbfr,
			_sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg );
		_sisfit[ unit ].bfrend -= _sisfit[ unit ].bfrbeg;
		_sisfit[ unit ].bfrbeg = 0;

		nread = _readpipe( _sisfit[ unit ].filedes,
			_sisfit[ unit ].buffer + _sisfit[ unit ].bfrend,
			( unsigned ) ( LGBUFSIZE - _sisfit[ unit ].bfrend ) );

		if ( nread < 0 ) return( -E_READ );

		_sisfit[ unit ].bfrend += nread;
	}

	if ( _sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg < reclen )
		return( -E_RECLEN );

	/*
		Check or set the record length in the FIT.
	*/

#ifdef DEBUG
	fprintf(stderr,"debugging(8) unit %d - bfrend = %d, bfrbeg = %d\n",
	  unit,_sisfit[ unit ].bfrend, _sisfit[ unit ].bfrbeg );

	fprintf(stderr,"unit %d - pointer = %d, headerat = %d\n",
	  unit, _sisfit[ unit ].pointer, _sisfit[ unit ].headerat );
#endif
	
	if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat ) {

#ifdef DEBUG
	fprintf(stderr,"debugging(8) unit %d - bfrend = %d, bfrbeg = %d\n",
	  unit,_sisfit[ unit ].bfrend, _sisfit[ unit ].bfrbeg );
	fprintf(stderr,"unit %d - hdrlen = %d\n",unit,_sisfit[ unit ].hdrlen);
#endif

		if ( _sisfit[ unit ].hdrlen == 0 )
		{
			_sisfit[ unit ].hdrlen = reclen;
#ifdef DEBUG
	fprintf(stderr,"unit %d - hdrlen = %d\n",unit,_sisfit[ unit ].hdrlen);
#endif
		}
		else
		{
			if ( _sisfit[ unit ].format != 0 &&
					_sisfit[ unit ].format != 'L' )
				if ( _sisfit[ unit ].hdrlen != reclen )
					return( -E_RECLEN );
		}
	} /*debug*/

	else  /* pointer != headerat */

		if ( _sisfit[ unit ].trclen == 0 )
			_sisfit[ unit ].trclen = reclen;
		else
		{
			if ( _sisfit[ unit ].format != 0 &&
					_sisfit[ unit ].format != 'L' )
				if ( _sisfit[ unit ].trclen != reclen )
					return( -E_RECLEN );
		}


	/*
		Copy the record to the buffer parameter.
	*/
#ifdef DEBUG
	fprintf(stderr,"debugging(9) unit %d - bfrend = %d, bfrbeg = %d\n",
	  unit,_sisfit[ unit ].bfrend, _sisfit[ unit ].bfrbeg );

	fprintf(stderr,"copy the buffer - unit = %d, bfrbeg = %d, reclen = %d\n",
		unit, _sisfit[ unit ].bfrbeg, reclen);

	fprintf(stderr,"unit %d - buffer = %08x, _sisfit buffer = %08x\n",
		unit, (long)buffer,
		(long)(_sisfit[ unit ].buffer + _sisfit[ unit ].bfrbeg));
#endif

	( void ) memcpy( buffer, _sisfit[ unit ].buffer +
		_sisfit[ unit ].bfrbeg, reclen );

	_sisfit[ unit ].bfrbeg += reclen;
	_sisfit[ unit ].pointer += 1;

#ifdef DEBUG
	fprintf(stderr,"debugging(10) unit %d - bfrend = %d, bfrbeg = %d\n",
	  unit,_sisfit[ unit ].bfrend, _sisfit[ unit ].bfrbeg );
#endif

	return( reclen );
}
