/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	_readsb.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_readsb reads a record from a simple blocked file.  Each record in
	a simple blocked file is preceeded by its length in either a four-
	or eight-byte field.

	Calling sequence:

	nread = _readsb( unit, buffer, bfrlen )

	arg	i/o	type	description
	-----------------------------------
	nread	result	int	Number of bytes read, 0 if EOF, < 0 if error.
	unit	input	int	Unit to read from.
	buffer	output	char *	Address of area to read into.
	bfrlen	input	int	Size of buffer.

	Modified 1/26/2001 to handle conversion checking for datasets
        coming in via pipe (with small buffering forced in code)
					- Joe M. Wade

	$Header: /m/s1/dmk/xlate/sisio/RCS/_readsb.c,v 4.3 91/09/11 08:36:31 dmk Exp $

	$Log:	_readsb.c,v $
	Revision 4.3  91/09/11  08:36:31  dmk
	MODSET: 4.3
	Tests for CRAY rather than sun.
	
	Revision 4.1  90/07/13  09:10:02  dmk
	MODSET: 4.1
	Initial revision.
	
--------------------------------------------------------------------------- */


#include <stdio.h>
#include	"sisio.h"

#define	SB_EOF		 0	/* end of file encountered */
#define	SB_OVFLOW	-1	/* buffer overflow */
#define	SB_TOOSHRT	-2	/* record too short */
#define	SB_BADFLD	-3	/* invalid control word length */


int	_readsb( unit, buffer, bfrlen )

	int	unit;
	char	*buffer;
	int	bfrlen;

{
	long	reclen;

#ifdef	CRAY
	if ( _sisfit[ unit ].cwlen != 4 && _sisfit[ unit ].cwlen != 8 ) return( SB_BADFLD );
#else
	if ( _sisfit[ unit ].cwlen != 4 ) return( SB_BADFLD );
#endif

	if ( _readpipe( _sisfit[ unit ].filedes, buffer, ( unsigned ) _sisfit[ unit ].cwlen ) != _sisfit[ unit ].cwlen )
		return( SB_EOF );

	if ( _sisfit[ unit ].trwhen != W_ALWAYS &&
	  ( _sisfit[ unit ].trwhen != W_IFDISK
	     || ! ( _sisfit[ unit ].isdisk )) ) {

	   ( void ) memcpy( ( char * ) &reclen, buffer, WORDSIZE );
	   }
	else {

	  ( void ) memcpy( ( char * ) &reclen, buffer, WORDSIZE );
#ifdef CRAY
	  reclen = ( unsigned ) reclen >>
		( ( WORDSIZE - _sisfit[ unit ].cwlen ) * WORDSIZE );
#endif
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	  CTOHL(&reclen, 1);
#endif
	  }

	if ( reclen > bfrlen ) return( SB_OVFLOW );

	if ( _readpipe( _sisfit[ unit ].filedes, buffer,
	  ( unsigned ) reclen ) != reclen )
		return( SB_TOOSHRT );

	return( reclen );
}
