/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	_writeit.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_Writeit writes a record to the specified unit, taking into account
	large buffering.

	nwrite = _writeit( unit, buffer, length );

	nwrite	return	int	Number of bytes written, < 0 if error.
	unit	input	int	Unit to write to.
	buffer	input	char *	Buffer containing the data to write.
	length	input	int	Length of data in buffer.


	$Header: /m/s1/dmk/xlate/sisio/RCS/_writeit.c,v 4.3 91/09/11 08:37:46 dmk Exp $

	$Log:	_writeit.c,v $
	Revision 4.3  91/09/11  08:37:46  dmk
	MODSET: 4.3
	Tests for CRAY rather than sun.
	
	Revision 4.1  90/07/13  09:06:25  dmk
	MODSET: 4.1
	Added code for format L.  Changed calls to eliminate need for dmklib.
	Changed SUN to sun.
	
	Revision 1.2  88/06/27  09:35:10  dmk
	MODSET: 1.2
	Will now flush the buffer if switching from reading to writing, rather
	than flagging an error.  Fixed a bug in the record length check.
	
	Revision 1.1  88/06/24  11:46:01  dmk
	Initial revision
	
--------------------------------------------------------------------------- */

#ifdef DEBUG
#include <stdio.h>
#define MODULE "_writeit"
#endif

#include	"sisio.h"


int	_writeit( unit, buffer, length )

	int	unit;
	char *	buffer;
	int	length;

{
	int	ier;
	int	ferror;
	int	nwritten;
	int	c1 = 1, c4 = 4;
	int	start;

#ifdef DEBUG
	fprintf(stderr,"entering _writeit: unit = %d, length = %d\n",
		unit,length);
#endif
	/*
		Check or set record length as necessary.
	*/

	if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat )

		if ( _sisfit[ unit ].hdrlen == 0 )
			_sisfit[ unit ].hdrlen = length;
		else
		{
			if ( _sisfit[ unit ].format != 0 &&
					_sisfit[ unit ].format != 'L' )
				if ( _sisfit[ unit ].hdrlen != length )
					return( -E_NEWLEN );
		}

	else	/* pointer != headerat */

		if ( _sisfit[ unit ].trclen == 0 )
			_sisfit[ unit ].trclen = length;
		else
		{
			if ( _sisfit[ unit ].format != 0 &&
					_sisfit[ unit ].format != 'L' )
				if ( _sisfit[ unit ].trclen != length )
					return( -E_NEWLEN );
		}

	/*
		If large buffering is not enabled, simply write the record
		to the file.
	*/

	if ( ! _sisfit[ unit ].largebuf )
	{
		/*
			Translate control word and copy data to FIT buffer.
		*/

/*	- I think what we actually want to know here is whether
	  we are translating or not 		- j.m.wade 8/11/92

		if ( _sisfit[ unit ].cwlen == WORDSIZE )
*/
		if ( _sisfit[ unit ].trwhen != W_ALWAYS &&
		  ( _sisfit[ unit ].trwhen != W_IFDISK
		     || ! ( _sisfit[ unit ].isdisk )) ) {
			( void ) memcpy( _sisfit[ unit ].buffer,
				( char * ) &length, _sisfit[ unit ].cwlen );
#ifdef DEBUG
	fprintf(stderr,"_writeit: small buffering\n");
	fprintf(stderr,"_writeit: unit %d - don't translate the green word\n",
		unit);
#endif
		  }
		else
#ifdef	CRAY
			USICTI( &length, _sisfit[ unit ].buffer, &c1, &c1, &c4,
				&ier );
#else
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		{
#ifdef DEBUG
	fprintf(stderr,"_writeit: unit %d - translating the green word\n",unit);
		fprintf(stderr,"_writeit: unit %d - buffer length = %d\n",
			unit,length);
#endif
			memcpy(_sisfit[ unit ].buffer, (char *) &length, c4);
			CTOHL(_sisfit[ unit ].buffer,1);
		}
#else
		{
			_error( "_writeit", unit, E_INTERNAL );
			exit( E_SISIO + E_INTERNAL );
		}
#endif
#endif

		( void ) memcpy( _sisfit[ unit ].buffer + _sisfit[ unit ].cwlen,
			buffer, length );

		/*
			Write the data to the file.
		*/

#ifdef DEBUG
	fprintf(stderr,"_writeit: attempting to write %d bytes to unit %d\n",
		( unsigned ) ( length + _sisfit[ unit ].cwlen ), unit);
#endif

		nwritten = write( _sisfit[ unit ].filedes,
			_sisfit[ unit ].buffer,
			( unsigned ) ( length + _sisfit[ unit ].cwlen ) );

#ifdef DEBUG
	fprintf(stderr,"_writeit: %d bytes actually written to unit %d\n",
		nwritten, unit);
#endif

		if ( nwritten != length + _sisfit[ unit ].cwlen )
			return( -E_WRITE );

		_sisfit[ unit ].pointer += 1;

		return( nwritten );
	}

	/*
		If large buffering is enabled, fall through to here.

		First, check to make sure we are not already reading on this
		unit.  If we are, then flush the buffer.
	*/
#ifdef DEBUG
	fprintf(stderr,"_writeit: large buffering\n");
	fprintf(stderr,"%s: lgoper = %d, bufsize = %d, bfrend = %d, cwlen = %d\n",
		MODULE,
		_sisfit[ unit ].lgoper,_sisfit[ unit ].bufsize,
	 	_sisfit[ unit ].bfrend,_sisfit[ unit ].cwlen );
	 if (_sisfit[ unit ].bfrend == 0) {
          fprintf(stderr,"first seven bytes = %6s\n",(char *)buffer+1);
	  }
#endif

	if ( _sisfit[ unit ].lgoper == L_READ )
	{
		ferror = _flushit( unit );
		if ( ferror < 0 ) return( ferror );
	}

	_sisfit[ unit ].lgoper = L_WRITE;

	/*
		If there is not enough room in the buffer for the record and
		a control word, write out the buffer.  If there is still not
		enough room, flag an error.
	*/

	if ( _sisfit[ unit ].bufsize - _sisfit[ unit ].bfrend <
		length + _sisfit[ unit ].cwlen )
	{

#ifdef DEBUG
	fprintf(stderr,"_writeit: attempting to write %d bytes to unit %d\n",
		( unsigned ) ( _sisfit[ unit ].bfrend ), unit);
#endif

		nwritten = write( _sisfit[ unit ].filedes,
			_sisfit[ unit ].buffer,
			( unsigned ) _sisfit[ unit ].bfrend );

#ifdef DEBUG
	fprintf(stderr,"_writeit: %d bytes actually written to unit %d\n",
		nwritten, unit);
#endif

		if ( nwritten != _sisfit[ unit ].bfrend ) return( -E_WRITE );

		_sisfit[ unit ].bfrend = 0;
	}

	if ( _sisfit[ unit ].bufsize - _sisfit[ unit ].bfrend <
			length + _sisfit[ unit ].cwlen )
		return( -E_INTERNAL );

	/*
		Translate the control word, then copy the record to the FIT
		buffer.
	*/

/*	- I think what we actually want to know here is whether
	  we are translating or not 		- j.m.wade 8/11/92

	if ( _sisfit[ unit ].cwlen == WORDSIZE )
*/
#ifdef DEBUG
	fprintf(stderr,"%s: trwhen = %d\n",MODULE,_sisfit[unit].trwhen);
#endif
	if ( _sisfit[ unit ].trwhen != W_ALWAYS &&
	  ( _sisfit[ unit ].trwhen != W_IFDISK
	     || ! ( _sisfit[ unit ].isdisk )) )
	{
#ifdef DEBUG
	fprintf(stderr,"_writeit: unit %d - don't translate the green word\n",
		unit);
#endif
		( void ) memcpy( _sisfit[ unit ].buffer +
			_sisfit[ unit ].bfrend, ( char * ) &length, WORDSIZE );
	}
	else
	{
#ifdef	CRAY
		start = _sisfit[ unit ].bfrend + 1;
		USICTI( &length, _sisfit[ unit ].buffer, &start, &c1, &c4,
			&ier );
#else
#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef DEBUG
	fprintf(stderr,"_writeit: unit %d - translating the green word\n",unit);
		fprintf(stderr,"_writeit: unit %d - buffer length = %d\n",unit,length);
fprintf(stderr,"before memcpy: control word = %0*x\n",
2*sizeof(int),*(int *)(_sisfit[ unit ].buffer + _sisfit[unit].bfrend));
#endif
		memcpy(_sisfit[ unit ].buffer + _sisfit[ unit ].bfrend, &length, c4);
#ifdef DEBUG
fprintf(stderr,"after memcpy: control word = %0*x\n",
2*sizeof(int),*(int *)(_sisfit[ unit ].buffer + _sisfit[unit].bfrend));
#endif
		CTOHL(_sisfit[ unit ].buffer + _sisfit[ unit ].bfrend, 1);
#ifdef DEBUG
fprintf(stderr,"after CTOHL: control word = %0*x\n",
2*sizeof(int),*(int *)(_sisfit[unit].buffer + _sisfit[unit].bfrend));
#endif
#else
		_error( "_writeit", unit, E_INTERNAL );
		exit( E_SISIO + E_INTERNAL );
#endif
#endif
	}

	_sisfit[ unit ].bfrend += _sisfit[ unit ].cwlen;

	( void ) memcpy( _sisfit[ unit ].buffer + _sisfit[ unit ].bfrend,
		buffer, length );

	_sisfit[ unit ].bfrend += length;
	_sisfit[ unit ].pointer += 1;

	return( length );
}
