/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef LOCALSYS_H	/*  if LOCALSYS_H is undefined, define it */

#define LOCALSYS_H

#define LITTLE_ENDIAN	1234
#define BIG_ENDIAN	4321
#define PDP_ENDIAN	3412

#ifdef __hpux		/* hp's cpp guarantees 'hpux' will be defined */

#define HAVEASYSTEM
#define	HPUXSYSTEM
#define	X11versionR4
#define HAVE_LIMITS_H 1
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define ASSUMED_SIZE_CHARACTER_POINTEE 1
#define REMSH_DEFINED
#define FTN_TO_C_NAME_COMPATABILITY
#define BYTE_ORDER BIG_ENDIAN

#endif

#ifdef sun		/* sun's cpp guarantees 'sun' will be defined */

#define HAVEASYSTEM
#define	SUNSYSTEM
#define	X11versionR4
#define RSH_DEFINED
#define FTN_TO_C_UNDERSCORE_SUFFIX
#ifdef i386
#define BYTE_ORDER LITTLE_ENDIAN
#else
#define BYTE_ORDER BIG_ENDIAN
#endif
#ifdef SOLARIS
#define HAVE_LIMITS_H 1
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#else
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define LPR_PRINT_CMD
#endif

#endif

#ifdef _IBMR2		/* ibm's cpp guarantees '_IBMR2' will be defined */

#define HAVEASYSTEM
#define AIXSYSTEM
#define	X11versionR3
#define HAVE_LIMITS_H 1
#define REMSH_DEFINED	/* just taking a guess here.... */
#define FTN_TO_C_NAME_COMPATABILITY
#define BYTE_ORDER BIG_ENDIAN

#endif
#ifdef CRAY		/* cray's cpp guarantees 'CRAY' will be defined */

#define HAVEASYSTEM
#define CRAYSYSTEM
#define	X11versionR4
#define HAVE_LIMITS_H 1
#define HAVE_SYS_IOCTL_H 1
#define ASSUMED_SIZE_CHARACTER_POINTEE 1
#define COLUMN_6_CONTINUATION 1
#define C_COMMENTS_DISALLOWED 1
#define REMSH_DEFINED
#define FTN_TO_C_UPPERCASE
#define BYTE_ORDER BIG_ENDIAN

#endif

#ifdef __convex__   /* convex's cpp guarantees '__convex__' will be defined */

#define HAVEASYSTEM
#define	CONVEXSYSTEM
#define	X11versionR4
#define HAVE_SYS_IOCTL_H 1
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#define C_COMMENTS_DISALLOWED 1
#define RSH_DEFINED
#define FTN_TO_C_UNDERSCORE_SUFFIX
#define BYTE_ORDER BIG_ENDIAN

#endif

#ifdef CM5

#define HAVEASYSTEM
#define	CM5SYSTEM
#define	X11versionR5
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#define RSH_DEFINED
#define BYTE_ORDER BIG_ENDIAN

#endif

#ifdef __sgi

#define HAVEASYSTEM
#define	SGISYSTEM
#define	X11versionR5
#define HAVE_LIMITS_H 1
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define DEFINED_SIZE_CHARACTER_POINTEE 1
#define COLUMN_6_CONTINUATION 1
#define RSH_DEFINED
#define FTN_TO_C_UNDERSCORE_SUFFIX
#define BYTE_ORDER BIG_ENDIAN

#endif

#ifdef linux

#define HAVEASYSTEM
#define LINUXSYSTEM
#define HAVE_LIMITS_H 1
#define HAVE_SYS_FILIO_H 1
#define HAVE_SYS_IOCTL_H 1
#define REMSH_DEFINED
#define FTN_TO_C_NAME_COMPATABILITY
#define BYTE_ORDER LITTLE_ENDIAN

#endif

#ifdef __alpha		/* NCP's cpp guarantees '__alpha' will be defined */

#define HAVEASYSTEM
#define	DECSYSTEM
#define HAVE_LIMITS_H 1
#define HAVE_SYS_IOCTL_H 1
#define ASSUMED_SIZE_CHARACTER_POINTEE 1
#define FTN_TO_C_UNDERSCORE_SUFFIX
#define BYTE_ORDER LITTLE_ENDIAN

#endif



#ifndef HAVEASYSTEM	/* if nothing has been defined by now, kill compiler
				by entering garbage */
	kill <- the -> compiler  :: NO SYSTEM
#endif

#endif
