/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	rtape.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	Reads a record from the specified unit, translating to CRAY format
	if necessary, and returning its length in bytes.  If the file is at
	EOF, no data will be read, and length will be set to 0.

	FORTRAN:

	CALL RTAPE( unit, buffer, length )

	unit	input	integer	Unit number to read from.
	buffer	output	array	Buffer to read data into.
	length	output	integer	Size of record read in bytes.

	C:

	rtape( unit, buffer, length );

	unit	input	int	Unit number to read from.
	buffer	output	array	Buffer to read data into.
	length	output	int *	Size of record read in bytes.


	$Header: /m/s1/dmk/xlate/sisio/RCS/rtape.c,v 4.3 91/09/11 08:48:30 dmk Exp $

	Moved tempbfr declaration to top-level and made it static to prevent
	stack overflow on the Convex.
		      94/08/25            zjmw36

	$Log:	rtape.c,v $
	Revision 4.3  91/09/11  08:48:30  dmk
	MODSET: 4.3
	Changed entry point names to macros.  Tests for CRAY, not sun.
	
	Revision 4.1  90/07/13  09:17:56  dmk
	MODSET: 4.1
	Added code for format L and V.  Changed calls to eliminate need for
	dmklib.  Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:54:42  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.2  88/07/20  08:55:50  dmk
	MODSET: 2.2
	Added CHECKDOIO.
	
	Revision 2.1  88/07/12  15:35:06  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.
	
	Revision 1.1  88/06/28  08:39:03  dmk
	Initial revision
	
--------------------------------------------------------------------------- */

#ifdef DEBUG
#include	<stdio.h>
#endif
#include	"sisio.h"

#define	MODULE	"RTAPE"

static	char	tempbfr[ SMBUFSIZE ];

void	F_RTAPE( unit, buffer, length )

	int *	unit;
	char *	buffer;
	int *	length;

{
	C_RTAPE( *unit, buffer, length );
}


void	C_RTAPE( unit, buffer, length )

	int	unit;
	char *	buffer;
	int *	length;

{
	int	nrecs;
	int	reclen;
/*
	char	tempbfr[ SMBUFSIZE ];
*/
	LOGICAL	translate;
	int	c1 = 1;
	int	ieeefmtbyte = IEEEFMTBYTE, ieeefmtsize = IEEEFMTSIZE;

	/*
		Initialize package if necessary.  Check for outstanding
		error condition.  Check unit for range and to make sure 
		it's open.  Check to make sure we really want to do I/O.
	*/

	INITIALIZE;
	CHECKERROR(MODULE,unit);
	CHECKRANGE(MODULE,unit);
	CHECKOPEN(MODULE,unit);
	CHECKDOIO(MODULE,unit);

	/*
		Determine whether to translate the record.
	*/

	translate =	( _sisfit[ unit ].trwhen == W_ALWAYS ||
			( _sisfit[ unit ].trwhen == W_IFDISK &&
			_sisfit[ unit ].isdisk ) );

	/*
		If we don't need to translate the record, just read it into
		the output buffer and return.
	*/

	if ( ! translate )
	{
		reclen = _readit( unit, buffer, SMBUFSIZE );

		if ( reclen < 0 )
		{
			_error( MODULE, unit, -reclen );
			return;
		}

#ifdef DEBUG
fprintf(stderr,"no translation: reclen returned from _readit = %d\n",reclen);
#endif
		*length = reclen;
		return;
	}

	/*
		Otherwise, fall through to here, read the record into a
		temporary buffer and translate it.
	*/

	reclen = _readit( unit, tempbfr, _sisfit[ unit ].bufsize );

#ifdef DEBUG
fprintf(stderr,"data translation: reclen returned from _readit = %d\n",reclen);
#endif
	if ( reclen < 0 )
	{
		_error( MODULE, unit, -reclen );
		return;
	}

	if ( reclen == 0 )
	{
		*length = 0;
		return;
	}

	if ( _sisfit[ unit ].pointer - 1 == _sisfit[ unit ].headerat )

	{
		/*
			Translate a line header.
			First, figure out the format, if we don't know.
		*/

		if ( _sisfit[ unit ].format == 0 )
		{
#ifdef	CRAY
		USICTC( tempbfr, &ieeefmtbyte, & ( _sisfit[ unit ].format ),
				&c1, &ieeefmtsize );
#else
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	/* this works because a half-word in the top of the long translates
	   out the same as a valid long value - jmw */

#ifdef DEBUG
		fprintf(stderr,"read in the format from the line header\n");
		fprintf(stderr,"ieeefmtbyte = %d, ieeefmtsize = %d\n",ieeefmtbyte, ieeefmtsize);
		fprintf(stderr,"value in tempbfr = %04x\n",*(short *)(tempbfr + ieeefmtbyte - 1));
#endif
		_sisfit[ unit ].format = 0;
		memcpy((char *)(& _sisfit[ unit ].format) + 2, (char *)(tempbfr + ieeefmtbyte - 1), 2);
#ifdef DEBUG
		fprintf(stderr,"value in _sisfit[ %d ].format = %04x\n",unit,*(short *)&_sisfit[ unit ].format);
#endif
		CTOHL(& _sisfit[ unit ].format, 1);
#ifdef DEBUG
		fprintf(stderr,"value in _sisfit[ %d ].format after rotation = %04x\n",unit,_sisfit[ unit ].format);
		fprintf(stderr,"format of data = %d\n",_sisfit[ unit ].format);
#endif
#else
			_error( MODULE, unit, E_INTERNAL );
			exit( E_SISIO + E_INTERNAL );
#endif
#endif
		if ( _sisfit[ unit ].format == 0 || _sisfit[ unit ].format > 5 )
				_sisfit[ unit ].format = 'L';
		}

		switch ( _sisfit[ unit ].format )
		{
			case 0:
				_error( MODULE, unit, E_NOFMT );
				return;

			case 1:
			case 3:
#ifdef  CRAY
#ifdef	IEEE
				sisclh( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siiclh( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				sisinlh( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				siiinlh( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 5:
#ifdef  CRAY
#ifdef	IEEE
				sisclh5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siiclh5( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				sisinlh5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				siiinlh5( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 'L':
#ifdef  CRAY
#ifdef	IEEE
				vascah( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vaicah( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				vasinah( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				vaiinah( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
	( void ) memcpy( ( char * ) & nrecs, buffer + CRAYNRECBYTE - 1,
					CRAYNRECSIZE );
				_sisfit[ unit ].headerat += nrecs + 1;
				break;

			case 'V':
#ifdef  CRAY
#ifdef	IEEE
				vfts2c( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vfti2c( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
/* to do
				vfts2in( tempbfr, &reclen, buffer, length );
*/
#endif
#ifdef	IBM
/* to do
				vfti2in( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}

	else if ( _sisfit[ unit ].dotraces )

	{
		/*
			Translate a trace header and samples.
		*/

		switch( _sisfit[ unit ].format )
		{
			case 0:
				_error( MODULE, unit, E_NOFMT );
				return;

			case 1:
#ifdef  CRAY
#ifdef	IEEE
				sisct1( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siict1( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				sisint1( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				siiint1( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 3:
#ifdef  CRAY
#ifdef	IEEE
				sisct3( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siict3( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				sisint3( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do 
				siiint3( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 5:
#ifdef  CRAY
#ifdef	IEEE
				sisct5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siict5( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				sisint5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do 
				siiint5( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 'L':
#ifdef  CRAY
#ifdef	IEEE
				vasccr( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vaiccr( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				vasincr( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				vaiincr( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 'V':
#ifdef  CRAY
#ifdef	IEEE
				vfts2c( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vfti2c( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
/*
				vfts2in( tempbfr, &reclen, buffer, length );
*/
#endif
#ifdef	IBM
/* to do 
				vfti2in( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}

	else

	{
		/*
			Translate a trace header only.
		*/

		switch( _sisfit[ unit ].format )
		{
			case 0:
				_error( MODULE, unit, E_NOFMT );
				return;

			case 1:
			case 3:
#ifdef  CRAY
#ifdef	IEEE
				siscth( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				siicth( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				sisinth( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				siiinth( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 5:
#ifdef  CRAY
#ifdef	IEEE
				sisct5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				siict5( tempbfr, &reclen, buffer, length );
*/
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
				sisint5( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				siiint5( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 'L':
#ifdef  CRAY
#ifdef	IEEE
				vasccv( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do 
				vaiccv( tempbfr, &reclen, buffer, length );
*/
#endif
#endif

#ifdef  CRAY
#ifdef	IEEE
				vasincv( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
/* to do
				vaiincv( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			case 'V':
#ifdef  CRAY
#ifdef	IEEE
				vfts2c( tempbfr, &reclen, buffer, length );
#endif
#ifdef	IBM
				vfti2c( tempbfr, &reclen, buffer, length );
#endif
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
/*
				vfts2in( tempbfr, &reclen, buffer, length );
*/
#endif
#ifdef	IBM
/*
				vfti2in( tempbfr, &reclen, buffer, length );
*/
#endif
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}
}
