/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	rwd.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	RWD rewinds the specified unit.

	FORTRAN:

	CALL RWD( unit )

	unit	input	integer	Unit to rewind.

	C:

	rwd( unit );

	unit	input	int	Unit to rewind.


	$Header: /m/s1/dmk/xlate/sisio/RCS/rwd.c,v 4.3 91/09/11 08:49:13 dmk Exp $

	$Log:	rwd.c,v $
	Revision 4.3  91/09/11  08:49:13  dmk
	MODSET: 4.3
	Changed entry point names to macros.
	
	Revision 4.1  90/07/13  09:19:23  dmk
	MODSET: 4.1
	Added .headerat = 0.  Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:55:39  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.1  88/07/12  15:35:39  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.
	
	Revision 1.2  88/06/27  09:38:43  dmk
	MODSET: 1.2
	Will now flush the buffer if large buffers are enabled, rather than
	flagging an error.
	
	Revision 1.1  88/06/24  12:09:30  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"
#include	<sys/types.h>
#include	<unistd.h>

#define	MODULE	"RWD"


void	F_RWD( unit )

	int *	unit;

{
	C_RWD( *unit );
}


void	C_RWD( unit )

	int	unit;

{
	int	ferror;

	/*
		Initialize package iff necessary, check unit for range,
		check for outstanding error, check to see if unit is open.
	*/

	INITIALIZE;
	CHECKRANGE(MODULE,unit);
	CHECKERROR(MODULE,unit);
	CHECKOPEN(MODULE,unit);

	/*
		Check for large buffering.  If so, flush the buffer.
	*/

	if ( _sisfit[ unit ].largebuf )
	{
		ferror = _flushit( unit );
		if ( ferror < 0 )
		{
			_error( MODULE, unit, -ferror );
			return;
		}
	}

	/*
		Rewind the unit.
	*/

	if ( lseek( _sisfit[ unit ].filedes, 0L, SEEK_SET ) != 0 )
	{
		_error( MODULE, unit, E_LSEEK );
		return;
	}
	_sisfit[ unit ].pointer = 0;
	_sisfit[ unit ].headerat = 0;
}
