/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	sisb4msg.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISB4MSG specifies a prefix to be printed on error messages.  This is
	useful for identifying which program in a pipeline is gagging.

	FORTRAN:

	CALL SISB4MSG( fprefix )

	fprefix	input	charact	The message prefix.

	C:

	sisb4msg( cprefix );

	cprefix	input	char *	The message prefix.


	$Header: /m/s1/dmk/xlate/sisio/RCS/sisb4msg.c,v 4.3 91/09/11 08:49:53 dmk Exp $

	$Log:	sisb4msg.c,v $
	Revision 4.3  91/09/11  08:49:53  dmk
	MODSET: 4.3
	Changed entry point names to macros.  Tests for STRLEN_IS_ARG, not sun.
	
	Revision 4.1  90/07/13  09:20:52  dmk
	MODSET: 4.1
	Initial revision.
	
--------------------------------------------------------------------------- */


#ifdef	CRAY
#include	<fortran.h>
#endif

#include	"sisio.h"

#define	MODULE	"SISB4MSG"

#define STRLEN	128


#ifdef	CRAY
void	F_SISB4MSG( fprefix )

	_fcd	fprefix;
#endif
#ifdef	STRLEN_IS_ARG
void	F_SISB4MSG( fprefix, fprelen )

	char *	fprefix;
	int	fprelen;
#endif

{
	char	cprefix[ STRLEN ];

	/*
		Check and translate format.
	*/

#ifdef	CRAY
	if ( _strf2c( fprefix, cprefix, STRLEN ) < 0 )
#endif
#ifdef	STRLEN_IS_ARG
	if ( _strf2c( fprefix, fprelen, cprefix, STRLEN ) < 0 )
#endif
	{
		_error( MODULE, -1, E_BADPREFIX );
		return;
	}

	/*
		Call C version.
	*/

	C_SISB4MSG( cprefix );
}


void	C_SISB4MSG( cprefix )

	char *	cprefix;

{
	/*
		Initialize if necessary.
	*/

	INITIALIZE;

	/*
		Set prefix.
	*/

	(void) strncpy( _msg_prefix, cprefix, PREFIX_LEN );
	_msg_prefix[ PREFIX_LEN - 1 ] = '\0';

	return;
}
