/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	sislgbuf.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISLGBUF enables and disables the use of large buffers on the
	specified unit.

	FORTRAN:

	CALL SISLGBUF( unit, fswitch )

	unit	input	integer	Unit number.
	fswitch	input	charact	"on" or "off" to enable or disable use of
				large buffers.

	C:

	sislgbuf( unit, cswitch );

	unit	input	int	Unit number.
	cswitch	input	char *	"on" or "off" to enable or disable use of
				large buffers.


	$Header: /m/s1/dmk/xlate/sisio/RCS/sislgbuf.c,v 4.3 91/09/11 08:59:02 dmk Exp $

	$Log:	sislgbuf.c,v $
	Revision 4.3  91/09/11  08:59:02  dmk
	MODSET: 4.3
	Changed entry point names to macros.  Tests for STRLEN_IS_ARG, not sun.
	
	Revision 4.1  90/07/13  09:25:56  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:57:44  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.3  88/08/16  12:42:56  dmk
	MODSET: 2.3
	Added the fswlen parameter to fix a bug in the SUN version.  Also,
	added a check for fswitch not equal to "on" or "off".
	
	Revision 2.1  88/07/12  15:36:24  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.
	
	Revision 1.2  88/06/24  16:19:04  dmk
	MODSET: 1.2
	It is no longer an error to turn large buffers on if they are already
	on, or off if they are already off.
	
	Revision 1.1  88/06/24  13:50:19  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#ifdef	CRAY
#include	<fortran.h>
#endif

#include	<stdio.h>
#include	"sisio.h"

#define	MODULE	"SISLGBUF"

#define STRLEN	128


#ifdef	CRAY
void	F_SISLGBUF( unit, fswitch )

	int *	unit;
	_fcd	fswitch;
#endif
#ifdef	STRLEN_IS_ARG
void	F_SISLGBUF( unit, fswitch, fswlen )

	int *	unit;
	char *	fswitch;
	int	fswlen;
#endif

{
	char	cswitch[ STRLEN ];

	/*
		Check and translate switch.
	*/

#ifdef	CRAY
	if ( _strf2c( fswitch, cswitch, STRLEN ) < 0 )
#endif
#ifdef	STRLEN_IS_ARG
	if ( _strf2c( fswitch, fswlen, cswitch, STRLEN ) < 0 )
#endif
	{
		_error( MODULE, *unit, E_BADSWITCH );
		return;
	}

	/*
		Call C version.
	*/

	C_SISLGBUF( *unit, cswitch );
}


void	C_SISLGBUF( unit, cswitch )

	int	unit;
	char *	cswitch;

{
	int	ier;

	/*
		Initialize if necessary; check unit for range; check for
		outstanding error on unit.
	*/

	INITIALIZE;
	CHECKRANGE( MODULE, unit );
	CHECKERROR( MODULE, unit );

	/*
		Check and translate switch.
	*/

	_strlower( cswitch );

	if ( strcmp( cswitch, "on" ) && strcmp( cswitch, "off" ) )
	{
		_error( MODULE, unit, E_BADSWITCH );
		return;
	}

	/*
		Set largebuf field and allocate buffer.
	*/

	if ( ! _sisfit[ unit ].largebuf && ! strcmp( cswitch, "on" ) )
	{
		if ( _sisfit[ unit ].buffer != NULL )
			free( _sisfit[ unit ].buffer );

		_sisfit[ unit ].buffer = malloc( LGBUFSIZE );

		if ( _sisfit[ unit ].buffer == NULL )
		{
			_error( MODULE, unit, E_NOBUFFER );
			return;
		}

		_sisfit[ unit ].largebuf = TRUE;
		_sisfit[ unit ].bufsize = LGBUFSIZE;
	}
	else if ( _sisfit[ unit ].largebuf && ! strcmp( cswitch, "off" ) )
	{
		if ( _sisfit[ unit ].buffer != NULL )
		{
			ier = _flushit( unit );

			if ( ier != 0 )
			{
				_error( MODULE, unit, -ier );
				return;
			}

			free( _sisfit[ unit ].buffer );
		}

		_sisfit[ unit ].buffer = malloc( SMBUFSIZE );

		if ( _sisfit[ unit ].buffer == NULL )
		{
			_error( MODULE, unit, E_NOBUFFER );
			return;
		}

		_sisfit[ unit ].largebuf = FALSE;
		_sisfit[ unit ].bufsize = SMBUFSIZE;
	}
}
