/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	_fitinit
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_Fitinit initializes the _sisfit entry for a given unit.

	_fitinit( unit );

	unit	input	int	The unit to initialize.


	$Header: /m/m1/dmk/xlate/sisio/RCS/_fitinit.c,v 4.4 1992/05/08 13:28:34 dmk Exp $

	$Log: _fitinit.c,v $
	Revision 4.4  1992/05/08  13:28:34  dmk
	Sets the default buffer size to small on workstations.

	Revision 4.3  91/09/11  08:35:02  dmk
	MODSET: 4.3
	Tests for NEVER_TRANSLATE rather than sun.
	
	Revision 4.1  90/07/13  08:54:57  dmk
	MODSET: 4.1
	Changed SUN to sun.  Added code to initialize .headerat and .filename.
	
	Revision 2.2  88/07/20  08:51:51  dmk
	MODSET: 2.2
	Added line to set .doio to TRUE.
	
	Revision 2.1  88/07/12  15:03:10  dmk
	MODSET: 2.1
	Added SUN block:  trwhen = never, dotrace = false.  Also, lgoper =
	L_NONE, error = E_NORMAL.
	
	Revision 1.2  88/06/27  09:32:37  dmk
	MODSET: 1.2
	Largebuf (large buffering) now set to TRUE rather than FALSE.
	
	Revision 1.1  88/06/24  11:19:46  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"
#include	<stdio.h>


void _fitinit( unit )

	int	unit;

{
	_sisfit[ unit ].filedes = 0;
	_sisfit[ unit ].isopen = FALSE;
	_sisfit[ unit ].isdisk = FALSE;
	_sisfit[ unit ].doio = TRUE;
#ifndef	NEVER_TRANSLATE
	_sisfit[ unit ].trwhen = W_IFDISK;
	_sisfit[ unit ].dotraces = TRUE;
#else
	_sisfit[ unit ].trwhen = W_NEVER;
	_sisfit[ unit ].dotraces = FALSE;
#endif
	_sisfit[ unit ].pointer = 0;
	_sisfit[ unit ].format = 0;
	_sisfit[ unit ].hdrlen = 0;
	_sisfit[ unit ].trclen = 0;
	_sisfit[ unit ].cwlen = 0;
	_sisfit[ unit ].abort = TRUE;
	_sisfit[ unit ].error = E_NORMAL;
#ifndef	DEFAULT_SMALLBUF
	_sisfit[ unit ].largebuf = TRUE;
#else
	_sisfit[ unit ].largebuf = FALSE;
#endif
	_sisfit[ unit ].bufsize = 0;
	_sisfit[ unit ].bfrbeg = 0;
	_sisfit[ unit ].bfrend = 0;
	_sisfit[ unit ].lgoper = L_NONE;
	_sisfit[ unit ].buffer = NULL;
	_sisfit[ unit ].headerat = 0;
	_sisfit[ unit ].filename = NULL;
}
