/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	_readit.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_Readit reads a record from the specified unit, taking into account
	large buffering.

	nread = _readit( unit, buffer, length );

	nread	return	int	Number of bytes read; 0 if EOF; < 0 if error.
	unit	input	int	Unit to read from.
	buffer	output	char *	Buffer to read into.
	length	input	int	Length of buffer.


	$Header: /m/s1/dmk/xlate/sisio/RCS/_readit.c,v 4.3 91/09/11 08:36:10 dmk Exp $

	Moved tempbfr declaration to top-level and made it static to prevent
	stack overflow on the Convex.
		      94/08/25            zjmw36

	$Log:	_readit.c,v $
	Revision 4.3  91/09/11  08:36:10  dmk
	MODSET: 4.3
	Tests for CRAY rather than sun.
	
	Revision 4.1  90/07/13  09:00:31  dmk
	MODSET: 4.1
	Added mods for format L.  Changed calls to eliminate need for dmklib.
	Changed SUN to sun.
	
	Revision 2.1  88/07/12  15:11:41  dmk
	MODSET: 2.1
	Change tempbfr size from LGBUFSIZE to SMBUFSIZE.  Cast third readpipe
	argument to unsigned for lint.
	
	Revision 1.2  88/06/27  09:33:45  dmk
	MODSET: 1.2
	Will now flush the buffer if switching from writing to reading, rather
	than flagging an error.
	
	Revision 1.1  88/06/24  11:33:02  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"

static char	tempbfr[ SMBUFSIZE ];

int	_readit( unit, buffer, length )

	int	unit;
	char *	buffer;
	int	length;

{
/*
	char	tempbfr[ SMBUFSIZE ];
*/
	int	cword;
	int	_ferror;
	int	nread;
	int	reclen;
	int	c1 = 1, c4 = 4;
	int	start;

	/*
		If no large buffering, then just read a record.
	*/

	if ( ! _sisfit[ unit ].largebuf )
	{
		if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat )
			reclen = _sisfit[ unit ].hdrlen;
		else
			reclen = _sisfit[ unit ].trclen;

		if ( _sisfit[ unit ].format == 0 ||
				_sisfit[ unit ].format == 'L' )
			reclen = 0;

		if ( reclen != 0 )
		{
			/*
				We know how long the record is, so just read
				it in and check the control word.
			*/

	nread = _readpipe( _sisfit[ unit ].filedes, _sisfit[ unit ].buffer,
		( unsigned ) ( reclen + _sisfit[ unit ].cwlen ) );

			if ( nread < 0 ) return( -E_READ );

			if ( nread == 0 ) return( 0 );

			cword = 0;  /* lint-proofing */

			if ( _sisfit[ unit ].cwlen == WORDSIZE )
				( void ) memcpy( ( char * ) &cword,
					_sisfit[ unit ].buffer, WORDSIZE );
			else
#ifdef	CRAY
				USICTC( _sisfit[ unit ].buffer, &c1, &cword,
					&c1, &c4 );
#else
			{
				_error( "_readit", unit, E_INTERNAL );
				exit( E_SISIO + E_INTERNAL );
			}
#endif

			if ( nread != reclen + _sisfit[ unit ].cwlen ||
					cword != reclen )
				return( -E_RECLEN );

			( void ) memcpy( buffer, _sisfit[ unit ].buffer +
				_sisfit[ unit ].cwlen, reclen );

			_sisfit[ unit ].pointer += 1;

			return( reclen );
		}

		else

		{
			/*
				We don't know how long the record is, so readsb
				the record directly into the buffer parameter,
				and set the appropriate field in the FIT.
			*/

			nread = _readsb( _sisfit[ unit ].filedes, buffer,
				length, _sisfit[ unit ].cwlen );

			if ( nread < 0 ) return( -E_READ );

			if ( nread == 0 ) return( 0 );

		if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat )
				_sisfit[ unit ].hdrlen = nread;
			else
				_sisfit[ unit ].trclen = nread;

			_sisfit[ unit ].pointer += 1;

			return( nread );
		}
	}

	/*
		If large buffering, fall through to here and read a bufferful,
		if there isn't at least a full record in the buffer.

		Check first to make sure we're not already writing to this
		unit.  If we are, then flush the buffer.
	*/

	if ( _sisfit[ unit ].lgoper == L_WRITE )
	{
		_ferror = _flushit( unit );
		if ( _ferror < 0 ) return( _ferror );
	}

	_sisfit[ unit ].lgoper = L_READ;

	/*
		If there is not even a control word in the buffer, shift the
		buffer, then read a bunch.  If there is still not a control
		word, flag an EOF.
	*/

	if ( _sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg <
		_sisfit[ unit ].cwlen )
	{
		if (_sisfit[ unit ].bfrend != _sisfit[ unit ].bfrbeg) {
		  ( void ) memcpy( tempbfr,
			_sisfit[ unit ].buffer + _sisfit[ unit ].bfrbeg,
			_sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg );
		  ( void ) memcpy( _sisfit[ unit ].buffer, tempbfr,
			_sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg );
		  }
		_sisfit[ unit ].bfrend -= _sisfit[ unit ].bfrbeg;
		_sisfit[ unit ].bfrbeg = 0;

		nread = _readpipe( _sisfit[ unit ].filedes,
			_sisfit[ unit ].buffer + _sisfit[ unit ].bfrend,
			( unsigned ) ( LGBUFSIZE - _sisfit[ unit ].bfrend ) );

		if ( nread < 0 ) return( -E_READ );

		_sisfit[ unit ].bfrend += nread;
	}

	if ( _sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg <
			_sisfit[ unit ].cwlen ) {
		return( 0 );
		}

	/*
		Translate the control word.
	*/

	if ( _sisfit[ unit ].cwlen == WORDSIZE )
		( void ) memcpy( ( char * ) &reclen, _sisfit[ unit ].buffer +
			_sisfit[ unit ].bfrbeg, WORDSIZE );
	else
	{
#ifdef	CRAY
		start = _sisfit[ unit ].bfrbeg + 1;
		USICTC( _sisfit[ unit ].buffer, &start, &reclen, &c1, &c4 );
#else
		_error( "_readit", unit, E_INTERNAL );
		exit( E_SISIO + E_INTERNAL );
#endif
	}
/*
   -- added 1/18/99 to catch bad trace green words in buffer - joe m. wade
*/
	if (( _sisfit[ unit ].pointer > 1) &&
	    ( reclen != _sisfit[ unit ].trclen )) return( -E_RECLEN );

	_sisfit[ unit ].bfrbeg += _sisfit[ unit ].cwlen;

	/*
		If there is not a full record in the buffer, shift the
		buffer, then read a bunch.  If there is still not a full
		record, flag an error.
	*/

	if ( _sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg < reclen )
	{
		( void ) memcpy( tempbfr,
			_sisfit[ unit ].buffer + _sisfit[ unit ].bfrbeg,
			_sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg );
		( void ) memcpy( _sisfit[ unit ].buffer, tempbfr,
			_sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg );
		_sisfit[ unit ].bfrend -= _sisfit[ unit ].bfrbeg;
		_sisfit[ unit ].bfrbeg = 0;

		nread = _readpipe( _sisfit[ unit ].filedes,
			_sisfit[ unit ].buffer + _sisfit[ unit ].bfrend,
			( unsigned ) ( LGBUFSIZE - _sisfit[ unit ].bfrend ) );

		if ( nread < 0 ) return( -E_READ );

		_sisfit[ unit ].bfrend += nread;
	}

	if ( _sisfit[ unit ].bfrend - _sisfit[ unit ].bfrbeg < reclen )
		return( -E_RECLEN );

	/*
		Check or set the record length in the FIT.
	*/

	if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat )

		if ( _sisfit[ unit ].hdrlen == 0 )
			_sisfit[ unit ].hdrlen = reclen;
		else
		{
			if ( _sisfit[ unit ].format != 0 &&
					_sisfit[ unit ].format != 'L' )
				if ( _sisfit[ unit ].hdrlen != reclen )
					return( -E_RECLEN );
		}

	else  /* pointer != headerat */

		if ( _sisfit[ unit ].trclen == 0 )
			_sisfit[ unit ].trclen = reclen;
		else
		{
			if ( _sisfit[ unit ].format != 0 &&
					_sisfit[ unit ].format != 'L' )
				if ( _sisfit[ unit ].trclen != reclen )
					return( -E_RECLEN );
		}


	/*
		Copy the record to the buffer parameter.
	*/

	( void ) memcpy( buffer, _sisfit[ unit ].buffer +
		_sisfit[ unit ].bfrbeg, reclen );

	_sisfit[ unit ].bfrbeg += reclen;
	_sisfit[ unit ].pointer += 1;

	return( reclen );
}
