/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	Package	:	sisio
	File	:	_strlower.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_Strlower converts a character string to lower case in place.

	_strlower( string );

	string	i/o	char[]	String to shift to lower case.


	$Header: /m/s1/dmk/xlate/sisio/RCS/_strlower.c,v 2.1 88/07/12 15:10:14 dmk Exp Locker: dmk $

	$Log:	_strlower.c,v $
	Revision 2.1  88/07/12  15:10:14  dmk
	MODSET: 2.1
	Include <ctype.h>.  Add 'if ( isupper )' before 'tolower' for
	compatibility with SUN.
	
	Revision 1.1  88/06/28  08:10:01  dmk
	Initial revision
	
*/


#include	<ctype.h>


void _strlower( string )

	char *	string;

{
	while ( *string != '\0' )
	{
		if ( isupper( *string ) ) *string = tolower( *string );
		string++;
	}
}
