/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	wrtape.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	WRTAPE writes a record to the specified unit, translating from
	CRAY format if necessary.

	FORTRAN:

	CALL WRTAPE( unit, buffer, length )

	unit	input	integer	Unit number to which to write.
	buffer	input	array	Buffer to write from.
	length	input	integer	Length of data in buffer in bytes.

	C:

	wrtape( unit, buffer, length );

	unit	input	int	Unit number to which to write.
	buffer	input	array	Buffer to write from.
	length	input	int	Length of data in buffer in bytes.


	$Header: /m/m1/dmk/xlate/sisio/RCS/wrtape.c,v 4.3 1991/09/11 09:02:31 dmk Exp dmk $

	Moved tempbfr declaration to top-level and made it static to prevent
	stack overflow on the Convex.
		      94/08/25            zjmw36

	$Log: wrtape.c,v $
	Revision 4.3  1991/09/11  09:02:31  dmk
	MODSET: 4.3
	Changed entry point names to macros.

	Revision 4.1  90/07/13  09:30:21  dmk
	MODSET: 4.1
	Added code for formats L and V.  Changed SUN to sun.
	
	Revision 3.1  89/09/27  10:00:26  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.2  88/07/20  08:58:03  dmk
	MODSET: 2.2
	Added CHECKDOIO.
	
	Revision 2.1  88/07/12  15:37:11  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.
	
	Revision 1.1  88/06/29  09:37:58  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"

#define	MODULE	"WRTAPE"

/* KLUDGE to dodge problem in IESCTI() */
#define	EVEN_SAMP(len,hdr) \
	( ((len) - (hdr)) / 8 % 2 == 0 ? (len) : (len) + 8 )

static	char	tempbfr[ SMBUFSIZE ];

void	F_WRTAPE( unit, buffer, length )

	int *	unit;
	char *	buffer;
	int *	length;

{
	C_WRTAPE( *unit, buffer, *length );
}


void	C_WRTAPE( unit, buffer, length )

	int	unit;
	char *	buffer;
	int	length;

{
	int	nrecs;
	int	nwritten;
	int	reclen;
/*
	char	tempbfr[ SMBUFSIZE ];
*/
	LOGICAL	translate;
	int	reallen;  /* KLUDGE */

	/*
		Initialize package if necessary.  Check for outstanding
		error condition.  Check unit for range and to make sure 
		it's open.  Check to make sure we really want to do I/O.
	*/

	INITIALIZE;
	CHECKERROR(MODULE,unit);
	CHECKRANGE(MODULE,unit);
	CHECKOPEN(MODULE,unit);
	CHECKDOIO(MODULE,unit);

	/*
		Determine whether to translate the record.
	*/

	translate =	( _sisfit[ unit ].trwhen == W_ALWAYS ||
			( _sisfit[ unit ].trwhen == W_IFDISK &&
			_sisfit[ unit ].isdisk ) );

	/*
		If we don't need to translate the record, just write it out.
	*/

	if ( ! translate )

	{
		nwritten = _writeit( unit, buffer, length );

		if ( nwritten < 0 ) _error( MODULE, unit, -nwritten );

		return;
	}

	/*
		If we need to translate the record, fall through to here,
		translate it into a temporary buffer and write that out.
	*/

#ifdef	lint
	reclen = 0;
#endif

	if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat )

	{
		/*
			Translate a line header.
			If we don't know the format, figure it out.
			THIS METHOD IS STUPID!
		*/

		if ( _sisfit[ unit ].format == 0 )
		{
		( void ) memcpy( ( char * ) & ( _sisfit[ unit ].format ),
				buffer + CRAYFMTBYTE - 1, CRAYFMTSIZE );
		if ( _sisfit[ unit ].format == 0 || _sisfit[ unit ].format > 5 )
				_sisfit[ unit ].format = 'L';
		}

		switch ( _sisfit[ unit ].format )
		{
			case 1:
			case 3:
#ifdef	IEEE
				sicslh( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				sicilh( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 5:
#ifdef	IEEE
				sicslh5( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				sicilh5( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 'L':
#ifdef	IEEE
		/* KLUDGE */	reallen=length; length=EVEN_SAMP(length,176);
				vacsah( buffer, &length, tempbfr, &reclen );
		/* KLUDGE */	if ( reallen != length ) reclen -= 4;
#endif
#ifdef	IBM
				vaciah( buffer, &length, tempbfr, &reclen );
#endif
	( void ) memcpy( ( char * ) & nrecs, buffer + CRAYNRECBYTE - 1,
					CRAYNRECSIZE );
				_sisfit[ unit ].headerat += nrecs + 1;
				break;

			case 'V':
#ifdef	IEEE
				vftc2s( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				vftc2i( buffer, &length, tempbfr, &reclen );
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}

	else if ( _sisfit[ unit ].dotraces )

	{
		/*
			Translate a trace header and samples.
		*/

		switch ( _sisfit[ unit ].format )
		{
			case 0:
				_error( MODULE, unit, E_NOFMT );
				return;

			case 1:
#ifdef	IEEE
				sicst1( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				sicit1( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 3:
#ifdef	IEEE
		/* KLUDGE */	reallen=length; length=EVEN_SAMP(length,1024);
				sicst3( buffer, &length, tempbfr, &reclen );
		/* KLUDGE */	if ( reallen != length ) reclen -= 4;
#endif
#ifdef	IBM
				sicit3( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 5:
#ifdef	IEEE
				sicst5( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				sicit5( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 'L':
#ifdef	IEEE
		/* KLUDGE */	reallen=length; length=EVEN_SAMP(length,0);
				vacscr( buffer, &length, tempbfr, &reclen );
		/* KLUDGE */	if ( reallen != length ) reclen -= 4;
#endif
#ifdef	IBM
				vacicr( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 'V':
#ifdef	IEEE
				vftc2s( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				vftc2i( buffer, &length, tempbfr, &reclen );
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}

	else

	{
		/*
			Translate a trace header only.
		*/

		switch ( _sisfit[ unit ].format )
		{
			case 0:
				_error( MODULE, unit, E_NOFMT );
				return;

			case 1:
			case 3:
#ifdef	IEEE
				sicsth( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				sicith( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 5:
#ifdef	IEEE
				sicst5( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				sicit5( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 'L':
#ifdef	IEEE
				vacscv( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				vacicv( buffer, &length, tempbfr, &reclen );
#endif
				break;

			case 'V':
#ifdef	IEEE
				vftc2s( buffer, &length, tempbfr, &reclen );
#endif
#ifdef	IBM
				vftc2i( buffer, &length, tempbfr, &reclen );
#endif
				break;

			default:
				_error( MODULE, unit, E_BADFMT );
				return;
		}
	}

	nwritten = _writeit( unit, tempbfr, reclen );

	if ( nwritten < 0 ) _error( MODULE, unit, -nwritten );

	return;
}
