/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <ctype.h>

/*
#include "ikp_defines.h"
*/
#include <ikp_defines.h>

int
ikp_gettoken(line, n, buf, buflen)
/*
   Copy the first buflen characters of the
   n'th token of line into buf. A token is
   a contiguous set of non-whitespace characters
   or any set of characters within double-quotes.
*/

/*
 *	Modified above definition to be "within double-quotes which
 *	have not been escaped by the use of a backslash character".
 *	This enables the input of arbitrary command line strings ie.
 *	-xrm "*foreground: red" for an X program, where blanks must
 *	be preserve within on command line argument. This has the 
 *	desirable side effect that you can also use double-quote marks
 *	within any token.
 *						- j.m.wade - 92083
 */
char *line;
int n;
char *buf;
int buflen;
{
	int ntokens, tokenlen;
	char *c, *d;
	boolean escaped = FALSE;

	if (line == (char *) NULL)
		return(IKP_FAILURE);
	if (n < 0)
		return(IKP_FAILURE);
	if (buf == (char *) NULL)
		return(IKP_FAILURE);
	if (buflen < 1)
		return(IKP_FAILURE);

	buf[0]= '\0';

	/* skip leading whitespace */
	for (c= line; (*c != '\n') && (*c != '\0') && !isgraph(*c); c++);
	if (!isgraph(*c))
		return(IKP_FAILURE);


	/* skip until n'th token reached */
	for (ntokens= 0; ntokens < n; ntokens++) {

		/* skip token */
		if ((*c == '"') && (!escaped)) {
			for (c++; (*c != '\n') && (*c != '\0') &&
			  ((*c !=  '"') || escaped); c++) {
				if (*c == '\\') escaped = TRUE;
				else escaped = FALSE;
			}
			if (*c != '"')
				return(IKP_FAILURE);
			c++;
		}
		else {
			if (*c == '\\') escaped = TRUE;
			for (; isgraph(*c); c++);
		}

		/* skip trailing whitespace */
		for (; (*c != '\n') && (*c != '\0') && !isgraph(*c); c++);
		if (!isgraph(*c))
			return(IKP_FAILURE);

	}
	if (!isgraph(*c))
		return(IKP_FAILURE);

	d= buf;
	tokenlen= 0;
	if (*c == '"') {
		for (c++, escaped = FALSE; (*c != '\n') && (*c != '\0') &&
		  ((*c !=  '"') || escaped); c++, tokenlen++) {
			if (escaped && (*c == '"')) {
				d--;
				tokenlen--;
				}
			if (*c == '\\') escaped = TRUE;
			else escaped = FALSE;
			if (tokenlen < buflen) {
				*d= *c;
				d++;
			}
		}
		if (*c != '"')
			return(IKP_FAILURE);
	}
	else {
		for (; isgraph(*c); c++, tokenlen++) {
			if (tokenlen < buflen) {
				*d= *c;
				d++;
			}
		}
	}
	*d= '\0';

	if (tokenlen <= buflen)
		return(IKP_SUCCESS);
	else
		return(IKP_FAILURE);
}
